/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.tydic.pfscext.external.api.BusiPayReceiptErpService;
import com.tydic.pfscext.external.api.bo.BusiPayReceiptErpReqBO;
import com.tydic.pfscext.external.api.bo.BusiPayReceiptErpRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiPayReceiptErpServiceImpl
implements BusiPayReceiptErpService {
    private static final Logger log = LoggerFactory.getLogger(BusiPayReceiptErpServiceImpl.class);
    @Value(value="${FSC_PAY_RECEIPT_ERP_URL:}")
    private String FSC_PAY_RECEIPT_ERP_URL;
    ValueFilter filter = new ValueFilter(){

        public Object process(Object obj, String s, Object v) {
            if (v == null) {
                return "";
            }
            return v;
        }
    };

    @Override
    public BusiPayReceiptErpRspBO getPayReceiptErp(BusiPayReceiptErpReqBO reqBO) {
        HttpRetBean httpRetBean;
        try {
            String reqEsbStr = JSON.toJSONString((Object)reqBO, (SerializeFilter)this.filter, (SerializerFeature[])new SerializerFeature[0]);
            log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)this.FSC_PAY_RECEIPT_ERP_URL);
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ed8\u6b3e\u5355\u8bf7\u6c42\u62a5\u6587:{}", (Object)reqEsbStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.FSC_PAY_RECEIPT_ERP_URL), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528ERP\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u5f02\u5e38");
        }
        log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ed8\u6b3e\u5355\u54cd\u5e94\u62a5\u6587:{}", (Object)httpRetBean.getStr());
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u5931\u8d25[http_status={}], [http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.FSC_PAY_RECEIPT_ERP_URL);
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u5931\u8d25");
        }
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528ERP\u83b7\u53d6\u4ed8\u6b3e\u5355\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new RuntimeException("\u8c03\u7528ERP\u83b7\u53d6\u4ed8\u6b3e\u5355\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        String replaced = returnString.replaceAll("~", "");
        return (BusiPayReceiptErpRspBO)JSON.parseObject((String)replaced, BusiPayReceiptErpRspBO.class);
    }
}

