/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiTransferRecAmtConfirmService;
import com.tydic.pfscext.external.api.bo.BusiTransferRecAmtConfirmReqBO;
import com.tydic.pfscext.external.api.bo.BusiTransferRecAmtConfirmRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.JsonUtils;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiTransferRecAmtConfirmServiceImpl
implements BusiTransferRecAmtConfirmService {
    private static final Logger log = LoggerFactory.getLogger(BusiTransferRecAmtConfirmServiceImpl.class);
    @Autowired
    private Environment prop;

    @Override
    public BusiTransferRecAmtConfirmRspBO transfer(BusiTransferRecAmtConfirmReqBO reqBO) {
        HttpRetBean httpRetBean;
        String seqid;
        if (log.isInfoEnabled()) {
            log.info("\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)(seqid = reqBO.getSeqid()))) {
            log.error("\u552f\u4e00\u6807\u793a[seqid]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u552f\u4e00\u6807\u793a[seqid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSsdw())) {
            log.error("\u6240\u5c5e\u5355\u4f4d[ssdw]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u6240\u5c5e\u5355\u4f4d[ssdw]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getYhdm())) {
            log.error("\u7528\u6237\u4ee3\u7801[yhdm]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u7528\u6237\u4ee3\u7801[yhdm]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getFlowid())) {
            log.error("\u6d41\u7a0bID[flowid]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u6d41\u7a0bID[flowid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getItems() == null || reqBO.getItems().isEmpty()) {
            log.error("\u660e\u7ec6[items]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO);
            throw new PfscExternalBusinessException("0001", "\u660e\u7ec6[items]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        log.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + reqStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_RECAMTCONFIRM_SEND_YUANGUANG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            log.error("\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,seqid=" + seqid, (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,seqid=" + seqid);
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,http_status=" + httpRetBean.getStatus() + ",seqid=" + seqid);
            throw new PfscExternalBusinessException("18002", "\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,http_status=" + httpRetBean.getStatus() + ",seqid=" + seqid);
        }
        String returnString = httpRetBean.getStr();
        log.info("\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
        if (!StringUtils.hasText((String)returnString)) {
            log.error("\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new PfscExternalBusinessException("18002", "\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        BusiTransferRecAmtConfirmRspBO rspBO = new BusiTransferRecAmtConfirmRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        rspBO.setSeqid(rspJsonObject.getString("seqid"));
        rspBO.setCwdjid(rspJsonObject.getString("cwdjid"));
        rspBO.setRspcode(rspJsonObject.getString("rspcode"));
        rspBO.setRspmsg(rspJsonObject.getString("rspmsg"));
        return rspBO;
    }
}

