/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiInvoiceBaiwangBlackListService;
import com.tydic.pfscext.external.api.bo.BusiInvoiceBaiwangBlackListInfoBO;
import com.tydic.pfscext.external.api.bo.BusiInvoiceBaiwangBlackListReqBO;
import com.tydic.pfscext.external.api.bo.BusiInvoiceBaiwangBlackListRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.JsonUtils;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiInvoiceBaiwangBlackListServiceImpl
implements BusiInvoiceBaiwangBlackListService {
    @Value(value="${URL_BAIWANG_BLACKLIST:http://172.24.2.66:15561/tax/supplier/isBlacklist}")
    private String URL_BAIWANG_BLACKLIST;
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiInvoiceBaiwangBlackListServiceImpl.class);

    @Override
    public BusiInvoiceBaiwangBlackListRspBO checkBlacklist(BusiInvoiceBaiwangBlackListReqBO busiInvoiceBaiwangBlackListReqBO) {
        this.checkParams(busiInvoiceBaiwangBlackListReqBO);
        String resultStr = this.postCheckBlacklist(busiInvoiceBaiwangBlackListReqBO);
        LOGGER.info("FSC-\u767e\u65fa\u9ed1\u540d\u5355\u67e5\u8be2--\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)resultStr);
        BusiInvoiceBaiwangBlackListRspBO<Object> rspBO = new BusiInvoiceBaiwangBlackListRspBO<Object>();
        JSONObject jsonObject = JSON.parseObject((String)resultStr);
        rspBO.setCode(jsonObject.getString("code"));
        rspBO.setMsg(jsonObject.getString("msg"));
        String dataJson = jsonObject.getString("data");
        try {
            JSON.parseObject((String)dataJson);
            BusiInvoiceBaiwangBlackListInfoBO busiInvoiceBaiwangBlackListInfoBO = (BusiInvoiceBaiwangBlackListInfoBO)JSON.parseObject((String)dataJson, BusiInvoiceBaiwangBlackListInfoBO.class);
            rspBO.setData(busiInvoiceBaiwangBlackListInfoBO);
        }
        catch (Exception e) {
            rspBO.setData(dataJson);
        }
        return rspBO;
    }

    private String postCheckBlacklist(BusiInvoiceBaiwangBlackListReqBO busiInvoiceBaiwangBlackListReqBO) {
        HttpRetBean httpRetBean;
        try {
            String reqBody = JsonUtils.objectBeanToJsonString(busiInvoiceBaiwangBlackListReqBO);
            LOGGER.info("\u67e5\u770bjson\u8f6c\u6362\u662f\u5426\u6210\u529f\uff1a", (Object)reqBody);
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.URL_BAIWANG_BLACKLIST), HSNHttpHeader.getRequestHeaders("json"), reqBody.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u9a8c\u9ed1\u540d\u5355\u5931\u8d25", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u67e5\u9a8c\u767e\u65fa\u53d1\u7968\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            LOGGER.error("\u8c03\u7528\u767e\u65fa\u67e5\u8be2\u9ed1\u540d\u5355\u4f01\u4e1a\u5931\u8d25[http_status={},http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.URL_BAIWANG_BLACKLIST);
            throw new RuntimeException("\u8c03\u7528\u767e\u65fa\u67e5\u8be2\u9ed1\u540d\u5355\u4f01\u4e1a\u5931\u8d25");
        }
        String returnString = httpRetBean.getStr();
        LOGGER.info("\u67e5\u8be2\u9ed1\u540d\u5355\u4f01\u4e1a\u54cd\u5e94\u62a5\u6587\uff1a", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            LOGGER.info("\u67e5\u8be2\u9ed1\u540d\u5355\u4f01\u4e1a\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u67e5\u9a8c\u8be2\u9ed1\u540d\u5355\u4f01\u4e1a\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        LOGGER.debug("--\u67e5\u8be2\u9ed1\u540d\u5355\u4f01\u4e1a|\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        return returnString;
    }

    private void checkParams(BusiInvoiceBaiwangBlackListReqBO busiInvoiceBaiwangBlackListReqBO) {
        if (StringUtils.isEmpty((Object)busiInvoiceBaiwangBlackListReqBO.getDwmc())) {
            LOGGER.error("\u67e5\u8be2\u9ed1\u540d\u5355\u4f01\u4e1a|\u5355\u4f4d\u540d\u79f0:={}|\u51fa\u9519", (Object)busiInvoiceBaiwangBlackListReqBO.getDwmc());
        }
        if (StringUtils.isEmpty((Object)busiInvoiceBaiwangBlackListReqBO.getNsrsbh())) {
            LOGGER.error("\u67e5\u8be2\u9ed1\u540d\u5355\u4f01\u4e1a|\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:={}|\u51fa\u9519", (Object)busiInvoiceBaiwangBlackListReqBO.getNsrsbh());
        }
    }
}

