/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiInvoiceBaiwangCheckService;
import com.tydic.pfscext.external.api.bo.BusiInvoiceBaiwangCheckReqBO;
import com.tydic.pfscext.external.api.bo.BusiInvoiceBaiwangCheckRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiInvoiceBaiwangCheckServiceImpl
implements BusiInvoiceBaiwangCheckService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceBaiwangCheckServiceImpl.class);
    @Value(value="${URL_FSC_BAIWANG_CHECK:http://10.18.0.39:8001/OSN/api/checkLKBill/v1}")
    private String URL_FSC_BAIWANG_CHECK;

    @Override
    public BusiInvoiceBaiwangCheckRspBO invoiceBaiwangCheck(BusiInvoiceBaiwangCheckReqBO busiInvoiceBaiwangCheckReqBO) {
        log.info("\u767e\u65fa\u67e5\u9a8c\u53d1\u7968\u5165\u53c2\uff1a{}", (Object)busiInvoiceBaiwangCheckReqBO.toString());
        this.checkParams(busiInvoiceBaiwangCheckReqBO);
        String jsonStr = JSON.toJSONString((Object)busiInvoiceBaiwangCheckReqBO);
        String returnJson = this.postQueryBaiwang(jsonStr);
        JSONObject jsonObject = JSON.parseObject((String)returnJson);
        BusiInvoiceBaiwangCheckRspBO<Object> busiInvoiceBaiwangCheckRspBO = new BusiInvoiceBaiwangCheckRspBO<Object>();
        String resCode = jsonObject.getString("code");
        String resMsg = jsonObject.getString("msg");
        String dataJson = jsonObject.getString("data");
        busiInvoiceBaiwangCheckRspBO.setCode(resCode);
        busiInvoiceBaiwangCheckRspBO.setMsg(resMsg);
        String code = "0000";
        if (code.equals(resCode)) {
            BusiInvoiceBaiwangCheckRspBO.Data data = (BusiInvoiceBaiwangCheckRspBO.Data)JSON.parseObject((String)dataJson, BusiInvoiceBaiwangCheckRspBO.Data.class);
            busiInvoiceBaiwangCheckRspBO.setData(data);
        } else {
            busiInvoiceBaiwangCheckRspBO.setData(dataJson);
        }
        return busiInvoiceBaiwangCheckRspBO;
    }

    private String postQueryBaiwang(String jsonStr) {
        HttpRetBean httpRetBean;
        try {
            log.info("\u67e5\u770bjson\u8f6c\u6362\u662f\u5426\u6210\u529f\uff1a{}", (Object)jsonStr);
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.URL_FSC_BAIWANG_CHECK), HSNHttpHeader.getRequestHeaders("json"), jsonStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
        }
        catch (Exception e) {
            log.error("\u67e5\u9a8c\u767e\u65fa\u53d1\u7968\u5931\u8d25", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u67e5\u9a8c\u767e\u65fa\u53d1\u7968\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528\u767e\u65fa\u67e5\u9a8c\u53d1\u7968\u5931\u8d25[http_status={},http_url={}]", (Object)httpRetBean.getStatus(), (Object)this.URL_FSC_BAIWANG_CHECK);
            throw new RuntimeException("\u8c03\u7528\u767e\u65fa\u67e5\u9a8c\u53d1\u7968\u5931\u8d25");
        }
        String returnString = httpRetBean.getStr();
        log.info("\u67e5\u9a8c\u767e\u65fa\u53d1\u7968\u54cd\u5e94\u62a5\u6587\uff1a", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u67e5\u9a8c\u767e\u65fa\u53d1\u7968\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u67e5\u9a8c\u767e\u65fa\u53d1\u7968\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        log.debug("fsc--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        return returnString;
    }

    private void checkParams(BusiInvoiceBaiwangCheckReqBO busiInvoiceBaiwangCheckReqBO) {
        boolean fpkePresent;
        boolean present;
        String fplxdm = busiInvoiceBaiwangCheckReqBO.getFplx();
        if (StringUtils.isEmpty((Object)fplxdm)) {
            log.error("\u67e5\u9a8c\u53d1\u7968\u7c7b\u578b:fplx={}.\u51fa\u9519", (Object)fplxdm);
        }
        if (StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getFphm())) {
            log.error("\u67e5\u9a8c\u53d1\u7968\u53f7\u7801:fphm={}.\u51fa\u9519", (Object)busiInvoiceBaiwangCheckReqBO.getFphm());
        }
        if (StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getFpdm())) {
            log.error("\u67e5\u9a8c\u53d1\u7968\u4ee3\u7801:fpdm={}.\u51fa\u9519", (Object)busiInvoiceBaiwangCheckReqBO.getFpdm());
        }
        if ((present = Arrays.asList("04", "10", "11", "14").stream().filter(code -> code.equals(fplxdm.trim())).findAny().isPresent()) && StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getJym())) {
            log.error("\u67e5\u9a8c\u6821\u9a8c\u7801\u51fa\u9519:code={},jym={}", (Object)fplxdm, (Object)busiInvoiceBaiwangCheckReqBO.getJym());
        }
        if ((fpkePresent = Arrays.asList("01", "02", "03", "15").stream().filter(code -> code.equals(fplxdm.trim())).findAny().isPresent()) && StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getFpje())) {
            log.error("\u67e5\u9a8c\u53d1\u7968\u91d1\u989d\u51fa\u9519:fplx={},fpje={}", (Object)fplxdm, (Object)busiInvoiceBaiwangCheckReqBO.getFpje());
        }
        if (StringUtils.isEmpty((Object)busiInvoiceBaiwangCheckReqBO.getKprq())) {
            log.error("\u67e5\u9a8c\u5f00\u7968\u65e5\u671f\u51fa\u9519:kprq={}", (Object)busiInvoiceBaiwangCheckReqBO.getKprq());
        }
    }
}

