/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.picker.PickerClient;
import com.tydic.picker.advice.SyncDataByPointCutAdvice;
import com.tydic.picker.config.RecordTableCheckRunner;
import com.tydic.picker.disruptor.PickerClientDisruptorClientPublisher;
import com.tydic.picker.properties.PickerProperties;
import com.tydic.picker.publisher.PickerClientPublisher;
import com.tydic.picker.service.DataSyncService;
import com.tydic.picker.service.imp.DataSyncServiceImpl;
import com.tydic.picker.utils.ElasticsearchUtil;
import org.aopalliance.aop.Advice;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(prefix="picker.client", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={PickerProperties.class})
public class PickerClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PickerClientConfiguration.class);
    private static final String PACKAGE_DELIMITER = ",";
    private PickerProperties pickerProperties;

    public PickerClientConfiguration(PickerProperties pickerProperties) {
        this.pickerProperties = pickerProperties;
    }

    @Bean(value={"elasticsearchUtil"})
    public ElasticsearchUtil elasticsearchUtil(RestHighLevelClient client) {
        return new ElasticsearchUtil(client);
    }

    @Bean(value={"pickerClient"}, destroyMethod="close")
    public PickerClient pickerClient(CacheClient cacheClient, DataSyncService dataSyncService) {
        log.info("\u521d\u59cb\u5316\u6570\u636e\u540c\u6b65\u5ba2\u6237\u7aef");
        PickerClient pickerClient = new PickerClient();
        PickerClientDisruptorClientPublisher publisher = PickerClientDisruptorClientPublisher.getInstance();
        publisher.start(dataSyncService);
        pickerClient.init((PickerClientPublisher)publisher, cacheClient, dataSyncService);
        return pickerClient;
    }

    @Bean
    @Order(value=-1)
    public AspectJExpressionPointcutAdvisor syncDataByPointCutAdvice(PickerClient pickerClient) {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText((String)this.pickerProperties.getPointcutPackage())) {
            if (this.pickerProperties.getPointcutPackage().contains(PACKAGE_DELIMITER)) {
                String[] nativeRpcPackageSplit;
                for (String nativeRpcPackageString : nativeRpcPackageSplit = this.pickerProperties.getPointcutPackage().split(PACKAGE_DELIMITER)) {
                    if (!StringUtils.hasText((String)nativeRpcPackageString)) continue;
                    if (null == expressionBuilder) {
                        expressionBuilder = new StringBuilder();
                        expressionBuilder.append("(execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                        continue;
                    }
                    expressionBuilder.append(" || (execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(this.pickerProperties.getPointcutPackage()).append("..*(..)))");
            }
        }
        String expression = String.valueOf(expressionBuilder);
        advisor.setExpression(expression);
        log.info("\u6570\u636e\u540c\u6b65\u5207\u9762\u8868\u8fbe\u5f0f\u4e3a\uff1a" + expression);
        advisor.setAdvice((Advice)new SyncDataByPointCutAdvice(pickerClient));
        log.info("\u6570\u636e\u540c\u6b65\u5207\u9762\u914d\u7f6e\u5b8c\u6210\uff0c\u5207\u70b9\u89c4\u5219\u4e3a\uff1a{}", (Object)expression);
        return advisor;
    }

    @Bean
    public RecordTableCheckRunner recordTableCheckRunner() {
        return new RecordTableCheckRunner();
    }

    @Bean(value={"dataSyncService"})
    public DataSyncService DataSyncService(JdbcTemplate jdbcTemplate, ElasticsearchUtil elasticsearchUtil) {
        return new DataSyncServiceImpl(jdbcTemplate, elasticsearchUtil);
    }
}

