/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.service.imp;

import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.picker.config.FastJsonConfig;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.dto.PickerRecordDTO;
import com.tydic.picker.enums.ConstantEnum;
import com.tydic.picker.enums.ResultCodeEnum;
import com.tydic.picker.result.PickerResult;
import com.tydic.picker.service.DataSyncService;
import com.tydic.picker.task.PartitionResult;
import com.tydic.picker.task.PartitionTask;
import com.tydic.picker.utils.DynamicSqlUtil;
import com.tydic.picker.utils.ElasticsearchUtil;
import com.tydic.picker.utils.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataSyncServiceImpl
implements DataSyncService {
    private static final Logger log = LoggerFactory.getLogger(DataSyncServiceImpl.class);
    @Resource
    private DynamicSqlUtil dynamicSqlUtil;
    private JdbcTemplate jdbcTemplate;
    private ElasticsearchUtil elasticsearchUtil;
    private ExecutorService partitionRequestPool;
    private Integer pageSize;

    public DataSyncServiceImpl(JdbcTemplate jdbcTemplate, ElasticsearchUtil elasticsearchUtil, ExecutorService partitionRequestPool, Integer pageSize) {
        this.jdbcTemplate = jdbcTemplate;
        this.elasticsearchUtil = elasticsearchUtil;
        this.partitionRequestPool = partitionRequestPool;
        this.pageSize = pageSize;
    }

    @Override
    public PickerResult doSync(DataPickDTO dto) {
        log.info("==\u5f00\u59cb\u91c7\u96c6\u6570\u636e\u5e76\u540c\u6b65ES");
        Long recordId = null;
        try {
            recordId = this.createSyncRecord(dto);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u540c\u6b65\u8bb0\u5f55\u5165\u5e93\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        StrBuilder errorMessageBuilder = StrUtil.strBuilder();
        String mainSql = dto.getDynamicSql();
        if (StringUtils.isEmpty((CharSequence)mainSql)) {
            JSONObject esData = this.dynamicSqlUtil.getMappedData(dto);
            log.debug("\u6839\u636e\u6620\u5c04\u5173\u7cfb\u7684\u5230\u7684\u6570\u636e\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)esData, (SerializerFeature[])FastJsonConfig.getSerializerFeature()));
            this.elasticsearchUtil.doSyncByEventType(dto.getEventTypeEnum(), dto.getIndexName(), esData);
        } else {
            int mainDataResultSize;
            mainSql = this.dynamicSqlUtil.getDynamicSqlPage(dto, this.pageSize);
            Integer startPageNo = 0;
            ArrayList<Future<Object>> futureResults = new ArrayList<Future<Object>>();
            do {
                mainDataResultSize = 0;
                List mainDataList = this.dynamicSqlUtil.getDataPage(mainSql, startPageNo, this.pageSize);
                if (!CollectionUtil.isNotEmpty((Collection)mainDataList) || 0 >= (mainDataResultSize = mainDataList.size())) continue;
                Integer n = startPageNo;
                Integer n2 = startPageNo = Integer.valueOf(startPageNo + 1);
                PartitionTask partitionTask = PartitionTask.builder().recordId(recordId).dynamicSqlUtil(this.dynamicSqlUtil).elasticsearchUtil(this.elasticsearchUtil).dto(dto).pageNo(n).mainDataList(mainDataList).build();
                Future<Object> future = this.partitionRequestPool.submit(partitionTask);
                futureResults.add(future);
            } while (this.pageSize == mainDataResultSize);
            List<Object> resultList = new ArrayList<PartitionResult>(futureResults.size());
            for (Future<Object> future : futureResults) {
                try {
                    resultList.add((PartitionResult)future.get(5L, TimeUnit.MINUTES));
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u5206\u7247\u4efb\u52a1\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    e.printStackTrace();
                    errorMessageBuilder.append((CharSequence)("\u83b7\u53d6\u5206\u7247\u4efb\u52a1\u7ed3\u679c\u5f02\u5e38\uff1a{}" + e.getMessage()));
                }
            }
            resultList = resultList.stream().filter(item -> ResultCodeEnum.FAIL.getCode().equals(item.getCode())).collect(Collectors.toList());
            resultList.forEach(item -> errorMessageBuilder.append((CharSequence)item.getMessage()).append((CharSequence)","));
        }
        return this.updateRecordAndBuildResult(recordId, errorMessageBuilder.toString());
    }

    private PickerResult updateRecordAndBuildResult(Long recordId, String errMessage) {
        PickerResult result = new PickerResult(ResultCodeEnum.SUCCESS);
        try {
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                this.updateRecord(recordId, ConstantEnum.PickerRecordStatusEnum.SUCCESS, ConstantEnum.PickerRecordStatusEnum.SUCCESS.getDesc());
            } else {
                this.updateRecord(recordId, ConstantEnum.PickerRecordStatusEnum.FAIL, errMessage);
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u540c\u6b65\u8bb0\u5f55\u72b6\u6001\u66f4\u65b0\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        if (StringUtils.isNotEmpty((CharSequence)errMessage)) {
            result.buildFail(errMessage);
        }
        log.info("==\u91c7\u96c6\u6570\u636e\u5e76\u540c\u6b65ES\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    private Long createSyncRecord(DataPickDTO dto) {
        Long id = Sequence.nextId();
        PickerRecordDTO recordPo = new PickerRecordDTO();
        BeanUtils.copyProperties((Object)dto, (Object)recordPo);
        recordPo.setId(id);
        recordPo.setConditionParam(JSON.toJSONString((Object)dto.getConditionParam()));
        recordPo.setEventType(dto.getEventTypeEnum().getEventType());
        recordPo.setStartTime(new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
        recordPo.setStatusDesc(ConstantEnum.PickerRecordStatusEnum.INIT.getDesc());
        recordPo.setDynamicSql(StringUtils.isEmpty((CharSequence)dto.getDynamicSql()) ? null : Base64Encoder.encode((CharSequence)dto.getDynamicSql()));
        String dynamicSql = ConstantEnum.DynamicSqlEnum.INSERT.getDynamicSql((Map)JSON.parseObject((String)JSON.toJSONString((Object)recordPo), Map.class));
        log.debug("\u8bb0\u5f55\u6570\u636e\u540c\u6b65SQL\uff1a{}", (Object)dynamicSql);
        if (1 > this.jdbcTemplate.update(dynamicSql)) {
            log.error("\u8bb0\u5f55\u6570\u636e\u540c\u6b65\u8bb0\u5f55\u5931\u8d25");
            return null;
        }
        return id;
    }

    private void updateRecord(Long recordId, ConstantEnum.PickerRecordStatusEnum statusEnum, String desc) {
        PickerRecordDTO recordPo = new PickerRecordDTO();
        recordPo.setId(recordId);
        recordPo.setStatus(statusEnum.getState());
        recordPo.setStatusDesc(desc);
        recordPo.setFinishTime(new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
        String dynamicSql = ConstantEnum.DynamicSqlEnum.UPDATE.getDynamicSql((Map)JSON.parseObject((String)JSON.toJSONString((Object)recordPo), Map.class));
        log.debug("\u8bb0\u5f55\u6570\u636e\u540c\u6b65SQL\uff1a{}", (Object)dynamicSql);
        if (1 > this.jdbcTemplate.update(dynamicSql)) {
            log.error("\u66f4\u65b0\u6570\u636e\u540c\u6b65\u8bb0\u5f55\u5931\u8d25");
        }
    }
}

