package com.tydic.picker.disruptor.executor;

import com.tydic.picker.consumer.QueueConsumerExecutor;
import com.tydic.picker.consumer.QueueConsumerFactory;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.subscriber.ExecutorSubscriber;
import org.apache.commons.collections4.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName PickerConsumerExecutor
 * @Description
 * @Author liugs
 * @Date 2022/8/15 16:15
 */
public class DataSyncConsumerExecutor extends QueueConsumerExecutor<Collection<DataPickDTO>> {

    private ExecutorSubscriber<DataPickDTO> subscribers;

    public DataSyncConsumerExecutor(ExecutorSubscriber<DataPickDTO> subscribers) {
        this.subscribers = subscribers;
    }

    @Override
    public void run() {
        Collection<DataPickDTO> results = getData()
                .stream()
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(results)) {
            return;
        }

        subscribers.executor(results);
    }

    public static class DataSyncExecutorFactory implements QueueConsumerFactory<Collection<DataPickDTO>> {
        /**
         * The Subscribers.
         */
        private ExecutorSubscriber<DataPickDTO> subscriber;

        @Override
        public QueueConsumerExecutor<Collection<DataPickDTO>> create() {
            return new DataSyncConsumerExecutor(subscriber);
        }

        @Override
        public String fixName() {
            return "data_sync_executor";
        }

        /**
         * Add subscribers abstract queue consumer factory.
         *
         * @param subscriber the subscriber
         * @return the abstract queue consumer factory
         */
        public DataSyncExecutorFactory setSubscribers(ExecutorSubscriber<DataPickDTO> subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        /**
         * Gets subscribers.
         *
         * @return the subscribers
         */
        public ExecutorSubscriber<? extends DataPickDTO> getSubscribers() {
            return subscriber;
        }
    }
}
