/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.disruptor;

import com.tydic.picker.DisruptorProviderManage;
import com.tydic.picker.consumer.QueueConsumerFactory;
import com.tydic.picker.disruptor.executor.DataSyncConsumerExecutor;
import com.tydic.picker.disruptor.subscriber.DataSyncExecutorSubscriber;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.provider.DisruptorProvider;
import com.tydic.picker.publisher.PickerClientPublisher;
import com.tydic.picker.service.DataSyncService;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public class PickerClientDisruptorClientPublisher
implements PickerClientPublisher {
    private static final PickerClientDisruptorClientPublisher INSTANCE = new PickerClientDisruptorClientPublisher();
    private DisruptorProviderManage<Collection<DataPickDTO>> providerManage;

    public static PickerClientDisruptorClientPublisher getInstance() {
        return INSTANCE;
    }

    public void start(DataSyncService dataSyncService) {
        DataSyncConsumerExecutor.DataSyncExecutorFactory factory = new DataSyncConsumerExecutor.DataSyncExecutorFactory();
        factory.setSubscribers(new DataSyncExecutorSubscriber(dataSyncService));
        this.providerManage = new DisruptorProviderManage((QueueConsumerFactory)factory);
        this.providerManage.startup();
    }

    public void publish(DataPickDTO data) {
        DisruptorProvider provider = this.providerManage.getProvider();
        provider.onData(Collections.singleton(data));
    }

    public void publish(Collection<? extends DataPickDTO> dataList) {
        DisruptorProvider provider = this.providerManage.getProvider();
        provider.onData(dataList.stream().map(DataPickDTO.class::cast).collect(Collectors.toList()));
    }

    public void close() {
        this.providerManage.getProvider().shutdown();
    }
}

