/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.disruptor.executor;

import com.tydic.picker.consumer.QueueConsumerExecutor;
import com.tydic.picker.consumer.QueueConsumerFactory;
import com.tydic.picker.dto.DataPickDTO;
import com.tydic.picker.subscriber.ExecutorSubscriber;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class DataSyncConsumerExecutor
extends QueueConsumerExecutor<Collection<DataPickDTO>> {
    private ExecutorSubscriber<DataPickDTO> subscribers;

    public DataSyncConsumerExecutor(ExecutorSubscriber<DataPickDTO> subscribers) {
        this.subscribers = subscribers;
    }

    public void run() {
        Collection results = ((Collection)this.getData()).stream().collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)results)) {
            return;
        }
        this.subscribers.executor(results);
    }

    public static class DataSyncExecutorFactory
    implements QueueConsumerFactory<Collection<DataPickDTO>> {
        private ExecutorSubscriber<DataPickDTO> subscriber;

        public QueueConsumerExecutor<Collection<DataPickDTO>> create() {
            return new DataSyncConsumerExecutor(this.subscriber);
        }

        public String fixName() {
            return "data_sync_executor";
        }

        public DataSyncExecutorFactory setSubscribers(ExecutorSubscriber<DataPickDTO> subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        public ExecutorSubscriber<? extends DataPickDTO> getSubscribers() {
            return this.subscriber;
        }
    }
}

