package com.tydic.picker.dto;

import com.tydic.picker.enums.DataEventTypeEnum;
import lombok.Data;

import java.util.List;

/**
 * @ClassName DataPickDTO
 * @Description
 * @Author liugs
 * @Date 2022/8/15 16:01
 */
@Data
public class DataPickDTO {

    private static final long serialVersionUID = 6246044242583586703L;

    public DataPickDTO(String serviceCode, String methodCode, String conditionParam) {
        this.serviceCode = serviceCode;
        this.methodCode = methodCode;
        this.conditionParam = conditionParam;
    }

    public DataPickDTO(final Builder builder) {
        serviceCode = builder.serviceCode;
        methodCode = builder.methodCode;
        conditionParam = builder.conditionParam;
    }

    /**
     * 业务中心编码
     */
    private String busiCode;
    /**
     * 服务编码
     */
    private String serviceCode;
    /**
     * 方法编码
     */
    private String methodCode;
    /**
     * 索引名称
     */
    private String indexName;
    /**
     * 数据查询条件参数
     */
    private String conditionParam;
    /**
     * 查询语句
     */
    private String dynamicSql;
    /**
     * 映射配置信息
     */
    private String mappingInfo;
    /**
     * 同步类型 0：同步，1：异步
     */
    private Integer syncType;
    /**
     * 事件类型 1：新增，2：修改，3：删除
     */
    private DataEventTypeEnum eventTypeEnum;
    /**
     * 文档ID取值字段
     */
    private String docIdField;

    /**
     * 子查询
     */
    private List<DataSyncConfigSubQueryDTO> subQuery;

    /**
     * builder.
     *
     * @return Builder builder
     */
    public static Builder builder() {
        return new Builder();
    }

    /**
     * The type Builder.
     */
    public static final class Builder {
        /**
         * 服务编码
         */
        private String serviceCode;
        /**
         * 方法编码
         */
        private String methodCode;
        /**
         * 数据查询条件参数
         */
        private String conditionParam;

        private Builder() {
        }

        public Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public Builder methodCode(String methodCode) {
            this.methodCode = methodCode;
            return this;
        }

        public Builder conditionParam(String conditionParam) {
            this.conditionParam = conditionParam;
            return this;
        }

        /**
         * build.
         *
         * @return DataPickDTO
         */
        public DataPickDTO build() {
            return new DataPickDTO(this);
        }
    }

}
