package com.tydic.picker.dto;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * 描述：picker_record
 * 
 * @author liugs
 * @date 2022-08-18 18:04
 **/
@Data
public class PickerRecordDTO implements Serializable {
	private static final long serialVersionUID =  3387307462095260685L;

	/**
	 * 主键
	 */
	private Long id;
	/**
	 * 业务中心编码
	 */
	private String busiCode;
	/**
	 * 服务编码
	 */
	private String serviceCode;
	/**
	 * 方法编码
	 */
	private String methodCode;
	/**
	 * 索引名称
	 */
	private String indexName;
	/**
	 * 文档ID取值字段
	 */
	private String docIdField;
	/**
	 * 动态语句
	 */
	private String dynamicSql;
	/**
	 * 条件参数
	 */
	private String conditionParam;
	/**
	 * 映射关系
	 */
	private String mappingInfo;
	/**
	 * 同步类型 0：同步，1：异步
	 */
	private Integer syncType;
	/**
	 * 事件类型 1：新增，2：更新，3：删除
	 */
	private Integer eventType;
	/**
	 * 状态 0：初始状态，1：成功， 2：失败
	 */
	private Integer status;
	/**
	 * 状态描述
	 */
	private String statusDesc;
	/**
	 * 开始时间
	 */
	private String startTime;
	private Date startTimeStart;
	private Date startTimeEnd;
	/**
	 * 完成时间
	 */
	private String finishTime;
	private Date finishTimeStart;
	private Date finishTimeEnd;
	/**
	 * 排序
	 */
	private String orderBy;

}
