/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.picker.enums.DataEventTypeEnum;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsToolCompatibleEdition {
    private static final Logger log = LoggerFactory.getLogger(EsToolCompatibleEdition.class);
    private final RestClient restClient;

    public EsToolCompatibleEdition(RestClient restClient) {
        this.restClient = restClient;
    }

    public void doSyncByEventType(DataEventTypeEnum eventTypeEnum, String indexName, JSONObject esData) {
        switch (eventTypeEnum) {
            case CREATE: {
                this.addDocument(indexName, esData.remove((Object)"DOCUMENT_ID").toString(), esData);
                break;
            }
            case UPDATE: {
                this.updateDoc(indexName, esData.remove((Object)"DOCUMENT_ID").toString(), esData);
                break;
            }
            case BATCH_UPDATE: {
                this.updateBatch(indexName, esData.remove((Object)"DOCUMENT_ID"), esData);
                break;
            }
            case DELETE: {
                this.deleteDocById(indexName, esData.getString("DOCUMENT_ID"));
                break;
            }
            case DELETE_BY_QUERY: {
                esData.remove((Object)"DOCUMENT_ID");
                this.deleteDocByQuery(indexName, esData);
            }
        }
    }

    public void addDocument(String indexName, String docId, JSONObject source) {
        log.debug("\u65b0\u589e\u6587\u7ae0\u5165\u53c2\uff1aindexName='{}'\uff0cid='{}'\uff0csource='{}'", new Object[]{indexName, docId, source});
        if (StringUtils.isEmpty((CharSequence)indexName) || source.isEmpty()) {
            log.info("\u65b0\u589e\u6587\u7ae0\uff0c[indexName]\uff0c[source]\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseBusinessException("8888", "\u65b0\u589e\u6587\u7ae0\uff0c[indexName]\uff0c[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String endPoint = StrUtil.format((CharSequence)"/{}/_doc/{}", (Object[])new Object[]{indexName, docId});
        NStringEntity entity = new NStringEntity(JSON.toJSONString((Object)source, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        request.addParameter("refresh", "true");
        try {
            Response response = this.restClient.performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u65b0\u589e\u6587\u7ae0\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 201 && statusCode != 200) {
                String failReason = EntityUtils.toString((HttpEntity)response.getEntity());
                log.info("\u65b0\u589e\u6587\u7ae0\u5931\u8d25\uff1a{}", (Object)failReason);
                throw new BaseBusinessException("8888", "\u65b0\u589e\u6587\u7ae0\u5931\u8d25\uff1a" + failReason);
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u65b0\u589e\u6587\u7ae0\u6210\u529f\uff0c\u54cd\u5e94\u53c2\u6570\uff1a{}", (Object)responseBody);
        }
        catch (IOException e) {
            log.error("\u65b0\u589e\u6587\u7ae0\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BaseBusinessException("8888", "\u65b0\u589e\u6587\u7ae0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void updateDoc(String indexName, String docId, JSONObject source) {
        if (log.isDebugEnabled()) {
            log.debug("\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\uff0c\u5165\u53c2\uff1aindexName = '{}', docId = '{}'", (Object)indexName, (Object)docId);
        }
        String endPoint = StrUtil.format((CharSequence)"/{}/_update/{}", (Object[])new Object[]{indexName, docId});
        NStringEntity entity = new NStringEntity("{\"doc\": " + JSON.toJSONString((Object)source, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}) + "}", ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        request.addParameter("retry_on_conflict", "3");
        try {
            Response response = this.restClient.performRequest(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject jsonResponse = JSONObject.parseObject((String)responseBody);
                String result = jsonResponse.getString("result");
                if ("updated".equals(result) || "noop".equals(result)) {
                    log.info("\u6587\u7ae0\u66f4\u65b0\u6210\u529f");
                    return;
                }
                throw new BaseBusinessException("8888", "\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\u5931\u8d25\uff1a" + result);
            }
            String failReason = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\u5931\u8d25\uff1a{}", (Object)failReason);
            throw new BaseBusinessException("8888", "\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\u5931\u8d25\uff1a" + failReason);
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BaseBusinessException("8888", "\u6839\u636e\u6587\u7ae0ID\u66f4\u65b0\u6587\u7ae0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void updateBatch(String indexName, Object docIds, JSONObject source) {
        String endPoint = "/" + indexName + "/_update_by_query";
        String esUpdateStr = this.toEsBatchUpdateStr(docIds, source);
        log.info("esUpdate URL:{}", (Object)endPoint);
        log.info("esUpdateStrReq:{}", (Object)esUpdateStr);
        NStringEntity entity = new NStringEntity(esUpdateStr, ContentType.APPLICATION_JSON);
        try {
            JSONObject rspJsonObject;
            Integer updated;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.restClient.performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("esUpdateStrRsp:{}", (Object)result);
            if (StringUtils.isNotBlank((CharSequence)result) && (updated = (Integer)(rspJsonObject = JSON.parseObject((String)result)).get((Object)"updated")) > 0) {
                log.info("\u6279\u91cf\u66f4\u65b0\u6210\u529f");
            }
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u66f4\u65b0ES\u6570\u636e\u5931\u8d25:{},\u66f4\u65b0\u8bed\u53e5:{}", (Object)e, (Object)esUpdateStr);
            throw new BaseBusinessException("8888", "\u6279\u91cf\u66f4\u65b0ES\u6570\u636e\u5931\u8d25(ES6)\uff1a" + e.getMessage());
        }
    }

    public void deleteDocById(String indexName, String docId) {
        log.debug("\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\uff0c\u5165\u53c2\uff1aindexName={}\uff0cdocId={}", (Object)indexName, (Object)docId);
        if (StringUtils.isEmpty((CharSequence)indexName) || StringUtils.isEmpty((CharSequence)docId)) {
            log.info("\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\uff0c\u5165\u53c2[indexName]\u548c[docId]\u4e3a\u7a7a\uff0c\u6267\u884c\u7ed3\u675f\uff01");
            return;
        }
        Request request = new Request("DELETE", StrUtil.format((CharSequence)"/{}/_doc/{}", (Object[])new Object[]{indexName, docId}));
        request.addParameter("refresh", "true");
        try {
            Response response = this.restClient.performRequest(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                HttpEntity entity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)entity);
                log.error("\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff0c\u72b6\u6001\u7801\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", (Object)statusCode, (Object)responseString);
                throw new BaseBusinessException("8888", "\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a" + responseString);
            }
            log.info("\u5220\u9664\u7d22\u5f15[{}]\u6587\u7ae0[{}]\u6210\u529f", (Object)indexName, (Object)docId);
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
            throw new BaseBusinessException("8888", "\u6839\u636e\u6587\u7ae0ID\u5220\u9664\u6587\u7ae0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void deleteDocByQuery(String indexName, JSONObject condition) {
        block6: {
            log.debug("\u6839\u636e\u6761\u4ef6\u5220\u9664\u6587\u7ae0\uff0c\u5165\u53c2\uff1aindexName={}\uff0ccondition={}", (Object)indexName, (Object)condition.toJSONString());
            if (StringUtils.isEmpty((CharSequence)indexName) || ObjectUtil.isEmpty((Object)condition)) {
                log.info("\u6839\u636e\u6761\u4ef6\u5220\u9664\u6587\u7ae0\uff0c\u5165\u53c2[indexName]\u548c[condition]\u4e3a\u7a7a\uff0c\u6267\u884c\u7ed3\u675f\uff01");
                return;
            }
            StringBuilder queryBuilder = new StringBuilder("{\"query\":{\"bool\":{\"must\":[");
            Iterator iterator = condition.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                queryBuilder.append("{\"term\":{\"").append((String)entry.getKey()).append("\":\"").append(entry.getValue()).append("\"}}");
                if (!iterator.hasNext()) continue;
                queryBuilder.append(",");
            }
            queryBuilder.append("]}}}");
            Request request = new Request("POST", "/" + indexName + "/_delete_by_query");
            request.setEntity((HttpEntity)new NStringEntity(queryBuilder.toString(), ContentType.APPLICATION_JSON));
            request.addParameter("refresh", "true");
            try {
                Response response = this.restClient.performRequest(request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity entity = response.getEntity();
                    String responseString = EntityUtils.toString((HttpEntity)entity);
                    log.info("\u6839\u636e\u6761\u4ef6{}\u5220\u9664\u7d22\u5f15{}\u6587\u7ae0\u8c03\u7528\u6210\u529f\uff0c\u54cd\u5e94\uff1a{}", new Object[]{condition.toJSONString(), indexName, responseString});
                    Integer deleted = JSON.parseObject((String)responseString).getInteger("deleted");
                    if (deleted > 1) {
                        log.info("\u6839\u636e\u6761\u4ef6\u5220\u9664\u7d22\u5f15\u6587\u7ae0\u6210\u529f\u3002");
                    }
                    break block6;
                }
                HttpEntity entity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)entity);
                log.error("\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff0c\u72b6\u6001\u7801\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", (Object)statusCode, (Object)responseString);
                throw new BaseBusinessException("8888", "\u6839\u636e\u6761\u4ef6\u5220\u9664\u6587\u7ae0\u5931\u8d25\uff1a" + responseString);
            }
            catch (IOException e) {
                log.error("\u6839\u636e\u6761\u4ef6\u5220\u9664\u6587\u7ae0\u5f02\u5e38\uff1a" + e);
                throw new BaseBusinessException("8888", "\u6839\u636e\u6761\u4ef6\u5220\u9664\u6587\u7ae0\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public String toEsBatchUpdateStr(Object docIds, JSONObject updateParams) {
        JSONArray docList = JSON.parseArray((String)JSON.toJSONString((Object)docIds));
        List idsList = docList.stream().map(Object::toString).collect(Collectors.toList());
        JSONObject ids = new JSONObject();
        ids.put("values", idsList);
        JSONObject query = new JSONObject();
        query.put("ids", (Object)ids);
        JSONObject script = new JSONObject();
        script.put("source", (Object)this.getSource(updateParams));
        script.put("lang", (Object)"painless");
        script.put("params", (Object)updateParams);
        JSONObject esJsonObj = new JSONObject();
        esJsonObj.put("query", (Object)query);
        esJsonObj.put("script", (Object)script);
        return esJsonObj.toJSONString();
    }

    private String getSource(JSONObject updateParams) {
        StringBuilder stringBuilder = new StringBuilder();
        updateParams.keySet().forEach(key -> stringBuilder.append("ctx._source.").append((String)key).append("=").append("params.").append((String)key).append(";"));
        return stringBuilder.toString();
    }
}

