/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.picker.thread;

import com.google.common.hash.Hashing;
import com.tydic.picker.thread.SingletonExecutor;
import java.nio.charset.StandardCharsets;
import java.util.SortedMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;

public class OrderlyExecutor
extends ThreadPoolExecutor {
    private final ConcurrentSkipListMap<Long, SingletonExecutor> virtualExecutors = new ConcurrentSkipListMap();
    private final ThreadSelector threadSelector = new ThreadSelector();

    public OrderlyExecutor(boolean isOrderly, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.orderlyThreadPool(isOrderly, corePoolSize, threadFactory);
    }

    private void orderlyThreadPool(boolean isOrderly, int corePoolSize, ThreadFactory threadFactory) {
        if (isOrderly) {
            IntStream.range(0, corePoolSize).forEach(index -> {
                SingletonExecutor singletonExecutor = new SingletonExecutor(threadFactory);
                String hash = singletonExecutor.hashCode() + ":" + index;
                byte[] bytes = this.threadSelector.sha(hash);
                for (int i = 0; i < 4; ++i) {
                    this.virtualExecutors.put(this.threadSelector.hash(bytes, i), singletonExecutor);
                }
            });
        }
    }

    public SingletonExecutor select(String hash) {
        long select = this.threadSelector.select(hash);
        if (!this.virtualExecutors.containsKey(select)) {
            SortedMap tailMap = this.virtualExecutors.tailMap((Object)select);
            select = tailMap.isEmpty() ? this.virtualExecutors.firstKey().longValue() : ((Long)tailMap.firstKey()).longValue();
        }
        return this.virtualExecutors.get(select);
    }

    private static final class ThreadSelector {
        private ThreadSelector() {
        }

        public long select(String hash) {
            byte[] digest = this.sha(hash);
            return this.hash(digest, 0);
        }

        private long hash(byte[] digest, int number) {
            return ((long)(digest[3 + number * 4] & 0xFF) << 24 | (long)(digest[2 + number * 4] & 0xFF) << 16 | (long)(digest[1 + number * 4] & 0xFF) << 8 | (long)(digest[number * 4] & 0xFF)) & 0xFFFFFFFFL;
        }

        private byte[] sha(String hash) {
            byte[] bytes = hash.getBytes(StandardCharsets.UTF_8);
            return Hashing.sha256().newHasher().putBytes(bytes).hash().asBytes();
        }
    }
}

