/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.maven.boot;

import com.google.common.base.Charsets;
import com.google.common.collect.FluentIterable;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="BootCompileMojo", defaultPhase=LifecyclePhase.PRE_CLEAN)
public class BootCompileMojo
extends AbstractMojo {
    private static final String PLUGIN_NAME = "plugin-boot-compile";
    private static final String API_BIG = "API";
    private static final String API_MIN = "api";
    private static final String LOMBOK_CONFIG = "lombok.config";
    private static final String INVOKE_TYPES_KEY = "haotian.service.invokeTypes";
    private static final String GROUP_KEY = "haotian.service.group";
    private static final String VERSION_KEY = "haotian.service.version";
    private static final String APPLICATIONNAME_KEY = "haotian.service.applicationName";
    private String pomsName = "poms";
    private static final String POMXML = "pom.xml";
    private static final String PACKAGE_POM = "pom";
    private static final String JAVA_SUFFIX = ".java";
    private static final String TXT_SUFFIX = ".txt";
    private Set<String> invokeTypesSet = new HashSet<String>();
    @Parameter
    private boolean enable;
    @Parameter
    private Set<String> options;
    @Parameter
    private String invokeTypes;
    @Parameter
    private String group;
    @Parameter
    private String version;
    @Parameter
    private String applicationName;
    @Parameter
    private String pomName;
    @Parameter
    private String projectName;
    @Parameter
    private String projectPath;
    @Parameter
    private String packaging;
    @Parameter
    private String pomsFileName;
    @Parameter
    private boolean replaceMainAble;
    @Parameter
    private Map<String, String> mainObjectMap;

    public BootCompileMojo() {
        this.invokeTypesSet.add("Dubbo");
        this.invokeTypesSet.add("HSF");
        this.invokeTypesSet.add("SpringCloud");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        System.out.println("main switch is : " + this.enable);
        if (this.enable) {
            this.validata();
            if (this.pomsFileName != null && !this.pomsFileName.isEmpty()) {
                this.pomsName = this.pomsFileName;
            }
            if (this.options.contains(this.projectName)) {
                System.out.println("options=" + this.options + ",invokeTypes=" + this.invokeTypes + ",pomName=" + this.pomName + ",packaging=" + this.packaging + ",projectName=" + this.projectName + ",projectPath=" + this.projectPath);
                if (this.projectName.contains(API_MIN) || this.projectName.contains(API_BIG)) {
                    this.replaceLombokConfig();
                }
                this.replacePomFile();
            } else {
                System.out.println("plugin-boot-compile skip project : " + this.projectName);
            }
            System.out.println("replace main object switch is : " + this.replaceMainAble);
            if (this.replaceMainAble) {
                System.out.println("replace main object map is : " + this.mainObjectMap);
                this.replaceMainObject();
            }
        } else {
            System.out.println("plugin-boot-compile do not work");
        }
    }

    private void replaceMainObject() {
        if (this.mainObjectMap.keySet().contains(this.projectName)) {
            String mainObjectStr = this.mainObjectMap.get(this.projectName);
            if (!mainObjectStr.endsWith(JAVA_SUFFIX)) {
                mainObjectStr = mainObjectStr + JAVA_SUFFIX;
            }
            String absoluteMainPath = this.findConfigPath(this.projectPath, mainObjectStr);
            System.out.println("projectName(" + this.projectName + ") , main object name is : " + mainObjectStr);
            System.out.println("projectName(" + this.projectName + ") , main object absolute path is : " + absoluteMainPath);
            if (absoluteMainPath == null) {
                throw new RuntimeException("projectName(" + this.projectName + ") ,main object(" + mainObjectStr + ") file is not exists");
            }
            String mainSouceFileName = this.invokeTypes + TXT_SUFFIX;
            String mainSourceFileAbsPath = this.findConfigPath(this.projectPath, mainSouceFileName);
            System.out.println("projectName(" + this.projectName + ") , .txt file absolute path is : " + mainSourceFileAbsPath);
            if (mainSourceFileAbsPath == null) {
                throw new RuntimeException("projectName(" + this.projectName + ") ," + this.invokeTypes + ".txt(" + mainSouceFileName + ") file is not exists");
            }
            try {
                File oldPomFile = new File(absoluteMainPath);
                Files.asCharSink((File)oldPomFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
                FileChannel outChannel = FileChannel.open(Paths.get(absoluteMainPath, new String[0]), StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
                FileChannel inChannel = FileChannel.open(Paths.get(mainSourceFileAbsPath, new String[0]), new OpenOption[0]);
                inChannel.transferTo(0L, inChannel.size(), outChannel);
                inChannel.close();
                outChannel.close();
            }
            catch (IOException e) {
                throw new RuntimeException("projectName(" + this.projectName + ") copy main object exception:" + e.getMessage(), e);
            }
        }
    }

    private void replacePomFile() {
        String fileSeparator = File.separator;
        String newPomFilePath = this.pomsPath() + fileSeparator + this.projectName + fileSeparator + this.pomName;
        System.out.println("newPomFilePath = " + newPomFilePath);
        File newPomFilePathFile = new File(newPomFilePath);
        if (!newPomFilePathFile.exists()) {
            throw new RuntimeException("projectName(" + this.projectName + "),pomName(" + this.pomName + ") file is not exists");
        }
        StringBuilder newFileStrBuilder = new StringBuilder("");
        try {
            List newFileStrList = Files.readLines((File)newPomFilePathFile, (Charset)Charsets.UTF_8);
            for (String value : newFileStrList) {
                newFileStrBuilder.append(value).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("projectName(" + this.projectName + ") read pom file exception" + e);
        }
        String oldPomFilePath = this.projectPath + fileSeparator + POMXML;
        File oldPomFile = new File(oldPomFilePath);
        if (!oldPomFile.exists()) {
            throw new RuntimeException("projectName(" + this.projectName + "),oldPomFile(" + POMXML + ") file is not exists");
        }
        try {
            String newFileResultStr = newFileStrBuilder.toString();
            Files.asCharSink((File)oldPomFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
            Files.asCharSink((File)oldPomFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)newFileResultStr.substring(0, newFileResultStr.length() - 1));
        }
        catch (IOException e) {
            throw new RuntimeException("cover pom.xml file exception", e);
        }
    }

    private String pomsPath() {
        String pomsPath = "";
        pomsPath = PACKAGE_POM.equals(this.packaging) ? this.projectPath + File.separator + this.pomsName : this.projectPath.substring(0, this.projectPath.lastIndexOf(File.separator)) + File.separator + this.pomsName;
        return pomsPath;
    }

    private void replaceLombokConfig() {
        String findConfigPath = this.findConfigPath(this.projectPath, LOMBOK_CONFIG);
        System.out.println("lombok.config = " + findConfigPath);
        if (findConfigPath == null || findConfigPath.isEmpty()) {
            return;
        }
        File configFile = new File(findConfigPath);
        StringBuilder changedConfigValues = new StringBuilder();
        try {
            List configValues = Files.readLines((File)configFile, (Charset)Charsets.UTF_8);
            for (String value : configValues) {
                if (value.contains(INVOKE_TYPES_KEY)) {
                    changedConfigValues.append(INVOKE_TYPES_KEY).append(" += ").append(this.invokeTypes).append("\n");
                    continue;
                }
                if (value.contains(GROUP_KEY)) {
                    changedConfigValues.append(GROUP_KEY).append(" = ").append(this.group).append("\n");
                    continue;
                }
                if (value.contains(VERSION_KEY)) {
                    changedConfigValues.append(VERSION_KEY).append(" = ").append(this.version).append("\n");
                    continue;
                }
                if (value.contains(APPLICATIONNAME_KEY)) {
                    changedConfigValues.append(APPLICATIONNAME_KEY).append(" = ").append(this.applicationName).append("\n");
                    continue;
                }
                changedConfigValues.append(value).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("read lombok.config file exception", e);
        }
        try {
            Files.asCharSink((File)configFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
            Files.asCharSink((File)configFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)changedConfigValues.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("cover config file exception", e);
        }
    }

    private void validata() {
        if (!this.invokeTypesSet.contains(this.invokeTypes)) {
            throw new RuntimeException("invokeTypes must be one of : " + this.invokeTypesSet);
        }
        if (this.invokeTypes == null || this.invokeTypes.isEmpty()) {
            throw new RuntimeException("invokeTypes property can not be null");
        }
        if (this.group == null || this.group.isEmpty()) {
            throw new RuntimeException("group property can not be null");
        }
        if (this.version == null || this.version.isEmpty()) {
            throw new RuntimeException("version property can not be null");
        }
        if (this.applicationName == null || this.applicationName.isEmpty()) {
            throw new RuntimeException("applicationName property can not be null");
        }
    }

    private String findConfigPath(String projectPath, String fileName) {
        FluentIterable files = Files.fileTreeTraverser().preOrderTraversal((Object)new File(projectPath));
        for (File file : files) {
            if (!file.getAbsolutePath().endsWith(fileName)) continue;
            return file.getAbsolutePath();
        }
        return null;
    }
}

