/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.ability.impl;

import com.tydic.prc.ability.PrcGetDelegateTaskAbilityService;
import com.tydic.prc.ability.bo.DelegationTaskAbilityBO;
import com.tydic.prc.ability.bo.PrcGetDelegateTaskAbilityReqBO;
import com.tydic.prc.ability.bo.PrcGetDelegateTaskAbilityRespBO;
import com.tydic.prc.comb.PrcGetDelegateTaskCombService;
import com.tydic.prc.comb.bo.DelegationTaskCombBO;
import com.tydic.prc.comb.bo.PrcGetDelegateTaskCombReqBO;
import com.tydic.prc.comb.bo.PrcGetDelegateTaskCombRespBO;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prcGetDelegateTaskAbilityService")
public class PrcGetDelegateTaskAbilityServiceImpl
implements PrcGetDelegateTaskAbilityService {
    @Autowired
    private PrcGetDelegateTaskCombService prcGetDelegateTaskCombService;
    public static final String DELEGATION_STATE_PENDING = "PENDING";
    public static final String DELEGATION_STATE_RESOLVED = "RESOLVED";
    public static final String DELEGATION_STATE_ALL = "ALL";

    public PrcGetDelegateTaskAbilityRespBO getDelegateTask(PrcGetDelegateTaskAbilityReqBO req) {
        PrcGetDelegateTaskAbilityRespBO rsp = new PrcGetDelegateTaskAbilityRespBO();
        if (req == null) {
            rsp.setRspDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            rsp.setRspCode("5010");
            return rsp;
        }
        if (StringUtils.isBlank((CharSequence)req.getOperId())) {
            rsp.setRspDesc("\u5de5\u53f7[operId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            rsp.setRspCode("5010");
            return rsp;
        }
        if (StringUtils.isBlank((CharSequence)req.getSysCode())) {
            rsp.setRspDesc("\u7cfb\u7edf\u7f16\u7801[sysCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            rsp.setRspCode("5010");
            return rsp;
        }
        if (StringUtils.isNotBlank((CharSequence)req.getDelegationState()) && !DELEGATION_STATE_PENDING.equals(req.getDelegationState()) && !DELEGATION_STATE_RESOLVED.equals(req.getDelegationState()) && !DELEGATION_STATE_ALL.equals(req.getDelegationState())) {
            rsp.setRspDesc("\u59d4\u6258\u72b6\u6001[delegationState]\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4e3aPENDING/RESOLVED/ALL\uff01");
            rsp.setRspCode("5010");
            return rsp;
        }
        if (req.getPageNo() != null && req.getPageNo() < 1) {
            rsp.setRspDesc("\u9875\u7801[pageNo]\u4e0d\u80fd\u5c0f\u4e8e1\uff01");
            rsp.setRspCode("5010");
            return rsp;
        }
        if (req.getPageSize() != null && req.getPageSize() < 1) {
            rsp.setRspDesc("\u6bcf\u9875\u6570\u636e\u91cf[pageSize]\u4e0d\u80fd\u5c0f\u4e8e1\uff01");
            rsp.setRspCode("5010");
            return rsp;
        }
        PrcGetDelegateTaskCombReqBO combReq = new PrcGetDelegateTaskCombReqBO();
        BeanUtils.copyProperties((Object)req, (Object)combReq);
        PrcGetDelegateTaskCombRespBO combRsp = this.prcGetDelegateTaskCombService.getDelegateTask(combReq);
        if ("0000".equals(combRsp.getRspCode())) {
            ArrayList<DelegationTaskAbilityBO> taskList = new ArrayList<DelegationTaskAbilityBO>();
            for (DelegationTaskCombBO combBO : combRsp.getTaskList()) {
                DelegationTaskAbilityBO abilityBO = new DelegationTaskAbilityBO();
                BeanUtils.copyProperties((Object)combBO, (Object)abilityBO);
                taskList.add(abilityBO);
            }
            rsp.setTaskList(taskList);
            rsp.setTotalCount(combRsp.getTotalCount());
            rsp.setRspCode("0000");
            rsp.setRspDesc(combRsp.getRspDesc());
            return rsp;
        }
        rsp.setRspDesc(combRsp.getRspDesc());
        rsp.setRspCode(combRsp.getRspCode());
        return rsp;
    }
}

