/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.prc.aop.ability;

import com.alibaba.dubbo.rpc.RpcContext;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.taobao.eagleeye.EagleEye;
import com.tydic.prc.ability.bo.AbilityBaseRespBO;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public class AbilityAopAdvisor
implements Ordered {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String SEPARATOR = "|";
    private static final String excludeMethods = "subscribe";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String START_IDENTIFICATION = "START";
    private static final String ERROR_IDENTIFICATION = "ERROR";
    private static final String END_IDENTIFICATION = "END";
    private static final Logger atomLog = LoggerFactory.getLogger(AbilityAopAdvisor.class);

    public int getOrder() {
        return 100;
    }

    public Object throwAopTreat(ProceedingJoinPoint pjp) throws Throwable {
        Map hiddenParm = RpcContext.getContext().getAttachments();
        String traceId = "";
        if (hiddenParm.containsKey("traceId")) {
            traceId = (String)hiddenParm.get("traceId");
        } else {
            traceId = EagleEye.getTraceId();
            hiddenParm.put("traceId", traceId);
        }
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        Object rspObj = null;
        String[] infos = this.printAbilityAopStartLog(pjp, traceId);
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, "0000", "\u6210\u529f");
        }
        catch (BusinessException e) {
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)msgCode)) {
                msgCode = "8888";
            }
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = "\u5931\u8d25";
            }
            this.printAbilityAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            rspObj = rspClass.newInstance();
            this.printAbilityAopErrorLog(infos, e);
            this.putCodeToRsp(rspObj, "8888", "\u5931\u8d25:" + e.getMessage());
        }
        this.printAbilityAopEndLog(infos, rspObj);
        return rspObj;
    }

    private void printAbilityAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (this.getThrowableStrRep(e) != null) {
            infos[5] = this.getThrowableStrRep(e);
        }
        atomLog.error(this.getLogInfoByStrings(infos));
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.putCodeToRsp(object, code, desc, false);
    }

    private void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (object instanceof AbilityBaseRespBO) {
            Field field = AbilityBaseRespBO.class.getDeclaredField("rspCode");
            field.setAccessible(true);
            if (!fource && field.get(object) == null) {
                field.set(object, code);
                field = AbilityBaseRespBO.class.getDeclaredField("rspDesc");
                field.setAccessible(true);
                field.set(object, desc);
            } else if (fource && field.get(object) == null) {
                field.set(object, code);
                field = AbilityBaseRespBO.class.getDeclaredField("rspDesc");
                field.setAccessible(true);
                field.set(object, desc);
            }
        }
    }

    private String[] printAbilityAopStartLog(ProceedingJoinPoint pjp, String traceId) throws Throwable {
        Long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(String.valueOf(traceId) + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (excludeMethods.equals(methodString)) {
            return null;
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[7];
        infos[0] = commonHead.toString();
        infos[1] = START_IDENTIFICATION;
        infos[2] = nowTime.toString();
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[4] = mapper.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[4] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                Object[] objectArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = mapper.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            objStr = null;
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                    ++n2;
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
            }
        }
        atomLog.info(this.getLogInfoByStrings(infos));
        return infos;
    }

    private void printAbilityAopEndLog(String[] infos, Object object) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[1] = END_IDENTIFICATION;
        infos[3] = nowTime.toString();
        if (object != null && object instanceof AbilityBaseRespBO) {
            AbilityBaseRespBO resp = (AbilityBaseRespBO)object;
            infos[4] = resp.getRspCode();
            infos[5] = resp.getRspDesc();
            infos[6] = "\u7528\u65f6\uff1a" + (Long.parseLong(infos[3]) - Long.parseLong(infos[2])) + "ms";
        }
        atomLog.info(this.getLogInfoByStrings(infos));
    }

    private String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        String[] stringArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            stb.append(String.valueOf(info) + SEPARATOR);
            ++n2;
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }

    private String getThrowableStrRep(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        StringBuffer sb = new StringBuffer();
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(String.valueOf(line) + "\r\n");
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            sb.append(ex.toString());
        }
        return sb.toString();
    }
}

