package com.tydic.pre.contest.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.pre.contest.common.api.OrderTaskLogQryListService;
import com.tydic.pre.contest.common.bo.*;
import com.tydic.pre.contest.constants.OrderContants;
import com.tydic.pre.contest.dao.OrderTaskLogMapper;
import com.tydic.pre.contest.po.OrderListQryInfoPO;
import com.tydic.pre.contest.po.OrderTaskLogPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：OrderTaskLogQryListServiceImpl
 * 说明：
 * 时间：2023/7/22 17:16
 * 作者：Zhouhaifeng
 */
@Service
public class OrderTaskLogQryListServiceImpl implements OrderTaskLogQryListService {

    @Autowired
    private OrderTaskLogMapper orderTaskLogMapper;

    @Override
    public OrderTaskLogQryListRspBO qryTaskLogList(OrderTaskLogQryListReqBO reqBO) {
        OrderTaskLogQryListRspBO rspBO = new OrderTaskLogQryListRspBO();
        Page<OrderTaskLogPO> page =  new Page<>();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        String orderBo = JSONObject.toJSONString(reqBO);
        OrderTaskLogPO orderListQryInfoPO = JSONObject.parseObject(orderBo, OrderTaskLogPO.class);
        List<OrderTaskLogPO> orderTaskLogPOS = orderTaskLogMapper.qryList(orderListQryInfoPO, page);
        List<OrderTaskLogBO> rows = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(orderTaskLogPOS)){
            for (OrderTaskLogPO listQryInfoPO : orderTaskLogPOS) {
                String boStr = JSONObject.toJSONString(listQryInfoPO);
                OrderTaskLogBO orderListQryInfoBO = JSONObject.parseObject(boStr, OrderTaskLogBO.class);
                if(1 == listQryInfoPO.getStatus()){
                    orderListQryInfoBO.setStatusDesc("导出中");
                }
                if(2 == listQryInfoPO.getStatus()){
                    orderListQryInfoBO.setStatusDesc("导出完成");
                }
                rows.add(orderListQryInfoBO);
            }
            // 设置页码
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRows(rows);
        }else {
            rspBO.setRows(null);
        }
        return rspBO;
    }
}
