package com.tydic.pre.contest.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 标题：OrderContants
 * 说明：
 * 时间：2023/7/22 15:54
 * 作者：Zhouhaifeng
 */
public enum OrderContants {
    ORDER_STATUS_ZONE("0", "代付款"),
    ORDER_STATUS_ONE("1", "已付款"),
    ORDER_STATUS_TWO("2", "待发货"),
    ORDER_STATUS_THREE("3", "已发货"),
    ORDER_STATUS_FOUR("4", "已完成");

    private String code;
    private String message;

    OrderContants(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }



    public static Map<String, String> mapping() {
        Map<String, String> map = new LinkedHashMap<String, String>();
        for (OrderContants type : values()) {
            map.put(type.getCode(), type.getMessage());
        }
        return map;
    }

    /**
     * 通过枚举值码查找枚举值。
     *
     * @param code 查找枚举值的枚举值码。
     * @return 枚举值码对应的枚举值。
     * @throws IllegalArgumentException 如果 code 没有对应的 Status 。
     */
    public static OrderContants find(String code) {
        for (OrderContants status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    /**
     * 获取全部枚举值。
     *
     * @return 全部枚举值。
     */
    public static List<OrderContants> getAll() {
        List<OrderContants> list = new ArrayList<OrderContants>();
        for (OrderContants status : values()) {
            list.add(status);
        }
        return list;
    }

    /**
     * 获取全部枚举值码。
     *
     * @return 全部枚举值码。
     */
    public static List<String> getAllCode() {
        List<String> list = new ArrayList<String>();
        for (OrderContants status : values()) {
            list.add(status.code());
        }
        return list;
    }
}
