package com.tydic.pre.contest.exception;

/**
 * @author jiangbing(江冰)
 * @date 2017/12/22
 * @time 下午12:56
 * @discription FDS 响应 code 枚举
 **/
public enum FDSResponseInfoEnum implements BaseExceptionInfo {
    /**
     * FDS相应CODE类枚举
     */
    UNKNOWN_ERROR("FDS100999", "未知异常"),
    SUCCESS("FDS000000", "成功"),
    SYSTEM_ERROR("FDS100000", "系统异常"),
    PARAM_ERROR("FDS100001", "参数错误"),

    SEND_MSG_ERROR("FDS100002", "发送短信异常"),
    COMMIT_TASK_FAIL("FDS100003", "下载任务提交失败"),
    TEMPLATE_NOT_EXIST("FDS100004", "文件模板类型不存在"),
    TARGET_FILE_NOT_EXIST("FDS100005", "目标文件类型不存在"),
    MAPPING_IS_NULL("FDS100006", "mapping映射JSON不能为空"),
    XML_TEMPLATE_NAME_IS_NULL("FDS100007", "xml模板名不能为空"),
    FILE_TEMPLATE_ALREADY_EXIST("FDS100008", "已存在同名的模板文件, 请修改文件名"),
    FILE_TEMPLATE_NOT_XML("FDS100009", "模板文件必须是xml文件"),
    FILE_TEMPLATE_CANT_NULL("FDS100010", "模板文件内容不能为空"),
    REQ_PARAM_ERROR("FDS100011", "请求入参格式不正确"),
    MAPPING_NOT_JSON("FDS100012", "映射JSON格式错误，请校验JSON格式是否正确"),

    CALL_BUSI_CENTER_ERROR("FDS100013", "调用业务中心查询接口异常"),

    USER_UN_LOGIN_ERROR("FDS100014", "用户未登录!"),
    USER_NO_AUTH_ERROR("FDS100015", "用户没有权限!"),
    GET_USER_AUTH_ERROR("FDS100016", "获取用户权限失败!"),
    CRON_INVALID("FDS100017", "CRON表达式不可用"),
    MERGE_FILE_ERROR("FDS100018","合并临时文件异常"),
    UPLOAD_FILE_NOT_EXIST_ERROR("FDS100019","上传文件失败，待上传文件不存在!"),
    NOTICE_CENTER_PARAM_ERROR("FDS100020", "调用通知中心参数错误"),
    NOTICE_CENTER_NULL_RETURN("FDS100021", "调用通知中心 err in sending msg :null return"),
    NOTICE_CENTER_GET_USER_INFO_ERROR("FDS100022", "调用通知中心 获取用户信息异常"),
    API_COMMIT_REQUEST_PARAM_EMPTY_ERROR("FDS100023", "functionIds，functionCode二者必传其一"),
    FUNCTION_NOT_EXIST("FDS100401", "功能ID不存在"),
    FUNCTION_CODE_NOT_EXIST("FDS100402", "功能编码不存在"),
    FUNCTION_ID_AND_CODE_NOT_EXIST("FDS100403", "根据功能ID和功能编码未查询到功能"),
    UN_SUPPORT_ERROR("FDS100101", "不支持的策略"),

    NO_AVAILABLE_SERVICE("FDS100401", "无可用服务"),

    /**
     * 任务相关异常信息。
     * FDS100501 - FDS100599
     */
    TASK_DOWNLOAD_EXCEPTION("FDS100501", "任务下载异常。"),
    TASK_PRE_HANDLE_EXCEPTION("FDS100502", "任务下载预处理异常。"),
    TASK_GENERATE_FILE_EXCEPTION("FDS100503", "任务下载生成文件异常。"),
    TASK_UN_EXISTS_EXCEPTION("FDS100504", "未知的下载任务。"),
    TASK_PROGRESS_UPDATE_EXCEPTION("FDS100505", "任务状态更新失败。"),
    TASK_PRE_HANDLE_RESPONSE_EXCEPTION("FDS100506", "预处理响应JSON格式错误，请校验JSON格式是否正确"),
    TASK_TOTAL_RECORDS_SHORT_EXCEPTION("FDS100507", "任务总记录数缺失"),
    TASK_PARTITION_RESPONSE_EXCEPTION("FDS100508", "任务分片请求响应异常"),
    TASK_DATA_VOLUME_GREATER_THAN_MAXIMUM("FDS100509", "任务数据量大于数据量限制最大值"),
    TASK_CALLBACK_FAILED_EXCEPTION("FDS100510", "任务状态回调失败"),
    TASK_PARSER_IMG_FAILED_EXCEPTION("FDS100511", "写入图片信息到表格失败"),

    /**
     * id已存在 及重名校验
     * 应该数据库加唯一索引。
     */
    NAME_EXISTS_EXCEPTION("FDS100601", "存在重名记录。"),
    CODE_EXISTS_EXCEPTION("FDS100602", "编码已存在。"),
    REQUEST_PARAM_ERROR("FDS100701", "入参异常"),
    ;

    private final String errorCode;
    private final String errorMessage;

    FDSResponseInfoEnum(String errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public String getErrorCode() {
        return errorCode;
    }

    @Override
    public String getErrorMsg() {
        return errorMessage;
    }
}
