package com.tydic.pre.contest.listen;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;

import java.util.ArrayList;
import java.util.List;

/**
 * @author:jiliang
 * @Date:2019/6/12
 * @Time:10:47
 */
public class ExcelListener extends AnalysisEventListener {

    private List<List<String>> data = new ArrayList<>();

    private boolean isAllAnalysed = false;

    public ExcelListener(int size, List<String> columns) {
        if (size == 0) {
            data.add(columns);
        }
    }

    @Override
    public void invoke(Object object, AnalysisContext context) {
        data.add((List<String>) object);
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        isAllAnalysed = true;
    }

    public List<List<String>> getData() {
        return this.data;
    }

    public boolean getIsAllAnalysed() {
        return isAllAnalysed;
    }
}
