package com.tydic.pre.contest.utils;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author feifz
 * @version 1.0.0
 * @Description 静态变量定义
 * @createTime 2019年06月05日 11:43:00
 */
@Component
public class Consts {

    /**
     * 一般样式最大数据量
     */
    public static int generalMaxDataSize;

    /**
     * 复杂样式最大数据量
     */
    public static int complexMaxDataSize;

    /**
     * 最大数据量开关
     */
    public static int maxDataSizeSwitch;

    @Value("${general.max.data.size:30000}")
    private void setGeneralMaxDataSize(int generalMaxDataSize) {
        Consts.generalMaxDataSize = generalMaxDataSize;
    }

    @Value("${complex.max.data.size:30000}")
    private void setComplexMaxDataSize(int complexMaxDataSize) {
        Consts.complexMaxDataSize = complexMaxDataSize;
    }

    @Value("${max.data.size.switch:0}")
    private void setMaxDataSizeSwitch(int maxDataSizeSwitch) {
        Consts.maxDataSizeSwitch = maxDataSizeSwitch;
    }

    /**
     * 最大数据量开关 开
     */
    public static final Integer MAX_DATA_SIZE_ON = 1;

    /**
     * 描述 最大数据量开关是否开启
     *
     * @return boolean
     * @author liugs
     * @date 2021/11/10 16:19
     */
    public static boolean maxDataSizeIsOn() {
        return MAX_DATA_SIZE_ON.equals(maxDataSizeSwitch);
    }

    public static final String SUCCESS_CODE = "0";

    /**
     * 删除标志符 -已删除
     */
    public static final Integer DELETED_FLAG = 1;

    /**
     * 删除标志符 -未删除
     */
    public static final Integer UNDELETED_FLAG = 0;

    /**
     * 下载中心-通知中心配置模块中-发送平台标志位
     */
    public static final Integer FDS_SEND_PLATFORM = 1;
    /**
     * http 协议前缀
     */
    public static final String HTTP_PROTOCOL_PRX = "http://";
    /**
     * 分页返参 key
     */
    public static final String DATA = "data";
    public static final String PAGE_NO = "pageNo";
    public static final String RECORDS_TOTAL = "recordsTotal";
    public static final String TOTAL = "total";
    public static final String ROWS = "rows";
    public static final String PAGE_SIZE = "pageSize";
    /**
     * 重试次数 默认为1
     */
    public static final int RETRY_VALUE = 2;
    /**
     * 重试间隔 默认为1000（单位毫秒）
     */
    public static final int RETRY_SLEEP = 1000;
    /**
     * 服务调用验证字段
     */
    public static final String SERVICE_CHECK_STRING = "code";
    /**
     * 成功code
     */
    public static final String SERVICE_CHECK_SUCCESS = "0";
    public static final String TASK_FORMAT_NAME = "%s-DOWNLOAD-TASK-%d";
    public static final String JOB_FORMAT_NAME = "JOB-%s";
    public static final String TRIGGER_FORMAT_NAME = "TRIGGER-%s";
    public static final String TASK_KEY = "IDENTITY";
    public static final String JOB_GROUP_TASK_DATA_FETCH = "GROUP";
    /**
     * api
     */
    public static final String URL_QUERY_USER_INFO = "/rest/portal/authForApp/query/userInfo";
    public static final String URL_QUERY_USER_MENU = "/rest/portal/authForApp/query/loadUserMenus";
    public static final String URL_QUERY_USER_ROLES = "/rest/portal/user/selectUserRoles";
    public static final String URL_QUERY_TOKEN = "/rest/portal/api/token/get";
    /**
     * msg
     */
    public static final String SERVICE_ID_REQUIRE_NOT_NULL = "服务id[serviceId]不能为空";
    public static final String SERVICE_NAME_REQUIRE_NOT_NULL = "服务名称[serviceName]不能为空";
    public static final String SERVICE_TYPE_REQUIRE_NOT_NULL = "服务类型[serviceType]不能为空";
    public static final String FUNCTION_ID_REQUIRE_NOT_NULL = "功能id[functionId]不能为空";
    public static final String BUSINESS_ID_REQUIRE_NOT_NULL = "业务中心id[businessCenterId]不能为空";
    public static final String TASK_ID_REQUIRE_NOT_NULL = "任务id[taskId]不能为空";
    public static final String USER_ID_REQUIRE_NOT_NULL = "用户id[userId]不能为空";
    /**
     * 调用业务中心分页请求 pageSize/pageNo
     */
    public static int PAGE_SIZE_NUM;
    public static int PAGE_SIZE_NUM_COMPLEX;
    public static final String KEY_PAGE_SIZE = "pageSize";
    public static final String KEY_PAGE_NO = "pageNo";

    @Value("${http-pagesize:5000}")
    private void setPageSizeNum(int pageSizeNum) {
        PAGE_SIZE_NUM = pageSizeNum;
    }

    @Value("${http-pagesize-complex:5000}")
    private void setPageSizeNumComplex(int pageSizeNumComplex) {
        PAGE_SIZE_NUM_COMPLEX = pageSizeNumComplex;
    }

    /**
     * CAS登录成功之后存入session用户id
     */
    public static String LOGINED_USER_ID = "userId";
    /**
     * 角色
     */
    public static String AUTH_IDENTITY_ENUM = "authIdentityEnum";
    public static String UTF_8 = "UTF-8";

    /**
     * path
     */

    public static String FILE_SERVICE_PATH = "fileDownloadPlatform/excel";

    /*
     * 文件模板路径
     */
    public static String FILE_TEMPLATE_PATH = "fileDownloadPlatform/xml";

    /**
     * 业务中心出参图片对象
     */
    public static final String IMG_HOLDER = "imgHolders";

    /**
     * 业务中心出参图片对象
     */
    public static final String WATER_HOLDER = "waterHolders";

    public static final String MERAGE =  "Merge";

}
