/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.qry.business;

import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.qry.api.QueryMainService;
import com.tydic.qry.bo.BoolQueryConfigBo;
import com.tydic.qry.bo.BoolQueryConfigRspBo;
import com.tydic.qry.bo.EsMainQueryInfoRspBo;
import com.tydic.qry.bo.EsMainQueryReqBo;
import com.tydic.qry.bo.EsMainQueryRspBo;
import com.tydic.qry.bo.EsQueryConfigBo;
import com.tydic.qry.bo.RelatQueryConfigBo;
import com.tydic.qry.bo.SortQueryConfigBo;
import com.tydic.qry.bo.SortQueryConfigRspBo;
import com.tydic.qry.bo.SourceQueryConfigBo;
import com.tydic.qry.bo.SourceQueryConfigRspBo;
import com.tydic.qry.dao.BoolQueryConfigMapper;
import com.tydic.qry.dao.EsQueryConfigMapper;
import com.tydic.qry.dao.RelatQueryConfigMapper;
import com.tydic.qry.dao.SortQueryConfigMapper;
import com.tydic.qry.dao.SourceQueryConfigMapper;
import com.tydic.qry.po.BoolQueryConfigPO;
import com.tydic.qry.po.EsQueryConfigPO;
import com.tydic.qry.po.RelatQueryConfigPO;
import com.tydic.qry.po.SortQueryConfigPO;
import com.tydic.qry.po.SourceQueryConfigPO;
import com.tydic.qry.util.BeanUtilCopyListUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QueryMainServiceImpl
implements QueryMainService {
    @Autowired
    private EsQueryConfigMapper esQueryConfigMapper;
    @Autowired
    private RelatQueryConfigMapper relatQueryConfigMapper;
    @Autowired
    private BoolQueryConfigMapper boolQueryConfigMapper;
    @Autowired
    private SourceQueryConfigMapper sourceQueryConfigMapper;
    @Autowired
    private SortQueryConfigMapper sortQueryConfigMapper;

    public RspPage<EsMainQueryRspBo> qryQueryServiceListPage(EsMainQueryReqBo esMainQueryReqBo) {
        if (esMainQueryReqBo.getPageNo() < 1) {
            esMainQueryReqBo.setPageNo(1);
        }
        if (esMainQueryReqBo.getPageSize() < 1) {
            esMainQueryReqBo.setPageSize(10);
        }
        List<Object> esMainQueryRspBos = new ArrayList<Object>();
        EsQueryConfigBo esQueryConfigBo = new EsQueryConfigBo();
        esQueryConfigBo.setQueryName(esMainQueryReqBo.getQueryName());
        List<EsQueryConfigBo> esQueryConfigBos = this.esQueryConfigMapper.selectByCondition(esQueryConfigBo);
        if (esQueryConfigBos.size() > 0) {
            for (EsQueryConfigBo esQueryConfigRspBo : esQueryConfigBos) {
                EsMainQueryRspBo esMainQueryRspBo2 = new EsMainQueryRspBo();
                esMainQueryRspBo2.setType("1");
                esMainQueryRspBo2.setMatedataId(esQueryConfigRspBo.getMatedataId());
                esMainQueryRspBo2.setQueryName(esQueryConfigRspBo.getQueryName());
                esMainQueryRspBo2.setBoolBoName(esQueryConfigRspBo.getBoolBoName());
                esMainQueryRspBo2.setSourceBoName(esQueryConfigRspBo.getSourceBoName());
                esMainQueryRspBos.add(esMainQueryRspBo2);
            }
        }
        RelatQueryConfigBo relatQueryConfigBO = new RelatQueryConfigBo();
        relatQueryConfigBO.setChildQueryName(esMainQueryReqBo.getQueryName());
        List<RelatQueryConfigBo> relatQueryConfigBos = this.relatQueryConfigMapper.selectByCondition(relatQueryConfigBO);
        if (relatQueryConfigBos.size() > 0) {
            for (RelatQueryConfigBo relatQueryConfigBo : relatQueryConfigBos) {
                EsMainQueryRspBo esMainQueryRspBo3 = new EsMainQueryRspBo();
                esMainQueryRspBo3.setType("2");
                esMainQueryRspBo3.setMatedataId(relatQueryConfigBo.getMatedataId());
                esMainQueryRspBo3.setChildQueryName(relatQueryConfigBo.getChildQueryName());
                esMainQueryRspBo3.setBoolBoName(relatQueryConfigBo.getBoolBoName());
                esMainQueryRspBo3.setSourceBoName(relatQueryConfigBo.getSourceBoName());
                esMainQueryRspBos.add(esMainQueryRspBo3);
            }
        }
        esMainQueryRspBos.removeIf(esMainQueryRspBo -> esMainQueryRspBo.getMatedataId() == null);
        esMainQueryRspBos.sort(Comparator.comparing(EsMainQueryRspBo::getMatedataId));
        int total = esMainQueryRspBos.size();
        int pageSize = esMainQueryReqBo.getPageSize();
        int recordsTotal = total / pageSize + 1;
        int pageNo = Math.min(esMainQueryReqBo.getPageNo(), recordsTotal);
        int indexFrom = (pageNo - 1) * pageSize;
        int indexTo = Math.min(pageNo * pageSize, total);
        esMainQueryRspBos = esMainQueryRspBos.subList(indexFrom, indexTo);
        RspPage rspBo = new RspPage();
        rspBo.setRows(esMainQueryRspBos);
        rspBo.setPageNo(pageNo);
        rspBo.setTotal(total);
        rspBo.setRecordsTotal(recordsTotal);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    public EsMainQueryInfoRspBo qryQueryServiceInfo(EsMainQueryReqBo esMainQueryReqBo) {
        EsMainQueryInfoRspBo rspBo = new EsMainQueryInfoRspBo();
        if (esMainQueryReqBo.getId() == null) {
            throw new ZTBusinessException("id\u4e3a\u7a7a");
        }
        EsQueryConfigPO esQueryConfigPO = this.esQueryConfigMapper.selectByPrimaryKey(esMainQueryReqBo.getId());
        if (esQueryConfigPO == null) {
            rspBo.setCode("0");
            rspBo.setMessage("\u6210\u529f");
            return rspBo;
        }
        List<RelatQueryConfigPO> relatQueryConfigPOS = this.relatQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
        List<BoolQueryConfigPO> boolQueryConfigPOS = this.boolQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
        boolQueryConfigPOS.removeIf(BoolQueryConfigPO2 -> !"1".equals(BoolQueryConfigPO2.getQryType()));
        List<SourceQueryConfigPO> sourceQueryConfigPOS = this.sourceQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
        sourceQueryConfigPOS.removeIf(SourceQueryConfigPO2 -> SourceQueryConfigPO2.getType() != 1);
        List<SortQueryConfigPO> sortQueryConfigPOS = this.sortQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
        sortQueryConfigPOS.removeIf(SortQueryConfigPO2 -> !"1".equals(SortQueryConfigPO2.getQryType()));
        EsQueryConfigBo esQueryConfigBo = new EsQueryConfigBo();
        BeanUtils.copyProperties((Object)esQueryConfigPO, (Object)esQueryConfigBo);
        List<RelatQueryConfigBo> relatQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(relatQueryConfigPOS, RelatQueryConfigBo::new);
        List<BoolQueryConfigBo> boolQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(boolQueryConfigPOS, BoolQueryConfigBo::new);
        List<SourceQueryConfigBo> sourceQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(sourceQueryConfigPOS, SourceQueryConfigBo::new);
        List<SortQueryConfigBo> sortQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(sortQueryConfigPOS, SortQueryConfigBo::new);
        esQueryConfigBo.setRelateQuery(relatQueryConfigBos);
        esQueryConfigBo.setCustomQuery(boolQueryConfigBos);
        esQueryConfigBo.setSourceQuery(sourceQueryConfigBos);
        esQueryConfigBo.setSortQuery(sortQueryConfigBos);
        rspBo.setEsQueryConfigBo(esQueryConfigBo);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    @Transactional
    public RspBaseBO qryQueryServiceSave(EsMainQueryReqBo esMainQueryReqBo) {
        if (esMainQueryReqBo.getId() == null) {
            return this.addQueryService(esMainQueryReqBo);
        }
        return this.updateQueryService(esMainQueryReqBo);
    }

    public RspPage<BoolQueryConfigRspBo> qryQueryServiceReqParamListPage(EsMainQueryReqBo esMainQueryReqBo) {
        if (esMainQueryReqBo.getPageNo() < 1) {
            esMainQueryReqBo.setPageNo(1);
        }
        if (esMainQueryReqBo.getPageSize() < 1) {
            esMainQueryReqBo.setPageSize(10);
        }
        if (esMainQueryReqBo.getMatedataId() == null) {
            throw new ZTBusinessException("\u5173\u8054MatedataId\u4e3a\u7a7a");
        }
        RspPage rspBo = new RspPage();
        int total = 0;
        int recordsTotal = 0;
        int pageNo = 0;
        List<BoolQueryConfigPO> boolQueryConfigPOS = this.boolQueryConfigMapper.selectByMateDataId(esMainQueryReqBo.getMatedataId());
        boolQueryConfigPOS.removeIf(BoolQueryConfigPO2 -> !"1".equals(BoolQueryConfigPO2.getQryType()));
        if (boolQueryConfigPOS.size() > 0) {
            total = boolQueryConfigPOS.size();
            int pageSize = esMainQueryReqBo.getPageSize();
            recordsTotal = total / pageSize + 1;
            pageNo = Math.min(esMainQueryReqBo.getPageNo(), recordsTotal);
            int indexFrom = (pageNo - 1) * pageSize;
            int indexTo = Math.min(pageNo * pageSize, total);
            boolQueryConfigPOS = boolQueryConfigPOS.subList(indexFrom, indexTo);
        }
        List<BoolQueryConfigRspBo> boolQueryConfigRspBos = BeanUtilCopyListUtil.copyListProperties(boolQueryConfigPOS, BoolQueryConfigRspBo::new);
        rspBo.setRows(boolQueryConfigRspBos);
        rspBo.setRecordsTotal(recordsTotal);
        rspBo.setTotal(total);
        rspBo.setPageNo(pageNo);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    public RspPage<SourceQueryConfigRspBo> qryQueryServiceRspParamListPage(EsMainQueryReqBo esMainQueryReqBo) {
        if (esMainQueryReqBo.getPageNo() < 1) {
            esMainQueryReqBo.setPageNo(1);
        }
        if (esMainQueryReqBo.getPageSize() < 1) {
            esMainQueryReqBo.setPageSize(10);
        }
        if (esMainQueryReqBo.getMatedataId() == null) {
            throw new ZTBusinessException("\u5173\u8054MatedataId\u4e3a\u7a7a");
        }
        RspPage rspBo = new RspPage();
        int total = 0;
        int recordsTotal = 0;
        int pageNo = 0;
        List<SourceQueryConfigPO> sourceQueryConfigPOS = this.sourceQueryConfigMapper.selectByMateDataId(esMainQueryReqBo.getMatedataId());
        sourceQueryConfigPOS.removeIf(SourceQueryConfigPO2 -> SourceQueryConfigPO2.getType() != 1);
        if (sourceQueryConfigPOS.size() > 0) {
            total = sourceQueryConfigPOS.size();
            int pageSize = esMainQueryReqBo.getPageSize();
            recordsTotal = total / pageSize + 1;
            pageNo = Math.min(esMainQueryReqBo.getPageNo(), recordsTotal);
            int indexFrom = (pageNo - 1) * pageSize;
            int indexTo = Math.min(pageNo * pageSize, total);
            sourceQueryConfigPOS = sourceQueryConfigPOS.subList(indexFrom, indexTo);
        }
        List<SourceQueryConfigRspBo> sourceQueryConfigRspBos = BeanUtilCopyListUtil.copyListProperties(sourceQueryConfigPOS, SourceQueryConfigRspBo::new);
        rspBo.setRows(sourceQueryConfigRspBos);
        rspBo.setRecordsTotal(recordsTotal);
        rspBo.setTotal(total);
        rspBo.setPageNo(pageNo);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    public RspPage<SortQueryConfigRspBo> qryQueryServiceSortParamListPage(EsMainQueryReqBo esMainQueryReqBo) {
        if (esMainQueryReqBo.getPageNo() < 1) {
            esMainQueryReqBo.setPageNo(1);
        }
        if (esMainQueryReqBo.getPageSize() < 1) {
            esMainQueryReqBo.setPageSize(10);
        }
        if (esMainQueryReqBo.getMatedataId() == null) {
            throw new ZTBusinessException("\u5173\u8054MatedataId\u4e3a\u7a7a");
        }
        RspPage rspBo = new RspPage();
        int total = 0;
        int recordsTotal = 0;
        int pageNo = 0;
        List<SortQueryConfigPO> sortQueryConfigPOS = this.sortQueryConfigMapper.selectByMateDataId(esMainQueryReqBo.getMatedataId());
        sortQueryConfigPOS.removeIf(SortQueryConfigPO2 -> !"1".equals(SortQueryConfigPO2.getQryType()));
        if (sortQueryConfigPOS.size() > 0) {
            total = sortQueryConfigPOS.size();
            int pageSize = esMainQueryReqBo.getPageSize();
            recordsTotal = total / pageSize + 1;
            pageNo = Math.min(esMainQueryReqBo.getPageNo(), recordsTotal);
            int indexFrom = (pageNo - 1) * pageSize;
            int indexTo = Math.min(pageNo * pageSize, total);
            sortQueryConfigPOS = sortQueryConfigPOS.subList(indexFrom, indexTo);
        }
        List<SortQueryConfigRspBo> sortQueryConfigRspBos = BeanUtilCopyListUtil.copyListProperties(sortQueryConfigPOS, SortQueryConfigRspBo::new);
        rspBo.setRows(sortQueryConfigRspBos);
        rspBo.setRecordsTotal(recordsTotal);
        rspBo.setTotal(total);
        rspBo.setPageNo(pageNo);
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private RspBaseBO updateQueryService(EsMainQueryReqBo esMainQueryReqBo) {
        EsQueryConfigBo esQueryConfigBo = new EsQueryConfigBo();
        BeanUtils.copyProperties((Object)esMainQueryReqBo, (Object)esQueryConfigBo);
        this.configureTransformation(esQueryConfigBo);
        this.esQueryConfigMapper.update(esQueryConfigBo);
        List<BoolQueryConfigPO> boolQueryConfigPOS = this.boolQueryConfigMapper.selectByMateDataId(esMainQueryReqBo.getMatedataId());
        boolQueryConfigPOS.removeIf(BoolQueryConfigPO2 -> !"1".equals(BoolQueryConfigPO2.getQryType()));
        Set boolIds = boolQueryConfigPOS.stream().map(BoolQueryConfigPO::getBoolId).collect(Collectors.toSet());
        List<SourceQueryConfigPO> sourceQueryConfigPOS = this.sourceQueryConfigMapper.selectByMateDataId(esMainQueryReqBo.getMatedataId());
        sourceQueryConfigPOS.removeIf(SourceQueryConfigPO2 -> SourceQueryConfigPO2.getType() != 1);
        Set sourceIds = sourceQueryConfigPOS.stream().map(SourceQueryConfigPO::getSourceId).collect(Collectors.toSet());
        List<SortQueryConfigPO> sortQueryConfigPOS = this.sortQueryConfigMapper.selectByMateDataId(esMainQueryReqBo.getMatedataId());
        sortQueryConfigPOS.removeIf(SortQueryConfigPO2 -> !"1".equals(SortQueryConfigPO2.getQryType()));
        Set sortIds = sortQueryConfigPOS.stream().map(SortQueryConfigPO::getSortId).collect(Collectors.toSet());
        List<BoolQueryConfigBo> boolQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(esMainQueryReqBo.getCustomQuery(), BoolQueryConfigBo::new);
        List<SourceQueryConfigBo> sourceQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(esMainQueryReqBo.getSourceQuery(), SourceQueryConfigBo::new);
        List<SortQueryConfigBo> sortQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(esMainQueryReqBo.getSortQuery(), SortQueryConfigBo::new);
        if (boolQueryConfigBos.size() > 0) {
            for (BoolQueryConfigBo boolQueryConfigBo : boolQueryConfigBos) {
                boolIds.remove(boolQueryConfigBo.getBoolId());
                if (boolQueryConfigBo.getBoolId() == null) {
                    boolQueryConfigBo.setMatedataId(esMainQueryReqBo.getMatedataId());
                    boolQueryConfigBo.setQryType("1");
                    this.boolQueryConfigMapper.addQueryService(boolQueryConfigBo);
                }
                BoolQueryConfigPO boolQueryConfigPO = new BoolQueryConfigPO();
                BeanUtils.copyProperties((Object)boolQueryConfigBo, (Object)boolQueryConfigPO);
                boolQueryConfigPO.setQryType("1");
                this.boolQueryConfigMapper.updateByPrimaryKeySelective(boolQueryConfigPO);
            }
        }
        if (sourceQueryConfigBos.size() > 0) {
            for (SourceQueryConfigBo sourceQueryConfigBo : sourceQueryConfigBos) {
                sourceIds.remove(sourceQueryConfigBo.getSourceId());
                if (sourceQueryConfigBo.getSourceId() == null) {
                    sourceQueryConfigBo.setMatedataId(esMainQueryReqBo.getMatedataId());
                    sourceQueryConfigBo.setType(Integer.valueOf(1));
                    this.sourceQueryConfigMapper.addQueryService(sourceQueryConfigBo);
                }
                SourceQueryConfigPO sourceQueryConfigPO = new SourceQueryConfigPO();
                BeanUtils.copyProperties((Object)sourceQueryConfigBo, (Object)sourceQueryConfigPO);
                sourceQueryConfigPO.setType(1);
                this.sourceQueryConfigMapper.updateByPrimaryKeySelective(sourceQueryConfigPO);
            }
        }
        if (sortQueryConfigBos.size() > 0) {
            for (SortQueryConfigBo sortQueryConfigBo : sortQueryConfigBos) {
                sortIds.remove(sortQueryConfigBo.getSortId());
                if (sortQueryConfigBo.getSortId() == null) {
                    sortQueryConfigBo.setMatedataId(esMainQueryReqBo.getMatedataId());
                    sortQueryConfigBo.setQryType("1");
                    this.sortQueryConfigMapper.addQueryService(sortQueryConfigBo);
                }
                SortQueryConfigPO sortQueryConfigPO = new SortQueryConfigPO();
                BeanUtils.copyProperties((Object)sortQueryConfigBo, (Object)sortQueryConfigPO);
                sortQueryConfigPO.setQryType("1");
                this.sortQueryConfigMapper.updateByPrimaryKeySelective(sortQueryConfigPO);
            }
        }
        if (boolIds.size() > 0) {
            for (Long boolId : boolIds) {
                this.boolQueryConfigMapper.deleteByPrimaryKey(boolId);
            }
        }
        if (sourceIds.size() > 0) {
            for (Long boolId : sourceIds) {
                this.sourceQueryConfigMapper.deleteByPrimaryKey(boolId);
            }
        }
        if (sortIds.size() > 0) {
            for (Long boolId : sortIds) {
                this.sortQueryConfigMapper.deleteByPrimaryKey(boolId);
            }
        }
        RspBaseBO rspBo = new RspBaseBO();
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private RspBaseBO addQueryService(EsMainQueryReqBo esMainQueryReqBo) {
        long mateId = Sequence.getInstance().nextId();
        EsQueryConfigBo esQueryConfigBo = new EsQueryConfigBo();
        BeanUtils.copyProperties((Object)esMainQueryReqBo, (Object)esQueryConfigBo);
        esQueryConfigBo.setMatedataId(Long.valueOf(mateId));
        esQueryConfigBo.setCode(String.valueOf(mateId));
        this.configureTransformation(esQueryConfigBo);
        this.esQueryConfigMapper.addQueryService(esQueryConfigBo);
        List<BoolQueryConfigBo> boolQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(esMainQueryReqBo.getCustomQuery(), BoolQueryConfigBo::new);
        List<SourceQueryConfigBo> sourceQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(esMainQueryReqBo.getSourceQuery(), SourceQueryConfigBo::new);
        List<SortQueryConfigBo> sortQueryConfigBos = BeanUtilCopyListUtil.copyListProperties(esMainQueryReqBo.getSortQuery(), SortQueryConfigBo::new);
        if (boolQueryConfigBos.size() > 0) {
            for (BoolQueryConfigBo boolQueryConfigBo : boolQueryConfigBos) {
                boolQueryConfigBo.setMatedataId(Long.valueOf(mateId));
                boolQueryConfigBo.setQryType("1");
                this.boolQueryConfigMapper.addQueryService(boolQueryConfigBo);
            }
        }
        if (sourceQueryConfigBos.size() > 0) {
            for (SourceQueryConfigBo sourceQueryConfigBo : sourceQueryConfigBos) {
                sourceQueryConfigBo.setMatedataId(Long.valueOf(mateId));
                sourceQueryConfigBo.setType(Integer.valueOf(1));
                this.sourceQueryConfigMapper.addQueryService(sourceQueryConfigBo);
            }
        }
        if (sortQueryConfigBos.size() > 0) {
            for (SortQueryConfigBo sortQueryConfigBo : sortQueryConfigBos) {
                sortQueryConfigBo.setMatedataId(Long.valueOf(mateId));
                sortQueryConfigBo.setQryType("1");
                this.sortQueryConfigMapper.addQueryService(sortQueryConfigBo);
            }
        }
        RspBaseBO rspBo = new RspBaseBO();
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void configureTransformation(EsQueryConfigBo esQueryConfigBo) {
        esQueryConfigBo.setCustomQuerys(esQueryConfigBo.getCustomQuery().toString());
        esQueryConfigBo.setRelateQuerys(esQueryConfigBo.getRelateQuery().toString());
        esQueryConfigBo.setSourceQuerys(esQueryConfigBo.getSourceQuery().toString());
        esQueryConfigBo.setSortQuerys(esQueryConfigBo.getSortQuery().toString());
    }
}

