/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.qry.config;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticsearchConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchConfiguration.class);
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchConfiguration.class);
    @Value(value="${es.cluster.address}")
    private String clusterNodes;
    @Value(value="${es.source}")
    private String esSource;
    @Value(value="${ali.es.username:}")
    private String userName;
    @Value(value="${ali.es.password:}")
    private String password;
    @Value(value="${es.config.max.connect.numb:600}")
    private int maxConnectNumb;
    @Value(value="${es.config.connect.timeout:30000}")
    private int connectTimeout;
    @Value(value="${es.config.socket.timeout:30000}")
    private int socketTimeout;
    @Value(value="${es.config.request.connect.timeout:6000}")
    private int requestConnectTimeout;

    @Bean(value={"restHighLevelClient"})
    public RestHighLevelClient buildHighLevelClient() {
        if (StringUtils.isEmpty((CharSequence)this.clusterNodes)) {
            return null;
        }
        ArrayList<String> nodeList = new ArrayList<String>(Arrays.asList(this.clusterNodes.split(",")));
        log.info("es.config.addresses\uff1a{}", (Object)JSON.toJSONString(nodeList));
        HttpHost[] httpHosts = (HttpHost[])nodeList.stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        restClientBuilder.setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node node) {
                super.onFailure(node);
                System.out.println(node.getHost().getHostName() + "===\u8282\u70b9\u5931\u8d25\u4e86");
            }
        });
        restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
            if ("AliYun".equals(this.esSource)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
                httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(this.maxConnectNumb).build());
            return httpAsyncClientBuilder;
        });
        restClientBuilder.setRequestConfigCallback(builder -> builder.setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setConnectionRequestTimeout(this.requestConnectTimeout));
        return new RestHighLevelClient(restClientBuilder);
    }

    @Bean(value={"restClientBuilder"})
    public RestClientBuilder buildRestClientBuilder() {
        if (StringUtils.isEmpty((CharSequence)this.clusterNodes)) {
            return null;
        }
        ArrayList<String> nodeList = new ArrayList<String>(Arrays.asList(this.clusterNodes.split(",")));
        log.info("es.config.addresses\uff1a{}", (Object)JSON.toJSONString(nodeList));
        HttpHost[] httpHosts = (HttpHost[])nodeList.stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        restClientBuilder.setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node node) {
                super.onFailure(node);
                System.out.println(node.getHost().getHostName() + "===\u8282\u70b9\u5931\u8d25\u4e86");
            }
        });
        restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
            if ("AliYun".equals(this.esSource)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
                httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            return httpAsyncClientBuilder;
        });
        restClientBuilder.setRequestConfigCallback(builder -> builder.setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setConnectionRequestTimeout(this.requestConnectTimeout));
        return restClientBuilder;
    }
}

