/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.qry.config;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class LogLevelControllerConfig
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(LogLevelControllerConfig.class);
    @Value(value="${dyc.log.config:}")
    private String defaultLogConfig = "";
    private static final String DYC_LOG_CONFIG = "dyc.log.config";
    private String oldConfigValue = "";

    public void run(ApplicationArguments args) throws Exception {
        log.error("\u521d\u59cb\u5316\u65e5\u5fd7\u7ea7\u522b\u914d\u7f6e\uff0c\u503c\u4e3a\uff1a" + this.defaultLogConfig);
        this.changeLogLevel(this.defaultLogConfig);
    }

    @Scheduled(cron="*/5 * * * * *")
    public void changeLocalConfig() {
        if (!this.defaultLogConfig.equals(this.oldConfigValue)) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u76d1\u542c\u5230\u65e5\u5fd7\u914d\u7f6e\u53d8\u66f4\uff0c\u8986\u76d6\u914d\u7f6e\uff0c\u65b0\u503c\u4e3a\uff1a" + this.defaultLogConfig);
            this.oldConfigValue = this.defaultLogConfig;
            this.changeLogLevel(this.defaultLogConfig);
        }
    }

    @ApolloConfigChangeListener
    public void onChangeToAll(ConfigChangeEvent changeEvent) {
        for (String key : changeEvent.changedKeys()) {
            if (!DYC_LOG_CONFIG.equals(key)) continue;
            ConfigChange change = changeEvent.getChange(key);
            String oldValue = change.getOldValue();
            String newValue = change.getNewValue();
            log.error("\u68c0\u6d4b\u5230apollo\u65e5\u5fd7\u7ea7\u522b\u53d8\u66f4\uff0c\u65e7\u503c\u4e3a[" + oldValue + "]\uff0c\u65b0\u503c\u4e3a\uff1a[" + newValue + "]");
            this.changeLogLevel(newValue);
            break;
        }
    }

    public void changeLogLevel(String defaultLogConfig) {
        if (ObjectUtil.isEmpty((Object)defaultLogConfig)) {
            log.error("\u65e5\u5fd7\u914d\u7f6e\u503c\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406");
            return;
        }
        Map<String, String> configMap = this.convertToMap(defaultLogConfig);
        Map<String, Level> stringLevelMap = this.initLogMap();
        Collection current = LoggerContext.getContext((boolean)false).getLoggers();
        Collection notCurrent = LoggerContext.getContext().getLoggers();
        current.addAll(notCurrent);
        for (org.apache.logging.log4j.core.Logger log : current) {
            Level level;
            String logLevel;
            String logLevelConfigName = this.getLogLevelConfigName(log);
            if (!ObjectUtil.isNotEmpty((Object)logLevelConfigName) || !ObjectUtil.isNotEmpty((Object)(logLevel = configMap.get(logLevelConfigName))) || !ObjectUtil.isNotEmpty((Object)(level = stringLevelMap.get(logLevel.toUpperCase())))) continue;
            log.setLevel(level);
        }
    }

    private String getLogLevelConfigName(org.apache.logging.log4j.core.Logger log) {
        Object name;
        Object loggerConfig;
        Object privateConfig = ReflectUtil.getFieldValue((Object)log, (String)"privateConfig");
        if (ObjectUtil.isNotEmpty((Object)privateConfig) && ObjectUtil.isNotEmpty((Object)(loggerConfig = ReflectUtil.getFieldValue((Object)privateConfig, (String)"loggerConfig"))) && ObjectUtil.isNotEmpty((Object)(name = ReflectUtil.getFieldValue((Object)loggerConfig, (String)"name")))) {
            return name.toString();
        }
        return null;
    }

    private Map<String, String> convertToMap(String logConfig) {
        HashMap<String, String> configMap = new HashMap<String, String>(16);
        if (ObjectUtil.isEmpty((Object)logConfig)) {
            return configMap;
        }
        String[] split = logConfig.split(",");
        if (split.length > 0) {
            for (String con : split) {
                String[] conArray;
                if (!ObjectUtil.isNotEmpty((Object)con) || (conArray = con.split(":")).length <= 1) continue;
                String key = conArray[0];
                String value = conArray[1];
                configMap.put(key, value);
            }
        }
        log.error("\u65e5\u5fd7\u914d\u7f6e\u8f6c\u6210map\u540e\u4e3a\uff1a" + JSON.toJSONString(configMap));
        return configMap;
    }

    private Map<String, Level> initLogMap() {
        HashMap<String, Level> logMap = new HashMap<String, Level>(16);
        logMap.put("TRACE", Level.TRACE);
        logMap.put("DEBUG", Level.DEBUG);
        logMap.put("INFO", Level.INFO);
        logMap.put("WARN", Level.WARN);
        logMap.put("ERROR", Level.ERROR);
        return logMap;
    }
}

