/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.qry.factory;

import com.alibaba.fastjson.JSONObject;
import com.tydic.qry.po.BoolQueryConfigPO;
import com.tydic.qry.service.strategy.EsQueryBoolQueryTypeStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EsQueryBoolBuilderStrategyFactory {
    @Autowired
    private Map<String, EsQueryBoolQueryTypeStrategy> strategyMap = new ConcurrentHashMap<String, EsQueryBoolQueryTypeStrategy>();

    public EsQueryBoolBuilderStrategyFactory(Map<String, EsQueryBoolQueryTypeStrategy> strategyMap) {
        this.strategyMap.clear();
        strategyMap.forEach((k, v) -> this.strategyMap.put((String)k, (EsQueryBoolQueryTypeStrategy)v));
    }

    public void doAction(String strategy, BoolQueryConfigPO mateData, JSONObject params, BoolQueryBuilder boolQueryBuilder) {
        this.strategyMap.get(strategy).buildEsQuryCondition(mateData, params, boolQueryBuilder);
    }

    public void checkParam(String strategy, BoolQueryConfigPO mateData) {
        this.strategyMap.get(strategy).checkParam(mateData);
    }
}

