/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.qry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.qry.dao.BoolQueryConfigMapper;
import com.tydic.qry.dao.EsQueryConfigMapper;
import com.tydic.qry.dao.RelatQueryConfigMapper;
import com.tydic.qry.dao.SortQueryConfigMapper;
import com.tydic.qry.dao.SourceQueryConfigMapper;
import com.tydic.qry.po.BoolQueryConfigPO;
import com.tydic.qry.po.EsQueryConfigPO;
import com.tydic.qry.po.RelatQueryConfigPO;
import com.tydic.qry.po.SortQueryConfigPO;
import com.tydic.qry.po.SourceQueryConfigPO;
import com.tydic.qry.service.EsQueryConfigService;
import com.tydic.qry.util.CodeGenerateUtil;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EsQueryConfigServiceImpl
implements EsQueryConfigService {
    @Autowired
    private EsQueryConfigMapper esQueryConfigMapper;
    @Autowired
    private BoolQueryConfigMapper boolQueryConfigMapper;
    @Autowired
    private RelatQueryConfigMapper relatQueryConfigMapper;
    @Autowired
    private SortQueryConfigMapper sortQueryConfigMapper;
    @Autowired
    private SourceQueryConfigMapper sourceQueryConfigMapper;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;

    @Override
    public EsQueryConfigPO queryByCode(String code) {
        return this.esQueryConfigMapper.selectByCode(code);
    }

    @Override
    public List<EsQueryConfigPO> queryByMateIds(List<Long> mateIds) {
        List<EsQueryConfigPO> esQueryConfigPOS = this.esQueryConfigMapper.selectByMateIds(mateIds);
        if (CollectionUtil.isNotEmpty(esQueryConfigPOS)) {
            for (EsQueryConfigPO esQueryConfigPO : esQueryConfigPOS) {
                List<BoolQueryConfigPO> boolQueryConfigPOS = this.boolQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
                List<SortQueryConfigPO> sortQueryConfigPOS = this.sortQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
                List<SourceQueryConfigPO> sourceQueryConfigPOS = this.sourceQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
                List<RelatQueryConfigPO> relatQueryConfigPOS = this.relatQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
                esQueryConfigPO.setCustomQuerys(boolQueryConfigPOS);
                esQueryConfigPO.setSortQuerys(sortQueryConfigPOS);
                esQueryConfigPO.setSourceQuerys(sourceQueryConfigPOS);
                for (RelatQueryConfigPO relatQueryConfigPO : relatQueryConfigPOS) {
                    List<SourceQueryConfigPO> sourceQueryConfigPOS1 = this.sourceQueryConfigMapper.selectByrelatId(relatQueryConfigPO.getRelatId());
                    relatQueryConfigPO.setChildSource(sourceQueryConfigPOS1);
                }
                esQueryConfigPO.setRelateQuerys(relatQueryConfigPOS);
            }
        }
        return esQueryConfigPOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int addConfig(EsQueryConfigPO esQueryConfigPO) {
        List<BoolQueryConfigPO> customQuerys = esQueryConfigPO.getCustomQuerys();
        for (BoolQueryConfigPO boolQueryConfigPO : customQuerys) {
            BoolQueryConfigPO boolQueryConfigPO2 = new BoolQueryConfigPO();
            BeanUtils.copyProperties((Object)boolQueryConfigPO, (Object)boolQueryConfigPO2);
            boolQueryConfigPO2.setIndexName(esQueryConfigPO.getIndexName());
            boolQueryConfigPO2.setMatedataId(esQueryConfigPO.getMatedataId());
            this.boolQueryConfigMapper.insertSelective(boolQueryConfigPO2);
        }
        List<SortQueryConfigPO> sortQuerys = esQueryConfigPO.getSortQuerys();
        for (SortQueryConfigPO sortQueryConfigPO : sortQuerys) {
            SortQueryConfigPO sortQueryConfigPO2 = new SortQueryConfigPO();
            BeanUtils.copyProperties((Object)sortQueryConfigPO, (Object)sortQueryConfigPO2);
            sortQueryConfigPO2.setMatedataId(esQueryConfigPO.getMatedataId());
            this.sortQueryConfigMapper.insertSelective(sortQueryConfigPO2);
        }
        List<SourceQueryConfigPO> list = esQueryConfigPO.getSourceQuerys();
        for (SourceQueryConfigPO sourceQuery : list) {
            SourceQueryConfigPO sourceQueryConfigPO = new SourceQueryConfigPO();
            BeanUtils.copyProperties((Object)sourceQuery, (Object)sourceQueryConfigPO);
            sourceQueryConfigPO.setIndexName(esQueryConfigPO.getIndexName());
            sourceQueryConfigPO.setMatedataId(esQueryConfigPO.getMatedataId());
            this.sourceQueryConfigMapper.insertSelective(sourceQueryConfigPO);
        }
        List<RelatQueryConfigPO> list2 = esQueryConfigPO.getRelateQuerys();
        for (RelatQueryConfigPO relateQuery : list2) {
            RelatQueryConfigPO relatQueryConfigPO = new RelatQueryConfigPO();
            BeanUtils.copyProperties((Object)relateQuery, (Object)relatQueryConfigPO);
            relatQueryConfigPO.setMatedataId(esQueryConfigPO.getMatedataId());
            this.relatQueryConfigMapper.insertSelective(relatQueryConfigPO);
            List<SourceQueryConfigPO> childSource = relateQuery.getChildSource();
            if (!CollectionUtil.isNotEmpty(childSource)) continue;
            for (SourceQueryConfigPO sourceQueryConfigPO : childSource) {
                SourceQueryConfigPO sourceQueryConfigPO1 = new SourceQueryConfigPO();
                BeanUtils.copyProperties((Object)sourceQueryConfigPO, (Object)sourceQueryConfigPO1);
                sourceQueryConfigPO1.setType(2);
                sourceQueryConfigPO1.setRelatId(relatQueryConfigPO.getRelatId());
                sourceQueryConfigPO1.setIndexName(relateQuery.getIndexName());
                sourceQueryConfigPO1.setMatedataId(esQueryConfigPO.getMatedataId());
                this.sourceQueryConfigMapper.insertSelective(sourceQueryConfigPO1);
            }
        }
        esQueryConfigPO.setCode(String.valueOf(this.codeGenerateUtil.nextId()));
        return this.esQueryConfigMapper.insertSelective(esQueryConfigPO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int addChildConfig(EsQueryConfigPO esQueryConfigPO) {
        List<RelatQueryConfigPO> relateQuerys = esQueryConfigPO.getRelateQuerys();
        for (RelatQueryConfigPO relateQuery : relateQuerys) {
            RelatQueryConfigPO relatQueryConfigPO = new RelatQueryConfigPO();
            BeanUtils.copyProperties((Object)relateQuery, (Object)relatQueryConfigPO);
            relatQueryConfigPO.setMatedataId(esQueryConfigPO.getMatedataId());
            this.relatQueryConfigMapper.insertSelective(relatQueryConfigPO);
            List<SourceQueryConfigPO> childSource = relateQuery.getChildSource();
            if (!CollectionUtil.isNotEmpty(childSource)) continue;
            for (SourceQueryConfigPO sourceQueryConfigPO : childSource) {
                SourceQueryConfigPO sourceQueryConfigPO1 = new SourceQueryConfigPO();
                BeanUtils.copyProperties((Object)sourceQueryConfigPO, (Object)sourceQueryConfigPO1);
                sourceQueryConfigPO1.setType(2);
                sourceQueryConfigPO1.setRelatId(relatQueryConfigPO.getRelatId());
                sourceQueryConfigPO1.setIndexName(relateQuery.getIndexName());
                sourceQueryConfigPO1.setMatedataId(esQueryConfigPO.getMatedataId());
                this.sourceQueryConfigMapper.insertSelective(sourceQueryConfigPO1);
            }
        }
        return 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateConfig(EsQueryConfigPO esQueryConfigPO) {
        List<BoolQueryConfigPO> customQuerys = esQueryConfigPO.getCustomQuerys();
        for (BoolQueryConfigPO boolQueryConfigPO : customQuerys) {
            BoolQueryConfigPO boolQueryConfigPO2 = new BoolQueryConfigPO();
            BeanUtils.copyProperties((Object)boolQueryConfigPO, (Object)boolQueryConfigPO2);
            boolQueryConfigPO2.setIndexName(esQueryConfigPO.getIndexName());
            boolQueryConfigPO2.setMatedataId(esQueryConfigPO.getMatedataId());
            if (ObjectUtil.isEmpty((Object)boolQueryConfigPO2.getBoolId())) {
                this.boolQueryConfigMapper.insertSelective(boolQueryConfigPO2);
                continue;
            }
            this.boolQueryConfigMapper.deleteByPrimaryKey(boolQueryConfigPO2.getBoolId());
            this.boolQueryConfigMapper.insertSelective(boolQueryConfigPO2);
        }
        List<SortQueryConfigPO> sortQuerys = esQueryConfigPO.getSortQuerys();
        for (SortQueryConfigPO sortQueryConfigPO : sortQuerys) {
            SortQueryConfigPO sortQueryConfigPO2 = new SortQueryConfigPO();
            BeanUtils.copyProperties((Object)sortQueryConfigPO, (Object)sortQueryConfigPO2);
            sortQueryConfigPO2.setMatedataId(esQueryConfigPO.getMatedataId());
            if (ObjectUtil.isEmpty((Object)sortQueryConfigPO2.getSortId())) {
                this.sortQueryConfigMapper.insertSelective(sortQueryConfigPO2);
                continue;
            }
            this.sortQueryConfigMapper.deleteByPrimaryKey(sortQueryConfigPO2.getSortId());
            this.sortQueryConfigMapper.insertSelective(sortQueryConfigPO2);
        }
        List<SourceQueryConfigPO> list = esQueryConfigPO.getSourceQuerys();
        for (SourceQueryConfigPO sourceQuery : list) {
            SourceQueryConfigPO sourceQueryConfigPO = new SourceQueryConfigPO();
            BeanUtils.copyProperties((Object)sourceQuery, (Object)sourceQueryConfigPO);
            sourceQueryConfigPO.setIndexName(esQueryConfigPO.getIndexName());
            sourceQueryConfigPO.setMatedataId(esQueryConfigPO.getMatedataId());
            if (ObjectUtil.isEmpty((Object)sourceQueryConfigPO.getSourceId())) {
                this.sourceQueryConfigMapper.insertSelective(sourceQueryConfigPO);
                continue;
            }
            this.sourceQueryConfigMapper.deleteByPrimaryKey(sourceQueryConfigPO.getSourceId());
            this.sourceQueryConfigMapper.insertSelective(sourceQueryConfigPO);
        }
        List<RelatQueryConfigPO> list2 = esQueryConfigPO.getRelateQuerys();
        for (RelatQueryConfigPO relateQuery : list2) {
            List<SourceQueryConfigPO> childSource;
            RelatQueryConfigPO relatQueryConfigPO = new RelatQueryConfigPO();
            BeanUtils.copyProperties((Object)relateQuery, (Object)relatQueryConfigPO);
            relatQueryConfigPO.setMatedataId(esQueryConfigPO.getMatedataId());
            if (ObjectUtil.isEmpty((Object)relatQueryConfigPO.getRelatId())) {
                this.relatQueryConfigMapper.insertSelective(relatQueryConfigPO);
            } else {
                this.relatQueryConfigMapper.deleteByPrimaryKey(relatQueryConfigPO.getRelatId());
                this.relatQueryConfigMapper.insertSelective(relatQueryConfigPO);
            }
            if (!CollectionUtil.isNotEmpty(childSource = relatQueryConfigPO.getChildSource())) continue;
            for (SourceQueryConfigPO sourceQueryConfigPO : childSource) {
                SourceQueryConfigPO sourceQueryConfigPO1 = new SourceQueryConfigPO();
                BeanUtils.copyProperties((Object)sourceQueryConfigPO, (Object)sourceQueryConfigPO1);
                sourceQueryConfigPO1.setType(2);
                sourceQueryConfigPO1.setRelatId(relatQueryConfigPO.getRelatId());
                sourceQueryConfigPO1.setIndexName(relateQuery.getIndexName());
                sourceQueryConfigPO1.setMatedataId(esQueryConfigPO.getMatedataId());
                if (ObjectUtil.isEmpty((Object)sourceQueryConfigPO1.getSourceId())) {
                    this.sourceQueryConfigMapper.insertSelective(sourceQueryConfigPO1);
                    continue;
                }
                this.sourceQueryConfigMapper.deleteByPrimaryKey(sourceQueryConfigPO1.getSourceId());
                this.sourceQueryConfigMapper.insertSelective(sourceQueryConfigPO1);
            }
        }
        return this.esQueryConfigMapper.updateByPrimaryKeySelective(esQueryConfigPO);
    }
}

