/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.qry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.qry.constant.QueryTypeEnum;
import com.tydic.qry.dao.BoolQueryConfigMapper;
import com.tydic.qry.dao.EsQueryConfigMapper;
import com.tydic.qry.dao.QueryPermissionControlGroupMapper;
import com.tydic.qry.dao.SortQueryConfigMapper;
import com.tydic.qry.dao.SourceQueryConfigMapper;
import com.tydic.qry.factory.EsQueryBoolBuilderStrategyFactory;
import com.tydic.qry.po.BoolQueryConfigPO;
import com.tydic.qry.po.EsQueryConfigPO;
import com.tydic.qry.po.QueryPermissionControlGroupPO;
import com.tydic.qry.po.QueryPermissionControlPO;
import com.tydic.qry.po.RelatQueryConfigPO;
import com.tydic.qry.po.SortQueryConfigPO;
import com.tydic.qry.po.SourceQueryConfigPO;
import com.tydic.qry.po.bo.CacheQueryEsDataBo;
import com.tydic.qry.po.bo.EsQueryRspBo;
import com.tydic.qry.po.bo.PageReqBo;
import com.tydic.qry.po.bo.SearchEsSQLRspBO;
import com.tydic.qry.service.EsQueryService;
import com.tydic.qry.service.strategy.impl.EsLinkageTermsQueryStrategy;
import com.tydic.qry.util.DeflaterUtils;
import com.tydic.qry.util.ElasticsearchUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class EsQueryServiceImpl
implements EsQueryService {
    private static final Logger log = LoggerFactory.getLogger(EsQueryServiceImpl.class);
    @Value(value="${es.config.search.expire:1}")
    private Integer ES_SEARCH_EXPIRE;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private EsQueryConfigMapper esQueryConfigMapper;
    @Autowired
    private EsQueryBoolBuilderStrategyFactory esQueryBoolBuilderStrategyFactory;
    @Autowired
    private EsLinkageTermsQueryStrategy esLinkageTermsQueryStrategy;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private BoolQueryConfigMapper boolQueryConfigMapper;
    @Autowired
    private SortQueryConfigMapper sortQueryConfigMapper;
    @Autowired
    private SourceQueryConfigMapper sourceQueryConfigMapper;
    @Autowired
    private QueryPermissionControlGroupMapper queryPermissionControlGroupMapper;

    private Map<String, String> getMapByObject(PageReqBo reqBo) {
        Map userMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        return userMap;
    }

    private void permissionControl(Map<String, String> mapByObject, Long id, String type, SearchEsSQLRspBO searchEsSQLRspBO, Map<String, List<QueryPermissionControlPO>> pcMaps) {
        if (CollectionUtil.isEmpty(pcMaps)) {
            return;
        }
        List<QueryPermissionControlPO> queryPermissionControlPOS = pcMaps.get(id + type);
        if (CollectionUtil.isNotEmpty(queryPermissionControlPOS)) {
            for (QueryPermissionControlPO permissionControlPO : queryPermissionControlPOS) {
                QueryPermissionControlGroupPO queryPermissionControlGroupPO = new QueryPermissionControlGroupPO();
                queryPermissionControlGroupPO.setPermissionControlId(permissionControlPO.getPermissionControlId());
                List<QueryPermissionControlGroupPO> queryPermissionControlGroupPOS = this.queryPermissionControlGroupMapper.selectByCondition(queryPermissionControlGroupPO);
                if (queryPermissionControlGroupPOS.size() <= 0) continue;
                for (QueryPermissionControlGroupPO permissionControlGroupPO : queryPermissionControlGroupPOS) {
                    if (!mapByObject.containsKey(permissionControlGroupPO.getSourceField())) continue;
                    searchEsSQLRspBO.getBoolQueryBuilder().must((QueryBuilder)QueryBuilders.termsQuery((String)permissionControlGroupPO.getTargetField(), (String[])new String[]{mapByObject.get(permissionControlGroupPO.getSourceField())}));
                }
            }
        }
    }

    @Override
    public EsQueryRspBo queryEsData(PageReqBo reqBo) {
        JSONObject aggregationsObj;
        JSONObject resultObj;
        if (reqBo.getReqParams() != null) {
            JSONObject params = JSON.parseObject((String)reqBo.getReqParams());
            params.put("traceId", (Object)"-1");
            reqBo.setReqParams(params.toJSONString());
        }
        String str = JSON.toJSONString((Object)((Object)reqBo));
        String cacheKey = "ES_QRY_" + DeflaterUtils.zipString(str);
        Object cacheObject = null;
        if (this.ES_SEARCH_EXPIRE > 0) {
            log.debug("\u7f13\u5b58Key{}", (Object)cacheKey);
            cacheObject = this.cacheClient.get(cacheKey);
            log.debug("\u83b7\u53d6\u7f13\u5b58\u503c{}", cacheObject);
        } else {
            this.cacheClient.delete(cacheKey);
        }
        EsQueryConfigPO esQueryConfigPO = null;
        String queryString = null;
        Boolean queryCountFlag = null;
        EsQueryRspBo esQueryRspBo = new EsQueryRspBo();
        List<SourceQueryConfigPO> sourceQueryConfigPOS = null;
        Integer pageNo = 0;
        Integer pageSize = 10;
        if (ObjectUtil.isNotEmpty((Object)cacheObject)) {
            log.info("\u641c\u7d22\u67e5\u8be2\u5165\u53c2\u5728\u6709\u6548\u671f\u5185\uff0c\u8fdb\u884c\u7f13\u5b58\u83b7\u53d6\u7ed3\u679c\uff0c\u5165\u53c2=" + str);
            String cacheQueryEsDataBoStr = DeflaterUtils.unzipString((String)cacheObject);
            CacheQueryEsDataBo cacheQueryEsDataBo = (CacheQueryEsDataBo)JSON.parseObject((String)cacheQueryEsDataBoStr, CacheQueryEsDataBo.class);
            esQueryConfigPO = cacheQueryEsDataBo.getEsQueryConfigPO();
            queryString = cacheQueryEsDataBo.getQueryString();
            queryCountFlag = cacheQueryEsDataBo.getQueryCountFlag();
            esQueryRspBo = cacheQueryEsDataBo.getEsQueryRspBo();
            sourceQueryConfigPOS = cacheQueryEsDataBo.getSourceQueryConfigPOS();
            pageNo = cacheQueryEsDataBo.getPageNo();
            pageSize = cacheQueryEsDataBo.getPageSize();
        } else {
            String reqParams = reqBo.getReqParams();
            queryCountFlag = reqBo.getQueryCountFlag();
            if (StrUtil.isEmpty((CharSequence)reqParams)) {
                throw new ZTBusinessException("\u53c2\u6570\u6709\u8bef");
            }
            JSONObject params = JSON.parseObject((String)reqParams);
            String code = params.getString("code");
            if (ObjectUtil.isEmpty((Object)code)) {
                throw new ZTBusinessException("\u53c2\u6570\u6709\u8bef");
            }
            esQueryConfigPO = this.esQueryConfigMapper.selectByCode(code);
            if (ObjectUtil.isNull((Object)esQueryConfigPO)) {
                throw new ZTBusinessException("\u67e5\u8be2\u5143\u7d20\u636e\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a");
            }
            List<BoolQueryConfigPO> boolQueryConfigPOS = this.boolQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
            boolQueryConfigPOS.removeIf(BoolQueryConfigPO2 -> !"1".equals(BoolQueryConfigPO2.getQryType()));
            sourceQueryConfigPOS = this.sourceQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
            sourceQueryConfigPOS.removeIf(SourceQueryConfigPO2 -> SourceQueryConfigPO2.getType() != 1);
            ArrayList<BoolQueryConfigPO> fixBoolQueryConfigPOS = new ArrayList<BoolQueryConfigPO>();
            if (reqBo.getBoolQueryConfigPOS() != null && reqBo.getBoolQueryConfigPOS().size() > 0) {
                for (BoolQueryConfigPO boolQueryConfigPO : boolQueryConfigPOS) {
                    for (BoolQueryConfigPO reqBoolQueryConfigPO : reqBo.getBoolQueryConfigPOS()) {
                        if (!boolQueryConfigPO.getReqParamField().equals(reqBoolQueryConfigPO.getReqParamField())) continue;
                        if (reqBoolQueryConfigPO.getQryType() != null) {
                            boolQueryConfigPO.setQryType(reqBoolQueryConfigPO.getQryType());
                        }
                        if (reqBoolQueryConfigPO.getValType() == null) break;
                        boolQueryConfigPO.setValType(reqBoolQueryConfigPO.getValType());
                        break;
                    }
                    fixBoolQueryConfigPOS.add(boolQueryConfigPO);
                }
                boolQueryConfigPOS = fixBoolQueryConfigPOS;
            }
            List<Object> sortQueryConfigPOS = new ArrayList();
            if (reqBo.getSortQueryConfigList() != null && reqBo.getSortQueryConfigList().size() > 0) {
                for (SortQueryConfigPO sortQueryConfigPO : reqBo.getSortQueryConfigList()) {
                    sortQueryConfigPO.setMatedataId(boolQueryConfigPOS.get(0).getMatedataId());
                    sortQueryConfigPO.setQryType("1");
                    sortQueryConfigPO.setSortId(-999L);
                    sortQueryConfigPOS.add(sortQueryConfigPO);
                }
            } else {
                sortQueryConfigPOS = this.sortQueryConfigMapper.selectByMateDataId(esQueryConfigPO.getMatedataId());
            }
            sortQueryConfigPOS.removeIf(SortQueryConfigPO2 -> !"1".equals(SortQueryConfigPO2.getQryType()));
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            SearchEsSQLRspBO searchEsSQLRspBO = this.buildSearchEsSQLRspBO(reqBo, params, sourceQueryConfigPOS, boolQueryBuilder, boolQueryConfigPOS, sortQueryConfigPOS);
            searchEsSQLRspBO.setAggs(esQueryConfigPO.getAggs());
            searchEsSQLRspBO.setSortDynamicValue(reqBo.getSortDynamicValue());
            if (!StringUtils.isEmpty((Object)reqBo.getAggs())) {
                searchEsSQLRspBO.setAggs(reqBo.getAggs());
            }
            if ("true".equals(esQueryConfigPO.getTrackTotalHits())) {
                searchEsSQLRspBO.setTrackTotalHits(true);
            }
            if (ObjectUtil.isNotEmpty((Object)queryCountFlag)) {
                searchEsSQLRspBO.setPageSize(queryCountFlag != false ? 0 : searchEsSQLRspBO.getPageSize());
            }
            queryString = this.getQueryString(searchEsSQLRspBO);
            esQueryRspBo.setQueryString(queryString);
            CacheQueryEsDataBo cacheQueryEsDataBo = new CacheQueryEsDataBo();
            cacheQueryEsDataBo.setEsQueryConfigPO(esQueryConfigPO);
            cacheQueryEsDataBo.setQueryString(queryString);
            cacheQueryEsDataBo.setQueryCountFlag(queryCountFlag);
            cacheQueryEsDataBo.setEsQueryRspBo(esQueryRspBo);
            cacheQueryEsDataBo.setSourceQueryConfigPOS(sourceQueryConfigPOS);
            cacheQueryEsDataBo.setPageNo(searchEsSQLRspBO.getPageNo());
            cacheQueryEsDataBo.setPageSize(searchEsSQLRspBO.getPageSize());
            String cacheQueryEsDataBoStr = DeflaterUtils.zipString(JSON.toJSONString((Object)cacheQueryEsDataBo));
            this.cacheClient.set(cacheKey, (Object)cacheQueryEsDataBoStr, this.ES_SEARCH_EXPIRE.intValue());
            pageNo = cacheQueryEsDataBo.getPageNo();
            pageSize = cacheQueryEsDataBo.getPageSize();
        }
        String result = this.searchEsResultString(esQueryConfigPO, queryString);
        log.info("ES-result:" + result);
        Integer total = 0;
        JSONArray listObject = new JSONArray();
        if (StringUtils.isEmpty((Object)reqBo.getAggs())) {
            log.debug("\u975e\u805a\u5408\u67e5\u8be2");
            resultObj = JSONObject.parseObject((String)result);
            JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
            log.debug("\u83b7\u53d6\u5230hits{}", (Object)hitsObj);
            try {
                total = hitsObj.getJSONObject("total").getInteger("value");
                log.debug("\u83b7\u53d6\u5230total{}", (Object)total);
            }
            catch (Exception e) {
                log.debug("\u83b7\u53d6total\u5f02\u5e38");
                total = hitsObj.getInteger("total");
                log.debug("\u83b7\u53d6total\u5f02\u5e38\u7ed3\u679c{}", (Object)total);
            }
            if (ObjectUtil.isNotEmpty((Object)queryCountFlag) && queryCountFlag.booleanValue()) {
                log.debug("queryCountFlag\u7b49\u4e8etrue");
                esQueryRspBo.setPageNo(1);
                esQueryRspBo.setTotal(0);
                log.debug("");
                esQueryRspBo.setRecordsTotal(total);
                esQueryRspBo.setRows(new ArrayList());
                log.debug("queryCountFlag\u7b49\u4e8etrue\u8fd4\u56de{}", (Object)esQueryRspBo);
                return esQueryRspBo;
            }
            listObject = hitsObj.getJSONArray("hits");
            if (listObject == null || listObject.size() < 1) {
                log.debug("listObject\u7b49\u4e8eNULL\u6216\u8005size\u5c0f\u4e8e1");
                esQueryRspBo.setPageNo(1);
                esQueryRspBo.setTotal(0);
                esQueryRspBo.setRecordsTotal(total);
                esQueryRspBo.setRows(new ArrayList());
                log.debug("listObject\u7b49\u4e8eNULL\u6216\u8005size\u5c0f\u4e8e1\u8fd4\u56de{}", (Object)esQueryRspBo);
                return esQueryRspBo;
            }
        } else if (!StringUtils.isEmpty((Object)reqBo.getAggs())) {
            log.debug("\u805a\u5408\u67e5\u8be2");
            resultObj = JSONObject.parseObject((String)result);
            aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
            esQueryRspBo.setAggregations(aggregationsObj.toJSONString());
        } else {
            log.debug("\u805a\u5408\u67e5\u8be2ELSE");
            resultObj = JSONObject.parseObject((String)result);
            aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
            JSONObject group_by_group1Obj = (JSONObject)aggregationsObj.get((Object)"group_by_group1");
            JSONArray jSONArray = group_by_group1Obj.getJSONArray("buckets");
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject bucket = jSONArray.getJSONObject(i);
                JSONObject top1Obj = (JSONObject)bucket.get((Object)"top1");
                JSONObject hitsObj = (JSONObject)top1Obj.get((Object)"hits");
                listObject.addAll((Collection)hitsObj.getJSONArray("hits"));
            }
            JSONObject groupNumObj = (JSONObject)aggregationsObj.get((Object)"distinct_group_num");
            total = groupNumObj.getInteger("value");
            if (listObject == null || listObject.size() < 1) {
                esQueryRspBo.setPageNo(1);
                esQueryRspBo.setTotal(0);
                esQueryRspBo.setRecordsTotal(total);
                esQueryRspBo.setRows(new ArrayList());
                return esQueryRspBo;
            }
        }
        JSONArray rows = new JSONArray();
        for (int i = 0; i < listObject.size(); ++i) {
            log.debug("\u5f00\u59cb\u83b7\u53d6rows{}", (Object)rows);
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject jSONObject = (JSONObject)hitObj.get((Object)"_source");
            log.debug("\u83b7\u53d6\u5230Source{}", (Object)jSONObject);
            JSONObject sourceData = new JSONObject();
            sourceData = this.buildMainData(sourceQueryConfigPOS, jSONObject, sourceData);
            rows.add((Object)sourceData);
            log.debug("\u83b7\u53d6rows\u7ed3\u675f{}", (Object)rows);
        }
        log.debug("\u8ba1\u7b97\u603b\u9875\u6570\u5f00\u59cb{}{}", (Object)total, (Object)pageSize);
        int totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        log.debug("\u8ba1\u7b97\u603b\u9875\u6570{}", (Object)totalPageNo);
        esQueryRspBo.setTotal(totalPageNo);
        esQueryRspBo.setRecordsTotal(total);
        esQueryRspBo.setPageNo(pageNo);
        esQueryRspBo.setRows(rows.stream().map(x -> JSON.parseObject((String)x.toString())).collect(Collectors.toList()));
        log.debug("\u8fd4\u56de\u4e86{}\u603b\u6570\uff1a{}", (Object)esQueryRspBo.getRows(), (Object)esQueryRspBo.getRecordsTotal());
        return esQueryRspBo;
    }

    private JSONObject buildMainDataDeep(List<SourceQueryConfigPO> sourceQueryConfigPOS, JSONObject sourceData) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = mapper.readTree(sourceData.toJSONString());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        for (SourceQueryConfigPO configPO : sourceQueryConfigPOS) {
            String[] splitRsp = configPO.getRspParamField().split("\\.");
            String newFieldName = splitRsp[splitRsp.length - 1];
            String[] splitIndex = configPO.getIndexFieldName().split("\\.");
            splitRsp[splitRsp.length - 1] = splitIndex[splitIndex.length - 1];
            List<String> pathToModify = Arrays.asList(splitRsp);
            String oldFieldName = splitIndex[splitIndex.length - 1];
            EsQueryServiceImpl.modifyFieldNameAtPath(rootNode, pathToModify, oldFieldName, newFieldName);
        }
        String modifiedJsonStr = null;
        try {
            modifiedJsonStr = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return JSONObject.parseObject((String)modifiedJsonStr);
    }

    private static void modifyFieldNameAtPath(JsonNode node, List<String> path, String oldFieldName, String newFieldName) {
        if (path.isEmpty()) {
            return;
        }
        String currentFieldName = path.get(0);
        if (node.isObject()) {
            ObjectNode objectNode = (ObjectNode)node;
            if (objectNode.has(currentFieldName)) {
                JsonNode childNode = objectNode.get(currentFieldName);
                if (childNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)childNode;
                    for (JsonNode arrayElement : arrayNode) {
                        EsQueryServiceImpl.modifyFieldNameAtPath(arrayElement, path, oldFieldName, newFieldName);
                    }
                }
                if ((path = path.subList(1, path.size())).isEmpty()) {
                    objectNode.put(newFieldName, childNode);
                    objectNode.remove(oldFieldName);
                } else {
                    EsQueryServiceImpl.modifyFieldNameAtPath(childNode, path, oldFieldName, newFieldName);
                }
            }
        } else if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            for (JsonNode arrayElement : arrayNode) {
                EsQueryServiceImpl.modifyFieldNameAtPath(arrayElement, path, oldFieldName, newFieldName);
            }
        }
    }

    private JSONObject buildMainData(List<SourceQueryConfigPO> sourceQueryConfigPOS, JSONObject data, JSONObject sourceData) {
        List childMappingSuff;
        String[] split1;
        List childMappingPre = sourceQueryConfigPOS.stream().filter(x -> x.getRspParamField().contains(".")).collect(Collectors.toList());
        ArrayList<SourceQueryConfigPO> deepChildMapping = new ArrayList<SourceQueryConfigPO>();
        if (CollectionUtil.isNotEmpty(childMappingPre)) {
            for (SourceQueryConfigPO sourceQueryConfigPO : childMappingPre) {
                String[] split = sourceQueryConfigPO.getRspParamField().split("\\.");
                if (split.length > 2) {
                    for (int i = 2; i < split.length; ++i) {
                        split1 = sourceQueryConfigPO.getIndexFieldName().split("\\.");
                        if (split[i].equals(split1[i])) continue;
                        deepChildMapping.add(sourceQueryConfigPO);
                    }
                }
                String preStr = split[0];
                sourceData.put(preStr, (Object)new JSONArray());
            }
        }
        if (CollectionUtil.isNotEmpty(childMappingSuff = sourceQueryConfigPOS.stream().filter(x -> !x.getRspParamField().contains(".")).collect(Collectors.toList()))) {
            for (SourceQueryConfigPO sourceQueryConfigPO : childMappingSuff) {
                String rspParamField = sourceQueryConfigPO.getRspParamField();
                sourceData.put(rspParamField, (Object)"");
            }
        }
        for (SourceQueryConfigPO sourceQueryConfigPO : sourceQueryConfigPOS) {
            String indexFieldName;
            if (CollectionUtil.isNotEmpty(childMappingPre)) {
                if (childMappingPre.contains(sourceQueryConfigPO)) {
                    String[] split = sourceQueryConfigPO.getRspParamField().split("\\.");
                    split1 = sourceQueryConfigPO.getIndexFieldName().split("\\.");
                    try {
                        JSONArray jsonArray = data.getJSONArray(split1[0]);
                        if (!CollectionUtil.isNotEmpty((Collection)jsonArray)) continue;
                        for (int j = 0; j < jsonArray.size(); ++j) {
                            JSONObject itemObj = JSON.parseObject((String)jsonArray.get(j).toString());
                            Object o1 = itemObj.get((Object)split1[1]);
                            JSONArray jsonArray1 = sourceData.getJSONArray(split[0]);
                            if (CollectionUtil.isEmpty((Collection)jsonArray1)) {
                                jsonArray1.add((Object)new JSONObject());
                            }
                            for (int k = jsonArray1.size(); k <= j; ++k) {
                                jsonArray1.add((Object)new JSONObject());
                            }
                            JSONObject jsonObject1 = jsonArray1.getJSONObject(j);
                            if (ObjectUtil.isEmpty((Object)jsonObject1)) {
                                jsonObject1 = new JSONObject();
                            }
                            if (ObjectUtil.isEmpty((Object)o1)) {
                                jsonObject1.put(split[1], (Object)"");
                            } else {
                                jsonObject1.put(split[1], o1);
                            }
                            jsonArray1.remove(j);
                            jsonArray1.add(j, (Object)jsonObject1);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        JSONObject jsonObject = data.getJSONObject(split1[0]);
                        sourceData.remove((Object)split[0]);
                        sourceData.put(split[0], (Object)jsonObject);
                        continue;
                    }
                }
                if (!childMappingSuff.contains(sourceQueryConfigPO)) continue;
                indexFieldName = sourceQueryConfigPO.getIndexFieldName();
                if (indexFieldName.contains(".")) {
                    String[] split = indexFieldName.split("\\.");
                    String preStr = data.getString(split[0]);
                    if (ObjectUtil.isNotEmpty((Object)preStr) && JSONUtil.isJsonArray((String)preStr)) {
                        JSONArray jsonArray = data.getJSONArray(split[0]);
                        if (ObjectUtil.isEmpty((Object)jsonArray)) {
                            sourceData.put(sourceQueryConfigPO.getRspParamField(), (Object)"");
                            continue;
                        }
                        Object o = jsonArray.get(0);
                        JSONObject jsonObject = JSON.parseObject((String)o.toString());
                        Object o1 = jsonObject.get((Object)split[1]);
                        sourceData.put(sourceQueryConfigPO.getRspParamField(), o1);
                        continue;
                    }
                    if (!ObjectUtil.isNotEmpty((Object)preStr) || !JSONUtil.isJsonObj((String)preStr)) continue;
                    JSONObject dataJson = data.getJSONObject(split[0]);
                    if (ObjectUtil.isEmpty((Object)dataJson)) {
                        sourceData.put(sourceQueryConfigPO.getRspParamField(), (Object)"");
                        continue;
                    }
                    Object o1 = dataJson.get((Object)split[1]);
                    sourceData.put(sourceQueryConfigPO.getRspParamField(), o1);
                    continue;
                }
                if (!ObjectUtil.isNotEmpty((Object)data.get((Object)sourceQueryConfigPO.getIndexFieldName()))) continue;
                sourceData.put(sourceQueryConfigPO.getRspParamField(), data.get((Object)sourceQueryConfigPO.getIndexFieldName()));
                continue;
            }
            indexFieldName = sourceQueryConfigPO.getIndexFieldName();
            Object o = data.get((Object)indexFieldName);
            if (!ObjectUtil.isNotEmpty((Object)o)) continue;
            sourceData.put(sourceQueryConfigPO.getRspParamField(), o);
        }
        if (CollectionUtil.isNotEmpty(deepChildMapping)) {
            sourceData = this.buildMainDataDeep(deepChildMapping, sourceData);
        }
        return sourceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relatChildQuery(Map<String, String> mapByObject, JSONObject data, List<RelatQueryConfigPO> mateDataRelatQueries, Map<String, List<QueryPermissionControlPO>> pcMaps) {
        if (CollectionUtil.isEmpty(mateDataRelatQueries)) {
            return;
        }
        for (RelatQueryConfigPO mateDataRelatQuery : mateDataRelatQueries) {
            String indexName = mateDataRelatQuery.getIndexName();
            String mainQueryFieldName = mateDataRelatQuery.getMainQueryFieldName();
            String childQueryFieldName = mateDataRelatQuery.getChildQueryFieldName();
            List<SourceQueryConfigPO> childSource = mateDataRelatQuery.getChildSource();
            Object mainQueryFieldVal = data.get((Object)mainQueryFieldName);
            if (ObjectUtil.isNull((Object)mainQueryFieldVal)) continue;
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)childQueryFieldName, (Object)data.get((Object)mainQueryFieldName)));
            SearchEsSQLRspBO searchEsSQLRspBO = new SearchEsSQLRspBO();
            searchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
            if (CollectionUtil.isNotEmpty(childSource)) {
                searchEsSQLRspBO.setSourceQuery(childSource.stream().map(SourceQueryConfigPO::getIndexFieldName).collect(Collectors.toList()));
            }
            this.permissionControl(mapByObject, mateDataRelatQuery.getRelatId(), "2", searchEsSQLRspBO, pcMaps);
            String queryString = this.getQueryString(searchEsSQLRspBO);
            EsQueryConfigPO EsQueryConfigPO2 = new EsQueryConfigPO();
            EsQueryConfigPO2.setIndexName(indexName);
            String result = this.searchEsResultString(EsQueryConfigPO2, queryString);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
            Integer total = hitsObj.getJSONObject("total").getInteger("value");
            JSONArray listObject = hitsObj.getJSONArray("hits");
            String mainMappingFieldName = "";
            if (listObject == null || listObject.size() < 1) continue;
            EsQueryServiceImpl esQueryServiceImpl = this;
            synchronized (esQueryServiceImpl) {
                List childMappingSuff;
                List childMappingPre = childSource.stream().filter(x -> x.getRspParamField().contains(".")).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(childMappingPre)) {
                    SourceQueryConfigPO sourceQueryConfigPO = (SourceQueryConfigPO)childMappingPre.get(0);
                    mainMappingFieldName = sourceQueryConfigPO.getRspParamField().split("\\.")[0];
                    data.put(mainMappingFieldName, (Object)new JSONArray(listObject.size()));
                }
                if (CollectionUtil.isNotEmpty(childMappingSuff = childSource.stream().filter(x -> !x.getRspParamField().contains(".")).collect(Collectors.toList()))) {
                    for (SourceQueryConfigPO sourceQueryConfigPO : childMappingSuff) {
                        String rspParamField = sourceQueryConfigPO.getRspParamField();
                        data.put(rspParamField, (Object)new JSONArray(listObject.size()));
                    }
                }
                JSONArray rows = new JSONArray();
                for (int i = 0; i < listObject.size(); ++i) {
                    JSONObject hitObj = listObject.getJSONObject(i);
                    JSONObject childData = (JSONObject)hitObj.get((Object)"_source");
                    for (SourceQueryConfigPO sourceQueryConfigPO : childSource) {
                        JSONArray jsonArray;
                        if (CollectionUtil.isNotEmpty(childMappingPre)) {
                            if (childMappingPre.contains(sourceQueryConfigPO)) {
                                jsonArray = data.getJSONArray(sourceQueryConfigPO.getRspParamField().split("\\.")[0]);
                                JSONObject objJsonArrayi = new JSONObject();
                                try {
                                    objJsonArrayi = jsonArray.getJSONObject(i);
                                }
                                catch (Exception e) {
                                    objJsonArrayi = new JSONObject();
                                    jsonArray.add((Object)objJsonArrayi);
                                }
                                objJsonArrayi.put(sourceQueryConfigPO.getRspParamField().split("\\.")[1], childData.get((Object)sourceQueryConfigPO.getIndexFieldName()));
                                continue;
                            }
                            if (!childMappingSuff.contains(sourceQueryConfigPO)) continue;
                            jsonArray = data.getJSONArray(sourceQueryConfigPO.getRspParamField());
                            jsonArray.add(childData.get((Object)sourceQueryConfigPO.getIndexFieldName()));
                            continue;
                        }
                        jsonArray = data.getJSONArray(sourceQueryConfigPO.getRspParamField());
                        jsonArray.add(childData.get((Object)sourceQueryConfigPO.getIndexFieldName()));
                    }
                }
            }
        }
    }

    private String searchEsResultString(EsQueryConfigPO esQueryConfigPO, String queryString) {
        String result;
        log.info("ESQUERY INDEXNAME:{},QUERYSTR:{}", (Object)esQueryConfigPO.getIndexName(), (Object)queryString);
        String endPoint = "/" + esQueryConfigPO.getIndexName() + "/_search";
        Request request = new Request("POST", endPoint);
        request.setJsonEntity(queryString);
        try (RestClient restClient = this.elasticsearchUtil.getLowLevelClient();){
            Response response = restClient.performRequest(request);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getMessage());
            log.error("ioException = " + ioExceptionStr, (Throwable)e);
            throw new ZTBusinessException("ES\u8c03\u7528\u67e5\u8be2\u5217\u8868\u4fe1\u606f\u5f02\u5e38");
        }
        return result;
    }

    private SearchEsSQLRspBO buildSearchEsSQLRspBO(PageReqBo reqBo, JSONObject params, List<SourceQueryConfigPO> sourceQuery, BoolQueryBuilder boolQueryBuilder, List<BoolQueryConfigPO> mateDataTermQueries, List<SortQueryConfigPO> mateDataSortQueries) {
        if (CollectionUtil.isNotEmpty(mateDataTermQueries)) {
            Map<Integer, List<BoolQueryConfigPO>> mateDataTermQueriesGroup = mateDataTermQueries.stream().collect(Collectors.groupingBy(BoolQueryConfigPO::getBlock));
            mateDataTermQueriesGroup.keySet().forEach(x -> {
                BoolQueryBuilder innerBoolQuery = new BoolQueryBuilder();
                List boolQueryConfigPOS = (List)mateDataTermQueriesGroup.get(x);
                ArrayList<BoolQueryConfigPO> mateDataLinkage = new ArrayList<BoolQueryConfigPO>();
                for (BoolQueryConfigPO mateDataTermQuery : boolQueryConfigPOS) {
                    Integer queryType = mateDataTermQuery.getQueryType();
                    if (queryType == 9) {
                        mateDataTermQuery.setParamsLinkage(params);
                        mateDataLinkage.add(mateDataTermQuery);
                        continue;
                    }
                    this.esQueryBoolBuilderStrategyFactory.doAction(QueryTypeEnum.getName(queryType), mateDataTermQuery, params, innerBoolQuery);
                }
                if (mateDataLinkage.size() > 0) {
                    this.esLinkageTermsQueryStrategy.buildEsQuryCondition(mateDataLinkage, innerBoolQuery);
                }
                if (innerBoolQuery.hasClauses()) {
                    if ("1".equals(reqBo.getGroupConnectType())) {
                        boolQueryBuilder.should((QueryBuilder)innerBoolQuery);
                    } else {
                        boolQueryBuilder.must((QueryBuilder)innerBoolQuery);
                    }
                }
            });
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (CollectionUtil.isNotEmpty(mateDataSortQueries)) {
            for (SortQueryConfigPO mateDataSortQuery : mateDataSortQueries) {
                String name = mateDataSortQuery.getIndexFieldName();
                FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)name).order(mateDataSortQuery.getIndexSort() == 1 ? SortOrder.ASC : SortOrder.DESC)).unmappedType(mateDataSortQuery.getIndexDataType());
                fieldSortBuilders.add(sortQueryFirst);
            }
        }
        SearchEsSQLRspBO searchEsSQLRspBO = new SearchEsSQLRspBO();
        searchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        searchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        Object pageNoObj = params.get((Object)"pageNo");
        Object pageSizeObj = params.get((Object)"pageSize");
        int pageNo = 1;
        int pageSize = 10;
        if (ObjectUtil.isNotEmpty((Object)pageNoObj)) {
            try {
                pageNo = Integer.parseInt(pageNoObj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (ObjectUtil.isNotEmpty((Object)pageSizeObj)) {
            try {
                pageSize = Integer.parseInt(pageSizeObj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        searchEsSQLRspBO.setPageNo(pageNo);
        if (CollectionUtil.isNotEmpty(sourceQuery)) {
            searchEsSQLRspBO.setSourceQuery(sourceQuery.stream().map(x -> x.getIndexFieldName()).collect(Collectors.toList()));
        }
        searchEsSQLRspBO.setPageSize(pageSize);
        return searchEsSQLRspBO;
    }

    private String getQueryString(SearchEsSQLRspBO searchEsSQLRspBO) {
        if (searchEsSQLRspBO.getPageNo() <= 0) {
            searchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)searchEsSQLRspBO.getPageSize());
        queryJson.put("from", (Object)(searchEsSQLRspBO.getPageSize() * (searchEsSQLRspBO.getPageNo() - 1)));
        queryJson.put("query", (Object)JSON.parseObject((String)searchEsSQLRspBO.getBoolQueryBuilder().toString()));
        if (CollectionUtil.isNotEmpty(searchEsSQLRspBO.getSourceQuery())) {
            queryJson.put("_source", searchEsSQLRspBO.getSourceQuery());
        }
        if (CollectionUtil.isNotEmpty(searchEsSQLRspBO.getSortQuery())) {
            queryJson.put("sort", (Object)JSON.parseArray((String)searchEsSQLRspBO.getSortQuery().toString()));
        }
        if (!StringUtils.isEmpty((Object)searchEsSQLRspBO.getSortDynamicValue())) {
            queryJson.put("sort", (Object)JSON.parseArray((String)searchEsSQLRspBO.getSortDynamicValue()));
        }
        if (ObjectUtil.isNotEmpty((Object)searchEsSQLRspBO.getAggs())) {
            searchEsSQLRspBO.setAggs(searchEsSQLRspBO.getAggs().replaceAll("\\$size", String.valueOf(searchEsSQLRspBO.getPageSize())));
            searchEsSQLRspBO.setAggs(searchEsSQLRspBO.getAggs().replaceAll("\\$from", String.valueOf(searchEsSQLRspBO.getPageSize() * (searchEsSQLRspBO.getPageNo() - 1))));
            queryJson.put("aggs", (Object)JSON.parseObject((String)searchEsSQLRspBO.getAggs()));
        }
        if (searchEsSQLRspBO.getTrackTotalHits().booleanValue()) {
            queryJson.put("track_total_hits", (Object)searchEsSQLRspBO.getTrackTotalHits());
        }
        return queryJson.toJSONString();
    }
}

