/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.qry.service.strategy.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.qry.constant.QueryValTypeEnum;
import com.tydic.qry.constant.RespConstant;
import com.tydic.qry.po.BoolQueryConfigPO;
import com.tydic.qry.service.strategy.EsQueryBoolQueryTypeStrategy;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsQueryRangeQueryStrategy
implements EsQueryBoolQueryTypeStrategy {
    private static final Logger log = LoggerFactory.getLogger(EsQueryRangeQueryStrategy.class);
    public static final String PARTTON = "yyyy-MM-dd HH:mm:ss";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void buildEsQuryCondition(BoolQueryConfigPO mateData, JSONObject params, BoolQueryBuilder boolQueryBuilder) {
        Integer valType = mateData.getValType();
        String name = mateData.getReqParamField();
        String fieldName = mateData.getFieldName();
        Integer connectType = mateData.getConnectType();
        Integer rangeFlag = mateData.getRangeFlag();
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)fieldName);
        if (QueryValTypeEnum.CUSTOM_VAL.getType().equals(valType)) {
            String startRange = "";
            String endRange = "";
            String rangeVal = params.getString(name);
            if (rangeFlag.equals(RespConstant.RangeFlag.FRONT_CONDITION.getCode()) || rangeFlag == 3) {
                startRange = rangeVal;
            } else if (rangeFlag.equals(RespConstant.RangeFlag.BACK_CONDITION.getCode())) {
                endRange = rangeVal;
            }
            if (!ObjectUtil.isNotEmpty((Object)startRange) && !ObjectUtil.isNotEmpty((Object)endRange)) return;
            if (ObjectUtil.isNotEmpty((Object)startRange) && rangeFlag == 3) {
                rangeQueryBuilder.gt((Object)startRange);
            } else if (ObjectUtil.isNotEmpty((Object)startRange)) {
                rangeQueryBuilder.gte((Object)startRange);
            }
            if (ObjectUtil.isNotEmpty((Object)endRange)) {
                rangeQueryBuilder.lte((Object)endRange);
            }
        } else {
            String startVal = mateData.getStartVal();
            String endVal = mateData.getEndVal();
            if (ObjectUtil.isEmpty((Object)startVal) && ObjectUtil.isEmpty((Object)endVal)) {
                throw new ZTBusinessException("\u5143\u6570\u636e\u914d\u7f6e\u5f02\u5e38");
            }
            if (ObjectUtil.isNotEmpty((Object)startVal) || ObjectUtil.isNotEmpty((Object)endVal)) {
                if (ObjectUtil.isNotEmpty((Object)startVal) && rangeFlag == 3) {
                    rangeQueryBuilder.gt((Object)startVal);
                } else if (ObjectUtil.isNotEmpty((Object)startVal)) {
                    rangeQueryBuilder.gte((Object)startVal);
                }
                if (ObjectUtil.isNotEmpty((Object)endVal)) {
                    rangeQueryBuilder.lte((Object)endVal);
                }
            }
        }
        if (Integer.valueOf(2).equals(connectType)) {
            boolQueryBuilder.should((QueryBuilder)rangeQueryBuilder);
            return;
        } else {
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
    }

    @Override
    public Boolean checkParam(BoolQueryConfigPO mateData) {
        if (ObjectUtil.isEmpty((Object)mateData.getValType())) {
            throw new ZTBusinessException("\u67e5\u8be2\u6761\u4ef6\u4f20\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)mateData.getFieldName())) {
            throw new ZTBusinessException("\u67e5\u8be2\u6761\u4ef6\u7d22\u5f15\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)mateData.getQueryType())) {
            throw new ZTBusinessException("\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (QueryValTypeEnum.FIX_VAL.getType().equals(mateData.getValType()) && (ObjectUtil.isEmpty((Object)mateData.getStartVal()) || ObjectUtil.isEmpty((Object)mateData.getEndVal()))) {
            throw new ZTBusinessException("\u67e5\u8be2\u6761\u4ef6\u56fa\u5b9a\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)mateData.getRangeFlag())) {
            throw new ZTBusinessException("\u67e5\u8be2\u6761\u4ef6\u8303\u56f4\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return true;
    }
}

