/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.qry.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.qry.util.AnyTrustStrategy;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchUtil {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchUtil.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchUtil.class);
    private static ObjectMapper mapper = new ObjectMapper();
    @Qualifier(value="restHighLevelClient")
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Qualifier(value="restClientBuilder")
    @Autowired
    private RestClientBuilder restClientBuilder;
    @Value(value="${ali.es.username:}")
    private String userName;
    @Value(value="${ali.es.password:}")
    private String password;
    @Value(value="${es.cluster.address}")
    private String clusterNodes;

    public String sendPost(String endPoint, String esQueryBody) {
        String resultCode = "";
        try {
            Long startTime = System.currentTimeMillis();
            String url = new StringBuffer().append("http://").append(this.userName).append(":").append(this.password).append("@").append(this.clusterNodes).append(endPoint).toString();
            log.info("\u8c03\u7528es\u5730\u5740\uff1a" + url);
            RegistryBuilder registryBuilder = RegistryBuilder.create();
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            SSLContext sslContext = SSLContexts.custom().useTLS().loadTrustMaterial(trustStore, (TrustStrategy)new AnyTrustStrategy()).build();
            SSLConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry socketFactoryRegistry = registryBuilder.register("https", (Object)sslSF).register("http", (Object)new PlainConnectionSocketFactory()).build();
            try (PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);){
                HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
                CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
                HttpPost httpPost = new HttpPost(url);
                StringEntity uefEntity = new StringEntity(esQueryBody, "UTF-8");
                uefEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)uefEntity);
                log.info("uefEntity=" + JSON.toJSONString((Object)uefEntity));
                CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
                if (response != null) {
                    log.info("response=" + JSON.toJSONString((Object)response));
                    if (200 != response.getStatusLine().getStatusCode()) {
                        resultCode = "";
                    } else {
                        HttpEntity entity = response.getEntity();
                        resultCode = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
                        EntityUtils.consume((HttpEntity)entity);
                        response.close();
                    }
                } else {
                    resultCode = "";
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Long endTime = System.currentTimeMillis();
            log.info("\u672c\u6b21es\u67e5\u8be2\u82b1\u8d39\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms\uff0cesQueryBody:" + esQueryBody);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return resultCode;
    }

    public String getEsIndex(String indexName) {
        Long startTime = System.currentTimeMillis();
        String esIndex = "";
        String method = "GET";
        String endpoint = StringUtils.isNotBlank((CharSequence)indexName) ? new StringBuffer().append("/").append(indexName).toString() : new StringBuffer().append("/_cat/indices").toString();
        Request request = new Request(method, endpoint);
        try (RestHighLevelClient client = new RestHighLevelClient(this.restClientBuilder);){
            Response response = client.getLowLevelClient().performRequest(request);
            esIndex = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.info("\u8c03\u7528es\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        Long endTime = System.currentTimeMillis();
        log.info("\u672c\u6b21es\u67e5\u8be2\u82b1\u8d39\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return esIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteIndex(String index) {
        if (StrUtil.isBlank((CharSequence)index)) {
            LOGGER.info("\u5220\u9664\u7d22\u5f15\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        try (RestHighLevelClient client = new RestHighLevelClient(this.restClientBuilder);){
            AcknowledgedResponse indexResponse = client.indices().delete(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                LOGGER.info("\u5220\u9664\u7d22\u5f15\u6210\u529f");
            } else {
                LOGGER.info("\u5220\u9664\u7d22\u5f15\u5931\u8d25");
            }
            boolean bl = indexResponse.isAcknowledged();
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            String exceptionStr = JSON.toJSONString((Object)e.getMessage());
            if (!exceptionStr.contains("index_not_found_exception")) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createIndex(String index) {
        CreateIndexRequest request = new CreateIndexRequest(index);
        try (RestHighLevelClient client = new RestHighLevelClient(this.restClientBuilder);){
            CreateIndexResponse indexResponse = client.indices().create(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                LOGGER.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f");
            } else {
                LOGGER.info("\u521b\u5efa\u7d22\u5f15\u5931\u8d25");
            }
            boolean bl = indexResponse.isAcknowledged();
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addData(String index, String type, String id, JSONObject object) {
        try (RestClient client = this.restClientBuilder.build();){
            String jsonString = JSON.toJSONString((Object)object);
            Request request = new Request("PUT", "/" + index + "/_doc/" + (id != null ? id : ""));
            request.setJsonEntity(jsonString);
            Response response = client.performRequest(request);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201) {
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                String string = id != null ? id : responseBody;
                return string;
            }
            LOGGER.info("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + response.getStatusLine().getStatusCode());
            return null;
        }
        catch (IOException e) {
            LOGGER.info("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public boolean checkIndexExist(String index) {
        String ok = "OK";
        boolean checkResult = false;
        try (RestHighLevelClient client = new RestHighLevelClient(this.restClientBuilder);){
            Request request = new Request("HEAD", index);
            Response response = client.getLowLevelClient().performRequest(request);
            if (ok.equals(response.getStatusLine().getReasonPhrase())) {
                checkResult = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("\u68c0\u67e5\u7d22\u5f15\u5931\u8d25", (Throwable)e);
        }
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        boolean deleteResult = false;
        NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);
        try (RestHighLevelClient client = new RestHighLevelClient(this.restClientBuilder);){
            JSONObject deleteResultJson;
            int deleteCount;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StrUtil.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (entity != null) {
                try {
                    entity.getContent().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return deleteResult;
    }

    public RestClient getLowLevelClient() {
        return new RestHighLevelClient(this.restClientBuilder).getLowLevelClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean reIndex(String endPoint, JSONObject qryJson) {
        boolean reIndexResult = false;
        NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);
        try (RestHighLevelClient client = new RestHighLevelClient(this.restClientBuilder);){
            JSONObject deleteResultJson;
            int createdCount;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StrUtil.isNotBlank((CharSequence)result) && (createdCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("created").intValue()) > 0) {
                reIndexResult = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("\u8fc1\u79fb\u7d22\u5f15\u5185\u5bb9", (Throwable)e);
        }
        finally {
            if (entity != null) {
                try {
                    entity.getContent().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return reIndexResult;
    }
}

