/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.qry.util;

import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlRunnable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolUtil.class);
    private static int CPU_CORE_NUM = Runtime.getRuntime().availableProcessors();
    public static ExecutorService cpuExecutor = new ThreadPoolExecutor(CPU_CORE_NUM, CPU_CORE_NUM + 1, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(50), new ThreadPoolExecutor.CallerRunsPolicy());
    private static ExecutorService ioExecutor = new ThreadPoolExecutor(CPU_CORE_NUM * 2, CPU_CORE_NUM * 3, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(50), new ThreadPoolExecutor.CallerRunsPolicy());

    public static void executeCpuTask(Runnable task) {
        cpuExecutor.execute((Runnable)TtlRunnable.get((Runnable)task));
    }

    public static Future<?> submitCpuTask(Runnable task) {
        return cpuExecutor.submit((Runnable)TtlRunnable.get((Runnable)task));
    }

    public static <V> Future<V> submitCpuTask(Callable<V> task) {
        return cpuExecutor.submit(TtlCallable.get(task));
    }

    public static <T> Future<T> submitCpuTask(Runnable task, T result) {
        return cpuExecutor.submit((Runnable)TtlRunnable.get((Runnable)task), result);
    }

    public static void executeIoTask(Runnable task) {
        ioExecutor.execute((Runnable)TtlRunnable.get((Runnable)task));
    }

    public static Future<?> submitIoTask(Runnable task) {
        return ioExecutor.submit((Runnable)TtlRunnable.get((Runnable)task));
    }

    public static <V> Future<V> submitIoTask(Callable<V> task) {
        return ioExecutor.submit(TtlCallable.get(task));
    }

    public static <T> Future<T> submitIoTask(Runnable task, T result) {
        return ioExecutor.submit((Runnable)TtlRunnable.get((Runnable)task), result);
    }
}

