/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.robot.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.robot.scoketcommon.bo.CommandBO;
import com.tydic.nicc.robot.scoketcommon.vo.AccessTokenVO;
import com.tydic.robot.service.WebSocketClientHandler;
import com.tydic.robot.service.WebSocketListener;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketManagement {
    static Channel channel = null;
    private String port;
    private String serviceIp;
    private WebSocketListener webSocketListener;
    private static final Logger logger = LoggerFactory.getLogger(WebSocketManagement.class);

    public WebSocketManagement(String port, String serviceIp, WebSocketListener webSocketListener) {
        this.port = port;
        this.serviceIp = serviceIp;
        this.webSocketListener = webSocketListener;
    }

    public void createWebSocketConnection(String appKey, String secreteKey, String robotId) {
        Bootstrap boot = new Bootstrap();
        NioEventLoopGroup group = new NioEventLoopGroup();
        AccessTokenVO accessTokenVO = new AccessTokenVO();
        accessTokenVO.setAppKey(appKey);
        accessTokenVO.setSecretKey(secreteKey);
        String rsp = this.sendHttpPost(JSON.toJSONString((Object)accessTokenVO), "http://" + this.serviceIp + ":8777/Robot/authorizeToken");
        logger.info(rsp);
        accessTokenVO = (AccessTokenVO)JSONObject.parseObject((String)rsp, AccessTokenVO.class);
        try {
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)boot.option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)0xA00000)).group((EventLoopGroup)group)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) {
                    ChannelPipeline p = socketChannel.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(0xA00000)});
                    p.addLast("hookedHandler", (ChannelHandler)new WebSocketClientHandler());
                }
            });
            URI websocketURI = new URI("ws://" + this.serviceIp + ":" + this.port + "/ws");
            DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
            httpHeaders.set("NLS_TOKEN", (Object)accessTokenVO.getToken());
            httpHeaders.set("ROBOT_ID", (Object)robotId);
            WebSocketClientHandshaker webSocketClientHandshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)websocketURI, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)httpHeaders);
            if (channel == null) {
                channel = boot.connect(websocketURI.getHost(), websocketURI.getPort()).sync().channel();
            }
            WebSocketClientHandler handler = (WebSocketClientHandler)channel.pipeline().get("hookedHandler");
            handler.setWebSocketListener(this.webSocketListener);
            handler.setHandShaker(webSocketClientHandshaker);
            webSocketClientHandshaker.handshake(channel);
            handler.handshakeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeWebSocketConnection() {
        CommandBO commandDTO = new CommandBO();
        commandDTO.setCommandContent("CHANNEL_CLOSE");
        this.sendCommand(commandDTO);
    }

    public void sendCommand(CommandBO commandBO) {
        TextWebSocketFrame textWebSocketFrame = new TextWebSocketFrame(JSON.toJSONString((Object)commandBO));
        channel.writeAndFlush((Object)textWebSocketFrame).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess()) {
                    logger.info("command send success");
                } else {
                    logger.error("command send failed  " + channelFuture.cause().getMessage());
                }
            }
        });
    }

    public void sendVoice(InputStream inputStream) {
        int bufSize = 6400;
        byte[] buffer = new byte[6400];
        try {
            while (inputStream.read(buffer, 0, 6400) > 0) {
                ByteBuf bf = Unpooled.buffer().writeBytes(buffer);
                BinaryWebSocketFrame binaryWebSocketFrame = new BinaryWebSocketFrame(bf);
                channel.writeAndFlush((Object)binaryWebSocketFrame).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        if (channelFuture.isSuccess()) {
                            logger.info("asr send success");
                        } else {
                            logger.error("asr send failed  " + channelFuture.cause().toString());
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendHttpPost(String params, String requestUrl) {
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + params);
        byte[] paramsData = params.getBytes();
        InputStream instr = null;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        try {
            URL url = new URL(requestUrl);
            URLConnection urlCon = url.openConnection();
            urlCon.setDoOutput(true);
            urlCon.setDoInput(true);
            urlCon.setUseCaches(false);
            urlCon.setRequestProperty("content-Type", "application/json");
            urlCon.setRequestProperty("charset", "utf-8");
            urlCon.setRequestProperty("Content-length", String.valueOf(paramsData.length));
            DataOutputStream printout = new DataOutputStream(urlCon.getOutputStream());
            printout.write(paramsData);
            printout.flush();
            printout.close();
            instr = urlCon.getInputStream();
            byte[] buff = new byte[1024];
            int rc = 0;
            while ((rc = instr.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            byte[] bis = swapStream.toByteArray();
            String ResponseString = new String(bis, "UTF-8");
            if (ResponseString == null || "".equals(ResponseString.trim())) {
                logger.error("\u8fd4\u56de\u6570\u636e\u4e3anull\uff01");
            }
            logger.info("\u8fd4\u56de\u6570\u636e\u4e3a:" + ResponseString);
            String string = ResponseString;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "0";
            return string;
        }
        finally {
            try {
                instr.close();
                swapStream.close();
            }
            catch (Exception ex) {
                return "0";
            }
        }
    }
}

