/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.rpa.api.bo.base;

import com.tydic.rpa.api.bo.base.CodeMsg;
import com.tydic.rpa.api.bo.base.RpaRspBaseBO;
import java.io.Serializable;

public class RpaRspBO<T>
extends RpaRspBaseBO
implements Serializable {
    private static final long serialVersionUID = -7205679255293823214L;
    private T result;

    private RpaRspBO(CodeMsg codeMsg, T data) {
        if (codeMsg != null) {
            this.setRespCode(codeMsg.getRespCode());
            this.setRespDesc(codeMsg.getRespDesc());
        }
        this.result = data;
    }

    public static <T> RpaRspBO<T> success(T data) {
        return new RpaRspBO<T>(CodeMsg.SUCCESS, data);
    }

    public static <T> RpaRspBO<T> error(T data) {
        return new RpaRspBO<T>(CodeMsg.ERROR, data);
    }

    public static RpaRspBO<String> alreadyExists(String data) {
        return new RpaRspBO<String>(CodeMsg.ALREADY_EXISTS, data + " " + CodeMsg.ALREADY_EXISTS.getRespDesc());
    }

    public static RpaRspBO<String> notExists(String data) {
        return new RpaRspBO<String>(CodeMsg.NOT_EXISTS, data + " " + CodeMsg.NOT_EXISTS.getRespDesc());
    }

    public static RpaRspBO<String> creationFailed(String ex) {
        return new RpaRspBO<String>(CodeMsg.CREATION_FAILED, ex);
    }

    public static RpaRspBO<String> changeFailed(String ex) {
        return new RpaRspBO<String>(CodeMsg.CHANGE_FAILED, ex);
    }

    public static <T> RpaRspBO<T> error(CodeMsg codeMsg) {
        return new RpaRspBO<T>(codeMsg);
    }

    public static <T> RpaRspBO<T> error(CodeMsg codeMsg, T data) {
        return new RpaRspBO<T>(codeMsg, data);
    }

    private RpaRspBO(T data) {
        this.result = data;
    }

    private RpaRspBO(String code, String message) {
        this.setRespCode(code);
        this.setRespDesc(message);
    }

    private RpaRspBO(CodeMsg codeMsg) {
        if (codeMsg != null) {
            this.setRespCode(codeMsg.getRespCode());
            this.setRespDesc(codeMsg.getRespDesc());
        }
    }

    private RpaRspBO(String message) {
        this.setRespCode(CodeMsg.ERROR.getRespCode());
        this.setRespDesc(message);
    }

    public static <T> RpaRspBOBuilder<T> builder() {
        return new RpaRspBOBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RpaRspBO)) {
            return false;
        }
        RpaRspBO other = (RpaRspBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RpaRspBO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    @Override
    public String toString() {
        return "RpaRspBO(result=" + this.getResult() + ")";
    }

    public RpaRspBO() {
    }

    public static class RpaRspBOBuilder<T> {
        private T result;

        RpaRspBOBuilder() {
        }

        public RpaRspBOBuilder<T> result(T result) {
            this.result = result;
            return this;
        }

        public RpaRspBO<T> build() {
            return new RpaRspBO(this.result);
        }

        public String toString() {
            return "RpaRspBO.RpaRspBOBuilder(result=" + this.result + ")";
        }
    }
}

