/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.rpa.ability.impl;

import com.tydic.rpa.api.DocManageService;
import com.tydic.rpa.api.bo.DocManageReqBO;
import com.tydic.rpa.api.bo.base.RpaRspBO;
import com.tydic.rpa.dao.DocMapper;
import com.tydic.rpa.exception.BaseBusinessException;
import com.tydic.rpa.po.DocPO;
import com.tydic.rpa.utils.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="docManageService")
public class DocManageServiceImpl
implements DocManageService {
    private static final Logger log = LoggerFactory.getLogger(DocManageServiceImpl.class);
    private final DocMapper docMapper;

    public DocManageServiceImpl(DocMapper docMapper) {
        this.docMapper = docMapper;
    }

    public RpaRspBO<String> dealManage(DocManageReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new BaseBusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (reqBO.getOperType()) {
            case 1: {
                this.addDoc(reqBO);
                break;
            }
            case 2: {
                this.editDoc(reqBO);
                break;
            }
            case 3: {
                this.deleteDoc(reqBO);
                break;
            }
            default: {
                throw new BaseBusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38");
            }
        }
        return RpaRspBO.success((Object)"\u6210\u529f");
    }

    private void addDoc(DocManageReqBO reqBO) {
        DocPO docPO = new DocPO();
        if (StringUtils.isEmpty((Object)reqBO.getDocCatalogId())) {
            throw new BaseBusinessException("8888", "\u6587\u6863\u76ee\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)docPO);
        docPO.setDocId(String.valueOf(Sequence.nextId()));
        docPO.setCreateBy(reqBO.getUserId());
        docPO.setCreateTime(this.docMapper.getDBDate());
        docPO.setUpdateTime(this.docMapper.getDBDate());
        docPO.setUpdateBy(reqBO.getUserId());
        try {
            this.docMapper.insert(docPO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u65b0\u589e\u6587\u6863\u5931\u8d25");
        }
    }

    private void editDoc(DocManageReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getDocId())) {
            throw new BaseBusinessException("8888", "\u6587\u6863ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocPO docPO = new DocPO();
        docPO.setDocId(reqBO.getDocId());
        docPO.setContent(reqBO.getContent());
        docPO.setUpdateBy(reqBO.getUserId());
        docPO.setUpdateTime(this.docMapper.getDBDate());
        try {
            this.docMapper.updateById(docPO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u66f4\u65b0\u6587\u6863\u5931\u8d25");
        }
    }

    private void deleteDoc(DocManageReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getDocId())) {
            throw new BaseBusinessException("8888", "\u6587\u6863ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocPO docPO = new DocPO();
        docPO.setDocId(reqBO.getDocId());
        try {
            this.docMapper.deleteBy(docPO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u5220\u9664\u6587\u6863\u5931\u8d25");
        }
    }
}

