/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.rpa.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.rpa.api.DocModuleQryService;
import com.tydic.rpa.api.bo.DocModuleDataBO;
import com.tydic.rpa.api.bo.DocModulePageQryReqBO;
import com.tydic.rpa.api.bo.DocModuleQryDetailReqBO;
import com.tydic.rpa.api.bo.DocModulesByCategoryRspBO;
import com.tydic.rpa.api.bo.HotSpotDataBO;
import com.tydic.rpa.api.bo.QryHotSpotReqBO;
import com.tydic.rpa.api.bo.base.RpaRspBO;
import com.tydic.rpa.api.bo.base.RpaRspPageBaseBO;
import com.tydic.rpa.dao.DocCatalogMapper;
import com.tydic.rpa.dao.DocMapper;
import com.tydic.rpa.dao.DocModuleMapper;
import com.tydic.rpa.exception.BaseBusinessException;
import com.tydic.rpa.po.DocCatalogPO;
import com.tydic.rpa.po.DocModulePO;
import com.tydic.rpa.po.DocPO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="docModuleQryService")
public class DocModuleQryServiceImpl
implements DocModuleQryService {
    private static final Logger log = LoggerFactory.getLogger(DocModuleQryServiceImpl.class);
    @Autowired
    private DocModuleMapper docModuleMapper;
    @Autowired
    private DocMapper docMapper;
    @Autowired
    private DocCatalogMapper catalogMapper;

    public RpaRspBO<DocModuleDataBO> qryDetail(DocModuleQryDetailReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getModuleId())) {
            throw new BaseBusinessException("8888", "\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocModulePO docModulePO = new DocModulePO();
        docModulePO.setModuleId(reqBO.getModuleId());
        DocModulePO modelBy = this.docModuleMapper.getModelBy(docModulePO);
        DocModuleDataBO docModuleQryDetailRspBO = (DocModuleDataBO)JSON.parseObject((String)JSON.toJSONString((Object)modelBy), DocModuleDataBO.class);
        return RpaRspBO.success((Object)docModuleQryDetailRspBO);
    }

    public RpaRspBO<RpaRspPageBaseBO<DocModuleDataBO>> qryPage(DocModulePageQryReqBO reqBO) {
        DocModulePO qryPo = new DocModulePO();
        if (!StringUtils.isEmpty((Object)reqBO.getModuleName())) {
            qryPo.setModuleName(reqBO.getModuleName());
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getModuleStatus())) {
            qryPo.setModuleStatus(reqBO.getModuleStatus());
        }
        RpaRspPageBaseBO rspPage = new RpaRspPageBaseBO();
        Page<DocModulePO> page = this.getDocModulePage(reqBO);
        List<DocModulePO> docModulePoList = this.docModuleMapper.getListPage(qryPo, page);
        List rows = new ArrayList();
        if (!CollectionUtils.isEmpty(docModulePoList)) {
            rows = JSON.parseArray((String)JSON.toJSONString(docModulePoList), DocModuleDataBO.class);
        }
        rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
        rspPage.setRows(rows);
        rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return RpaRspBO.success((Object)rspPage);
    }

    public RpaRspBO<RpaRspPageBaseBO<HotSpotDataBO>> qryHotSpot(QryHotSpotReqBO reqBO) {
        DocPO docPO = new DocPO();
        docPO.setOrderBy("d.update_time desc");
        RpaRspPageBaseBO rspPage = new RpaRspPageBaseBO();
        Page<DocPO> page = this.getDocPage(reqBO);
        List<DocPO> result = this.docMapper.getListOnCatalogDisplay(docPO, page);
        List collect = Collections.emptyList();
        if (!CollectionUtils.isEmpty(result)) {
            collect = result.stream().map(item -> {
                HotSpotDataBO hotSpotDataBO = new HotSpotDataBO();
                DocCatalogPO catalogPO = new DocCatalogPO();
                catalogPO.setId(item.getDocCatalogId());
                catalogPO = this.catalogMapper.getModelBy(catalogPO);
                DocModulePO docModulePO = new DocModulePO();
                docModulePO.setModuleId(catalogPO.getDocModuleId());
                docModulePO = this.docModuleMapper.getModelBy(docModulePO);
                hotSpotDataBO.setModuleName(docModulePO.getModuleName());
                hotSpotDataBO.setDocCatalogName(catalogPO.getCatalogName());
                hotSpotDataBO.setUpdateTime(item.getUpdateTime());
                hotSpotDataBO.setDocId(item.getDocId());
                hotSpotDataBO.setDocCatalogId(catalogPO.getId());
                hotSpotDataBO.setModuleId(docModulePO.getModuleId());
                return hotSpotDataBO;
            }).collect(Collectors.toList());
        }
        rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
        rspPage.setRows(collect);
        rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return RpaRspBO.success((Object)rspPage);
    }

    public RpaRspBO<List<DocModulesByCategoryRspBO>> qryListGroupByCategory() {
        ArrayList<DocModulesByCategoryRspBO> resultList = new ArrayList<DocModulesByCategoryRspBO>();
        DocModulePO docModulePO = new DocModulePO();
        docModulePO.setModuleStatus(1);
        List<DocModulePO> list = this.docModuleMapper.getList(docModulePO);
        Map<String, List<DocModulePO>> groupMap = list.stream().collect(Collectors.groupingBy(DocModulePO::getCategory));
        Set<Map.Entry<String, List<DocModulePO>>> entries = groupMap.entrySet();
        for (Map.Entry<String, List<DocModulePO>> entry : entries) {
            DocModulesByCategoryRspBO data = new DocModulesByCategoryRspBO();
            data.setCategory(entry.getKey());
            data.setModules(JSON.parseArray((String)JSON.toJSONString(entry.getValue()), DocModuleDataBO.class));
            resultList.add(data);
        }
        return RpaRspBO.success(resultList);
    }

    private Page<DocModulePO> getDocModulePage(DocModulePageQryReqBO reqBO) {
        Page page;
        if (1 < reqBO.getPageNo()) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBO, (Object)page);
            if (1 > page.getPageNo()) {
                page.setPageNo(1);
            }
            if (1 > page.getPageSize()) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private Page<DocPO> getDocPage(QryHotSpotReqBO reqBO) {
        Page page;
        if (1 < reqBO.getPageNo()) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBO, (Object)page);
            if (1 > page.getPageNo()) {
                page.setPageNo(1);
            }
            if (1 > page.getPageSize()) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

