/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.rpa.ability.impl;

import com.tydic.rpa.api.DocBatchManageService;
import com.tydic.rpa.api.bo.CatalogDataBO;
import com.tydic.rpa.api.bo.DocBatchManageReqBO;
import com.tydic.rpa.api.bo.base.RpaRspBO;
import com.tydic.rpa.dao.DocCatalogMapper;
import com.tydic.rpa.exception.BaseBusinessException;
import com.tydic.rpa.po.DocCatalogPO;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="docBatchManageService")
public class DocBatchManageServiceImpl
implements DocBatchManageService {
    private static final Logger log = LoggerFactory.getLogger(DocBatchManageServiceImpl.class);
    private final DocCatalogMapper docCatalogMapper;

    public DocBatchManageServiceImpl(DocCatalogMapper docCatalogMapper) {
        this.docCatalogMapper = docCatalogMapper;
    }

    public RpaRspBO<String> batchManage(DocBatchManageReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOperType() == null) {
            throw new BaseBusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (reqBO.getOperType()) {
            case 1: {
                this.deleteBatch(reqBO);
                break;
            }
            case 2: {
                this.sortBatch(reqBO);
                break;
            }
            default: {
                throw new BaseBusinessException("8888", "\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38");
            }
        }
        return RpaRspBO.success((Object)"\u6210\u529f");
    }

    private void deleteBatch(DocBatchManageReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getDocList())) {
            List docList = reqBO.getDocList();
            for (CatalogDataBO dataBO : docList) {
                DocCatalogPO catalogPO = new DocCatalogPO();
                catalogPO.setId(dataBO.getId());
                try {
                    this.docCatalogMapper.deleteBy(catalogPO);
                }
                catch (Exception e) {}
            }
        }
    }

    private void sortBatch(DocBatchManageReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getDocList())) {
            List docList = reqBO.getDocList();
            for (CatalogDataBO dataBO : docList) {
                DocCatalogPO catalogPO = new DocCatalogPO();
                catalogPO.setId(dataBO.getId());
                catalogPO.setSort(dataBO.getSort());
                try {
                    this.docCatalogMapper.updateById(catalogPO);
                }
                catch (Exception e) {}
            }
        }
    }
}

