/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.app.ability.impl;

import com.tydic.se.app.ability.SeAppQueryService;
import com.tydic.se.app.ability.bo.SeAppSearchReqBO;
import com.tydic.se.app.ability.bo.SeAppSearchRspBO;
import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQueryPropertyBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.search.ability.SeQueryService;
import com.tydic.se.search.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"search-engine-group/1.0.0/com.tydic.se.app.ability.SeAppQueryService"})
public class SeAppQueryServiceImpl
implements SeAppQueryService {
    private static final Logger log = LoggerFactory.getLogger(SeAppQueryServiceImpl.class);
    @Value(value="${es.config.search.size:500}")
    private Integer ES_SEARCH_SIZE;
    @Autowired
    private SeQueryService seQueryService;

    @PostMapping(value={"search"})
    public SeAppSearchRspBO search(@RequestBody SeAppSearchReqBO seAppSearchReqBO) {
        if (seAppSearchReqBO.getPageNo() < 1) {
            seAppSearchReqBO.setPageNo(1);
        }
        if (seAppSearchReqBO.getPageSize() < 1) {
            seAppSearchReqBO.setPageSize(10);
        }
        SeAppSearchRspBO rspBO = new SeAppSearchRspBO();
        ExecuteSearchReqBO executeSearchReqBO = new ExecuteSearchReqBO();
        executeSearchReqBO.setFrom(Integer.valueOf(0));
        executeSearchReqBO.setSize(this.ES_SEARCH_SIZE);
        executeSearchReqBO.setQueryStr(seAppSearchReqBO.getQueryStr());
        ArrayList mustTermsList = new ArrayList();
        if (seAppSearchReqBO.getMustTermsList() != null) {
            mustTermsList.addAll(seAppSearchReqBO.getMustTermsList());
        }
        if (seAppSearchReqBO.getQueryFilterList() != null) {
            HashMap<String, SeTermsBO> filterTermsMap = new HashMap<String, SeTermsBO>();
            String vendorName = "vendor_name";
            String brandName = "brand_name";
            String l3CategoryName = "l3_category_name";
            for (SeQueryFilterBO seQueryFilterBO : seAppSearchReqBO.getQueryFilterList()) {
                SeTermsBO seTermsBO;
                if (!vendorName.equals(seQueryFilterBO.getFilterId()) && !brandName.equals(seQueryFilterBO.getFilterId()) && !l3CategoryName.equals(seQueryFilterBO.getFilterId())) continue;
                if (filterTermsMap.containsKey(seQueryFilterBO.getFilterId())) {
                    seTermsBO = (SeTermsBO)filterTermsMap.get(seQueryFilterBO.getFilterId());
                    List valueList = seTermsBO.getValueList();
                    valueList.addAll(seQueryFilterBO.getFilterValues());
                    seTermsBO.setValueList(valueList);
                    filterTermsMap.put(seQueryFilterBO.getFilterId(), seTermsBO);
                    continue;
                }
                seTermsBO = new SeTermsBO(seQueryFilterBO.getFilterId(), seQueryFilterBO.getFilterValues());
                filterTermsMap.put(seQueryFilterBO.getFilterId(), seTermsBO);
            }
            List filterTermsList = filterTermsMap.values().stream().collect(Collectors.toList());
            mustTermsList.addAll(filterTermsList);
        }
        executeSearchReqBO.setMustTermsList(mustTermsList);
        executeSearchReqBO.setMustNotTermsList(seAppSearchReqBO.getMustNotTermsList());
        ExecuteSearchRspBO executeSearchRspBO = this.seQueryService.search(executeSearchReqBO);
        SeEsResultBO esResultBO = executeSearchRspBO.getEsResultBO();
        int recordsTotal = esResultBO.getHits().getHits().size();
        int maxPageNum = recordsTotal / seAppSearchReqBO.getPageSize() + 1;
        if (seAppSearchReqBO.getPageNo() > maxPageNum) {
            rspBO.setPageNo(maxPageNum);
        } else {
            rspBO.setPageNo(seAppSearchReqBO.getPageNo());
        }
        List<SeQuerySkuBO> skuList = this.parsePageList(esResultBO, rspBO.getPageNo(), seAppSearchReqBO.getPageSize(), seAppSearchReqBO);
        rspBO.setSkuList(skuList);
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotal(seAppSearchReqBO.getPageSize());
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @PostMapping(value={"categoryList"})
    public SeAppSearchRspBO categoryList(@RequestBody SeAppSearchReqBO seAppSearchReqBO) {
        SeAppSearchRspBO rspBO = new SeAppSearchRspBO();
        ExecuteSearchReqBO executeSearchReqBO = new ExecuteSearchReqBO();
        executeSearchReqBO.setFrom(Integer.valueOf(0));
        executeSearchReqBO.setSize(this.ES_SEARCH_SIZE);
        executeSearchReqBO.setQueryStr(seAppSearchReqBO.getQueryStr());
        ArrayList mustTermsList = new ArrayList();
        if (seAppSearchReqBO.getMustTermsList() != null) {
            mustTermsList.addAll(seAppSearchReqBO.getMustTermsList());
        }
        if (seAppSearchReqBO.getQueryFilterList() != null) {
            HashMap<String, SeTermsBO> filterTermsMap = new HashMap<String, SeTermsBO>();
            String vendorName = "vendor_name";
            String brandName = "brand_name";
            String l3CategoryName = "l3_category_name";
            for (SeQueryFilterBO seQueryFilterBO : seAppSearchReqBO.getQueryFilterList()) {
                SeTermsBO seTermsBO;
                if (!vendorName.equals(seQueryFilterBO.getFilterId()) && !brandName.equals(seQueryFilterBO.getFilterId()) && !l3CategoryName.equals(seQueryFilterBO.getFilterId())) continue;
                if (filterTermsMap.containsKey(seQueryFilterBO.getFilterId())) {
                    seTermsBO = (SeTermsBO)filterTermsMap.get(seQueryFilterBO.getFilterId());
                    List valueList = seTermsBO.getValueList();
                    valueList.addAll(seQueryFilterBO.getFilterValues());
                    seTermsBO.setValueList(valueList);
                    filterTermsMap.put(seQueryFilterBO.getFilterId(), seTermsBO);
                    continue;
                }
                seTermsBO = new SeTermsBO(seQueryFilterBO.getFilterId(), seQueryFilterBO.getFilterValues());
                filterTermsMap.put(seQueryFilterBO.getFilterId(), seTermsBO);
            }
            List filterTermsList = filterTermsMap.values().stream().collect(Collectors.toList());
            mustTermsList.addAll(filterTermsList);
        }
        executeSearchReqBO.setMustTermsList(mustTermsList);
        ExecuteSearchRspBO executeSearchRspBO = this.seQueryService.categoryList(executeSearchReqBO);
        rspBO.setQueryFilterList(executeSearchRspBO.getQueryFilterList());
        rspBO.setQueryPropertyList(executeSearchRspBO.getQueryPropertyList());
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    private List<SeQuerySkuBO> parsePageList(SeEsResultBO esResultBO, int pageNo, int pageSize, SeAppSearchReqBO seAppSearchReqBO) {
        ArrayList<SeQuerySkuBO> skuList = new ArrayList<SeQuerySkuBO>();
        List<SeEsResultBO.Hits.InHits> hitsList = esResultBO.getHits().getHits();
        if (seAppSearchReqBO.getMinSalePrice() != null) {
            BigDecimal minSalePrice = new BigDecimal(seAppSearchReqBO.getMinSalePrice());
            hitsList.removeIf(hits -> hits.get_source().getSalePrice().compareTo(minSalePrice) <= 0);
        }
        if (seAppSearchReqBO.getMaxSalePrice() != null) {
            BigDecimal maxSalePrice = new BigDecimal(seAppSearchReqBO.getMaxSalePrice());
            hitsList.removeIf(hits -> hits.get_source().getSalePrice().compareTo(maxSalePrice) >= 0);
        }
        if (seAppSearchReqBO.getSortMode() != null) {
            log.info("- - - - - \u5f00\u59cb\u6392\u5e8f - - - - -");
            hitsList = this.commoditySort(hitsList, seAppSearchReqBO, 0);
            log.info("- - - - - \u7ed3\u675f\u6392\u5e8f - - - - -");
        }
        int maxSize = pageNo * pageSize;
        if (hitsList == null) {
            maxSize = 0;
        } else if (hitsList.size() < maxSize) {
            maxSize = hitsList.size();
        }
        for (int index = (pageNo - 1) * pageSize; index < maxSize; ++index) {
            skuList.add(hitsList.get(index).get_source());
        }
        return skuList;
    }

    private List<SeTermsBO> parseMustTermsList(SeAppSearchReqBO seAppSearchReqBO) {
        SeTermsBO seTermsBO;
        ArrayList<SeTermsBO> tempMustTermsList = new ArrayList<SeTermsBO>();
        if (seAppSearchReqBO.getQueryFilterList() != null) {
            for (SeQueryFilterBO seQueryFilterBO : seAppSearchReqBO.getQueryFilterList()) {
                seTermsBO = new SeTermsBO(seQueryFilterBO.getFilterId(), seQueryFilterBO.getFilterValues());
                tempMustTermsList.add(seTermsBO);
            }
        }
        if (seAppSearchReqBO.getQueryPropertyList() != null) {
            for (SeQueryPropertyBO seQueryPropertyBO : seAppSearchReqBO.getQueryPropertyList()) {
                seTermsBO = new SeTermsBO(seQueryPropertyBO.getPropertyId(), seQueryPropertyBO.getPropertyValues());
                tempMustTermsList.add(seTermsBO);
            }
        }
        if (seAppSearchReqBO.getMustTermsList() != null) {
            tempMustTermsList.addAll(seAppSearchReqBO.getMustTermsList());
        }
        return tempMustTermsList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SeEsResultBO.Hits.InHits> commoditySort(List<SeEsResultBO.Hits.InHits> seResultData, SeAppSearchReqBO seAppSearchReqBO, int index) {
        String sortOrder = seAppSearchReqBO.getSortMode();
        if (seResultData == null) return seResultData;
        if (seResultData.size() == 0) return seResultData;
        if ("COMPREHENSIVE_SORT".equals(sortOrder)) {
            if (seAppSearchReqBO.getComSortList() == null) return seResultData;
            if (seAppSearchReqBO.getComSortList().isEmpty()) return seResultData;
            if (seAppSearchReqBO.getComSortList().size() <= index) return seResultData;
            sortOrder = this.comSortTransformation((SeComSortBO)seAppSearchReqBO.getComSortList().get(index));
        }
        if ("SOLD_NUMBER_DESC".equals(sortOrder) || "SOLD_NUMBER_ASC".equals(sortOrder)) {
            HashMap<Long, List<SeEsResultBO.Hits.InHits>> sortMap = new HashMap<Long, List<SeEsResultBO.Hits.InHits>>();
            Iterator<SeEsResultBO.Hits.InHits> iterator = seResultData.iterator();
            while (iterator.hasNext()) {
                List<SeEsResultBO.Hits.InHits> value;
                SeEsResultBO.Hits.InHits commodity = iterator.next();
                Long soldNumberL = commodity.get_source().getSoldNumber();
                if (soldNumberL == null) {
                    soldNumberL = 0L;
                }
                if (sortMap.containsKey(soldNumberL)) {
                    value = (List)sortMap.get(soldNumberL);
                    value.add(commodity);
                    sortMap.put(soldNumberL, value);
                    continue;
                }
                value = new ArrayList();
                value.add(commodity);
                sortMap.put(soldNumberL, value);
            }
            return this.sortBySoldNumber(sortMap, sortOrder, seAppSearchReqBO, index + 1);
        }
        if ("ON_SHELVE_TIME_DESC".equals(sortOrder) || "ON_SHELVE_TIME_ASC".equals(sortOrder)) {
            HashMap<Long, List<SeEsResultBO.Hits.InHits>> sortMap = new HashMap<Long, List<SeEsResultBO.Hits.InHits>>();
            Iterator<SeEsResultBO.Hits.InHits> commoditySortList = seResultData.iterator();
            while (commoditySortList.hasNext()) {
                List<SeEsResultBO.Hits.InHits> value;
                SeEsResultBO.Hits.InHits commodity = commoditySortList.next();
                Long onShelveTimeL = commodity.get_source().getOnShelveTime();
                if (sortMap.containsKey(onShelveTimeL)) {
                    value = (List)sortMap.get(onShelveTimeL);
                    value.add(commodity);
                    sortMap.put(onShelveTimeL, value);
                    continue;
                }
                value = new ArrayList();
                value.add(commodity);
                sortMap.put(onShelveTimeL, value);
            }
            return this.sortByOnShelveTime(sortMap, sortOrder, seAppSearchReqBO, index + 1);
        }
        if ("SALE_PRICE_DESC".equals(sortOrder) || "SALE_PRICE_ASC".equals(sortOrder)) {
            HashMap<BigDecimal, List<SeEsResultBO.Hits.InHits>> sortMap = new HashMap<BigDecimal, List<SeEsResultBO.Hits.InHits>>();
            Iterator<SeEsResultBO.Hits.InHits> commoditySortList = seResultData.iterator();
            while (commoditySortList.hasNext()) {
                List<SeEsResultBO.Hits.InHits> value;
                SeEsResultBO.Hits.InHits commodity = commoditySortList.next();
                BigDecimal salePrice = commodity.get_source().getSalePrice();
                if (sortMap.containsKey(salePrice)) {
                    value = (List)sortMap.get(salePrice);
                    value.add(commodity);
                    sortMap.put(salePrice, value);
                    continue;
                }
                value = new ArrayList();
                value.add(commodity);
                sortMap.put(salePrice, value);
            }
            return this.sortBySalePrice(sortMap, sortOrder, seAppSearchReqBO, index + 1);
        }
        if (!"DISCOUNTS_DESC".equals(sortOrder)) {
            if (!"DISCOUNTS_ASC".equals(sortOrder)) return seResultData;
        }
        HashMap<BigDecimal, List<SeEsResultBO.Hits.InHits>> sortMap = new HashMap<BigDecimal, List<SeEsResultBO.Hits.InHits>>();
        Iterator<SeEsResultBO.Hits.InHits> commoditySortList = seResultData.iterator();
        while (commoditySortList.hasNext()) {
            List<SeEsResultBO.Hits.InHits> value;
            SeEsResultBO.Hits.InHits commodity = commoditySortList.next();
            BigDecimal discounts = commodity.get_source().getDiscounts();
            if (discounts.compareTo(BigDecimal.ZERO) == 0) {
                discounts = BigDecimal.ONE;
            }
            if (sortMap.containsKey(discounts)) {
                value = (List)sortMap.get(discounts);
                value.add(commodity);
                sortMap.put(discounts, value);
                continue;
            }
            value = new ArrayList();
            value.add(commodity);
            sortMap.put(discounts, value);
        }
        return this.sortByDiscounts(sortMap, sortOrder, seAppSearchReqBO, index + 1);
    }

    private List<SeEsResultBO.Hits.InHits> sortByOnShelveTime(Map<Long, List<SeEsResultBO.Hits.InHits>> sortDataMap, String sortOrder, SeAppSearchReqBO seAppSearchReqBO, int index) {
        int count = 0;
        ArrayList<SeEsResultBO.Hits.InHits> commodityList = new ArrayList<SeEsResultBO.Hits.InHits>();
        Long[] dates = new Long[sortDataMap.size()];
        Long[] longArray = sortDataMap.keySet().iterator();
        while (longArray.hasNext()) {
            Long key;
            dates[count] = key = longArray.next();
            ++count;
        }
        this.fastSortByTime(sortOrder, dates, 0, count - 1);
        if (seAppSearchReqBO.getComSortList() != null && seAppSearchReqBO.getComSortList().size() > index) {
            for (Long da : dates) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(da);
                if (tempList.size() > 1) {
                    tempList = this.commoditySort(tempList, seAppSearchReqBO, index);
                }
                commodityList.addAll(tempList);
            }
        } else {
            for (Long da : dates) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(da);
                commodityList.addAll(tempList);
            }
        }
        return commodityList;
    }

    private void fastSortByTime(String sortOrder, Long[] dates, int left, int right) {
        if (left > right) {
            return;
        }
        int leftI = left;
        int rightJ = right;
        Long benchmark = dates[leftI];
        while (leftI < rightJ) {
            if ("ON_SHELVE_TIME_ASC".equals(sortOrder)) {
                while ((benchmark.compareTo(dates[rightJ]) < 0 || benchmark.compareTo(dates[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(dates[leftI]) > 0 || benchmark.compareTo(dates[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if ("ON_SHELVE_TIME_DESC".equals(sortOrder)) {
                while ((benchmark.compareTo(dates[rightJ]) > 0 || benchmark.compareTo(dates[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(dates[leftI]) < 0 || benchmark.compareTo(dates[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if (leftI >= rightJ) continue;
            Long temp = dates[rightJ];
            dates[rightJ] = dates[leftI];
            dates[leftI] = temp;
        }
        dates[left] = dates[leftI];
        dates[leftI] = benchmark;
        this.fastSortByTime(sortOrder, dates, left, leftI - 1);
        this.fastSortByTime(sortOrder, dates, leftI + 1, right);
    }

    private List<SeEsResultBO.Hits.InHits> sortBySoldNumber(Map<Long, List<SeEsResultBO.Hits.InHits>> sortDataMap, String sortOrder, SeAppSearchReqBO seAppSearchReqBO, int index) {
        int count = 0;
        ArrayList<SeEsResultBO.Hits.InHits> commodityList = new ArrayList<SeEsResultBO.Hits.InHits>();
        Long[] soldNumbers = new Long[sortDataMap.size()];
        Long[] longArray = sortDataMap.keySet().iterator();
        while (longArray.hasNext()) {
            Long key;
            soldNumbers[count] = key = longArray.next();
            ++count;
        }
        this.fastSortBySoldNumber(sortOrder, soldNumbers, 0, count - 1);
        if (seAppSearchReqBO.getComSortList() != null && seAppSearchReqBO.getComSortList().size() > index) {
            for (Long sale : soldNumbers) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(sale);
                if (tempList.size() > 1) {
                    tempList = this.commoditySort(tempList, seAppSearchReqBO, index);
                }
                commodityList.addAll(tempList);
            }
        } else {
            for (Long sale : soldNumbers) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(sale);
                commodityList.addAll(tempList);
            }
        }
        return commodityList;
    }

    private void fastSortBySoldNumber(String sortOrder, Long[] soldNumber, int left, int right) {
        if (left > right) {
            return;
        }
        int leftI = left;
        int rightJ = right;
        Long benchmark = soldNumber[leftI];
        while (leftI < rightJ) {
            if ("SOLD_NUMBER_ASC".equals(sortOrder)) {
                while ((benchmark.compareTo(soldNumber[rightJ]) < 0 || benchmark.compareTo(soldNumber[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(soldNumber[leftI]) > 0 || benchmark.compareTo(soldNumber[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if ("SOLD_NUMBER_DESC".equals(sortOrder)) {
                while ((benchmark.compareTo(soldNumber[rightJ]) > 0 || benchmark.compareTo(soldNumber[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(soldNumber[leftI]) < 0 || benchmark.compareTo(soldNumber[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if (leftI >= rightJ) continue;
            Long temp = soldNumber[rightJ];
            soldNumber[rightJ] = soldNumber[leftI];
            soldNumber[leftI] = temp;
        }
        soldNumber[left] = soldNumber[leftI];
        soldNumber[leftI] = benchmark;
        this.fastSortBySoldNumber(sortOrder, soldNumber, left, leftI - 1);
        this.fastSortBySoldNumber(sortOrder, soldNumber, leftI + 1, right);
    }

    private List<SeEsResultBO.Hits.InHits> sortBySalePrice(Map<BigDecimal, List<SeEsResultBO.Hits.InHits>> sortDataMap, String sortOrder, SeAppSearchReqBO seAppSearchReqBO, int index) {
        int count = 0;
        ArrayList<SeEsResultBO.Hits.InHits> commodityList = new ArrayList<SeEsResultBO.Hits.InHits>();
        BigDecimal[] salePrice = new BigDecimal[sortDataMap.size()];
        BigDecimal[] bigDecimalArray = sortDataMap.keySet().iterator();
        while (bigDecimalArray.hasNext()) {
            BigDecimal key;
            salePrice[count] = key = bigDecimalArray.next();
            ++count;
        }
        this.fastSortBySalePrice(sortOrder, salePrice, 0, count - 1);
        if (seAppSearchReqBO.getComSortList() != null && seAppSearchReqBO.getComSortList().size() > index) {
            for (BigDecimal salePri : salePrice) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(salePri);
                if (tempList.size() > 1) {
                    tempList = this.commoditySort(tempList, seAppSearchReqBO, index);
                }
                commodityList.addAll(tempList);
            }
        } else {
            for (BigDecimal salePri : salePrice) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(salePri);
                commodityList.addAll(tempList);
            }
        }
        return commodityList;
    }

    private void fastSortBySalePrice(String sortOrder, BigDecimal[] salePrice, int left, int right) {
        if (left > right) {
            return;
        }
        int leftI = left;
        int rightJ = right;
        BigDecimal benchmark = salePrice[leftI];
        while (leftI < rightJ) {
            if ("SALE_PRICE_ASC".equals(sortOrder)) {
                while ((benchmark.compareTo(salePrice[rightJ]) < 0 || benchmark.compareTo(salePrice[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(salePrice[leftI]) > 0 || benchmark.compareTo(salePrice[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if ("SALE_PRICE_DESC".equals(sortOrder)) {
                while ((benchmark.compareTo(salePrice[rightJ]) > 0 || benchmark.compareTo(salePrice[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(salePrice[leftI]) < 0 || benchmark.compareTo(salePrice[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if (leftI >= rightJ) continue;
            BigDecimal temp = salePrice[rightJ];
            salePrice[rightJ] = salePrice[leftI];
            salePrice[leftI] = temp;
        }
        salePrice[left] = salePrice[leftI];
        salePrice[leftI] = benchmark;
        this.fastSortBySalePrice(sortOrder, salePrice, left, leftI - 1);
        this.fastSortBySalePrice(sortOrder, salePrice, leftI + 1, right);
    }

    private List<SeEsResultBO.Hits.InHits> sortByDiscounts(Map<BigDecimal, List<SeEsResultBO.Hits.InHits>> sortDataMap, String sortOrder, SeAppSearchReqBO seAppSearchReqBO, int index) {
        int count = 0;
        ArrayList<SeEsResultBO.Hits.InHits> commodityList = new ArrayList<SeEsResultBO.Hits.InHits>();
        BigDecimal[] discounts = new BigDecimal[sortDataMap.size()];
        BigDecimal[] bigDecimalArray = sortDataMap.keySet().iterator();
        while (bigDecimalArray.hasNext()) {
            BigDecimal key;
            discounts[count] = key = bigDecimalArray.next();
            ++count;
        }
        this.fastSortByDiscounts(sortOrder, discounts, 0, count - 1);
        if (seAppSearchReqBO.getComSortList() != null && seAppSearchReqBO.getComSortList().size() > index) {
            for (BigDecimal salePri : discounts) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(salePri);
                if (tempList.size() > 1) {
                    tempList = this.commoditySort(tempList, seAppSearchReqBO, index);
                }
                commodityList.addAll(tempList);
            }
        } else {
            for (BigDecimal salePri : discounts) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(salePri);
                commodityList.addAll(tempList);
            }
        }
        return commodityList;
    }

    private void fastSortByDiscounts(String sortOrder, BigDecimal[] discounts, int left, int right) {
        if (left > right) {
            return;
        }
        int leftI = left;
        int rightJ = right;
        BigDecimal benchmark = discounts[leftI];
        while (leftI < rightJ) {
            if ("DISCOUNTS_ASC".equals(sortOrder)) {
                while ((benchmark.compareTo(discounts[rightJ]) > 0 || benchmark.compareTo(discounts[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(discounts[leftI]) < 0 || benchmark.compareTo(discounts[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if ("DISCOUNTS_DESC".equals(sortOrder)) {
                while ((benchmark.compareTo(discounts[rightJ]) < 0 || benchmark.compareTo(discounts[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(discounts[leftI]) > 0 || benchmark.compareTo(discounts[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if (leftI >= rightJ) continue;
            BigDecimal temp = discounts[rightJ];
            discounts[rightJ] = discounts[leftI];
            discounts[leftI] = temp;
        }
        discounts[left] = discounts[leftI];
        discounts[leftI] = benchmark;
        this.fastSortByDiscounts(sortOrder, discounts, left, leftI - 1);
        this.fastSortByDiscounts(sortOrder, discounts, leftI + 1, right);
    }

    private String comSortTransformation(SeComSortBO seComSortBO) {
        if ("sold_number".equals(seComSortBO.getOrderByColumn())) {
            if (seComSortBO.getOrderType() == 0) {
                return "SOLD_NUMBER_DESC";
            }
            if (seComSortBO.getOrderType() == 1) {
                return "SOLD_NUMBER_ASC";
            }
        }
        if ("on_shelve_time".equals(seComSortBO.getOrderByColumn())) {
            if (seComSortBO.getOrderType() == 0) {
                return "ON_SHELVE_TIME_DESC";
            }
            if (seComSortBO.getOrderType() == 1) {
                return "ON_SHELVE_TIME_ASC";
            }
        }
        if ("sale_price".equals(seComSortBO.getOrderByColumn())) {
            if (seComSortBO.getOrderType() == 0) {
                return "SALE_PRICE_DESC";
            }
            if (seComSortBO.getOrderType() == 1) {
                return "SALE_PRICE_ASC";
            }
        }
        if ("discounts".equals(seComSortBO.getOrderByColumn())) {
            if (seComSortBO.getOrderType() == 0) {
                return "DISCOUNTS_DESC";
            }
            if (seComSortBO.getOrderType() == 1) {
                return "DISCOUNTS_ASC";
            }
        }
        return null;
    }
}

