/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.app.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.se.app.ability.SeParticipleService;
import com.tydic.se.base.ability.bo.RspUccPageBo;
import com.tydic.se.behavior.ability.SeInitDicService;
import com.tydic.se.behavior.ability.bo.ComUocFileAppBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppReqBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppRspBO;
import com.tydic.se.behavior.ability.bo.SeInitDicBO;
import com.tydic.se.behavior.ability.bo.SeInitDicListRspBO;
import com.tydic.se.behavior.ability.bo.SeInitDicReqBO;
import com.tydic.se.behavior.ability.bo.SeInitDicRspBO;
import com.tydic.se.behavior.dao.SeInitDicMapper;
import com.tydic.se.behavior.po.SeInitDicPO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"search-engine-group/1.0.0/com.tydic.se.app.ability.SeParticipleService"})
public class SeParticipleServiceImpl
implements SeParticipleService {
    private static final Logger log = LoggerFactory.getLogger(SeParticipleServiceImpl.class);
    @Autowired
    private SeInitDicService seInitDicService;
    @Autowired
    private SeInitDicMapper seInitDicMapper;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "search-engine";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="nbd,ncg,ncor,nmd,nsz,nvd,ncl")
    private String dictionaryTypeAbbreviation;
    @Value(value="brand,catalog,color,model,specs,vendor,name")
    private String dictionaryType;

    @PostMapping(value={"dicExport"})
    public ComUocFileUploadAppRspBO dicExport(@RequestBody SeInitDicReqBO seInitDicReqBO) {
        List<String> dictionaryTypeAbbreviationList = Arrays.asList(this.dictionaryTypeAbbreviation.split(","));
        List<String> dictionaryTypeList = Arrays.asList(this.dictionaryType.split(","));
        List<SeInitDicPO> seInitDicPOS = this.selectSeInitDicListPage(seInitDicReqBO);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> dictionaryTypeMap = new HashMap<String, String>();
        Set collect = seInitDicPOS.stream().map(SeInitDicPO::getType).collect(Collectors.toSet());
        if (seInitDicPOS.size() > 0 && collect.size() > 0) {
            for (String s : collect) {
                StringBuffer stringBuffer = new StringBuffer();
                for (SeInitDicPO seInitDicBO : seInitDicPOS) {
                    if (!s.equals(seInitDicBO.getType())) continue;
                    stringBuffer.append(seInitDicBO.getDic()).append("\n");
                }
                map.put(s, stringBuffer.toString());
            }
        }
        for (int i = 0; i < dictionaryTypeAbbreviationList.size(); ++i) {
            if (!map.containsKey(dictionaryTypeAbbreviationList.get(i))) continue;
            dictionaryTypeMap.put(dictionaryTypeList.get(i), (String)map.get(dictionaryTypeAbbreviationList.get(i)));
        }
        ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
        if (seInitDicReqBO.getExportType() != null) {
            for (int i = 0; i < dictionaryTypeAbbreviationList.size(); ++i) {
                for (String s : seInitDicReqBO.getExportType()) {
                    if (!s.equals(dictionaryTypeAbbreviationList.get(i))) continue;
                    ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
                    comUocFileAppBO.setFileName(dictionaryTypeList.get(i) + ".dic");
                    comUocFileAppBO.setFileType(".txt");
                    comUocFileAppBO.setFile(((String)dictionaryTypeMap.get(dictionaryTypeList.get(i))).getBytes(StandardCharsets.UTF_8));
                    list.add(comUocFileAppBO);
                }
            }
        } else {
            for (String s : dictionaryTypeMap.keySet()) {
                ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
                comUocFileAppBO.setFileName(s + ".dic");
                comUocFileAppBO.setFileType(".txt");
                comUocFileAppBO.setFile(((String)dictionaryTypeMap.get(s)).toString().getBytes(StandardCharsets.UTF_8));
                list.add(comUocFileAppBO);
            }
        }
        ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
        reqBO.setFiles(list);
        return this.upload(reqBO);
    }

    @PostMapping(value={"querySeInitDicSingle"})
    public SeInitDicRspBO querySeInitDicSingle(@RequestBody SeInitDicReqBO seInitDicReqBO) {
        return this.seInitDicService.querySeInitDicSingle(seInitDicReqBO);
    }

    @PostMapping(value={"querySeInitDicList"})
    public SeInitDicListRspBO querySeInitDicList(@RequestBody SeInitDicReqBO seInitDicReqBO) {
        return this.seInitDicService.querySeInitDicList(seInitDicReqBO);
    }

    @PostMapping(value={"querySeInitDicListPage"})
    public RspUccPageBo<SeInitDicBO> querySeInitDicListPage(@RequestBody SeInitDicReqBO seInitDicReqBO) {
        return this.seInitDicService.querySeInitDicListPage(seInitDicReqBO);
    }

    @PostMapping(value={"addSeInitDic"})
    public SeInitDicRspBO addSeInitDic(@RequestBody SeInitDicReqBO seInitDicReqBO) {
        return this.seInitDicService.addSeInitDic(seInitDicReqBO);
    }

    @PostMapping(value={"updateSeInitDic"})
    public SeInitDicRspBO updateSeInitDic(@RequestBody SeInitDicReqBO seInitDicReqBO) {
        return this.seInitDicService.updateSeInitDic(seInitDicReqBO);
    }

    @PostMapping(value={"saveSeInitDic"})
    public SeInitDicRspBO saveSeInitDic(@RequestBody SeInitDicReqBO seInitDicReqBO) {
        return this.seInitDicService.saveSeInitDic(seInitDicReqBO);
    }

    @PostMapping(value={"deleteSeInitDic"})
    public SeInitDicRspBO deleteSeInitDic(@RequestBody SeInitDicReqBO seInitDicReqBO) {
        return this.seInitDicService.deleteSeInitDic(seInitDicReqBO);
    }

    private ComUocFileUploadAppRspBO upload(ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = file.getFileName();
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            map.put("innerUrl", innerFileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private List<SeInitDicPO> selectSeInitDicListPage(SeInitDicReqBO seInitDicReqBO) {
        Integer pageNo = 1;
        Integer pageSize = 10000;
        ArrayList<SeInitDicPO> seInitDicPOList = new ArrayList<SeInitDicPO>();
        while (true) {
            List seInitDicPOS = this.seInitDicMapper.selectSeInitDicList(seInitDicReqBO.getExportType(), Integer.valueOf((pageNo - 1) * pageSize), pageSize);
            seInitDicPOList.addAll(seInitDicPOS);
            if (seInitDicPOS == null || seInitDicPOS != null && seInitDicPOS.size() < pageSize) break;
            Integer n = pageNo;
            Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
        }
        return seInitDicPOList;
    }
}

