/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.app.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.se.app.ability.SeSynonymAndCorrectionService;
import com.tydic.se.base.ability.bo.RspUccBo;
import com.tydic.se.base.ability.bo.RspUccPageBo;
import com.tydic.se.behavior.ability.SeSynonymService;
import com.tydic.se.behavior.ability.bo.ComUocFileAppBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppReqBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionListRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionReqBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionRspBO;
import com.tydic.se.behavior.thesaurus.SeCorrectionService;
import com.tydic.se.behavior.thesaurus.bo.SeRemoteSynonymReqBo;
import com.tydic.se.behavior.thesaurus.bo.SeRemoteSynonymRspBo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"search-engine-group/1.0.0/com.tydic.se.app.ability.SeSynonymAndCorrectionService"})
public class SeSynonymAndCorrectionServiceImpl
implements SeSynonymAndCorrectionService {
    private static final Logger log = LoggerFactory.getLogger(SeSynonymAndCorrectionServiceImpl.class);
    @Autowired
    private SeSynonymService seSynonymService;
    @Autowired
    private SeCorrectionService seCorrectionService;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "search-engine";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"synchro"})
    public ComUocFileUploadAppRspBO synchro(@RequestBody SeCorrectionReqBO seCorrectionReqBO) {
        StringBuffer stringBuffer = new StringBuffer();
        SeCorrectionListRspBO seCorrectionListRspBO = this.seCorrectionService.querySeCorrectionList(seCorrectionReqBO);
        List data1 = seCorrectionListRspBO.getData();
        List collect1 = data1.stream().map(SeCorrectionBO::getSynonymList).collect(Collectors.toList());
        List collect2 = data1.stream().map(SeCorrectionBO::getCorrectionList).collect(Collectors.toList());
        for (String synony : collect1) {
            synony = this.parse(synony);
            stringBuffer.append(synony).append("\r\n");
        }
        for (int i = 0; i < collect2.size() && !StringUtils.isEmpty((CharSequence)((CharSequence)collect2.get(i))); ++i) {
            String synony;
            synony = this.parse((String)collect1.get(i));
            String correction = this.parse((String)collect2.get(i));
            stringBuffer.append(synony).append(" => ").append(correction).append("\r\n");
        }
        ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
        ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
        comUocFileAppBO.setFileName("synonyms.txt");
        comUocFileAppBO.setFileType(".txt");
        comUocFileAppBO.setFile(stringBuffer.toString().getBytes(StandardCharsets.UTF_8));
        list.add(comUocFileAppBO);
        ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
        reqBO.setFiles(list);
        return this.upload(reqBO);
    }

    @PostMapping(value={"querySeCorrectionSingle"})
    public SeCorrectionRspBO querySeCorrectionSingle(@RequestBody SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.querySeCorrectionSingle(seCorrectionReqBO);
    }

    @PostMapping(value={"querySeCorrectionList"})
    public SeCorrectionListRspBO querySeCorrectionList(@RequestBody SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.querySeCorrectionList(seCorrectionReqBO);
    }

    @PostMapping(value={"querySeCorrectionListPage"})
    public RspUccPageBo<SeCorrectionBO> querySeCorrectionListPage(@RequestBody SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.querySeCorrectionListPage(seCorrectionReqBO);
    }

    @PostMapping(value={"addSeCorrection"})
    public SeCorrectionRspBO addSeCorrection(@RequestBody SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.addSeCorrection(seCorrectionReqBO);
    }

    @PostMapping(value={"updateSeCorrection"})
    public SeCorrectionRspBO updateSeCorrection(@RequestBody SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.updateSeCorrection(seCorrectionReqBO);
    }

    @PostMapping(value={"saveSeCorrection"})
    public SeCorrectionRspBO saveSeCorrection(@RequestBody SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.saveSeCorrection(seCorrectionReqBO);
    }

    @PostMapping(value={"deleteSeCorrection"})
    public SeCorrectionRspBO deleteSeCorrection(@RequestBody SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.deleteSeCorrection(seCorrectionReqBO);
    }

    @PostMapping(value={"synonymFile"})
    public SeRemoteSynonymRspBo synonymFile() {
        return this.seCorrectionService.synonymFile();
    }

    @PostMapping(value={"rewriteFile"})
    public RspUccBo rewriteFile(@RequestBody SeRemoteSynonymReqBo seRemoteSynonymReqBo) {
        return this.seCorrectionService.rewriteFile(seRemoteSynonymReqBo);
    }

    private ComUocFileUploadAppRspBO upload(ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = file.getFileName();
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            map.put("innerUrl", innerFileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private String parse(String str) {
        str = str.replaceAll(" ", "");
        str = str.replaceAll(",", " , ");
        str = str.replaceAll("\uff0c", " , ");
        return str;
    }
}

