/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.app.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.se.app.ability.SeSynonymAndCorrectionService;
import com.tydic.se.base.ability.bo.RspUccBo;
import com.tydic.se.base.ability.bo.RspUccPageBo;
import com.tydic.se.behavior.ability.SeSynonymService;
import com.tydic.se.behavior.ability.bo.ComUocFileAppBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppReqBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionListRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionReqBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionRspBO;
import com.tydic.se.behavior.thesaurus.SeCorrectionService;
import com.tydic.se.behavior.thesaurus.bo.RemoteSynonymReqBo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="search-engine-group", serviceInterface=SeSynonymAndCorrectionService.class)
public class SeSynonymAndCorrectionServiceImpl
implements SeSynonymAndCorrectionService {
    private static final Logger log = LoggerFactory.getLogger(SeSynonymAndCorrectionServiceImpl.class);
    @Autowired
    private SeSynonymService seSynonymService;
    @Autowired
    private SeCorrectionService seCorrectionService;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "search-engine";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    public ComUocFileUploadAppRspBO synchro(SeCorrectionReqBO seCorrectionReqBO) {
        StringBuffer stringBuffer = new StringBuffer();
        SeCorrectionListRspBO seCorrectionListRspBO = this.seCorrectionService.querySeCorrectionList(seCorrectionReqBO);
        List data1 = seCorrectionListRspBO.getData();
        List collect1 = data1.stream().map(SeCorrectionBO::getSynonymList).collect(Collectors.toList());
        List collect2 = data1.stream().map(SeCorrectionBO::getCorrectionList).collect(Collectors.toList());
        for (String synony : collect1) {
            synony = this.parse(synony);
            stringBuffer.append(synony).append("\r\n");
        }
        for (int i = 0; i < collect2.size() && !StringUtils.isEmpty((CharSequence)((CharSequence)collect2.get(i))); ++i) {
            String synony;
            synony = this.parse((String)collect1.get(i));
            String correction = this.parse((String)collect2.get(i));
            stringBuffer.append(synony).append(" => ").append(correction).append("\r\n");
        }
        ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
        ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
        comUocFileAppBO.setFileName("synonyms.txt");
        comUocFileAppBO.setFileType(".txt");
        comUocFileAppBO.setFile(stringBuffer.toString().getBytes(StandardCharsets.UTF_8));
        list.add(comUocFileAppBO);
        ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
        reqBO.setFiles(list);
        return this.upload(reqBO);
    }

    public SeCorrectionRspBO querySeCorrectionSingle(SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.querySeCorrectionSingle(seCorrectionReqBO);
    }

    public SeCorrectionListRspBO querySeCorrectionList(SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.querySeCorrectionList(seCorrectionReqBO);
    }

    public RspUccPageBo<SeCorrectionBO> querySeCorrectionListPage(SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.querySeCorrectionListPage(seCorrectionReqBO);
    }

    public SeCorrectionRspBO addSeCorrection(SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.addSeCorrection(seCorrectionReqBO);
    }

    public SeCorrectionRspBO updateSeCorrection(SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.updateSeCorrection(seCorrectionReqBO);
    }

    public SeCorrectionRspBO saveSeCorrection(SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.saveSeCorrection(seCorrectionReqBO);
    }

    public SeCorrectionRspBO deleteSeCorrection(SeCorrectionReqBO seCorrectionReqBO) {
        return this.seCorrectionService.deleteSeCorrection(seCorrectionReqBO);
    }

    public void synonymFile(RemoteSynonymReqBo remoteSynonymReqBo) {
        this.seCorrectionService.synonymFile(remoteSynonymReqBo);
    }

    public RspUccBo rewriteFile(RemoteSynonymReqBo remoteSynonymReqBo) {
        return this.seCorrectionService.rewriteFile(remoteSynonymReqBo);
    }

    private ComUocFileUploadAppRspBO upload(ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = file.getFileName();
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            map.put("innerUrl", innerFileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private String parse(String str) {
        str = str.replaceAll(" ", "");
        str = str.replaceAll(",", " , ");
        str = str.replaceAll("\uff0c", " , ");
        return str;
    }
}

