/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.app.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.app.ability.SeAppNormQueryService;
import com.tydic.se.app.ability.bo.SeAppSearchReqBO;
import com.tydic.se.app.ability.bo.SeAppSearchRspBO;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.base.util.DeflaterUtils;
import com.tydic.se.search.ability.SeQueryService;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.sort.SearchCommodityRedisDataService;
import com.tydic.se.search.sort.SearchCommoditySortService;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.util.SearchSortUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"search-engine-group/3.0.0/com.tydic.se.app.ability.SeAppNormQueryService"})
public class SeAppNormQueryServiceImpl
implements SeAppNormQueryService {
    private static final Logger log = LoggerFactory.getLogger(SeAppNormQueryServiceImpl.class);
    @Value(value="${es.config.search.size:500}")
    private Integer ES_SEARCH_SIZE;
    @Value(value="${es.config.search.expire:30}")
    private Integer ES_SEARCH_EXPIRE;
    @Value(value="${es.config.search.openL3c:true}")
    private Boolean emptyQueryStrOpenL3c;
    @Autowired
    private SeQueryService seQueryService;
    @Autowired
    private SearchCommoditySortService searchCommoditySortService;
    @Autowired
    private SearchCommodityRedisDataService searchCommodityRedisDataService;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${norm.es.index_name:normspu}")
    private String INDEX_NAME;
    @Value(value="$norm.es.analyzer:ik_smart}")
    private String analyzer;
    @Value(value="${norm.es.fields:v_commodity_name^10.0,category_name^10.0,prop_arry^5.0}")
    private String FIELDS_STR;
    @Value(value="${norm.es.accurate.fields:category_id,v_commodity_id}")
    private String LONG_ACCURATE_FIELDS_STR;
    @Value(value="${norm.es.accurate.text.fields:v_commodity_name.keyword,category_name.keyword,prop_arry.keyword}")
    private String ACCURATE_FIELDS_STR;
    @Value(value="${norm.smart.weight.enable:true}")
    private Boolean smartWeightEnable;
    @Value(value="${norm.smart.weight.threshold:0.5}")
    private BigDecimal smartWeightThreshold;
    @Autowired
    private SeEntityCache seEntityCache;

    private void normSettings(ExecuteSearchReqBO executeSearchReqBO) {
        executeSearchReqBO.setIndexName(this.INDEX_NAME);
        executeSearchReqBO.setFieldsStr(this.FIELDS_STR);
        executeSearchReqBO.setAccurateFieldsStr(this.ACCURATE_FIELDS_STR);
        executeSearchReqBO.setLongAccurateFieldsStr(this.LONG_ACCURATE_FIELDS_STR);
    }

    @PostMapping(value={"search"})
    public SeAppSearchRspBO search(@RequestBody SeAppSearchReqBO seAppSearchReqBO) {
        SeAppSearchRspBO rspBO = new SeAppSearchRspBO();
        Long seChannelType = 1L;
        seChannelType = seAppSearchReqBO.getSeChannelType() != null ? seAppSearchReqBO.getSeChannelType() : (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        int pageNo = seAppSearchReqBO.getPageNo();
        int pageSize = seAppSearchReqBO.getPageSize();
        seAppSearchReqBO.setPageNo(-1);
        seAppSearchReqBO.setPageSize(-1);
        String str = JSON.toJSONString((Object)seAppSearchReqBO);
        Object cacheObject = null;
        String cacheKey = "ES_NORM_SE_SEARCH_" + DeflaterUtils.zipString((String)str);
        if (this.ES_SEARCH_EXPIRE > 0) {
            cacheObject = this.cacheClient.get(cacheKey);
        } else {
            this.cacheClient.delete(cacheKey);
        }
        seAppSearchReqBO.setPageNo(pageNo);
        seAppSearchReqBO.setPageSize(pageSize);
        if (cacheObject != null) {
            log.info("Norm\u641c\u7d22\u67e5\u8be2\u5165\u53c2\u5728\u6709\u6548\u671f\u5185\uff0c\u8fdb\u884c\u7f13\u5b58\u83b7\u53d6\u7ed3\u679c\uff0c\u5165\u53c2={}", (Object)seAppSearchReqBO);
            SeSearchReqBO seSearchReqBO = (SeSearchReqBO)JSON.parseObject((String)JSON.toJSONString((Object)seAppSearchReqBO), SeSearchReqBO.class);
            SeSearchRspBO searchRspBO = (SeSearchRspBO)JSON.parseObject((String)((String)cacheObject), SeSearchRspBO.class);
            try {
                searchRspBO = this.searchCommodityRedisDataService.dataEncapsulation(searchRspBO, seSearchReqBO);
            }
            catch (SearchSortException e) {
                log.error("{}{}{}", new Object[]{"9999", "\u6570\u636e\u5c01\u88c5\uff01", e});
                throw new SearchSortException("9999", "\u6570\u636e\u5c01\u88c5\uff01", (Throwable)e);
            }
            rspBO = (SeAppSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)searchRspBO), SeAppSearchRspBO.class);
            rspBO.setMessage("\u6210\u529f");
            rspBO.setCode("0");
            return rspBO;
        }
        if (seAppSearchReqBO.getPageNo() < 1) {
            seAppSearchReqBO.setPageNo(1);
        }
        if (seAppSearchReqBO.getPageSize() < 1) {
            seAppSearchReqBO.setPageSize(10);
        }
        ExecuteSearchReqBO executeSearchReqBO = new ExecuteSearchReqBO();
        executeSearchReqBO.setFrom(Integer.valueOf(0));
        executeSearchReqBO.setSize(this.ES_SEARCH_SIZE);
        executeSearchReqBO.setQueryStr(seAppSearchReqBO.getQueryStr());
        executeSearchReqBO.setShouldList(seAppSearchReqBO.getShouldList());
        executeSearchReqBO.setComSortList(seAppSearchReqBO.getComSortList());
        List<SeTermsBO> mustTermsList = this.addMustTermsList(seAppSearchReqBO, seChannelType);
        executeSearchReqBO.setMustTermsList(mustTermsList);
        executeSearchReqBO.setMustNotTermsList(seAppSearchReqBO.getMustNotTermsList());
        String properties = SearchSortUtils.parseProperties((Object)seAppSearchReqBO, SeAppSearchReqBO.class);
        executeSearchReqBO.setProperties(properties);
        executeSearchReqBO.setCheckBlankQueryStr(seAppSearchReqBO.getCheckBlankQueryStr());
        this.paresCopy(seAppSearchReqBO, executeSearchReqBO);
        this.normSettings(executeSearchReqBO);
        ExecuteSearchRspBO executeSearchRspBO = this.seQueryService.search(executeSearchReqBO);
        SeEsResultBO esResultBO = executeSearchRspBO.getEsResultBO();
        esResultBO = SearchSortUtils.propertyFilter((SeEsResultBO)esResultBO, (String)properties);
        rspBO.setSearchType(executeSearchRspBO.getSearchType());
        int recordsTotal = esResultBO.getHits().getHits().size();
        int maxPageNum = recordsTotal / seAppSearchReqBO.getPageSize() + 1;
        if (seAppSearchReqBO.getPageNo() > maxPageNum) {
            rspBO.setPageNo(maxPageNum);
        } else {
            rspBO.setPageNo(seAppSearchReqBO.getPageNo());
        }
        List<SeQuerySkuBO> skuList = this.parsePageList(esResultBO, rspBO.getPageNo(), seAppSearchReqBO.getPageSize(), seAppSearchReqBO);
        rspBO.setSkuList(skuList);
        try {
            SeSearchReqBO seSearchReqBO = (SeSearchReqBO)JSON.parseObject((String)JSON.toJSONString((Object)seAppSearchReqBO), SeSearchReqBO.class);
            SeSearchRspBO seSearchRspBO = (SeSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)rspBO), SeSearchRspBO.class);
            SeSearchRspBO searchRspBO = null;
            seSearchReqBO.setSearchType(executeSearchRspBO.getSearchType());
            if (Boolean.TRUE.equals(this.emptyQueryStrOpenL3c)) {
                List filterL3 = executeSearchReqBO.getMustTermsList().stream().filter(seTermsBO -> seTermsBO.getName().equals("l3_category_id")).collect(Collectors.toList());
                if (StringUtils.isBlank((CharSequence)executeSearchReqBO.getQueryStr()) && filterL3.size() > 0) {
                    Map L3cEntityCacheMap = (Map)((Map)SeEntityCache.getEntityCacheMap().get("l3_category_name")).get(seChannelType);
                    for (Map.Entry entry : L3cEntityCacheMap.entrySet()) {
                        List<String> cacheL3cIds = Arrays.asList(((String)entry.getValue()).split(","));
                        if (!cacheL3cIds.contains(((SeTermsBO)filterL3.get(0)).getValueList().get(0))) continue;
                        log.info("Norm\u5f53\u67e5\u8be2\u4e3a\u7a7a\u4e14\u67e5\u8be2\u7b5b\u9009\u5305\u542b\u4e09\u7ea7\u7c7b\u76ee:{}-{},{}", new Object[]{((SeTermsBO)filterL3.get(0)).getValueList().get(0), entry.getKey(), entry.getValue()});
                        seSearchReqBO.setQueryStr((String)entry.getKey());
                        break;
                    }
                } else {
                    log.warn("Norm\u8df3\u8fc7->\u5f53\u67e5\u8be2\u4e3a\u7a7a\u4e14\u67e5\u8be2\u7b5b\u9009\u5305\u542b\u4e09\u7ea7\u7c7b\u76ee\uff1aqueryStr:{}\uff0cfilterL3:{}", (Object)executeSearchReqBO.getQueryStr(), filterL3);
                }
            }
            rspBO.setReCallType(Integer.valueOf(1));
            String time1 = SearchSortUtils.getNowTime();
            log.info("Norm\u67e5\u8be2\u77ed\u8bed{}\uff0c\u6392\u5e8f\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff01", (Object)seAppSearchReqBO.getQueryStr(), (Object)time1);
            searchRspBO = this.searchCommoditySortService.normCommoditySorting(seSearchReqBO, executeSearchReqBO, seSearchRspBO);
            if (this.ES_SEARCH_EXPIRE > 0) {
                this.cacheClient.set(cacheKey, (Object)JSON.toJSONString((Object)searchRspBO), this.ES_SEARCH_EXPIRE.intValue());
            }
            try {
                List list = searchRspBO.getSkuList();
                if (Boolean.TRUE.equals(this.smartWeightEnable) && !CollectionUtils.isEmpty((Collection)list) && StringUtils.isNotBlank((CharSequence)seAppSearchReqBO.getQueryStr())) {
                    int index;
                    log.info("=============\u6807\u51c6\u5546\u54c1\u76f8\u4f3c\u6743\u91cd\u8fc7\u6ee4\u5f00\u59cb=======");
                    for (index = 0; index < list.size(); ++index) {
                        if (!ObjectUtils.isEmpty((Object)((SeQuerySkuBO)list.get(index)).getWeight())) {
                            BigDecimal smartWeight = BigDecimal.valueOf(((SeQuerySkuBO)list.get(index)).getWeight());
                            if (((SeQuerySkuBO)list.get(index)).getVCommodityName().equals(seSearchReqBO.getQueryStr())) {
                                smartWeight = smartWeight.add(new BigDecimal("1.15"));
                            }
                            if (smartWeight.compareTo(BigDecimal.valueOf(2L)) > -1) {
                                ((SeQuerySkuBO)list.get(index)).setSmartWeight(BigDecimal.valueOf(0.999));
                            } else if (smartWeight.compareTo(BigDecimal.valueOf(1L)) > -1) {
                                ((SeQuerySkuBO)list.get(index)).setSmartWeight(BigDecimal.valueOf(0.9).add(BigDecimal.valueOf((smartWeight.doubleValue() - 1.0) / 10.0)));
                            } else {
                                ((SeQuerySkuBO)list.get(index)).setSmartWeight(smartWeight.multiply(BigDecimal.valueOf(0.9)));
                            }
                        }
                        if (((SeQuerySkuBO)list.get(index)).getSmartWeight().compareTo(this.smartWeightThreshold) < 0) break;
                    }
                    list = list.subList(0, index);
                    log.info("=============\u6807\u51c6\u5546\u54c1\u76f8\u4f3c\u6743\u91cd\u8fc7\u6ee4\u7ed3\u675f,\u6761\u6570:{}=======", (Object)list.size());
                }
                searchRspBO.setSkuList(list);
                searchRspBO = this.searchCommodityRedisDataService.dataEncapsulation(searchRspBO, seSearchReqBO);
            }
            catch (SearchSortException e) {
                log.error("{}{}{}", new Object[]{"9999", "\u6570\u636e\u5c01\u88c5\uff01", e});
                throw new SearchSortException("9999", "\u6570\u636e\u5c01\u88c5\uff01", (Throwable)e);
            }
            String time2 = SearchSortUtils.getNowTime();
            log.info("Norm\u67e5\u8be2\u77ed\u8bed{}\uff0c\u6392\u5e8f\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff01", (Object)seAppSearchReqBO.getQueryStr(), (Object)time2);
            log.error(SearchSortUtils.timeCalculation((String)("Norm\u67e5\u8be2\u77ed\u8bed" + seAppSearchReqBO.getQueryStr() + "\u5b8c\u6574\u6392\u5e8f"), (String)time1, (String)time2));
            rspBO = (SeAppSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)searchRspBO), SeAppSearchRspBO.class);
        }
        catch (SearchSortException e) {
            throw new SeBusinessException(e.getMsgDesc());
        }
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    private List<SeTermsBO> addMustTermsList(SeAppSearchReqBO seAppSearchReqBO, Long seChanenlType) {
        ArrayList<SeTermsBO> mustTermsList = new ArrayList<SeTermsBO>();
        if (seAppSearchReqBO.getMustTermsList() != null) {
            mustTermsList.addAll(seAppSearchReqBO.getMustTermsList());
        }
        if (seAppSearchReqBO.getQueryFilterList() != null) {
            List valueList;
            SeTermsBO seTermsBO;
            HashMap<String, SeTermsBO> filterTermsMap = new HashMap<String, SeTermsBO>();
            String vendorName = "vendor_name";
            String brandName = "brand_name";
            String l3CategoryName = "l3_category_name";
            for (SeQueryFilterBO seQueryFilterBO : seAppSearchReqBO.getQueryFilterList()) {
                String key = null;
                if (vendorName.equals(seQueryFilterBO.getFilterId())) {
                    key = "vendor";
                } else if (brandName.equals(seQueryFilterBO.getFilterId())) {
                    key = "brand";
                } else if (l3CategoryName.equals(seQueryFilterBO.getFilterId())) {
                    key = "l3_category";
                }
                if (key != null && filterTermsMap.containsKey(key)) {
                    seTermsBO = (SeTermsBO)filterTermsMap.get(key);
                    valueList = seTermsBO.getValueList();
                    valueList.addAll(seQueryFilterBO.getFilterValues());
                    seTermsBO.setValueList(valueList);
                    filterTermsMap.put(key, seTermsBO);
                    continue;
                }
                seTermsBO = new SeTermsBO(key, seQueryFilterBO.getFilterValues());
                filterTermsMap.put(key, seTermsBO);
            }
            ArrayList<SeTermsBO> filterTermsList = new ArrayList<SeTermsBO>();
            for (String key : filterTermsMap.keySet()) {
                seTermsBO = (SeTermsBO)filterTermsMap.get(key);
                valueList = seTermsBO.getValueList();
                ArrayList<String> newValueList = new ArrayList<String>();
                if (valueList != null) {
                    for (String value : valueList) {
                        String cacheStr = this.seEntityCache.getEntityCacheMapPenetrate(key, value, Integer.valueOf(0), seChanenlType);
                        if (!StringUtils.isNotBlank((CharSequence)cacheStr)) continue;
                        String[] cacheStrArr = cacheStr.split(",");
                        List<String> tempValueList = Arrays.asList(cacheStrArr);
                        newValueList.addAll(tempValueList);
                    }
                }
                if (newValueList.isEmpty()) continue;
                String name = (String)((Map)((Map)SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_SEARCH_FIELD_MAPPING")).get(seChanenlType)).get(key);
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    seTermsBO.setName(name);
                } else {
                    seTermsBO.setName(key + "_id");
                }
                seTermsBO.setValueList(newValueList);
                filterTermsList.add(seTermsBO);
            }
            mustTermsList.addAll(filterTermsList);
        }
        return mustTermsList;
    }

    private void paresCopy(SeAppSearchReqBO seAppSearchReqBO, ExecuteSearchReqBO executeSearchReqBO) {
        executeSearchReqBO.setCheckBlankCatalog(seAppSearchReqBO.getCheckBlankCatalog());
        executeSearchReqBO.setSearchType(seAppSearchReqBO.getSearchType());
        executeSearchReqBO.setCheckBlankModel(seAppSearchReqBO.getCheckBlankModel());
        executeSearchReqBO.setCheckBlankCollapse(seAppSearchReqBO.getCheckBlankCollapse());
        executeSearchReqBO.setFieldsStr(seAppSearchReqBO.getFieldsStr());
        executeSearchReqBO.setAccurateFieldsStr(seAppSearchReqBO.getAccurateFieldsStr());
        executeSearchReqBO.setLongAccurateFieldsStr(seAppSearchReqBO.getLongAccurateFieldsStr());
        executeSearchReqBO.setQueryFilterList(seAppSearchReqBO.getQueryFilterList());
        executeSearchReqBO.setQueryPropertyList(seAppSearchReqBO.getQueryPropertyList());
        executeSearchReqBO.setSeRangeFilterList(seAppSearchReqBO.getSeRangeFilterList());
    }

    private List<SeQuerySkuBO> parsePageList(SeEsResultBO esResultBO, int pageNo, int pageSize, SeAppSearchReqBO seAppSearchReqBO) {
        ArrayList<SeQuerySkuBO> skuList = new ArrayList<SeQuerySkuBO>();
        List hitsList = esResultBO.getHits().getHits();
        hitsList.forEach(hits -> skuList.add(hits.get_source()));
        return skuList;
    }
}

