/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.app.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.tydic.dyc.pro.base.bo.esmapping.jneng.UccUpcSkuEsInfoBo;
import com.tydic.se.app.ability.SeAppQueryService;
import com.tydic.se.app.ability.bo.SeAppSearchReqBO;
import com.tydic.se.app.ability.bo.SeAppSearchRspBO;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.ConversionResultBO;
import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.ability.bo.SeChoSortBO;
import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQueryFilterValueBO;
import com.tydic.se.base.ability.bo.SeQueryPropertyBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.base.dao.EsFiledObjConfigMapper;
import com.tydic.se.base.dao.StandSeEntityCacheMapper;
import com.tydic.se.base.dao.po.EsFiledObjConfigPo;
import com.tydic.se.base.dao.po.StandSeEntityCachePo;
import com.tydic.se.base.util.DeflaterUtils;
import com.tydic.se.base.util.MemoryAppenderUtils;
import com.tydic.se.base.util.ParseStringUtil;
import com.tydic.se.behavior.api.SeBehaviorLogAbilityService;
import com.tydic.se.behavior.api.bo.SeSearchInLogBO;
import com.tydic.se.behavior.api.bo.SeSearchInLogRspBO;
import com.tydic.se.behavior.api.bo.SeSearchOutLogBO;
import com.tydic.se.manage.dao.StandSeCommDetailInLogMapper;
import com.tydic.se.manage.dao.po.StandSeCommDetailInLogPo;
import com.tydic.se.nlp.util.AnalysisCommTools;
import com.tydic.se.search.ability.CommodityDealService;
import com.tydic.se.search.ability.SeQueryService;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.SearchCommodityRedisDataService;
import com.tydic.se.search.sort.SearchCommoditySortService;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.utils.SearchStepRelevanceUtil;
import com.tydic.se.search.util.SearchSortUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"search-engine-group/3.0.0/com.tydic.se.app.ability.SeAppQueryService"})
public class SeAppQueryServiceImpl
implements SeAppQueryService {
    private static final Logger log = LoggerFactory.getLogger(SeAppQueryServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;
    @Autowired
    private SeQueryService seQueryService;
    @Autowired
    private SearchCommoditySortService searchCommoditySortService;
    @Autowired
    private SearchCommodityRedisDataService searchCommodityRedisDataService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SeEntityCache seEntityCache;
    @Autowired
    private SeBehaviorLogAbilityService seBehaviorLogAbilityService;
    @Autowired
    private StandSeCommDetailInLogMapper standSeCommDetailInLogMapper;
    @Autowired
    private EsFiledObjConfigMapper esFiledObjConfigMapper;
    @Autowired
    private StandSeEntityCacheMapper standSeEntityCacheMapper;
    @Autowired
    private CommodityDealService commodityDealService;

    @SearchLinkLog(desc="\u5b8c\u6574\u641c\u7d22")
    @PostMapping(value={"search"})
    public SeAppSearchRspBO search(@RequestBody SeAppSearchReqBO seAppSearchReqBO) {
        SeAppSearchRspBO rspBO = new SeAppSearchRspBO();
        int pageNo = seAppSearchReqBO.getPageNo();
        int pageSize = seAppSearchReqBO.getPageSize();
        seAppSearchReqBO.setPageNo(-1);
        seAppSearchReqBO.setPageSize(-1);
        String str = JSON.toJSONString((Object)seAppSearchReqBO);
        Object cacheObject = null;
        Long seChannelType = 1L;
        seChannelType = seAppSearchReqBO.getSeChannelType() != null ? seAppSearchReqBO.getSeChannelType() : (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        String cacheKey = "{SEARCH}_ES_" + DeflaterUtils.zipString((String)str);
        String esConfigSearchExpire = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).esConfigSearchExpire;
        if (Integer.parseInt(esConfigSearchExpire) > 0) {
            cacheObject = this.cacheClient.get(cacheKey);
        } else {
            this.cacheClient.delete(cacheKey);
        }
        seAppSearchReqBO.setPageNo(pageNo);
        seAppSearchReqBO.setPageSize(pageSize);
        if (cacheObject != null) {
            log.info("{}{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>TXT>>>", "\u641c\u7d22\u67e5\u8be2\u5165\u53c2\u5728\u6709\u6548\u671f\u5185\uff0c\u8fdb\u884c\u7f13\u5b58\u83b7\u53d6\u7ed3\u679c"});
            SeSearchReqBO seSearchReqBO = (SeSearchReqBO)JSON.parseObject((String)JSON.toJSONString((Object)seAppSearchReqBO), SeSearchReqBO.class);
            SeSearchRspBO searchRspBO = (SeSearchRspBO)JSON.parseObject((String)((String)cacheObject), SeSearchRspBO.class);
            try {
                searchRspBO = this.searchCommodityRedisDataService.dataEncapsulation(searchRspBO, seSearchReqBO);
            }
            catch (SearchSortException e) {
                log.error("{}{}{}{}", new Object[]{">>>\u6392\u5e8f\u540e\u7f6e", ">>>TXT>>>", "9999\u6570\u636e\u5c01\u88c5\u5f02\u5e38\uff01", e.getMsgDesc(), e});
                throw new SearchSortException("9999", "\u6570\u636e\u5c01\u88c5\uff01", (Throwable)e);
            }
            rspBO = (SeAppSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)searchRspBO), SeAppSearchRspBO.class);
            rspBO.setMessage("\u6210\u529f");
            rspBO.setCode("0");
            return rspBO;
        }
        if (seAppSearchReqBO.getPageNo() < 1) {
            seAppSearchReqBO.setPageNo(1);
        }
        if (seAppSearchReqBO.getPageSize() < 1) {
            seAppSearchReqBO.setPageSize(10);
        }
        ExecuteSearchReqBO executeSearchReqBO = this.searchEncapsulation(seAppSearchReqBO, seChannelType);
        Boolean hotGoodsIsNotNull = Boolean.FALSE;
        JSONObject hotGoodsMap = null;
        if (Boolean.TRUE.equals(seAppSearchReqBO.getSearchHostGoods())) {
            hotGoodsMap = this.hotPurchasedSearch(seAppSearchReqBO);
            SeTermsBO hotGoodsSeTermsBO = null;
            if (!ObjectUtils.isEmpty((Object)hotGoodsMap)) {
                hotGoodsSeTermsBO = (SeTermsBO)hotGoodsMap.getObject("seTermsBo", SeTermsBO.class);
            }
            if (!ObjectUtils.isEmpty(hotGoodsSeTermsBO)) {
                executeSearchReqBO.getMustTermsList().add(hotGoodsSeTermsBO);
                hotGoodsIsNotNull = Boolean.TRUE;
            }
        }
        ExecuteSearchRspBO executeSearchRspBO = this.seQueryService.search(executeSearchReqBO);
        SeEsResultBO esResultBO = executeSearchRspBO.getEsResultBO();
        String properties = SearchSortUtils.parseProperties((Object)seAppSearchReqBO, SeAppSearchReqBO.class);
        executeSearchReqBO.setProperties(properties);
        esResultBO = SearchSortUtils.propertyFilter((SeEsResultBO)esResultBO, (String)properties);
        rspBO.setSearchType(executeSearchRspBO.getSearchType());
        int recordsTotal = esResultBO.getHits().getHits().size();
        int maxPageNum = recordsTotal / seAppSearchReqBO.getPageSize() + 1;
        if (seAppSearchReqBO.getPageNo() > maxPageNum) {
            rspBO.setPageNo(maxPageNum);
        } else {
            rspBO.setPageNo(seAppSearchReqBO.getPageNo());
        }
        List<SeQuerySkuBO> skuList = this.parsePageList(esResultBO, rspBO.getPageNo(), seAppSearchReqBO.getPageSize(), seAppSearchReqBO);
        rspBO.setSkuList(skuList);
        try {
            String isOpenStandardSort;
            SeSearchReqBO seSearchReqBO = (SeSearchReqBO)JSON.parseObject((String)JSON.toJSONString((Object)seAppSearchReqBO), SeSearchReqBO.class);
            SeSearchRspBO seSearchRspBO = (SeSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)rspBO), SeSearchRspBO.class);
            Object searchRspBO = null;
            seSearchReqBO.setSearchType(executeSearchRspBO.getSearchType());
            seSearchReqBO.setSeChannelType(seChannelType);
            String emptyQueryStrOpenL3c = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).esConfigSearchOpenL3C;
            if (Objects.equals(emptyQueryStrOpenL3c, "1")) {
                List filterL3 = executeSearchReqBO.getMustTermsList().stream().filter(seTermsBO -> seTermsBO.getName().equals("l3_category_id")).collect(Collectors.toList());
                if (StringUtils.isBlank((CharSequence)executeSearchReqBO.getQueryStr()) && filterL3.size() > 0) {
                    Map L3cEntityCacheMap = (Map)((Map)SeEntityCache.getEntityCacheMap().get("l3_category_name")).get(seChannelType);
                    for (Map.Entry entry : L3cEntityCacheMap.entrySet()) {
                        List<String> cacheL3cIds = Arrays.asList(((String)entry.getValue()).split(","));
                        if (!cacheL3cIds.contains(((SeTermsBO)filterL3.get(0)).getValueList().get(0))) continue;
                        log.info("{}{}\u5f53\u67e5\u8be2\u4e3a\u7a7a\u4e14\u67e5\u8be2\u7b5b\u9009\u5305\u542b\u4e09\u7ea7\u7c7b\u76ee{}{}-{}", new Object[]{">>>\u6392\u5e8f\u524d\u7f6e", ">>>TXT>>>", ">>>", ((SeTermsBO)filterL3.get(0)).getValueList().get(0), entry.getKey()});
                        seSearchReqBO.setQueryStr((String)entry.getKey());
                        break;
                    }
                } else {
                    log.warn("{}{}[\u8df3\u8fc7]\u5f53\u67e5\u8be2\u4e3a\u7a7a\u4e14\u67e5\u8be2\u7b5b\u9009\u5305\u542b\u4e09\u7ea7\u7c7b\u76ee{}filterL3:{}", new Object[]{">>>\u6392\u5e8f\u524d\u7f6e", ">>>TXT>>>", ">>>", filterL3});
                }
            }
            this.standardSkuDataClean(executeSearchReqBO, seSearchRspBO);
            rspBO.setReCallType(Integer.valueOf(1));
            searchRspBO = this.searchCommoditySortService.commoditySorting(seSearchReqBO, seSearchRspBO);
            this.selectionSort(seAppSearchReqBO, (SeSearchRspBO)searchRspBO, seChannelType);
            if (executeSearchReqBO.getIsOpenStandardReplace().booleanValue() && searchRspBO != null && !CollectionUtils.isEmpty((Collection)searchRspBO.getSkuList())) {
                try {
                    List replacedSkuList = this.commodityDealService.replaceStandardProducts(searchRspBO.getSkuList(), executeSearchReqBO);
                    searchRspBO.setSkuList(replacedSkuList);
                    ((Map)((Map)SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_STANDARD_OPEN")).get(seChannelType)).put("isStandardOpen", String.valueOf(0));
                }
                catch (Exception e) {
                    log.error("{}{}\u6807\u51c6\u5546\u54c1\u66ff\u6362\u5904\u7406\u5f02\u5e38\uff0c\u7ee7\u7eed\u4f7f\u7528\u539f\u59cb\u5546\u54c1\u5217\u8868\uff1a{}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", e.getMessage()});
                }
            }
            if (Boolean.TRUE.equals(hotGoodsIsNotNull) && !ObjectUtils.isEmpty((Object)hotGoodsMap) && !ObjectUtils.isEmpty((Object)searchRspBO)) {
                try {
                    List standSeCommDetailInLogPoList = hotGoodsMap.getJSONArray("standSeCommDetailInLogPoList").toJavaList(StandSeCommDetailInLogPo.class);
                    LinkedList<SeQuerySkuBO> hotSkuList = new LinkedList<SeQuerySkuBO>();
                    Map<String, SeQuerySkuBO> skuMap = searchRspBO.getSkuList().stream().collect(Collectors.toMap(sku -> String.valueOf(sku.getSkuId()), sku -> sku));
                    for (StandSeCommDetailInLogPo seCommDetailInLogPo : standSeCommDetailInLogPoList) {
                        SeQuerySkuBO oneHotGood = skuMap.get(seCommDetailInLogPo.getSkuId());
                        if (ObjectUtils.isEmpty((Object)oneHotGood)) continue;
                        oneHotGood.setCountNum(Long.valueOf(seCommDetailInLogPo.getCountNum()));
                        hotSkuList.add(oneHotGood);
                    }
                    searchRspBO.setSkuList(hotSkuList);
                }
                catch (Exception e) {
                    log.error("\u70ed\u641c\u5546\u54c1\u83b7\u53d6\u5f02\u5e38", (Throwable)e);
                    throw new SeBusinessException(e.getMessage());
                }
            }
            if (Objects.equals(isOpenStandardSort = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).isOpenStandardSort, "1")) {
                this.standardSort((SeSearchRspBO)searchRspBO, seChannelType);
            }
            if (Integer.parseInt(esConfigSearchExpire) > 0 && !StringUtils.isBlank((CharSequence)seAppSearchReqBO.getQueryStr())) {
                this.cacheClient.set(cacheKey, (Object)JSON.toJSONString((Object)searchRspBO), Integer.parseInt(esConfigSearchExpire));
            }
            try {
                searchRspBO = this.searchCommodityRedisDataService.dataEncapsulation((SeSearchRspBO)searchRspBO, seSearchReqBO);
            }
            catch (SearchSortException e) {
                log.error("{}{}{}", new Object[]{"9999", "\u6570\u636e\u5c01\u88c5\uff01", e});
                throw new SearchSortException("9999", "\u6570\u636e\u5c01\u88c5\uff01", (Throwable)e);
            }
            rspBO = (SeAppSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)searchRspBO), SeAppSearchRspBO.class);
        }
        catch (SearchSortException e) {
            throw new SeBusinessException(e.getMsgDesc());
        }
        catch (NoSuchFieldException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6807\u51c6\u5546\u54c1\u5546\u54c1\u5217\u8868\u6392\u5e8f\u5f02\u5e38\uff01", e});
        }
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        if (Boolean.TRUE.equals(seAppSearchReqBO.getLogTrajectoryOpen())) {
            rspBO.setLogTrajectory(this.dealLogMessages(MemoryAppenderUtils.getLogMessages()));
            MemoryAppenderUtils.clearLogMessages();
            SearchSortMsgBo searchSortMsgBo = this.searchCommodityBaseService.initParameterCategory(executeSearchReqBO);
            List analyerList = searchSortMsgBo.getQueryStrParticiple();
            for (SeQuerySkuBO skuBO : rspBO.getSkuList()) {
                skuBO.setSkuName(this.highReplace(skuBO.getSkuName(), seAppSearchReqBO.getQueryStr(), analyerList));
            }
        }
        try {
            SeSearchInLogBO inLogBO = (SeSearchInLogBO)BeanMapper.map((Object)seAppSearchReqBO, SeSearchInLogBO.class);
            if (ObjectUtils.isEmpty((Object)inLogBO.getOrderByColumn())) {
                inLogBO.setOrderByColumn("");
            }
            SeSearchInLogRspBO seSearchInLogRspBO = this.seBehaviorLogAbilityService.putSearchInLog(inLogBO);
            rspBO.setTraceId(seSearchInLogRspBO.getTraceId().toString());
            rspBO.setSearchId(seSearchInLogRspBO.getSearchId().toString());
            SeSearchOutLogBO outLogBO = (SeSearchOutLogBO)BeanMapper.map((Object)seSearchInLogRspBO, SeSearchOutLogBO.class);
            outLogBO.setCreateTime(new Date());
            outLogBO.setPageNo(String.valueOf(rspBO.getPageNo()));
            outLogBO.setPageSize(String.valueOf(seAppSearchReqBO.getPageSize()));
            outLogBO.setTotal(String.valueOf(rspBO.getTotal()));
            outLogBO.setRecordsTotal(String.valueOf(rspBO.getRecordsTotal()));
            outLogBO.setResult(JSONObject.toJSONString((Object)rspBO));
            this.seBehaviorLogAbilityService.putSearchOutLog(outLogBO);
        }
        catch (Exception e) {
            log.error("\u641c\u7d22\u5f15\u64ce\u57cb\u70b9\u62a5\u9519\uff1a" + e.getMessage());
        }
        return rspBO;
    }

    private String highReplace(String fieldValue, String pName, List<String> analyerList) {
        List replaceStrList;
        if (StringUtils.isNotBlank((CharSequence)fieldValue) && !(replaceStrList = AnalysisCommTools.getReplaceSubStr((String)fieldValue, (String)pName, analyerList)).isEmpty()) {
            for (String replaceStr : replaceStrList) {
                if (replaceStr.length() == 1 && "<span style=\"color:red\"></span>".contains(replaceStr)) continue;
                fieldValue = fieldValue.replace(replaceStr, "<span style=\"color:red\">" + replaceStr + "</span>");
            }
        }
        return fieldValue;
    }

    @PostMapping(value={"recommendSorting"})
    public SeAppSearchRspBO recommendSorting(@RequestBody SeAppSearchReqBO seAppSearchReqBO) {
        SeSearchReqBO seSearchReqBO = (SeSearchReqBO)JSON.parseObject((String)JSON.toJSONString((Object)seAppSearchReqBO), SeSearchReqBO.class);
        SeSearchRspBO searchRspBO = this.searchCommoditySortService.recommendSorting(seSearchReqBO);
        return (SeAppSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)searchRspBO), SeAppSearchRspBO.class);
    }

    @PostMapping(value={"categoryList"})
    public SeAppSearchRspBO categoryList(@RequestBody SeAppSearchReqBO seAppSearchReqBO) {
        int i;
        List collect;
        Long seChannelType = 1L;
        seChannelType = seAppSearchReqBO.getSeChannelType() != null ? seAppSearchReqBO.getSeChannelType() : (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        SeAppSearchRspBO rspBO = new SeAppSearchRspBO();
        String str = JSON.toJSONString((Object)seAppSearchReqBO);
        Object cacheObject = null;
        String cacheKey = "{SEARCH}_ES_CATEGORYLIST_" + DeflaterUtils.zipString((String)str);
        String esConfigSearchExpire = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).esConfigSearchExpire;
        if (Integer.parseInt(esConfigSearchExpire) > 0) {
            cacheObject = this.cacheClient.get(cacheKey);
        } else {
            this.cacheClient.delete(cacheKey);
        }
        if (cacheObject != null) {
            log.info("\u5206\u7c7b\u5c5e\u6027\u5165\u53c2\u5728\u6709\u6548\u671f\u5185\uff0c\u8fdb\u884c\u7f13\u5b58\u83b7\u53d6\u7ed3\u679c\uff0c\u5165\u53c2=" + str);
            rspBO = (SeAppSearchRspBO)JSON.parseObject((String)((String)cacheObject), SeAppSearchRspBO.class);
            return rspBO;
        }
        if (seAppSearchReqBO.getShowSkuProperty() == null) {
            seAppSearchReqBO.setShowSkuProperty(Boolean.valueOf(true));
        }
        ExecuteSearchReqBO executeSearchReqBO = this.searchEncapsulation(seAppSearchReqBO, seChannelType);
        ExecuteSearchRspBO executeSearchRspBO = this.seQueryService.categoryList(executeSearchReqBO);
        List<SeQueryFilterBO> queryFilterList = new ArrayList();
        if (!seAppSearchReqBO.getShowSkuProperty().booleanValue() && executeSearchRspBO.getQueryFilterList().size() > 2) {
            queryFilterList.add((SeQueryFilterBO)executeSearchRspBO.getQueryFilterList().get(0));
            queryFilterList.add((SeQueryFilterBO)executeSearchRspBO.getQueryFilterList().get(1));
            queryFilterList.add((SeQueryFilterBO)executeSearchRspBO.getQueryFilterList().get(2));
        } else {
            queryFilterList = executeSearchRspBO.getQueryFilterList();
        }
        if (executeSearchReqBO.getCheckBlankModel().booleanValue()) {
            SeQueryFilterBO seQueryFilterBO = this.parseModel(executeSearchRspBO);
            queryFilterList.add(seQueryFilterBO);
        }
        if (seAppSearchReqBO.getQueryFilterList() != null) {
            collect = seAppSearchReqBO.getQueryFilterList().stream().map(SeQueryFilterBO::getFilterId).collect(Collectors.toList());
            block0: for (i = 0; i < collect.size(); ++i) {
                for (SeQueryFilterBO seQueryFilterBO : queryFilterList) {
                    if (!((String)collect.get(i)).equals(seQueryFilterBO.getFilterId())) continue;
                    queryFilterList.remove(seQueryFilterBO);
                    continue block0;
                }
            }
        }
        if (seAppSearchReqBO.getMustTermsList() != null) {
            collect = seAppSearchReqBO.getMustTermsList().stream().map(SeTermsBO::getName).collect(Collectors.toList());
            for (i = 0; i < collect.size(); ++i) {
                if (!"supplier_id".equals(collect.get(i))) continue;
                collect.remove(i);
                collect.add("vendor_id");
                break;
            }
            block3: for (i = 0; i < collect.size(); ++i) {
                for (SeQueryFilterBO seQueryFilterBO : queryFilterList) {
                    if (((String)collect.get(i)).equals(seQueryFilterBO.getFilterId())) {
                        queryFilterList.remove(seQueryFilterBO);
                        continue block3;
                    }
                    int collectIndex = ((String)collect.get(i)).indexOf("_");
                    int filterIdIndex = seQueryFilterBO.getFilterId().lastIndexOf("_");
                    if (collectIndex <= 0 || filterIdIndex <= 0 || !((String)collect.get(i)).substring(0, collectIndex).equals(seQueryFilterBO.getFilterId().substring(0, filterIdIndex))) continue;
                    queryFilterList.remove(seQueryFilterBO);
                    continue block3;
                }
            }
        }
        rspBO.setQueryFilterList(queryFilterList);
        rspBO.setQueryPropertyList(executeSearchRspBO.getQueryPropertyList());
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        if (Integer.parseInt(esConfigSearchExpire) > 0) {
            this.cacheClient.set(cacheKey, (Object)JSON.toJSONString((Object)rspBO), Integer.parseInt(esConfigSearchExpire));
        }
        if (Boolean.TRUE.equals(seAppSearchReqBO.getLogTrajectoryOpen())) {
            rspBO.setLogTrajectory(this.dealLogMessages(MemoryAppenderUtils.getLogMessages()));
            MemoryAppenderUtils.clearLogMessages();
        }
        return rspBO;
    }

    private List<JSONObject> dealLogMessages(List<String> logs) {
        ArrayList<JSONObject> logJsonList = new ArrayList<JSONObject>();
        try {
            for (String logString : logs) {
                String[] strings = logString.split("<<<");
                String time = strings[0];
                String logStr = strings[1];
                JSONObject oneLog = new JSONObject();
                if (!logStr.startsWith(">>>")) {
                    oneLog.put("time", (Object)time);
                    oneLog.put("type", (Object)"TXT");
                    oneLog.put("data", (Object)logStr);
                } else {
                    List<String> logSplit = Arrays.asList(logStr.split(">>>"));
                    oneLog.put("time", (Object)time);
                    oneLog.put("type", (Object)logSplit.get(2));
                    if ("JSON".equals(logSplit.get(2))) {
                        oneLog.put("title", (Object)logSplit.get(3));
                        oneLog.put("data", JSON.parse((String)logSplit.get(4)));
                    } else if ("LIST".equals(logSplit.get(2))) {
                        oneLog.put("title", (Object)logSplit.get(3));
                        oneLog.put("data", (Object)JSONArray.parseArray((String)logSplit.get(4)));
                    } else {
                        oneLog.put("title", (Object)logSplit.get(1));
                        oneLog.put("data", (Object)logSplit.get(3));
                    }
                }
                logJsonList.add(oneLog);
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u6570\u636e\u89e3\u6790\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return logJsonList;
    }

    private ExecuteSearchReqBO searchEncapsulation(SeAppSearchReqBO seAppSearchReqBO, Long seChannelType) {
        ExecuteSearchReqBO executeSearchReqBO = new ExecuteSearchReqBO();
        executeSearchReqBO.setFrom(Integer.valueOf(0));
        executeSearchReqBO.setSeChannelType(seChannelType);
        String esConfigSearchSize = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).esConfigSearchSize;
        executeSearchReqBO.setSize(Integer.valueOf(esConfigSearchSize));
        executeSearchReqBO.setQueryStr(seAppSearchReqBO.getQueryStr());
        executeSearchReqBO.setShouldList(seAppSearchReqBO.getShouldList());
        executeSearchReqBO.setComSortList(seAppSearchReqBO.getComSortList());
        executeSearchReqBO.setEsbVendorBoList(seAppSearchReqBO.getEsbVendorBoList());
        executeSearchReqBO.setQueryStr(seAppSearchReqBO.getQueryStr());
        executeSearchReqBO.setCounty(seAppSearchReqBO.getCounty());
        executeSearchReqBO.setCity(seAppSearchReqBO.getCity());
        executeSearchReqBO.setProvince(seAppSearchReqBO.getProvince());
        executeSearchReqBO.setTown(seAppSearchReqBO.getTown());
        executeSearchReqBO.setGetNewStockById(seAppSearchReqBO.getGetNewStockById());
        executeSearchReqBO.setCheckAreaLimit(seAppSearchReqBO.getCheckAreaLimit());
        List<SeTermsBO> mustTermsList = this.addMustTermsList(seAppSearchReqBO, seChannelType);
        executeSearchReqBO.setMustTermsList(mustTermsList);
        executeSearchReqBO.setMustNotTermsList(seAppSearchReqBO.getMustNotTermsList());
        String properties = SearchSortUtils.parseProperties((Object)seAppSearchReqBO, SeAppSearchReqBO.class);
        executeSearchReqBO.setProperties(properties);
        executeSearchReqBO.setCheckBlankQueryStr(seAppSearchReqBO.getCheckBlankQueryStr());
        this.paresCopy(seAppSearchReqBO, executeSearchReqBO);
        executeSearchReqBO.setLogTrajectoryOpen(seAppSearchReqBO.getLogTrajectoryOpen());
        return executeSearchReqBO;
    }

    public JSONObject hotPurchasedSearch(SeAppSearchReqBO seAppSearchReqBO) {
        try {
            ZonedDateTime threeMonthsAgo = ZonedDateTime.now(ZoneId.systemDefault()).minusMonths(3L);
            List standSeCommDetailInLogPoList = this.standSeCommDetailInLogMapper.selectSkuIdHistoryHot(Date.from(threeMonthsAgo.toInstant()), seAppSearchReqBO.getPageSize() * 3);
            if (CollectionUtils.isEmpty((Collection)standSeCommDetailInLogPoList)) {
                return null;
            }
            List skuIdList = standSeCommDetailInLogPoList.stream().map(StandSeCommDetailInLogPo::getSkuId).collect(Collectors.toList());
            SeTermsBO seTermsBo = new SeTermsBO();
            seTermsBo.setIsWildcard(Boolean.FALSE);
            seTermsBo.setNeedMust(Boolean.FALSE);
            seTermsBo.setName("skuId");
            seTermsBo.setValueList(skuIdList);
            JSONObject result = new JSONObject();
            result.put("seTermsBo", (Object)seTermsBo);
            result.put("standSeCommDetailInLogPoList", (Object)standSeCommDetailInLogPoList);
            return result;
        }
        catch (Exception e) {
            log.error("\u70ed\u641c\u5546\u54c1\u5c01\u88c5\u5f02\u5e38\uff01", (Throwable)e);
            throw new SeBusinessException(e.getMessage());
        }
    }

    private void paresCopy(SeAppSearchReqBO seAppSearchReqBO, ExecuteSearchReqBO executeSearchReqBO) {
        executeSearchReqBO.setCheckBlankCatalog(seAppSearchReqBO.getCheckBlankCatalog());
        executeSearchReqBO.setSearchType(seAppSearchReqBO.getSearchType());
        executeSearchReqBO.setCheckBlankModel(seAppSearchReqBO.getCheckBlankModel());
        executeSearchReqBO.setCheckBlankCollapse(seAppSearchReqBO.getCheckBlankCollapse());
        executeSearchReqBO.setFieldsStr(seAppSearchReqBO.getFieldsStr());
        executeSearchReqBO.setAccurateFieldsStr(seAppSearchReqBO.getAccurateFieldsStr());
        executeSearchReqBO.setLongAccurateFieldsStr(seAppSearchReqBO.getLongAccurateFieldsStr());
        executeSearchReqBO.setQueryFilterList(seAppSearchReqBO.getQueryFilterList());
        executeSearchReqBO.setQueryPropertyList(seAppSearchReqBO.getQueryPropertyList());
        executeSearchReqBO.setSeRangeFilterList(seAppSearchReqBO.getSeRangeFilterList());
        executeSearchReqBO.setCloseNeedQuery(seAppSearchReqBO.getCloseNeedQuery());
        executeSearchReqBO.setIsOpenStandardReplace(seAppSearchReqBO.getIsOpenStandardReplace());
    }

    private SeQueryFilterBO parseModel(ExecuteSearchRspBO executeSearchRspBO) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        SeQueryFilterBO seQueryFilterBO = new SeQueryFilterBO();
        seQueryFilterBO.setFilterId("model");
        seQueryFilterBO.setFilterName("\u578b\u53f7");
        for (SeEsResultBO.Hits.InHits hit : executeSearchRspBO.getEsResultBO().getHits().getHits()) {
            if (!StringUtils.isNotBlank((CharSequence)hit.get_source().getModel()) || map.containsKey(hit.get_source().getModel())) continue;
            map.put(hit.get_source().getModel(), 0);
        }
        ArrayList list = new ArrayList(map.keySet());
        seQueryFilterBO.setFilterValues(list);
        ArrayList<SeQueryFilterValueBO> valueBOS = new ArrayList<SeQueryFilterValueBO>();
        for (String s : list) {
            SeQueryFilterValueBO seQueryFilterValueBO = new SeQueryFilterValueBO();
            seQueryFilterValueBO.setName(s);
            valueBOS.add(seQueryFilterValueBO);
        }
        seQueryFilterBO.setFilterMaps(valueBOS);
        return seQueryFilterBO;
    }

    private List<SeQuerySkuBO> parsePageList(SeEsResultBO esResultBO, int pageNo, int pageSize, SeAppSearchReqBO seAppSearchReqBO) {
        ArrayList<SeQuerySkuBO> skuList = new ArrayList<SeQuerySkuBO>();
        List hitsList = esResultBO.getHits().getHits();
        hitsList.forEach(hits -> skuList.add(hits.get_source()));
        return skuList;
    }

    private List<SeTermsBO> parseMustTermsList(SeAppSearchReqBO seAppSearchReqBO) {
        SeTermsBO seTermsBO;
        ArrayList<SeTermsBO> tempMustTermsList = new ArrayList<SeTermsBO>();
        if (seAppSearchReqBO.getQueryFilterList() != null) {
            for (SeQueryFilterBO seQueryFilterBO : seAppSearchReqBO.getQueryFilterList()) {
                seTermsBO = new SeTermsBO(seQueryFilterBO.getFilterId(), seQueryFilterBO.getFilterValues());
                tempMustTermsList.add(seTermsBO);
            }
        }
        if (seAppSearchReqBO.getQueryPropertyList() != null) {
            for (SeQueryPropertyBO seQueryPropertyBO : seAppSearchReqBO.getQueryPropertyList()) {
                seTermsBO = new SeTermsBO(seQueryPropertyBO.getPropertyId(), seQueryPropertyBO.getPropertyValues());
                tempMustTermsList.add(seTermsBO);
            }
        }
        if (seAppSearchReqBO.getMustTermsList() != null) {
            tempMustTermsList.addAll(seAppSearchReqBO.getMustTermsList());
        }
        return tempMustTermsList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SeEsResultBO.Hits.InHits> commoditySort(List<SeEsResultBO.Hits.InHits> seResultData, SeAppSearchReqBO seAppSearchReqBO, int index) {
        String sortOrder = seAppSearchReqBO.getSortMode();
        if (seResultData == null) return seResultData;
        if (seResultData.size() == 0) return seResultData;
        if ("COMPREHENSIVE_SORT".equals(sortOrder)) {
            if (seAppSearchReqBO.getComSortList() == null) return seResultData;
            if (seAppSearchReqBO.getComSortList().isEmpty()) return seResultData;
            if (seAppSearchReqBO.getComSortList().size() <= index) return seResultData;
            sortOrder = this.comSortTransformation((SeComSortBO)seAppSearchReqBO.getComSortList().get(index));
        }
        if ("SOLD_NUMBER_DESC".equals(sortOrder) || "SOLD_NUMBER_ASC".equals(sortOrder)) {
            HashMap<Double, List<SeEsResultBO.Hits.InHits>> sortMap = new HashMap<Double, List<SeEsResultBO.Hits.InHits>>();
            Iterator<SeEsResultBO.Hits.InHits> iterator = seResultData.iterator();
            while (iterator.hasNext()) {
                List<SeEsResultBO.Hits.InHits> value;
                SeEsResultBO.Hits.InHits commodity = iterator.next();
                Double soldNumberL = 0.0;
                if (soldNumberL == null) {
                    soldNumberL = 0.0;
                }
                if (sortMap.containsKey(soldNumberL)) {
                    value = (List)sortMap.get(soldNumberL);
                    value.add(commodity);
                    sortMap.put(soldNumberL, value);
                    continue;
                }
                value = new ArrayList();
                value.add(commodity);
                sortMap.put(soldNumberL, value);
            }
            return this.sortBySoldNumber(sortMap, sortOrder, seAppSearchReqBO, index + 1);
        }
        if ("ON_SHELVE_TIME_DESC".equals(sortOrder) || "ON_SHELVE_TIME_ASC".equals(sortOrder)) {
            HashMap<Long, List<SeEsResultBO.Hits.InHits>> sortMap = new HashMap<Long, List<SeEsResultBO.Hits.InHits>>();
            Iterator<SeEsResultBO.Hits.InHits> commoditySortList = seResultData.iterator();
            while (commoditySortList.hasNext()) {
                List<SeEsResultBO.Hits.InHits> value;
                SeEsResultBO.Hits.InHits commodity = commoditySortList.next();
                Long onShelveTimeL = commodity.get_source().getOnShelveTime();
                if (onShelveTimeL == null) {
                    onShelveTimeL = 0L;
                }
                if (sortMap.containsKey(onShelveTimeL)) {
                    value = (List)sortMap.get(onShelveTimeL);
                    value.add(commodity);
                    sortMap.put(onShelveTimeL, value);
                    continue;
                }
                value = new ArrayList();
                value.add(commodity);
                sortMap.put(onShelveTimeL, value);
            }
            return this.sortByOnShelveTime(sortMap, sortOrder, seAppSearchReqBO, index + 1);
        }
        if ("SALE_PRICE_DESC".equals(sortOrder) || "SALE_PRICE_ASC".equals(sortOrder)) {
            HashMap<BigDecimal, List<SeEsResultBO.Hits.InHits>> sortMap = new HashMap<BigDecimal, List<SeEsResultBO.Hits.InHits>>();
            Iterator<SeEsResultBO.Hits.InHits> commoditySortList = seResultData.iterator();
            while (commoditySortList.hasNext()) {
                List<SeEsResultBO.Hits.InHits> value;
                SeEsResultBO.Hits.InHits commodity = commoditySortList.next();
                BigDecimal salePrice = commodity.get_source().getSalePrice();
                if (salePrice == null) {
                    salePrice = new BigDecimal(0);
                }
                if (sortMap.containsKey(salePrice)) {
                    value = (List)sortMap.get(salePrice);
                    value.add(commodity);
                    sortMap.put(salePrice, value);
                    continue;
                }
                value = new ArrayList();
                value.add(commodity);
                sortMap.put(salePrice, value);
            }
            return this.sortBySalePrice(sortMap, sortOrder, seAppSearchReqBO, index + 1);
        }
        if (!"DISCOUNTS_DESC".equals(sortOrder)) {
            if (!"DISCOUNTS_ASC".equals(sortOrder)) return seResultData;
        }
        HashMap<BigDecimal, List<SeEsResultBO.Hits.InHits>> sortMap = new HashMap<BigDecimal, List<SeEsResultBO.Hits.InHits>>();
        Iterator<SeEsResultBO.Hits.InHits> commoditySortList = seResultData.iterator();
        while (commoditySortList.hasNext()) {
            List<SeEsResultBO.Hits.InHits> value;
            SeEsResultBO.Hits.InHits commodity = commoditySortList.next();
            BigDecimal discounts = commodity.get_source().getDiscounts();
            if (discounts == null) {
                discounts = new BigDecimal(1);
            }
            if (discounts.compareTo(BigDecimal.ZERO) == 0) {
                discounts = BigDecimal.ONE;
            }
            if (sortMap.containsKey(discounts)) {
                value = (List)sortMap.get(discounts);
                value.add(commodity);
                sortMap.put(discounts, value);
                continue;
            }
            value = new ArrayList();
            value.add(commodity);
            sortMap.put(discounts, value);
        }
        return this.sortByDiscounts(sortMap, sortOrder, seAppSearchReqBO, index + 1);
    }

    private List<SeEsResultBO.Hits.InHits> sortByOnShelveTime(Map<Long, List<SeEsResultBO.Hits.InHits>> sortDataMap, String sortOrder, SeAppSearchReqBO seAppSearchReqBO, int index) {
        int count = 0;
        ArrayList<SeEsResultBO.Hits.InHits> commodityList = new ArrayList<SeEsResultBO.Hits.InHits>();
        Long[] dates = new Long[sortDataMap.size()];
        Long[] longArray = sortDataMap.keySet().iterator();
        while (longArray.hasNext()) {
            Long key;
            dates[count] = key = longArray.next();
            ++count;
        }
        this.fastSortByTime(sortOrder, dates, 0, count - 1);
        if (seAppSearchReqBO.getComSortList() != null && seAppSearchReqBO.getComSortList().size() > index) {
            for (Long da : dates) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(da);
                if (tempList.size() > 1) {
                    tempList = this.commoditySort(tempList, seAppSearchReqBO, index);
                }
                commodityList.addAll(tempList);
            }
        } else {
            for (Long da : dates) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(da);
                commodityList.addAll(tempList);
            }
        }
        return commodityList;
    }

    private void fastSortByTime(String sortOrder, Long[] dates, int left, int right) {
        if (left > right) {
            return;
        }
        int leftI = left;
        int rightJ = right;
        Long benchmark = dates[leftI];
        while (leftI < rightJ) {
            if ("ON_SHELVE_TIME_ASC".equals(sortOrder)) {
                while ((benchmark.compareTo(dates[rightJ]) < 0 || benchmark.compareTo(dates[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(dates[leftI]) > 0 || benchmark.compareTo(dates[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if ("ON_SHELVE_TIME_DESC".equals(sortOrder)) {
                while ((benchmark.compareTo(dates[rightJ]) > 0 || benchmark.compareTo(dates[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(dates[leftI]) < 0 || benchmark.compareTo(dates[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if (leftI >= rightJ) continue;
            Long temp = dates[rightJ];
            dates[rightJ] = dates[leftI];
            dates[leftI] = temp;
        }
        dates[left] = dates[leftI];
        dates[leftI] = benchmark;
        this.fastSortByTime(sortOrder, dates, left, leftI - 1);
        this.fastSortByTime(sortOrder, dates, leftI + 1, right);
    }

    private List<SeEsResultBO.Hits.InHits> sortBySoldNumber(Map<Double, List<SeEsResultBO.Hits.InHits>> sortDataMap, String sortOrder, SeAppSearchReqBO seAppSearchReqBO, int index) {
        int count = 0;
        ArrayList<SeEsResultBO.Hits.InHits> commodityList = new ArrayList<SeEsResultBO.Hits.InHits>();
        Double[] soldNumbers = new Double[sortDataMap.size()];
        Double[] doubleArray = sortDataMap.keySet().iterator();
        while (doubleArray.hasNext()) {
            Double key;
            soldNumbers[count] = key = doubleArray.next();
            ++count;
        }
        this.fastSortBySoldNumber(sortOrder, soldNumbers, 0, count - 1);
        if (seAppSearchReqBO.getComSortList() != null && seAppSearchReqBO.getComSortList().size() > index) {
            for (Double sale : soldNumbers) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(sale);
                if (tempList.size() > 1) {
                    tempList = this.commoditySort(tempList, seAppSearchReqBO, index);
                }
                commodityList.addAll(tempList);
            }
        } else {
            for (Double sale : soldNumbers) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(sale);
                commodityList.addAll(tempList);
            }
        }
        return commodityList;
    }

    private void fastSortBySoldNumber(String sortOrder, Double[] soldNumber, int left, int right) {
        if (left > right) {
            return;
        }
        int leftI = left;
        int rightJ = right;
        Double benchmark = soldNumber[leftI];
        while (leftI < rightJ) {
            if ("SOLD_NUMBER_ASC".equals(sortOrder)) {
                while ((benchmark.compareTo(soldNumber[rightJ]) < 0 || benchmark.compareTo(soldNumber[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(soldNumber[leftI]) > 0 || benchmark.compareTo(soldNumber[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if ("SOLD_NUMBER_DESC".equals(sortOrder)) {
                while ((benchmark.compareTo(soldNumber[rightJ]) > 0 || benchmark.compareTo(soldNumber[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(soldNumber[leftI]) < 0 || benchmark.compareTo(soldNumber[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if (leftI >= rightJ) continue;
            Double temp = soldNumber[rightJ];
            soldNumber[rightJ] = soldNumber[leftI];
            soldNumber[leftI] = temp;
        }
        soldNumber[left] = soldNumber[leftI];
        soldNumber[leftI] = benchmark;
        this.fastSortBySoldNumber(sortOrder, soldNumber, left, leftI - 1);
        this.fastSortBySoldNumber(sortOrder, soldNumber, leftI + 1, right);
    }

    private List<SeEsResultBO.Hits.InHits> sortBySalePrice(Map<BigDecimal, List<SeEsResultBO.Hits.InHits>> sortDataMap, String sortOrder, SeAppSearchReqBO seAppSearchReqBO, int index) {
        int count = 0;
        ArrayList<SeEsResultBO.Hits.InHits> commodityList = new ArrayList<SeEsResultBO.Hits.InHits>();
        BigDecimal[] salePrice = new BigDecimal[sortDataMap.size()];
        BigDecimal[] bigDecimalArray = sortDataMap.keySet().iterator();
        while (bigDecimalArray.hasNext()) {
            BigDecimal key;
            salePrice[count] = key = bigDecimalArray.next();
            ++count;
        }
        this.fastSortBySalePrice(sortOrder, salePrice, 0, count - 1);
        if (seAppSearchReqBO.getComSortList() != null && seAppSearchReqBO.getComSortList().size() > index) {
            for (BigDecimal salePri : salePrice) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(salePri);
                if (tempList.size() > 1) {
                    tempList = this.commoditySort(tempList, seAppSearchReqBO, index);
                }
                commodityList.addAll(tempList);
            }
        } else {
            for (BigDecimal salePri : salePrice) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(salePri);
                commodityList.addAll(tempList);
            }
        }
        return commodityList;
    }

    private void fastSortBySalePrice(String sortOrder, BigDecimal[] salePrice, int left, int right) {
        if (left > right) {
            return;
        }
        int leftI = left;
        int rightJ = right;
        BigDecimal benchmark = salePrice[leftI];
        while (leftI < rightJ) {
            if ("SALE_PRICE_ASC".equals(sortOrder)) {
                while ((benchmark.compareTo(salePrice[rightJ]) < 0 || benchmark.compareTo(salePrice[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(salePrice[leftI]) > 0 || benchmark.compareTo(salePrice[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if ("SALE_PRICE_DESC".equals(sortOrder)) {
                while ((benchmark.compareTo(salePrice[rightJ]) > 0 || benchmark.compareTo(salePrice[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(salePrice[leftI]) < 0 || benchmark.compareTo(salePrice[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if (leftI >= rightJ) continue;
            BigDecimal temp = salePrice[rightJ];
            salePrice[rightJ] = salePrice[leftI];
            salePrice[leftI] = temp;
        }
        salePrice[left] = salePrice[leftI];
        salePrice[leftI] = benchmark;
        this.fastSortBySalePrice(sortOrder, salePrice, left, leftI - 1);
        this.fastSortBySalePrice(sortOrder, salePrice, leftI + 1, right);
    }

    private List<SeEsResultBO.Hits.InHits> sortByDiscounts(Map<BigDecimal, List<SeEsResultBO.Hits.InHits>> sortDataMap, String sortOrder, SeAppSearchReqBO seAppSearchReqBO, int index) {
        int count = 0;
        ArrayList<SeEsResultBO.Hits.InHits> commodityList = new ArrayList<SeEsResultBO.Hits.InHits>();
        BigDecimal[] discounts = new BigDecimal[sortDataMap.size()];
        BigDecimal[] bigDecimalArray = sortDataMap.keySet().iterator();
        while (bigDecimalArray.hasNext()) {
            BigDecimal key;
            discounts[count] = key = bigDecimalArray.next();
            ++count;
        }
        this.fastSortByDiscounts(sortOrder, discounts, 0, count - 1);
        if (seAppSearchReqBO.getComSortList() != null && seAppSearchReqBO.getComSortList().size() > index) {
            for (BigDecimal salePri : discounts) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(salePri);
                if (tempList.size() > 1) {
                    tempList = this.commoditySort(tempList, seAppSearchReqBO, index);
                }
                commodityList.addAll(tempList);
            }
        } else {
            for (BigDecimal salePri : discounts) {
                List<SeEsResultBO.Hits.InHits> tempList = sortDataMap.get(salePri);
                commodityList.addAll(tempList);
            }
        }
        return commodityList;
    }

    private void fastSortByDiscounts(String sortOrder, BigDecimal[] discounts, int left, int right) {
        if (left > right) {
            return;
        }
        int leftI = left;
        int rightJ = right;
        BigDecimal benchmark = discounts[leftI];
        while (leftI < rightJ) {
            if ("DISCOUNTS_ASC".equals(sortOrder)) {
                while ((benchmark.compareTo(discounts[rightJ]) > 0 || benchmark.compareTo(discounts[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(discounts[leftI]) < 0 || benchmark.compareTo(discounts[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if ("DISCOUNTS_DESC".equals(sortOrder)) {
                while ((benchmark.compareTo(discounts[rightJ]) < 0 || benchmark.compareTo(discounts[rightJ]) == 0) && leftI < rightJ) {
                    --rightJ;
                }
                while ((benchmark.compareTo(discounts[leftI]) > 0 || benchmark.compareTo(discounts[leftI]) == 0) && leftI < rightJ) {
                    ++leftI;
                }
            }
            if (leftI >= rightJ) continue;
            BigDecimal temp = discounts[rightJ];
            discounts[rightJ] = discounts[leftI];
            discounts[leftI] = temp;
        }
        discounts[left] = discounts[leftI];
        discounts[leftI] = benchmark;
        this.fastSortByDiscounts(sortOrder, discounts, left, leftI - 1);
        this.fastSortByDiscounts(sortOrder, discounts, leftI + 1, right);
    }

    private String comSortTransformation(SeComSortBO seComSortBO) {
        if ("sold_number".equals(seComSortBO.getOrderByColumn())) {
            if (seComSortBO.getOrderType() == 0) {
                return "SOLD_NUMBER_DESC";
            }
            if (seComSortBO.getOrderType() == 1) {
                return "SOLD_NUMBER_ASC";
            }
        }
        if ("on_shelve_time".equals(seComSortBO.getOrderByColumn())) {
            if (seComSortBO.getOrderType() == 0) {
                return "ON_SHELVE_TIME_DESC";
            }
            if (seComSortBO.getOrderType() == 1) {
                return "ON_SHELVE_TIME_ASC";
            }
        }
        if ("sale_price".equals(seComSortBO.getOrderByColumn())) {
            if (seComSortBO.getOrderType() == 0) {
                return "SALE_PRICE_DESC";
            }
            if (seComSortBO.getOrderType() == 1) {
                return "SALE_PRICE_ASC";
            }
        }
        if ("discounts".equals(seComSortBO.getOrderByColumn())) {
            if (seComSortBO.getOrderType() == 0) {
                return "DISCOUNTS_DESC";
            }
            if (seComSortBO.getOrderType() == 1) {
                return "DISCOUNTS_ASC";
            }
        }
        return null;
    }

    private List<SeTermsBO> addMustTermsList(SeAppSearchReqBO seAppSearchReqBO, Long seChannelType) {
        boolean isVendorExactMatch;
        Map matchQueryMap;
        ArrayList<SeTermsBO> mustTermsList = new ArrayList<SeTermsBO>();
        if (seAppSearchReqBO.getMustTermsList() != null) {
            mustTermsList.addAll(seAppSearchReqBO.getMustTermsList());
        }
        boolean isBrandMatchQuery = (matchQueryMap = (Map)((Map)SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_MATCH_QUERY_MAPPING")).get(seChannelType)) != null && "0".equals(matchQueryMap.get("brand_name"));
        boolean isVenderMatchQuery = matchQueryMap != null && "0".equals(matchQueryMap.get("vendor_name"));
        Map exactMatchMap = (Map)((Map)SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_EXACT_MATCH_MAPPING")).get(seChannelType);
        boolean isBrandExactMatch = exactMatchMap != null && "0".equals(exactMatchMap.get("brand_name"));
        boolean bl = isVendorExactMatch = exactMatchMap != null && "0".equals(exactMatchMap.get("vendor_name"));
        if (isBrandMatchQuery && isBrandExactMatch && StringUtils.isNotBlank((CharSequence)seAppSearchReqBO.getQueryStr())) {
            this.processEntityMatch("brand_name", "brandName", seAppSearchReqBO.getQueryStr(), mustTermsList, seChannelType);
        }
        if (isVenderMatchQuery && isVendorExactMatch && StringUtils.isNotBlank((CharSequence)seAppSearchReqBO.getQueryStr())) {
            this.processEntityMatch("vendor_name", "supplierId", seAppSearchReqBO.getQueryStr(), mustTermsList, seChannelType);
        }
        if (seAppSearchReqBO.getQueryFilterList() != null) {
            HashMap<String, SeTermsBO> filterTermsMap = new HashMap<String, SeTermsBO>();
            List configList = this.esFiledObjConfigMapper.selectByStatus(Integer.valueOf(0));
            HashMap<String, EsFiledObjConfigPo> filterNameConfigMap = new HashMap<String, EsFiledObjConfigPo>();
            if (!CollectionUtils.isEmpty((Collection)configList)) {
                for (EsFiledObjConfigPo config : configList) {
                    if (!StringUtils.isNotBlank((CharSequence)config.getSearchFilterId())) continue;
                    filterNameConfigMap.put(ParseStringUtil.parseFilterId((String)config.getSearchFilterId(), (boolean)true), config);
                }
            }
            List standSeEntityCaches = this.standSeEntityCacheMapper.selectAllEntities();
            HashMap<String, StandSeEntityCachePo> filterNameCacheMap = new HashMap<String, StandSeEntityCachePo>();
            if (!CollectionUtils.isEmpty((Collection)standSeEntityCaches)) {
                for (StandSeEntityCachePo config : standSeEntityCaches) {
                    if (!StringUtils.isNotBlank((CharSequence)config.getSearchFilterId())) continue;
                    filterNameCacheMap.put(ParseStringUtil.parseFilterId((String)config.getSearchFilterId(), (boolean)true), config);
                }
            }
            for (SeQueryFilterBO seQueryFilterBO : seAppSearchReqBO.getQueryFilterList()) {
                SeTermsBO seTermsBO;
                boolean isIdValues = this.isIdValuesList(seQueryFilterBO.getFilterValues());
                if (isIdValues) {
                    String key = null;
                    Boolean isNested = false;
                    String nestedField = null;
                    Boolean isInnerFilter = false;
                    if (!filterNameConfigMap.isEmpty() && filterNameConfigMap.containsKey(seQueryFilterBO.getFilterId())) {
                        EsFiledObjConfigPo config = (EsFiledObjConfigPo)filterNameConfigMap.get(seQueryFilterBO.getFilterId());
                        key = config.getSearchFieldName();
                        isNested = config.getIsNested();
                        nestedField = config.getObjName();
                        isInnerFilter = config.getIsNested();
                    } else if (!filterNameCacheMap.isEmpty() && filterNameCacheMap.containsKey(seQueryFilterBO.getFilterId())) {
                        StandSeEntityCachePo cachePo = (StandSeEntityCachePo)filterNameCacheMap.get(seQueryFilterBO.getFilterId());
                        key = cachePo.getSearchFieldName();
                    }
                    SeTermsBO seTermsBO2 = new SeTermsBO();
                    seTermsBO2.setName(key);
                    seTermsBO2.setValueList(seQueryFilterBO.getFilterValues());
                    seTermsBO2.setNeedMust(Boolean.TRUE);
                    seTermsBO2.setIsWildcard(Boolean.FALSE);
                    seTermsBO2.setIsNested(isNested);
                    seTermsBO2.setNestedField(nestedField);
                    seTermsBO2.setIsInnerFilter(isInnerFilter);
                    mustTermsList.add(seTermsBO2);
                    continue;
                }
                if (!filterNameConfigMap.isEmpty() && filterNameConfigMap.containsKey(seQueryFilterBO.getFilterId())) {
                    ConversionResultBO conversionResultBO;
                    EsFiledObjConfigPo config = (EsFiledObjConfigPo)filterNameConfigMap.get(seQueryFilterBO.getFilterId());
                    String searchFieldName = config.getSearchFieldName();
                    if (StringUtils.isBlank((CharSequence)searchFieldName) || (conversionResultBO = this.convertEsObjectFieldValues(seQueryFilterBO.getFilterName(), seQueryFilterBO.getFilterValues(), seChannelType)) == null || conversionResultBO.getValues().isEmpty()) continue;
                    SeTermsBO termsBO = new SeTermsBO();
                    if (conversionResultBO.getSuccess().booleanValue()) {
                        termsBO.setName(searchFieldName + ".keyword");
                    } else {
                        termsBO.setName(ParseStringUtil.parseFilterId((String)config.getSearchFilterId(), (boolean)false));
                    }
                    termsBO.setValueList(conversionResultBO.getValues());
                    termsBO.setNeedMust(Boolean.TRUE);
                    termsBO.setIsWildcard(Boolean.FALSE);
                    termsBO.setIsNested(config.getIsNested());
                    termsBO.setNestedField(config.getObjName());
                    termsBO.setIsInnerFilter(config.getIsNested());
                    mustTermsList.add(termsBO);
                    continue;
                }
                if (filterNameCacheMap.isEmpty() || !filterNameCacheMap.containsKey(seQueryFilterBO.getFilterId())) continue;
                StandSeEntityCachePo cachePo = (StandSeEntityCachePo)filterNameCacheMap.get(seQueryFilterBO.getFilterId());
                String key = ParseStringUtil.parseFilterId((String)cachePo.getSearchFilterId(), (boolean)false);
                if (key != null && filterTermsMap.containsKey(key)) {
                    seTermsBO = (SeTermsBO)filterTermsMap.get(key);
                    List valueList = seTermsBO.getValueList();
                    valueList.addAll(seQueryFilterBO.getFilterValues());
                    seTermsBO.setValueList(valueList);
                    filterTermsMap.put(key, seTermsBO);
                    continue;
                }
                seTermsBO = new SeTermsBO(key, seQueryFilterBO.getFilterValues());
                filterTermsMap.put(key, seTermsBO);
            }
            ArrayList<SeTermsBO> filterTermsList = new ArrayList<SeTermsBO>();
            for (String key : filterTermsMap.keySet()) {
                SeTermsBO seTermsBO = (SeTermsBO)filterTermsMap.get(key);
                List valueList = seTermsBO.getValueList();
                ArrayList<String> newValueList = new ArrayList<String>();
                boolean hasCache = true;
                if (valueList != null) {
                    for (String value : valueList) {
                        String cacheStr = this.seEntityCache.getEntityCacheMapPenetrate(key, value, Integer.valueOf(0), seChannelType);
                        if (cacheStr == null && value != null) {
                            cacheStr = value;
                            hasCache = false;
                        }
                        String[] cacheStrArr = cacheStr.split(",");
                        List<String> tempValueList = Arrays.asList(cacheStrArr);
                        newValueList.addAll(tempValueList);
                    }
                }
                if (newValueList.isEmpty()) continue;
                String name = (String)((Map)((Map)SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_SEARCH_FIELD_MAPPING")).get(seChannelType)).get(key);
                if (StringUtils.isNotBlank((CharSequence)name) && hasCache) {
                    seTermsBO.setName(name);
                } else {
                    seTermsBO.setName(key);
                }
                seTermsBO.setValueList(newValueList);
                filterTermsList.add(seTermsBO);
            }
            mustTermsList.addAll(filterTermsList);
        }
        return mustTermsList;
    }

    private void processEntityMatch(String entityCacheKey, String fieldName, String queryStr, List<SeTermsBO> mustTermsList, Long seChannelType) {
        try {
            String[] queryWords;
            Map entityCacheMap = (Map)((Map)SeEntityCache.getEntityCacheMap().get(entityCacheKey)).get(seChannelType);
            if (entityCacheMap == null || entityCacheMap.isEmpty()) {
                return;
            }
            ArrayList<String> matchedEntityIds = new ArrayList<String>();
            ArrayList<String> matchedEntityBrands = new ArrayList<String>();
            for (String word : queryWords = queryStr.split("\\s+")) {
                if (StringUtils.isBlank((CharSequence)word) || !entityCacheMap.containsKey(word.trim())) continue;
                String entityIds = (String)entityCacheMap.get(word.trim());
                matchedEntityIds.addAll(Arrays.asList(entityIds.split(",")));
                matchedEntityBrands.add(word);
            }
            if (!matchedEntityIds.isEmpty()) {
                LinkedHashSet uniqueEntityIds = new LinkedHashSet(matchedEntityIds);
                LinkedHashSet uniqueEntityBrands = new LinkedHashSet(matchedEntityBrands);
                SeTermsBO termsBo = new SeTermsBO();
                termsBo.setName(fieldName);
                if (Objects.equals(entityCacheKey, "brand_name")) {
                    termsBo.setValueList(new ArrayList(uniqueEntityBrands));
                } else {
                    termsBo.setValueList(new ArrayList(uniqueEntityIds));
                }
                termsBo.setNeedMust(Boolean.TRUE);
                termsBo.setIsWildcard(Boolean.FALSE);
                mustTermsList.add(termsBo);
                log.info("{}{}{}\u7cbe\u51c6\u5339\u914d\u5230{}\u5b9e\u4f53: {}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>TXT>>>", fieldName, uniqueEntityIds.size(), ((Object)uniqueEntityIds).toString()});
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u7f13\u5b58\u5339\u914d\u5f02\u5e38 - entityCacheKey:{}, fieldName:{}, queryStr:{}, error:{}", new Object[]{entityCacheKey, fieldName, queryStr, e.getMessage()});
        }
    }

    private void queryStrToTerms(String seEntityCacheKey, String termsName, String queryStr, List<SeTermsBO> mustTermsList, Long seChannelType) {
        String nameCache = this.seEntityCache.getEntityCacheMapPenetrate(seEntityCacheKey, queryStr, Integer.valueOf(0), seChannelType);
        if (StringUtils.isNotBlank((CharSequence)nameCache)) {
            SeTermsBO termsBo = new SeTermsBO();
            termsBo.setName(termsName);
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add(nameCache);
            termsBo.setValueList(valueList);
            termsBo.setNeedMust(Boolean.FALSE);
            termsBo.setIsWildcard(Boolean.FALSE);
            mustTermsList.add(termsBo);
        }
    }

    private String parseProperties(SeAppSearchReqBO seAppSearchReqBO) {
        String propertiesGroup;
        StringBuilder properties = new StringBuilder();
        if (seAppSearchReqBO.getQueryPropertyList() != null) {
            for (SeQueryPropertyBO queryProperty : seAppSearchReqBO.getQueryPropertyList()) {
                propertiesGroup = queryProperty.getPropertyId();
                List propertyValueList = queryProperty.getPropertyValues();
                if (propertyValueList == null || propertyValueList.size() <= 0) continue;
                for (String propertyValue : propertyValueList) {
                    properties.append(propertiesGroup);
                    properties.append("*~~");
                    properties.append(propertyValue);
                    properties.append("\n");
                }
            }
        }
        if (seAppSearchReqBO.getQueryFilterList() != null) {
            for (SeQueryFilterBO queryFilter : seAppSearchReqBO.getQueryFilterList()) {
                List filterValueList;
                if (queryFilter.getFilterId().contains("*~~")) {
                    propertiesGroup = queryFilter.getFilterId();
                    List filterValueList2 = queryFilter.getFilterValues();
                    if (filterValueList2 == null || filterValueList2.size() <= 0) continue;
                    for (String propertyValue : filterValueList2) {
                        properties.append(propertiesGroup);
                        properties.append("*~~");
                        properties.append(propertyValue);
                        properties.append("\n");
                    }
                    continue;
                }
                if (!"model".equals(queryFilter.getFilterId()) || (filterValueList = queryFilter.getFilterValues()) == null || filterValueList.size() <= 0) continue;
                String propertiesGroup2 = queryFilter.getFilterId();
                for (String propertyValue : filterValueList) {
                    properties.append(propertiesGroup2);
                    properties.append("*~~");
                    properties.append(propertyValue);
                    properties.append("\n");
                }
            }
        }
        return properties.toString();
    }

    private SeEsResultBO propertyFilter(SeEsResultBO esResultBO, String properties) {
        if (StringUtils.isNotBlank((CharSequence)properties)) {
            String[] proArr = properties.split("\n");
            ArrayList hitList = new ArrayList();
            esResultBO.getHits().setHits(hitList);
            return esResultBO;
        }
        return esResultBO;
    }

    private boolean isIdValuesList(List<String> filterValues) {
        if (CollectionUtils.isEmpty(filterValues)) {
            return false;
        }
        for (String value : filterValues) {
            if (!StringUtils.isBlank((CharSequence)value) && AnalysisCommTools.isNumeric((String)value.trim())) continue;
            return false;
        }
        return true;
    }

    private ConversionResultBO convertEsObjectFieldValues(String searchFilterName, List<String> originalValues, Long seChannelType) {
        ConversionResultBO conversionResultBO = new ConversionResultBO();
        ArrayList<String> convertedValues = new ArrayList<String>();
        try {
            if (CollectionUtils.isEmpty(originalValues)) {
                return conversionResultBO;
            }
            for (String originalValue : originalValues) {
                if (!StringUtils.isNotBlank((CharSequence)originalValue)) continue;
                String convertedValue = SeEntityCache.getEsObjectFieldMapping((String)searchFilterName, (String)originalValue, (Long)seChannelType);
                convertedValues.add(convertedValue);
            }
        }
        catch (Exception e) {
            convertedValues.addAll(originalValues.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()));
            conversionResultBO.setSuccess(Boolean.valueOf(false));
        }
        conversionResultBO.setValues(convertedValues);
        return conversionResultBO;
    }

    private void selectionSort(SeAppSearchReqBO seAppSearchReqBO, SeSearchRspBO seAppSearchRspBO, Long seChannelType) {
        try {
            String smartChoiceEnable = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).smartChoiceEnable;
            if (Objects.equals(smartChoiceEnable, "1") && !CollectionUtils.isEmpty((Collection)seAppSearchReqBO.getChoSortList())) {
                String smartWeightGradientDescent = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).smartWeightGradientDescent;
                String[] weights = smartWeightGradientDescent.split(",");
                List skuBoList = seAppSearchRspBO.getSkuList();
                LinkedHashMap<BigDecimal, List> weightSegment = new LinkedHashMap<BigDecimal, List>();
                if (StringUtils.isNotBlank((CharSequence)seAppSearchReqBO.getQueryStr())) {
                    Arrays.stream(weights).sorted(Comparator.reverseOrder()).forEach(w -> weightSegment.put(BigDecimal.valueOf(Double.parseDouble(w)), new LinkedList()));
                    weightSegment.put(BigDecimal.valueOf(0.0), new LinkedList());
                    skuBoList.forEach(skuBo -> {
                        for (Map.Entry entry : weightSegment.entrySet()) {
                            if (skuBo.getSmartWeight().compareTo((BigDecimal)entry.getKey()) <= -1) continue;
                            ((List)weightSegment.get(entry.getKey())).add(skuBo);
                            break;
                        }
                    });
                } else {
                    log.info("\u67e5\u8be2\u77ed\u8bed\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u6743\u91cd\uff01");
                    weightSegment.put(BigDecimal.valueOf(0.55), skuBoList);
                }
                for (int i = 0; i < seAppSearchReqBO.getChoSortList().size(); ++i) {
                    SeChoSortBO seChoSortBO = (SeChoSortBO)seAppSearchReqBO.getChoSortList().get(i);
                    if (CollectionUtils.isEmpty((Collection)seChoSortBO.getValues())) continue;
                    if (i != 0) {
                        SeChoSortBO beforeSeChoSortBO = (SeChoSortBO)seAppSearchReqBO.getChoSortList().get(i - 1);
                        try {
                            Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
                            Field beforeField = clazz.getDeclaredField(beforeSeChoSortBO.getOrderByColumn());
                            beforeField.setAccessible(true);
                            Field nowField = clazz.getDeclaredField(seChoSortBO.getOrderByColumn());
                            nowField.setAccessible(true);
                            weightSegment.forEach((w, segmentSkuBoList) -> {
                                log.info("\u9009\u62e9\u6392\u5e8f,\u6743\u91cd\u533a\u95f4\uff1a{}", w);
                                LinkedList newSort = new LinkedList();
                                LinkedHashMap<String, Map> skuListMap = new LinkedHashMap<String, Map>();
                                segmentSkuBoList.forEach(skuBo -> {
                                    try {
                                        String beforeFieldValue = String.valueOf(beforeField.get(skuBo));
                                        String nowFieldValue = String.valueOf(nowField.get(skuBo));
                                        if (!skuListMap.containsKey(beforeFieldValue)) {
                                            skuListMap.put(beforeFieldValue, new LinkedHashMap());
                                        }
                                        if (!((Map)skuListMap.get(beforeFieldValue)).containsKey(nowFieldValue)) {
                                            ((Map)skuListMap.get(beforeFieldValue)).put(nowFieldValue, new LinkedList());
                                        }
                                        ((List)((Map)skuListMap.get(beforeFieldValue)).get(nowFieldValue)).add(skuBo);
                                    }
                                    catch (IllegalAccessException e) {
                                        log.error("\u9009\u62e9\u6392\u5e8f\u5b57\u6bb5\u503c\u83b7\u53d6\u5f02\u5e38\uff01", (Object)e.getMessage());
                                    }
                                });
                                skuListMap.forEach((k1, entityMap) -> this.selectSkuAdvance(seChoSortBO, (Map<String, List<SeQuerySkuBO>>)entityMap, newSort));
                                weightSegment.put((BigDecimal)w, newSort);
                            });
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
                    try {
                        Field nowField = clazz.getDeclaredField(seChoSortBO.getOrderByColumn());
                        nowField.setAccessible(true);
                        weightSegment.forEach((w, segmentSkuBoList) -> {
                            log.info("\u9009\u62e9\u6392\u5e8f,\u6743\u91cd\u533a\u95f4\uff1a{}", w);
                            LinkedHashMap<String, List<SeQuerySkuBO>> entityMap = new LinkedHashMap<String, List<SeQuerySkuBO>>();
                            LinkedList<SeQuerySkuBO> newSort = new LinkedList<SeQuerySkuBO>();
                            segmentSkuBoList.forEach(skuBo -> {
                                try {
                                    String nowFieldValue = String.valueOf(nowField.get(skuBo));
                                    if (!entityMap.containsKey(nowFieldValue)) {
                                        entityMap.put(nowFieldValue, new LinkedList());
                                    }
                                    ((List)entityMap.get(nowFieldValue)).add(skuBo);
                                }
                                catch (IllegalAccessException e) {
                                    log.error("\u9009\u62e9\u6392\u5e8f\u5b57\u6bb5\u503c\u83b7\u53d6\u5f02\u5e38\uff01", (Object)e.getMessage());
                                }
                            });
                            this.selectSkuAdvance(seChoSortBO, entityMap, newSort);
                            weightSegment.put((BigDecimal)w, newSort);
                        });
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        log.error("\u9009\u62e9\u6392\u5e8f\u5f02\u5e38\uff01", (Object)e.getMessage());
                    }
                }
                seAppSearchRspBO.setSkuList(new LinkedList());
                weightSegment.forEach((w, segmentSkuBoList) -> {
                    log.info("\u6743\u91cd\u5927\u4e8e{} \u6570\u91cf:{}", w, (Object)segmentSkuBoList.size());
                    seAppSearchRspBO.getSkuList().addAll(segmentSkuBoList);
                });
            }
        }
        catch (Exception e) {
            log.error("\u9009\u62e9\u6392\u5e8f\u6267\u884c\u5f02\u5e38\uff01", (Object)e.getMessage());
        }
    }

    private void selectSkuAdvance(SeChoSortBO seChoSortBO, Map<String, List<SeQuerySkuBO>> skuListMap, List<SeQuerySkuBO> newSort) {
        seChoSortBO.getValues().forEach(value -> {
            if (skuListMap.containsKey(value)) {
                log.info("\u9009\u62e9\u6392\u5e8f\uff1acolumn->{} value->{} ", (Object)seChoSortBO.getOrderByColumn(), value);
                newSort.addAll((Collection)skuListMap.get(value));
                skuListMap.remove(value);
            }
        });
        skuListMap.forEach((k2, entityList) -> newSort.addAll((Collection<SeQuerySkuBO>)entityList));
    }

    private void standardSort(SeSearchRspBO seAppSearchRspBO, Long seChannelType) throws NoSuchFieldException {
        String standardSortField = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).standardSortField;
        String standardSortType = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).standardSortType;
        if (!CollectionUtils.isEmpty((Collection)seAppSearchRspBO.getSkuList())) {
            for (SeQuerySkuBO seQuerySkuBO : seAppSearchRspBO.getSkuList()) {
                if (seQuerySkuBO.getSkuList().isEmpty()) continue;
                Field field = SearchStepRelevanceUtil.getDeclaredFieldRecursively(UccUpcSkuEsInfoBo.class, (String)standardSortField);
                seQuerySkuBO.getSkuList().sort((sku1, sku2) -> {
                    try {
                        Comparable value1 = (Comparable)field.get(sku1);
                        Comparable value2 = (Comparable)field.get(sku2);
                        if (value1 == null && value2 == null) {
                            return 0;
                        }
                        if (value1 == null) {
                            return "asc".equals(standardSortType) ? -1 : 1;
                        }
                        if (value2 == null) {
                            return "asc".equals(standardSortType) ? 1 : -1;
                        }
                        int result = value1.compareTo(value2);
                        return "asc".equals(standardSortType) ? result : -result;
                    }
                    catch (IllegalAccessException e) {
                        log.error("{}{}{}", new Object[]{"9999", "\u6807\u51c6\u5546\u54c1\u5546\u54c1\u5217\u8868\u6392\u5e8f\u5f02\u5e38\uff01", e});
                        return 0;
                    }
                });
            }
        }
    }

    private void standardSkuDataClean(ExecuteSearchReqBO executeSearchReqBO, SeSearchRspBO seSearchRspBO) {
        if (!CollectionUtils.isEmpty((Collection)seSearchRspBO.getSkuList()) && !CollectionUtils.isEmpty((Collection)executeSearchReqBO.getMustTermsList())) {
            HashMap<String, List> filterValues = new HashMap<String, List>();
            for (SeTermsBO seTermsBO : executeSearchReqBO.getMustTermsList()) {
                if (!seTermsBO.getIsInnerFilter().booleanValue()) continue;
                filterValues.put(this.removePrefix(seTermsBO.getName(), seTermsBO.getNestedField()), seTermsBO.getValueList());
            }
            if (filterValues.isEmpty()) {
                return;
            }
            seSearchRspBO.getSkuList().stream().filter(seQuerySkuBO -> !CollectionUtils.isEmpty((Collection)seQuerySkuBO.getSkuList())).forEach(seQuerySkuBO -> seQuerySkuBO.getSkuList().removeIf(uccUpcSkuEsInfoBo -> !this.satisfyAllFilterConditions((UccUpcSkuEsInfoBo)uccUpcSkuEsInfoBo, filterValues)));
        }
    }

    private String removePrefix(String str, String prefix) {
        if (str != null && prefix != null && str.startsWith(prefix)) {
            int dotIndex;
            String result = str.substring(prefix.length());
            if (result.startsWith(".")) {
                result = result.substring(1);
            }
            if ((dotIndex = result.indexOf(".")) != -1) {
                return result.substring(0, dotIndex);
            }
            return result;
        }
        return str;
    }

    private boolean satisfyAllFilterConditions(UccUpcSkuEsInfoBo uccUpcSkuEsInfoBo, Map<String, List<String>> filterValues) {
        for (Map.Entry<String, List<String>> entry : filterValues.entrySet()) {
            String fieldName = entry.getKey();
            List<String> allowedValues = entry.getValue();
            try {
                Field field = SearchStepRelevanceUtil.getDeclaredFieldRecursively(UccUpcSkuEsInfoBo.class, (String)fieldName);
                field.setAccessible(true);
                Object fieldValue = field.get(uccUpcSkuEsInfoBo);
                if (this.isValueInAllowedList(fieldValue, allowedValues)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean isValueInAllowedList(Object fieldValue, List<String> allowedValues) {
        if (fieldValue == null) {
            return false;
        }
        String valueStr = fieldValue.toString();
        if (fieldValue instanceof Collection) {
            Collection valueCollection = (Collection)fieldValue;
            for (Object item : valueCollection) {
                if (item == null || !allowedValues.contains(item.toString())) continue;
                return true;
            }
            return false;
        }
        return allowedValues.contains(valueStr);
    }
}

