/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.app.ability.impl;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import cn.hutool.poi.excel.WorkbookUtil;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.app.ability.SeAppQueryService;
import com.tydic.se.app.ability.SeQueryAnalysisService;
import com.tydic.se.app.ability.bo.SeAppSearchReqBO;
import com.tydic.se.app.ability.bo.SeAppSearchRspBO;
import com.tydic.se.base.ability.bo.RspUccBo;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.qa.InsertFileDataBO;
import com.tydic.se.base.ability.bo.qa.SimplifiedProductInfoBO;
import com.tydic.se.base.ability.bo.qa.req.QueryAnalysisFileUploadReqBO;
import com.tydic.se.base.ability.bo.qa.req.QueryAnalysisFilesListPO;
import com.tydic.se.base.ability.bo.qa.req.QueryAnalysisFilesListReqBO;
import com.tydic.se.base.ability.bo.qa.req.QueryAnalysisSearchGoodsReqBO;
import com.tydic.se.base.ability.bo.qa.rsp.QueryAnalysisRspBO;
import com.tydic.se.base.util.ExecutorProcessPool;
import com.tydic.se.base.util.ExecutorServiceFactory;
import com.tydic.se.search.ability.QueryAnalysisService;
import com.tydic.se.search.sort.QueryAnalysisSingleAtomService;
import com.tydic.se.search.sort.bo.QueryAnalysisExcelDataBO;
import com.tydic.se.search.sort.bo.QueryAnalysisReqBO;
import com.tydic.se.search.util.MultipartFileToFileUtil;
import com.tydic.se.search.util.SnowflakeIdWorker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"search-engine-group/3.0.0/com.tydic.se.app.ability.SeQueryAnalysisService"})
public class SeQueryAnalysisServiceImpl
implements SeQueryAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(SeQueryAnalysisServiceImpl.class);
    @Autowired
    private QueryAnalysisService queryAnalysisService;
    @Autowired
    private QueryAnalysisSingleAtomService queryAnalysisSingleAtomService;
    @Autowired
    private SeAppQueryService seAppQueryService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"singleAnalysis"})
    public QueryAnalysisRspBO singleAnalysis(@RequestBody QueryAnalysisSearchGoodsReqBO queryAnalysisSearchGoodsReqBO) throws Exception {
        QueryAnalysisRspBO queryAnalysisRspBO = new QueryAnalysisRspBO();
        try {
            QueryAnalysisReqBO queryAnalysisReqBO = new QueryAnalysisReqBO();
            queryAnalysisReqBO.setQueryConditions(queryAnalysisSearchGoodsReqBO.getQueryStr());
            Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
            List participle = this.queryAnalysisSingleAtomService.getQueryAnalysisParticiple(queryAnalysisReqBO, seChannelType);
            SeAppSearchReqBO seAppSearchReqBO = new SeAppSearchReqBO();
            seAppSearchReqBO.setQueryStr(queryAnalysisSearchGoodsReqBO.getQueryStr());
            SeAppSearchRspBO searchRspBO = this.seAppQueryService.search(seAppSearchReqBO);
            ArrayList<SimplifiedProductInfoBO> simplifiedProductInfoBOList = new ArrayList<SimplifiedProductInfoBO>();
            if (searchRspBO != null && !searchRspBO.getSkuList().isEmpty()) {
                for (SeQuerySkuBO seQuerySkuBO : searchRspBO.getSkuList()) {
                    SimplifiedProductInfoBO productInfo = new SimplifiedProductInfoBO();
                    productInfo.setWeight(seQuerySkuBO.getWeight());
                    productInfo.setCommodityName(seQuerySkuBO.getSkuName());
                    productInfo.setCatalogAllName(seQuerySkuBO.getCatalogAllName());
                    QueryAnalysisReqBO commodityAnalysisReq = new QueryAnalysisReqBO();
                    commodityAnalysisReq.setQueryConditions(productInfo.getCommodityName());
                    List commodityParticiple = this.queryAnalysisSingleAtomService.getQueryAnalysisParticiple(commodityAnalysisReq, seChannelType);
                    productInfo.setCommodityNameParticiples(commodityParticiple);
                    simplifiedProductInfoBOList.add(productInfo);
                }
            }
            queryAnalysisRspBO.setRespCode("0000");
            queryAnalysisRspBO.setRespDesc("\u5206\u6790\u6210\u529f");
            queryAnalysisRspBO.setQueryConditions(queryAnalysisSearchGoodsReqBO.getQueryStr());
            queryAnalysisRspBO.setParticiple(participle);
            queryAnalysisRspBO.setQueryResults(simplifiedProductInfoBOList);
            log.info("\u67e5\u8be2\u8bcd\u5206\u6790\u5b8c\u6210: {}, \u7ed3\u679c\u6570\u91cf: {}", (Object)queryAnalysisSearchGoodsReqBO.getQueryStr(), (Object)simplifiedProductInfoBOList.size());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8bcd\u5206\u6790\u5931\u8d25: {}", (Object)queryAnalysisSearchGoodsReqBO.getQueryStr(), (Object)e);
            queryAnalysisRspBO.setRespCode("9999");
            queryAnalysisRspBO.setRespDesc("\u5206\u6790\u5931\u8d25: " + e.getMessage());
            queryAnalysisRspBO.setQueryConditions(queryAnalysisSearchGoodsReqBO.getQueryStr());
            queryAnalysisRspBO.setParticiple(new ArrayList());
            queryAnalysisRspBO.setQueryResults(new ArrayList());
        }
        return queryAnalysisRspBO;
    }

    @PostMapping(value={"fileUpload"})
    public QueryAnalysisRspBO fileUpload(@RequestBody QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO) {
        try {
            if (queryAnalysisFileUploadReqBO == null) {
                throw new Exception("\u4e0a\u4f20\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)queryAnalysisFileUploadReqBO.getFile())) {
                throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (queryAnalysisFileUploadReqBO.getFileName() == null || queryAnalysisFileUploadReqBO.getFileName().trim().isEmpty()) {
                throw new Exception("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String fileName = queryAnalysisFileUploadReqBO.getFileName().toLowerCase();
            if (!fileName.endsWith(".xlsx") && !fileName.endsWith(".xls")) {
                throw new Exception("\u53ea\u652f\u6301Excel\u6587\u4ef6\u683c\u5f0f(.xlsx, .xls)");
            }
            log.info("\u5f00\u59cb\u5904\u7406\u67e5\u8be2\u8bcd\u5206\u6790\u6587\u4ef6\u4e0a\u4f20: {}", (Object)queryAnalysisFileUploadReqBO.getFileName());
            return this.saveAfterFile(queryAnalysisFileUploadReqBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8bcd\u5206\u6790\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            QueryAnalysisRspBO queryAnalysisRspBO = new QueryAnalysisRspBO();
            queryAnalysisRspBO.setRespCode("9999");
            queryAnalysisRspBO.setRespDesc("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage());
            return queryAnalysisRspBO;
        }
    }

    @PostMapping(value={"deleteByCategory"})
    public RspUccBo deleteByCategory(@RequestBody QueryAnalysisFilesListReqBO queryAnalysisFilesListReqBO) {
        return this.queryAnalysisService.deleteByCategory(queryAnalysisFilesListReqBO);
    }

    @PostMapping(value={"filesList"})
    public RspPage<QueryAnalysisFilesListPO> filesList(@RequestBody QueryAnalysisFilesListReqBO queryAnalysisFilesListReqBO) {
        return this.queryAnalysisService.filesList(queryAnalysisFilesListReqBO);
    }

    public QueryAnalysisRspBO saveAfterFile(final QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO) {
        QueryAnalysisRspBO queryAnalysisRspBO = new QueryAnalysisRspBO();
        try {
            String snowflakes = Long.toString(new SnowflakeIdWorker(0L, 0L).nextId());
            String[] files = queryAnalysisFileUploadReqBO.getFileName().split("\\.");
            String fileType = files[files.length - 1];
            String afterFilename = this.getNowTime() + "_" + snowflakes + "_" + queryAnalysisFileUploadReqBO.getFileName();
            String afterFilenameDfs = this.getNowTime() + "_" + snowflakes + "." + fileType;
            final String beforeFilename = this.getNowTime() + "_" + snowflakes + "_" + queryAnalysisFileUploadReqBO.getFileName();
            final String beforeFilenameDfs = this.getNowTime() + "_" + snowflakes + "." + fileType;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        log.info("\u5f00\u59cb\u5f02\u6b65\u5904\u7406\u67e5\u8be2\u8bcd\u5206\u6790\u6587\u4ef6: {}", (Object)beforeFilename);
                        SeQueryAnalysisServiceImpl.this.taskData(queryAnalysisFileUploadReqBO, beforeFilename, beforeFilenameDfs);
                        log.info("\u5f02\u6b65\u5904\u7406\u67e5\u8be2\u8bcd\u5206\u6790\u6587\u4ef6\u5b8c\u6210: {}", (Object)beforeFilename);
                    }
                    catch (Exception e) {
                        log.error("\u5f02\u6b65\u6267\u884c\u67e5\u8be2\u5206\u6790\u5931\u8d25: {}", (Object)beforeFilename, (Object)e);
                    }
                }
            };
            Thread thread = new Thread(run);
            thread.setName("QueryAnalysis-" + snowflakes);
            thread.start();
            QueryAnalysisFileUploadReqBO fileBo = new QueryAnalysisFileUploadReqBO();
            fileBo.setFile(queryAnalysisFileUploadReqBO.getFile());
            fileBo.setFileName(afterFilenameDfs);
            String url = this.queryAnalysisSingleAtomService.fileUpload(fileBo);
            InsertFileDataBO insertFileDataBO = new InsertFileDataBO();
            insertFileDataBO.setId(Long.valueOf(new SnowflakeIdWorker(0L, 0L).nextId()));
            insertFileDataBO.setFileurl(url);
            insertFileDataBO.setFilename(afterFilename);
            insertFileDataBO.setCategory("after");
            int num = this.queryAnalysisSingleAtomService.insertFileData(insertFileDataBO);
            if (num <= 0) {
                throw new Exception("\u6570\u636e\u5e93\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
            }
            queryAnalysisRspBO.setRespCode("0000");
            queryAnalysisRspBO.setRespDesc("\u4e0a\u4f20\u6210\u529f\uff0c\u6587\u4ef6\u6b63\u5728\u540e\u53f0\u5206\u6790\u4e2d");
            queryAnalysisRspBO.setDownloadFileName(this.getNowTime() + "_" + snowflakes + "_" + queryAnalysisFileUploadReqBO.getFileName());
            queryAnalysisRspBO.setQueryConditions(queryAnalysisFileUploadReqBO.getFileName());
            log.info("\u67e5\u8be2\u8bcd\u5206\u6790\u6587\u4ef6\u4e0a\u4f20\u6210\u529f: {}, \u6587\u4ef6ID: {}, \u5f02\u6b65\u4efb\u52a1\u5df2\u542f\u52a8", (Object)queryAnalysisRspBO.getDownloadFileName(), (Object)snowflakes);
            return queryAnalysisRspBO;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8bcd\u5206\u6790\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25: {}", (Object)queryAnalysisFileUploadReqBO.getFileName(), (Object)e);
            queryAnalysisRspBO.setRespCode("9999");
            queryAnalysisRspBO.setRespDesc("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25: " + e.getMessage());
            queryAnalysisRspBO.setQueryConditions(queryAnalysisFileUploadReqBO.getFileName());
            return queryAnalysisRspBO;
        }
    }

    public void taskData(QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO, String beforeFilename, String beforeFilenameDfs) throws Exception {
        try {
            List<List<QueryAnalysisExcelDataBO>> excelDataBos = this.readExcel(queryAnalysisFileUploadReqBO);
            LinkedList<List<QueryAnalysisExcelDataBO>> writeExcelDataBos = new LinkedList<List<QueryAnalysisExcelDataBO>>();
            ExecutorService executorService = ExecutorServiceFactory.getInstance().createCustomThreadPool(10);
            for (List<QueryAnalysisExcelDataBO> queryAnalysisExcelDataBOList : excelDataBos) {
                final LinkedList writeExcelDataBOList = new LinkedList();
                final CountDownLatch countDownLatch = new CountDownLatch(queryAnalysisExcelDataBOList.size());
                for (final QueryAnalysisExcelDataBO queryAnalysisExcelDataBO : queryAnalysisExcelDataBOList) {
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                QueryAnalysisSearchGoodsReqBO queryAnalysisSearchGoodsReqBO = new QueryAnalysisSearchGoodsReqBO();
                                queryAnalysisSearchGoodsReqBO.setQueryStr(queryAnalysisExcelDataBO.getQueryConditions());
                                queryAnalysisSearchGoodsReqBO.setPageSize(10);
                                QueryAnalysisRspBO queryAnalysisRspBO = SeQueryAnalysisServiceImpl.this.singleAnalysis(queryAnalysisSearchGoodsReqBO);
                                if ("9999".equals(queryAnalysisRspBO.getRespCode())) {
                                    QueryAnalysisExcelDataBO tmp = new QueryAnalysisExcelDataBO();
                                    tmp.setNum(queryAnalysisExcelDataBO.getNum());
                                    tmp.setQueryConditions(queryAnalysisExcelDataBO.getQueryConditions());
                                    tmp.setRemark(queryAnalysisRspBO.getRespDesc().replace("java.lang.Exception: ", ""));
                                    writeExcelDataBOList.add(tmp);
                                } else {
                                    List queryAnalysisBOList = queryAnalysisRspBO.getQueryResults();
                                    boolean flag = Boolean.TRUE;
                                    if (queryAnalysisBOList.size() == 0) {
                                        QueryAnalysisExcelDataBO tmp = new QueryAnalysisExcelDataBO();
                                        tmp.setNum(queryAnalysisExcelDataBO.getNum());
                                        tmp.setQueryConditions(queryAnalysisExcelDataBO.getQueryConditions());
                                        tmp.setParticiple(String.join((CharSequence)",", queryAnalysisRspBO.getParticiple()));
                                        tmp.setRemark("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                                        writeExcelDataBOList.add(tmp);
                                    } else {
                                        for (SimplifiedProductInfoBO simplifiedProductInfoBO : queryAnalysisBOList) {
                                            QueryAnalysisExcelDataBO tmp = new QueryAnalysisExcelDataBO();
                                            if (flag) {
                                                tmp.setNum(queryAnalysisExcelDataBO.getNum());
                                                tmp.setQueryConditions(queryAnalysisExcelDataBO.getQueryConditions());
                                                tmp.setParticiple(String.join((CharSequence)",", queryAnalysisRspBO.getParticiple()));
                                                if (queryAnalysisRspBO.getAnalyzerCatalogIndexData() != null) {
                                                    tmp.setAnalyzerCatalogIndexData(String.join((CharSequence)",", queryAnalysisRspBO.getAnalyzerCatalogIndexData()));
                                                }
                                                tmp.setReCallType(queryAnalysisRspBO.getReCallType());
                                                if (queryAnalysisRspBO.getFullTextMatchRate() != null) {
                                                    tmp.setFullTextMatchRate(queryAnalysisRspBO.getFullTextMatchRate());
                                                }
                                                if (queryAnalysisRspBO.getKeyFieldsMatchRate() != null) {
                                                    tmp.setKeyFieldsMatchRate(queryAnalysisRspBO.getKeyFieldsMatchRate());
                                                }
                                                if (queryAnalysisRspBO.getQueryResultType() != null) {
                                                    tmp.setQueryResultType(queryAnalysisRspBO.getQueryResultType());
                                                }
                                                flag = Boolean.FALSE;
                                            }
                                            tmp.setCommodityName(simplifiedProductInfoBO.getCommodityName());
                                            if (simplifiedProductInfoBO.getCommodityNameParticiples() != null) {
                                                tmp.setCommodityNameParticiples(String.join((CharSequence)",", simplifiedProductInfoBO.getCommodityNameParticiples()));
                                            }
                                            tmp.setCatalogAllName(simplifiedProductInfoBO.getCatalogAllName());
                                            tmp.setWeigh(simplifiedProductInfoBO.getWeight().toString());
                                            writeExcelDataBOList.add(tmp);
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("\u5355\u5143\u5f02\u6b65\u4efb\u52a1\u5931\u8d25\uff01" + e.getMessage());
                            }
                            finally {
                                countDownLatch.countDown();
                            }
                        }
                    };
                    ExecutorProcessPool.getInstance().executeByCustomThread(run, executorService);
                }
                countDownLatch.await();
                writeExcelDataBos.add(writeExcelDataBOList);
            }
            File beforeFile = new File(beforeFilenameDfs);
            this.writeExcel(beforeFile, writeExcelDataBos, beforeFilename);
            log.info("Search Qa : {} \u6587\u4ef6\u5c01\u88c5\u5b8c\u6210\uff01", (Object)beforeFilename.split("/")[beforeFilename.split("/").length - 1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u5f02\u6b65\u4efb\u52a1\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<QueryAnalysisExcelDataBO>> readExcel(QueryAnalysisFileUploadReqBO queryAnalysisFileUploadReqBO) throws InterruptedException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(queryAnalysisFileUploadReqBO.getFile());){
            ArrayList<List<QueryAnalysisExcelDataBO>> excelDataBOList = new ArrayList<List<QueryAnalysisExcelDataBO>>();
            Workbook workbook = WorkbookUtil.createBook((String)inputStream.toString());
            int sheetCount = workbook.getNumberOfSheets();
            log.info("\u5f00\u59cb\u89e3\u6790Excel\u6587\u4ef6\uff0c\u5171 {} \u4e2a\u5de5\u4f5c\u8868", (Object)sheetCount);
            for (int i = 0; i < sheetCount; ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                try {
                    ExcelReader sheetReader = new ExcelReader(sheet);
                    sheetReader.addHeaderAlias("\u7f16\u53f7", "num");
                    sheetReader.addHeaderAlias("\u641c\u7d22\u8bcd", "queryConditions");
                    sheetReader.addHeaderAlias("\u67e5\u8be2\u8bcd", "queryConditions");
                    sheetReader.addHeaderAlias("\u67e5\u8be2\u8bcd(queryStr)", "queryConditions");
                    sheetReader.addHeaderAlias("queryStr", "queryConditions");
                    List excelDataBOS = sheetReader.readAll(QueryAnalysisExcelDataBO.class);
                    if (excelDataBOS != null && !excelDataBOS.isEmpty()) {
                        excelDataBOS = excelDataBOS.stream().filter(data -> data != null && data.getQueryConditions() != null && !data.getQueryConditions().trim().isEmpty()).collect(Collectors.toList());
                        log.info("\u5de5\u4f5c\u8868 {} \u89e3\u6790\u6210\u529f\uff0c\u6709\u6548\u6570\u636e {} \u6761", (Object)(i + 1), (Object)excelDataBOS.size());
                    } else {
                        log.warn("\u5de5\u4f5c\u8868 {} \u65e0\u6709\u6548\u6570\u636e", (Object)(i + 1));
                    }
                    excelDataBOList.add(excelDataBOS);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u89e3\u6790\u5de5\u4f5c\u8868 {} \u5931\u8d25", (Object)(i + 1), (Object)e);
                    excelDataBOList.add(new ArrayList());
                }
            }
            log.info("Excel\u6587\u4ef6\u89e3\u6790\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u5de5\u4f5c\u8868", (Object)excelDataBOList.size());
            ArrayList<List<QueryAnalysisExcelDataBO>> arrayList = excelDataBOList;
            return arrayList;
        }
        catch (Exception e) {
            log.error("Excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
            throw new InterruptedException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25: " + e.getMessage());
        }
    }

    public String getNowTime() {
        LocalDateTime nowDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return nowDateTime.format(dateTimeFormatter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExcel(File fileName, List<List<QueryAnalysisExcelDataBO>> excelDataBOList, String beforeFilename) throws Exception {
        log.info(beforeFilename + "  \u5171\u6709\uff1a" + excelDataBOList.size() + " sheet!");
        for (int i = 0; i < excelDataBOList.size(); ++i) {
            ExcelWriter writer = ExcelUtil.getWriter((File)fileName, (String)Integer.toString(i));
            log.info("\u7a7a\u5904\u7406\u524d\u6709: " + excelDataBOList.get(i).size());
            excelDataBOList.set(i, excelDataBOList.get(i).stream().filter(Objects::nonNull).collect(Collectors.toList()));
            log.info("\u7a7a\u5904\u7406\u540e\u6709: " + excelDataBOList.get(i).size());
            try {
                writer.addHeaderAlias("num", "\u7f16\u53f7");
                writer.addHeaderAlias("queryConditions", "\u67e5\u8be2\u8bcd(queryStr)");
                writer.addHeaderAlias("participle", "\u5206\u8bcd\u7ed3\u679c");
                writer.addHeaderAlias("weigh", "\u6743\u91cd(weight)");
                writer.addHeaderAlias("commodityName", "\u5546\u54c1\u540d\u79f0(skuName)");
                writer.addHeaderAlias("catalogAllName", "\u7c7b\u76ee\u8def\u5f84(manageCatalogPathName)");
                writer.addHeaderAlias("commodityNameParticiples", "\u5546\u54c1\u540d\u79f0\u5206\u8bcd");
                writer.addHeaderAlias("analyzerCatalogIndexData", "\u7c7b\u76ee\u9884\u6d4b");
                writer.addHeaderAlias("reCallType", "\u53ec\u56de\u7c7b\u578b");
                writer.addHeaderAlias("keyFieldsMatchRate", "\u5173\u952e\u5b57\u6bb5\u5339\u914d\u7387");
                writer.addHeaderAlias("fullTextMatchRate", "\u5168\u6587\u5339\u914d\u7387");
                writer.addHeaderAlias("queryResultType", "\u67e5\u8be2\u7ed3\u679c\u7c7b\u578b");
                writer.addHeaderAlias("remark", "\u5907\u6ce8");
                writer.setColumnWidth(0, 10);
                writer.setColumnWidth(1, 25);
                writer.setColumnWidth(2, 30);
                writer.setColumnWidth(3, 15);
                writer.setColumnWidth(4, 30);
                writer.setColumnWidth(5, 40);
                writer.setColumnWidth(6, 30);
                writer.setColumnWidth(7, 20);
                writer.setColumnWidth(8, 15);
                writer.setColumnWidth(9, 20);
                writer.setColumnWidth(10, 20);
                writer.setColumnWidth(11, 20);
                writer.setColumnWidth(12, 30);
                writer.write((Iterable)excelDataBOList.get(i), true);
                continue;
            }
            catch (Exception e) {
                log.error("Excel\u5199\u5165\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                continue;
            }
            finally {
                writer.close();
            }
        }
        QueryAnalysisFileUploadReqBO fileBo = new QueryAnalysisFileUploadReqBO();
        try (FileInputStream fis = new FileInputStream(fileName);
             ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);){
            int n;
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            byte[] data = bos.toByteArray();
            fileBo.setFile(data);
            fileBo.setFileName(beforeFilename);
            log.info("\u5f00\u59cb\u4e0a\u4f20\u5206\u6790\u7ed3\u679c\u6587\u4ef6: {}", (Object)beforeFilename);
            String url = this.queryAnalysisSingleAtomService.fileUpload(fileBo);
            InsertFileDataBO insertFileDataBO = new InsertFileDataBO();
            insertFileDataBO.setId(Long.valueOf(new SnowflakeIdWorker(0L, 0L).nextId()));
            insertFileDataBO.setFilename(beforeFilename);
            insertFileDataBO.setFileurl(url);
            insertFileDataBO.setCategory("before");
            int num = this.queryAnalysisSingleAtomService.insertFileData(insertFileDataBO);
            if (num > 0) {
                log.info("\u5206\u6790\u7ed3\u679c\u6587\u4ef6\u4e0a\u4f20\u6210\u529f: {}, URL: {}, \u6570\u636e\u5e93\u8bb0\u5f55\u5df2\u4fdd\u5b58", (Object)beforeFilename, (Object)url);
            } else {
                log.warn("\u5206\u6790\u7ed3\u679c\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u4f46\u6570\u636e\u5e93\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25: {}", (Object)beforeFilename);
            }
        }
        catch (Exception e) {
            log.error("\u5206\u6790\u7ed3\u679c\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: {}", (Object)beforeFilename, (Object)e);
            throw new Exception("\u5206\u6790\u7ed3\u679c\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage());
        }
        finally {
            MultipartFileToFileUtil.delteTempFile((File)fileName);
        }
    }
}

