/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.base.util;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeFileUtil {
    private static final Logger log = LoggerFactory.getLogger(SeFileUtil.class);

    public static byte[] downloadResourceFile(String resourcePath, boolean isOnLine, HttpServletResponse response) throws IOException {
        return SeFileUtil.downloadResourceFile(resourcePath, null, isOnLine, response);
    }

    public static byte[] downloadResourceFile(String resourcePath) throws IOException {
        try {
            String content = SeFileUtil.loadFile(resourcePath);
            return content.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public static byte[] downloadResourceFile(String resourcePath, String fileName, boolean isOnLine, HttpServletResponse response) throws IOException {
        try {
            response.reset();
            if (StringUtils.isBlank((CharSequence)fileName)) {
                try {
                    fileName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
                }
                catch (Exception e) {
                    fileName = UUID.randomUUID().toString().replaceAll("-", "");
                }
            }
            if (isOnLine) {
                response.setHeader("Content-Disposition", "inline; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            } else {
                response.setContentType("application/x-msdownload");
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            }
            String content = SeFileUtil.loadFile(resourcePath);
            return content.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public static String loadFile(String filePath) throws IOException {
        File file = new File(filePath);
        FileInputStream inputStream = new FileInputStream(file);
        String content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        inputStream.close();
        log.info(content);
        return content;
    }

    public static void rewriteFile(String filePath, String content) throws IOException {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWritter = new FileWriter(file.getPath());
            try (BufferedWriter bufferWritter = new BufferedWriter(fileWritter);){
                bufferWritter.write(content);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

