/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.behavior.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.behavior.ability.SeInitDicService;
import com.tydic.se.behavior.ability.bo.SeInitDicBO;
import com.tydic.se.behavior.ability.bo.SeInitDicListRspBO;
import com.tydic.se.behavior.ability.bo.SeInitDicReqBO;
import com.tydic.se.behavior.ability.bo.SeInitDicRspBO;
import com.tydic.se.behavior.dao.SeInitDicMapper;
import com.tydic.se.behavior.po.SeInitDicPO;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="seInitDicService")
public class SeInitDicServiceImpl
implements SeInitDicService {
    @Autowired
    SeInitDicMapper seInitDicMapper;
    @Value(value="nbd,ncg,ncor,nmd,nsz,nvd,ncl")
    private String dictionaryTypeAbbreviation;
    @Value(value="brand,catalog,color,model,specs,vendor,name")
    private String dictionaryType;

    public SeInitDicRspBO querySeInitDicSingle(SeInitDicReqBO seInitDicReqBO) {
        SeInitDicRspBO rspBO = new SeInitDicRspBO();
        SeInitDicPO selectSeInitDicPO = new SeInitDicPO();
        BeanUtils.copyProperties((Object)seInitDicReqBO, (Object)selectSeInitDicPO);
        List<SeInitDicPO> seInitDicList = this.seInitDicMapper.selectByCondition(selectSeInitDicPO);
        if (seInitDicList.size() != 1) {
            if (seInitDicList.size() > 1) {
                throw new SeBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        SeInitDicBO seInitDicBO = new SeInitDicBO();
        BeanUtils.copyProperties((Object)seInitDicList.get(0), (Object)seInitDicBO);
        rspBO.setData(seInitDicBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public SeInitDicListRspBO querySeInitDicList(SeInitDicReqBO seInitDicReqBO) {
        SeInitDicListRspBO rspBO = new SeInitDicListRspBO();
        SeInitDicPO selectSeInitDicPO = new SeInitDicPO();
        BeanUtils.copyProperties((Object)seInitDicReqBO, (Object)selectSeInitDicPO);
        List<SeInitDicPO> seInitDicPOList = this.seInitDicMapper.selectByCondition(selectSeInitDicPO);
        ArrayList<SeInitDicBO> seInitDicBOList = new ArrayList<SeInitDicBO>();
        for (SeInitDicPO seInitDicPO : seInitDicPOList) {
            SeInitDicBO seInitDicBO = new SeInitDicBO();
            BeanUtils.copyProperties((Object)seInitDicPO, (Object)seInitDicBO);
            seInitDicBOList.add(seInitDicBO);
        }
        rspBO.setData(seInitDicBOList);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public RspPage<SeInitDicBO> querySeInitDicListPage(SeInitDicReqBO seInitDicReqBO) {
        if (seInitDicReqBO.getPageNo() < 1) {
            seInitDicReqBO.setPageNo(1);
        }
        if (seInitDicReqBO.getPageSize() < 1) {
            seInitDicReqBO.setPageSize(10);
        }
        SeInitDicPO selectSeInitDicPO = new SeInitDicPO();
        BeanUtils.copyProperties((Object)seInitDicReqBO, (Object)selectSeInitDicPO);
        Page page = PageHelper.startPage((int)seInitDicReqBO.getPageNo(), (int)seInitDicReqBO.getPageSize()).doSelectPage(() -> this.seInitDicMapper.selectByCondition(selectSeInitDicPO));
        ArrayList<SeInitDicBO> seInitDicBOList = new ArrayList<SeInitDicBO>();
        for (SeInitDicPO seInitDicPO : page.getResult()) {
            SeInitDicBO seInitDicBO = new SeInitDicBO();
            BeanUtils.copyProperties((Object)seInitDicPO, (Object)seInitDicBO);
            seInitDicBOList.add(seInitDicBO);
        }
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(seInitDicBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Transactional
    public SeInitDicRspBO addSeInitDic(SeInitDicReqBO seInitDicReqBO) {
        SeInitDicRspBO rspBO = new SeInitDicRspBO();
        SeInitDicPO insertSeInitDicPO = new SeInitDicPO();
        BeanUtils.copyProperties((Object)seInitDicReqBO, (Object)insertSeInitDicPO);
        long id = Sequence.getInstance().nextId();
        insertSeInitDicPO.setId(id);
        int num = this.seInitDicMapper.insert(insertSeInitDicPO);
        if (num != 1) {
            throw new SeBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        SeInitDicBO SeInitDicBO2 = new SeInitDicBO();
        BeanUtils.copyProperties((Object)insertSeInitDicPO, (Object)SeInitDicBO2);
        rspBO.setData(SeInitDicBO2);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @Transactional
    public SeInitDicRspBO updateSeInitDic(SeInitDicReqBO seInitDicReqBO) {
        SeInitDicPO updateSeInitDicPO;
        SeInitDicRspBO rspBO = new SeInitDicRspBO();
        SeInitDicPO selectSeInitDicPO = new SeInitDicPO();
        selectSeInitDicPO.setId(seInitDicReqBO.getId());
        List<SeInitDicPO> seInitDicList = this.seInitDicMapper.selectByCondition(selectSeInitDicPO);
        if (seInitDicList.size() == 1) {
            updateSeInitDicPO = new SeInitDicPO();
            BeanUtils.copyProperties((Object)seInitDicReqBO, (Object)updateSeInitDicPO);
            int num = this.seInitDicMapper.update(updateSeInitDicPO);
            if (num != 1) {
                throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (seInitDicList.size() > 1) {
                throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        SeInitDicBO seInitDicBO = new SeInitDicBO();
        BeanUtils.copyProperties((Object)updateSeInitDicPO, (Object)seInitDicBO);
        rspBO.setData(seInitDicBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @Transactional
    public SeInitDicRspBO saveSeInitDic(SeInitDicReqBO seInitDicReqBO) {
        if (seInitDicReqBO.getId() == null) {
            return this.addSeInitDic(seInitDicReqBO);
        }
        return this.updateSeInitDic(seInitDicReqBO);
    }

    @Transactional
    public SeInitDicRspBO deleteSeInitDic(SeInitDicReqBO seInitDicReqBO) {
        SeInitDicRspBO rspBO = new SeInitDicRspBO();
        SeInitDicPO selectSeInitDicPO = new SeInitDicPO();
        selectSeInitDicPO.setId(seInitDicReqBO.getId());
        List<SeInitDicPO> seInitDicList = this.seInitDicMapper.selectByCondition(selectSeInitDicPO);
        if (seInitDicList.size() == 1) {
            SeInitDicPO deleteSeInitDicPO = new SeInitDicPO();
            BeanUtils.copyProperties((Object)seInitDicReqBO, (Object)deleteSeInitDicPO);
            int num = this.seInitDicMapper.delete(deleteSeInitDicPO);
            if (num != 1) {
                throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5220\u9664\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (seInitDicList.size() > 1) {
                throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public String importUrl(String accessUrl, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)accessUrl)) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String read;
            URL url = new URL(accessUrl);
            URLConnection conn = url.openConnection();
            InputStream inputStream = conn.getInputStream();
            response.reset();
            String filename = accessUrl.substring(accessUrl.lastIndexOf("/") + 1);
            response.setHeader("Content-Disposition", "inline; filename=" + URLEncoder.encode(filename, "UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((read = bufferedReader.readLine()) != null) {
                stringBuffer.append(read + "\n");
            }
            String str = stringBuffer.toString();
            String name = filename.split("\\.")[0];
            inputStream.close();
            this.importTxt(str, name);
            return "\u5165\u5e93\u6210\u529f        " + str;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u6587\u4ef6\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public String importFile(MultipartFile[] files) {
        if (files == null || files.length == 0) {
            throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        }
        for (MultipartFile file : files) {
            InputStream inputStream = null;
            try {
                inputStream = file.getInputStream();
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                String name = Objects.requireNonNull(file.getOriginalFilename()).split("\\.")[0];
                String str = new String(bytes, StandardCharsets.UTF_8);
                inputStream.close();
                this.importTxt(str, name);
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
        }
        return "\u5165\u5e93\u6210\u529f";
    }

    public void importTxt(String s, String name) {
        List<String> list = Arrays.asList(s.split("\n"));
        if (list.size() <= 0) {
            throw new ZTBusinessException("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        this.recursion(list, name);
    }

    public void recursion(List<String> list, String name) {
        int j;
        String type;
        SeInitDicReqBO seInitDicReqBO;
        int i;
        ArrayList<SeInitDicReqBO> seInitDicReqBOS;
        List<String> dictionaryTypeAbbreviationList = Arrays.asList(this.dictionaryTypeAbbreviation.split(","));
        List<String> dictionaryTypeList = Arrays.asList(this.dictionaryType.split(","));
        if (list.size() <= 500 && list.size() > 0) {
            seInitDicReqBOS = new ArrayList<SeInitDicReqBO>();
            for (i = 0; i < list.size(); ++i) {
                if (!StringUtils.isNotBlank((CharSequence)list.get(i))) continue;
                seInitDicReqBO = new SeInitDicReqBO();
                seInitDicReqBO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                seInitDicReqBO.setCreateTime(new Date());
                seInitDicReqBO.setSource("jd");
                seInitDicReqBO.setStatus("1");
                seInitDicReqBO.setDic(list.get(i));
                type = null;
                for (j = 0; j < dictionaryTypeList.size(); ++j) {
                    if (!name.equals(dictionaryTypeList.get(j))) continue;
                    type = dictionaryTypeAbbreviationList.get(j);
                }
                seInitDicReqBO.setType(type);
                seInitDicReqBOS.add(seInitDicReqBO);
            }
            this.seInitDicMapper.addAll(seInitDicReqBOS);
        }
        if (list.size() > 500) {
            seInitDicReqBOS = new ArrayList();
            for (i = 0; i < 500; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)list.get(i))) continue;
                seInitDicReqBO = new SeInitDicReqBO();
                seInitDicReqBO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                seInitDicReqBO.setCreateTime(new Date());
                seInitDicReqBO.setSource("jd");
                seInitDicReqBO.setStatus("1");
                seInitDicReqBO.setDic(list.get(i));
                type = null;
                for (j = 0; j < dictionaryTypeList.size(); ++j) {
                    if (!name.equals(dictionaryTypeList.get(j))) continue;
                    type = dictionaryTypeAbbreviationList.get(j);
                }
                seInitDicReqBO.setType(type);
                seInitDicReqBOS.add(seInitDicReqBO);
            }
            this.seInitDicMapper.addAll(seInitDicReqBOS);
            List<String> list1 = list.subList(500, list.size());
            this.recursion(list1, name);
        }
    }
}

