/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.behavior.thesaurus;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.client.utils.StringUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.RspUccBo;
import com.tydic.se.base.ability.bo.RspUccPageBo;
import com.tydic.se.base.util.SeFileUtil;
import com.tydic.se.behavior.ability.bo.ComUocFileAppBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppReqBO;
import com.tydic.se.behavior.ability.bo.ComUocFileUploadAppRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionListRspBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionReqBO;
import com.tydic.se.behavior.ability.bo.SeCorrectionRspBO;
import com.tydic.se.behavior.dao.SeCorrectionMapper;
import com.tydic.se.behavior.po.SeCorrectionPO;
import com.tydic.se.behavior.thesaurus.SeCorrectionService;
import com.tydic.se.behavior.thesaurus.bo.SeRemoteSynonymReqBo;
import com.tydic.se.behavior.thesaurus.bo.SeRemoteSynonymRspBo;
import com.tydic.se.behavior.utils.SearchQaHttpUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service(value="seCorrectionService")
public class SeCorrectionServiceImpl
implements SeCorrectionService {
    private static final Logger log = LoggerFactory.getLogger(SeCorrectionServiceImpl.class);
    @Autowired
    private SeCorrectionMapper seCorrectionMapper;
    @Autowired
    private CacheClient cacheClient;
    private String filePath = System.getProperty("user.dir") + "/config/synonyms.txt";
    @Value(value="${search.synonym.key:ucc_search_remote_synonym_cache_}")
    private String remoteSynonymRedisKey;
    @Value(value="${search.synonym.key:ucc_search_remote_correcting_cache_}")
    private String remoteCorrectingRedisKey;
    @Value(value="${search.synonyms.is.upload:false}")
    private Boolean isUploadOss;
    @Value(value="${search.synonyms.requestBody:}")
    private String requestBody;
    @Value(value="${search.synonyms.update:}")
    private String updateSynonymsDicts;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "search";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    public SeCorrectionRspBO querySeCorrectionSingle(SeCorrectionReqBO seCorrectionReqBO) {
        SeCorrectionRspBO rspBO = new SeCorrectionRspBO();
        SeCorrectionPO selectSeCorrectionPO = new SeCorrectionPO();
        BeanUtils.copyProperties((Object)seCorrectionReqBO, (Object)selectSeCorrectionPO);
        List<SeCorrectionPO> seCorrectionList = this.seCorrectionMapper.selectByCondition(selectSeCorrectionPO);
        if (seCorrectionList.size() != 1) {
            if (seCorrectionList.size() > 1) {
                throw new SeBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        SeCorrectionBO seCorrectionBO = new SeCorrectionBO();
        BeanUtils.copyProperties((Object)seCorrectionList.get(0), (Object)seCorrectionBO);
        rspBO.setData(seCorrectionBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public SeCorrectionListRspBO querySeCorrectionList(SeCorrectionReqBO seCorrectionReqBO) {
        SeCorrectionListRspBO rspBO = new SeCorrectionListRspBO();
        SeCorrectionPO selectSeCorrectionPO = new SeCorrectionPO();
        BeanUtils.copyProperties((Object)seCorrectionReqBO, (Object)selectSeCorrectionPO);
        List<SeCorrectionPO> seCorrectionPOList = this.seCorrectionMapper.selectByCondition(selectSeCorrectionPO);
        ArrayList<SeCorrectionBO> seCorrectionBOList = new ArrayList<SeCorrectionBO>();
        for (SeCorrectionPO seCorrectionPO : seCorrectionPOList) {
            SeCorrectionBO seCorrectionBO = new SeCorrectionBO();
            BeanUtils.copyProperties((Object)seCorrectionPO, (Object)seCorrectionBO);
            seCorrectionBOList.add(seCorrectionBO);
        }
        rspBO.setData(seCorrectionBOList);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RspUccPageBo<SeCorrectionBO> querySeCorrectionListPage(SeCorrectionReqBO seCorrectionReqBO) {
        if (seCorrectionReqBO.getPageNo() < 1) {
            seCorrectionReqBO.setPageNo(1);
        }
        if (seCorrectionReqBO.getPageSize() < 1) {
            seCorrectionReqBO.setPageSize(10);
        }
        SeCorrectionPO selectSeCorrectionPO = new SeCorrectionPO();
        BeanUtils.copyProperties((Object)seCorrectionReqBO, (Object)selectSeCorrectionPO);
        Page page = PageMethod.startPage((int)seCorrectionReqBO.getPageNo(), (int)seCorrectionReqBO.getPageSize()).doSelectPage(() -> this.seCorrectionMapper.selectByCondition(selectSeCorrectionPO));
        ArrayList<SeCorrectionBO> seCorrectionBOList = new ArrayList<SeCorrectionBO>();
        for (SeCorrectionPO seCorrectionPO : page.getResult()) {
            SeCorrectionBO seCorrectionBO = new SeCorrectionBO();
            BeanUtils.copyProperties((Object)seCorrectionPO, (Object)seCorrectionBO);
            seCorrectionBOList.add(seCorrectionBO);
        }
        RspUccPageBo rspPage = new RspUccPageBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(seCorrectionBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        rspPage.setRespDesc("\u6210\u529f");
        rspPage.setRespCode("0000");
        return rspPage;
    }

    @Transactional
    public SeCorrectionRspBO addSeCorrection(SeCorrectionReqBO seCorrectionReqBO) {
        SeCorrectionRspBO rspBO = new SeCorrectionRspBO();
        SeCorrectionPO insertSeCorrectionPO = new SeCorrectionPO();
        BeanUtils.copyProperties((Object)seCorrectionReqBO, (Object)insertSeCorrectionPO);
        long id = Sequence.getInstance().nextId();
        insertSeCorrectionPO.setId(id);
        int num = this.seCorrectionMapper.insert(insertSeCorrectionPO);
        if (num != 1) {
            throw new SeBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        SeCorrectionBO SeCorrectionBO2 = new SeCorrectionBO();
        BeanUtils.copyProperties((Object)insertSeCorrectionPO, (Object)SeCorrectionBO2);
        rspBO.setData(SeCorrectionBO2);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        this.redisSynonym(this.querySeCorrectionList(new SeCorrectionReqBO()));
        return rspBO;
    }

    @Transactional
    public SeCorrectionRspBO updateSeCorrection(SeCorrectionReqBO seCorrectionReqBO) {
        SeCorrectionPO updateSeCorrectionPO;
        SeCorrectionRspBO rspBO = new SeCorrectionRspBO();
        SeCorrectionPO selectSeCorrectionPO = new SeCorrectionPO();
        selectSeCorrectionPO.setId(seCorrectionReqBO.getId());
        List<SeCorrectionPO> seCorrectionList = this.seCorrectionMapper.selectByCondition(selectSeCorrectionPO);
        if (seCorrectionList.size() == 1) {
            updateSeCorrectionPO = new SeCorrectionPO();
            BeanUtils.copyProperties((Object)seCorrectionReqBO, (Object)updateSeCorrectionPO);
            int num = this.seCorrectionMapper.update(updateSeCorrectionPO);
            if (num != 1) {
                throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (seCorrectionList.size() > 1) {
                throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        SeCorrectionBO seCorrectionBO = new SeCorrectionBO();
        BeanUtils.copyProperties((Object)updateSeCorrectionPO, (Object)seCorrectionBO);
        rspBO.setData(seCorrectionBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        this.redisSynonym(this.querySeCorrectionList(new SeCorrectionReqBO()));
        return rspBO;
    }

    @Transactional
    public SeCorrectionRspBO saveSeCorrection(SeCorrectionReqBO seCorrectionReqBO) {
        if (seCorrectionReqBO.getId() == null) {
            return this.addSeCorrection(seCorrectionReqBO);
        }
        return this.updateSeCorrection(seCorrectionReqBO);
    }

    @Transactional
    public SeCorrectionRspBO deleteSeCorrection(SeCorrectionReqBO seCorrectionReqBO) {
        SeCorrectionRspBO rspBO = new SeCorrectionRspBO();
        SeCorrectionPO selectSeCorrectionPO = new SeCorrectionPO();
        selectSeCorrectionPO.setId(seCorrectionReqBO.getId());
        List<SeCorrectionPO> seCorrectionList = this.seCorrectionMapper.selectByCondition(selectSeCorrectionPO);
        if (seCorrectionList.size() == 1) {
            SeCorrectionPO deleteSeCorrectionPO = new SeCorrectionPO();
            BeanUtils.copyProperties((Object)seCorrectionReqBO, (Object)deleteSeCorrectionPO);
            int num = this.seCorrectionMapper.delete(deleteSeCorrectionPO);
            if (num != 1) {
                throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5220\u9664\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (seCorrectionList.size() > 1) {
                throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        this.redisSynonym(this.querySeCorrectionList(new SeCorrectionReqBO()));
        return rspBO;
    }

    public SeRemoteSynonymRspBo synonymFile() {
        SeRemoteSynonymRspBo seRemoteSynonymRspBo = new SeRemoteSynonymRspBo();
        try {
            byte[] bytes = SeFileUtil.downloadResourceFile((String)this.filePath);
            seRemoteSynonymRspBo.setData(bytes);
            seRemoteSynonymRspBo.setFilename(FilenameUtils.getName((String)this.filePath));
            seRemoteSynonymRspBo.setRespCode("0000");
            seRemoteSynonymRspBo.setRespDesc("\u6210\u529f");
        }
        catch (IOException e) {
            seRemoteSynonymRspBo.setRespCode("8888");
            seRemoteSynonymRspBo.setRespCode("\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
        }
        return seRemoteSynonymRspBo;
    }

    public RspUccBo rewriteFile(SeRemoteSynonymReqBo seRemoteSynonymReqBo) {
        RspUccBo rspBO = new RspUccBo();
        String context = this.redisSynonym(this.querySeCorrectionList(new SeCorrectionReqBO()));
        try {
            SeFileUtil.rewriteFile((String)this.filePath, (String)context);
            if (this.isUploadOss.booleanValue()) {
                ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
                ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
                comUocFileAppBO.setFileName("synonyms.txt");
                comUocFileAppBO.setFileType(".txt");
                comUocFileAppBO.setFile(context.getBytes(StandardCharsets.UTF_8));
                list.add(comUocFileAppBO);
                ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
                reqBO.setFiles(list);
                this.upload(reqBO);
                if (StringUtils.isNotBlank((String)this.updateSynonymsDicts) && StringUtils.isNotBlank((String)this.requestBody)) {
                    try {
                        SearchQaHttpUtil.doPostJson((String)this.updateSynonymsDicts, (String)this.requestBody, (status, json) -> {
                            if (status != 200) {
                                log.error("\u8c03\u7528\u5931\u8d25\uff01");
                                throw new RuntimeException(new Exception("\u65e0\u6cd5\u83b7\u53d6\u6570\u636e"));
                            }
                            return status;
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        }
        catch (IOException e) {
            e.printStackTrace();
            rspBO.setRespDesc("\u5931\u8d25 " + e.getMessage());
            rspBO.setRespCode("8888");
        }
        return rspBO;
    }

    @Bean
    private void init() {
        this.rewriteFile(SeRemoteSynonymReqBo.builder().build());
    }

    private ComUocFileUploadAppRspBO upload(ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = file.getFileName();
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                String httphead = "https://";
                if (path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".png")) {
                    httphead = "http://";
                }
                innerFileUrl = this.accessUrl + path;
                fileUrl = httphead + this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            map.put("innerUrl", innerFileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        return rspBO;
    }

    private String redisSynonym(SeCorrectionListRspBO seCorrectionListRspBO) {
        List data = seCorrectionListRspBO.getData();
        StringBuilder stringBuilder = new StringBuilder();
        Set keys = this.cacheClient.getkeys(this.remoteSynonymRedisKey + "*");
        for (String key : keys) {
            this.cacheClient.delete(key);
        }
        keys = this.cacheClient.getkeys(this.remoteCorrectingRedisKey + "*");
        for (String key : keys) {
            this.cacheClient.delete(key);
        }
        for (SeCorrectionBO seCorrectionBO : data) {
            if (ObjectUtils.isEmpty((Object)seCorrectionBO.getStatus()) || "\u505c\u7528".equals(seCorrectionBO.getStatus())) continue;
            if (seCorrectionBO.getType().equals(String.valueOf(1))) {
                List<String> correctList = this.correctCombination(seCorrectionBO.getCorrectionList(), seCorrectionBO.getSynonymList());
                if (!ObjectUtils.isEmpty(correctList)) {
                    stringBuilder.append(String.join((CharSequence)System.lineSeparator(), correctList));
                    stringBuilder.append(System.lineSeparator());
                }
                this.writeCorrectingRedis(seCorrectionBO.getCorrectionList(), seCorrectionBO.getSynonymList());
                continue;
            }
            List<String> synonymList = this.synonymCombination(seCorrectionBO.getSynonymList());
            if (!ObjectUtils.isEmpty(synonymList)) {
                stringBuilder.append(String.join((CharSequence)System.lineSeparator(), synonymList));
                stringBuilder.append(System.lineSeparator());
            }
            this.writeSynonymRedis(seCorrectionBO.getSynonymList());
        }
        return stringBuilder.toString();
    }

    private void writeSynonymRedis(String synonym) {
        List<String> spiltList = Arrays.asList(synonym.split(","));
        for (int i = 0; i < spiltList.size(); ++i) {
            String key = this.remoteSynonymRedisKey + spiltList.get(i);
            String value = String.join((CharSequence)",", spiltList.subList(0, i)) + (i == 0 || i == spiltList.size() - 1 ? "" : ",") + String.join((CharSequence)",", spiltList.subList(i + 1, spiltList.size()));
            SeCorrectionBO seCorrectionBO = new SeCorrectionBO();
            seCorrectionBO.setSynonymList(value);
            this.cacheClient.set(key, (Object)JSON.toJSONString((Object)seCorrectionBO));
        }
    }

    private void writeCorrectingRedis(String correcting, String synonym) {
        List<String> spiltList = Arrays.asList(synonym.split(","));
        for (int i = 0; i < spiltList.size(); ++i) {
            String key = this.remoteCorrectingRedisKey + spiltList.get(i);
            SeCorrectionBO seCorrectionBO = new SeCorrectionBO();
            seCorrectionBO.setCorrectionList(correcting);
            this.cacheClient.set(key, (Object)JSON.toJSONString((Object)seCorrectionBO));
        }
    }

    private List<String> correctCombination(String correcting, String synonym) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> synonymList = Arrays.asList(synonym.split(","));
        synonymList.forEach(s -> list.add(s + "=>" + correcting));
        return list;
    }

    private List<String> synonymCombination(String synonym) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> splitList = Arrays.asList(synonym.split(","));
        if (splitList.size() <= 1) {
            return list;
        }
        if (splitList.size() <= 2) {
            list.add(synonym);
            return list;
        }
        for (int i = 1; i < splitList.size(); ++i) {
            list.add(splitList.get(0) + "," + splitList.get(i));
        }
        try {
            list.addAll(this.synonymCombination(String.join((CharSequence)",", splitList.subList(1, splitList.size()))));
        }
        catch (UnsupportedOperationException e) {
            throw new SeBusinessException("\u540c\u4e49\u8bcd\u7ec4\u5408\u5c01\u88c5\u5f02\u5e38:" + e.getMessage());
        }
        return list;
    }
}

