/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.behavior.thesaurus;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.RspUccBo;
import com.tydic.se.base.ability.bo.RspUccPageBo;
import com.tydic.se.base.util.SeFileUtil;
import com.tydic.se.behavior.ability.SeInitDicService;
import com.tydic.se.behavior.ability.bo.SeInitDicBO;
import com.tydic.se.behavior.ability.bo.SeInitDicReqBO;
import com.tydic.se.behavior.dao.SeWordMapper;
import com.tydic.se.behavior.po.SeWordPO;
import com.tydic.se.behavior.thesaurus.SeWordService;
import com.tydic.se.behavior.thesaurus.bo.SeRemoteSynonymReqBo;
import com.tydic.se.behavior.thesaurus.bo.SeRemoteSynonymRspBo;
import com.tydic.se.behavior.thesaurus.bo.SeWordBO;
import com.tydic.se.behavior.thesaurus.bo.SeWordListRspBO;
import com.tydic.se.behavior.thesaurus.bo.SeWordReqBO;
import com.tydic.se.behavior.thesaurus.bo.SeWordRspBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SeWordServiceImpl
implements SeWordService {
    private static final Logger log = LoggerFactory.getLogger(SeWordServiceImpl.class);
    @Autowired
    SeWordMapper seWordMapper;
    @Autowired
    SeInitDicService seInitDicService;
    private static boolean rewriteFile = false;
    private String filePath = System.getProperty("user.dir") + "/config/word.txt";

    public SeWordRspBO querySeParticipleSingle(SeWordReqBO seWordReqBO) {
        SeWordRspBO rspBO = new SeWordRspBO();
        SeWordPO selectSeWordPO = new SeWordPO();
        BeanUtils.copyProperties((Object)seWordReqBO, (Object)selectSeWordPO);
        List<SeWordPO> seParticipleList = this.seWordMapper.selectByCondition(selectSeWordPO);
        if (seParticipleList.size() != 1) {
            if (seParticipleList.size() > 1) {
                throw new SeBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        SeWordBO seWordBO = new SeWordBO();
        BeanUtils.copyProperties((Object)seParticipleList.get(0), (Object)seWordBO);
        rspBO.setData(seWordBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public SeWordListRspBO querySeParticipleList(SeWordReqBO seWordReqBO) {
        SeWordListRspBO rspBO = new SeWordListRspBO();
        SeWordPO selectSeWordPO = new SeWordPO();
        BeanUtils.copyProperties((Object)seWordReqBO, (Object)selectSeWordPO);
        List<SeWordPO> seWordPOList = this.seWordMapper.selectByCondition(selectSeWordPO);
        ArrayList<SeWordBO> seWordBOList = new ArrayList<SeWordBO>();
        for (SeWordPO seWordPO : seWordPOList) {
            SeWordBO seWordBO = new SeWordBO();
            BeanUtils.copyProperties((Object)seWordPO, (Object)seWordBO);
            seWordBOList.add(seWordBO);
        }
        rspBO.setData(seWordBOList);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public RspPage<SeWordBO> querySeParticipleListPage(SeWordReqBO seWordReqBO) {
        if (seWordReqBO.getPageNo() < 1) {
            seWordReqBO.setPageNo(1);
        }
        if (seWordReqBO.getPageSize() < 1) {
            seWordReqBO.setPageSize(10);
        }
        SeWordPO selectSeWordPO = new SeWordPO();
        BeanUtils.copyProperties((Object)seWordReqBO, (Object)selectSeWordPO);
        Page page = PageHelper.startPage((int)seWordReqBO.getPageNo(), (int)seWordReqBO.getPageSize()).doSelectPage(() -> this.seWordMapper.selectByCondition(selectSeWordPO));
        ArrayList<SeWordBO> seWordBOList = new ArrayList<SeWordBO>();
        for (SeWordPO seWordPO : page.getResult()) {
            SeWordBO seWordBO = new SeWordBO();
            BeanUtils.copyProperties((Object)seWordPO, (Object)seWordBO);
            seWordBOList.add(seWordBO);
        }
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(seWordBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Transactional
    public SeWordRspBO addSeParticiple(SeWordReqBO seWordReqBO) {
        SeWordRspBO rspBO = new SeWordRspBO();
        SeWordPO insertSeWordPO = new SeWordPO();
        BeanUtils.copyProperties((Object)seWordReqBO, (Object)insertSeWordPO);
        int num = this.seWordMapper.insert(insertSeWordPO);
        if (num != 1) {
            throw new SeBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        SeWordBO SeWordBO2 = new SeWordBO();
        BeanUtils.copyProperties((Object)insertSeWordPO, (Object)SeWordBO2);
        rspBO.setData(SeWordBO2);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @Transactional
    public SeWordRspBO updateSeParticiple(SeWordReqBO seWordReqBO) {
        SeWordPO updateSeWordPO;
        SeWordRspBO rspBO = new SeWordRspBO();
        SeWordPO selectSeWordPO = new SeWordPO();
        selectSeWordPO.setId(seWordReqBO.getId());
        List<SeWordPO> seParticipleList = this.seWordMapper.selectByCondition(selectSeWordPO);
        if (seParticipleList.size() == 1) {
            updateSeWordPO = new SeWordPO();
            BeanUtils.copyProperties((Object)seWordReqBO, (Object)updateSeWordPO);
            int num = this.seWordMapper.update(updateSeWordPO);
            if (num != 1) {
                throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (seParticipleList.size() > 1) {
                throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        SeWordBO seWordBO = new SeWordBO();
        BeanUtils.copyProperties((Object)updateSeWordPO, (Object)seWordBO);
        rspBO.setData(seWordBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @Transactional
    public SeWordRspBO saveSeParticiple(SeWordReqBO seWordReqBO) {
        if (seWordReqBO.getId() == null) {
            return this.addSeParticiple(seWordReqBO);
        }
        return this.updateSeParticiple(seWordReqBO);
    }

    @Transactional
    public SeWordRspBO deleteSeParticiple(SeWordReqBO seWordReqBO) {
        SeWordRspBO rspBO = new SeWordRspBO();
        SeWordPO selectSeWordPO = new SeWordPO();
        selectSeWordPO.setId(seWordReqBO.getId());
        List<SeWordPO> seParticipleList = this.seWordMapper.selectByCondition(selectSeWordPO);
        if (seParticipleList.size() == 1) {
            SeWordPO deleteSeWordPO = new SeWordPO();
            BeanUtils.copyProperties((Object)seWordReqBO, (Object)deleteSeWordPO);
            int num = this.seWordMapper.delete(deleteSeWordPO);
            if (num != 1) {
                throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5220\u9664\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (seParticipleList.size() > 1) {
                throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public SeRemoteSynonymRspBo synonymFile() {
        SeRemoteSynonymRspBo seRemoteSynonymRspBo = new SeRemoteSynonymRspBo();
        try {
            byte[] bytes = SeFileUtil.downloadResourceFile((String)this.filePath);
            seRemoteSynonymRspBo.setData(bytes);
            seRemoteSynonymRspBo.setFilename(FilenameUtils.getName((String)this.filePath));
            seRemoteSynonymRspBo.setRespCode("0000");
            seRemoteSynonymRspBo.setRespDesc("\u6210\u529f");
        }
        catch (IOException e) {
            seRemoteSynonymRspBo.setRespCode("8888");
            seRemoteSynonymRspBo.setRespCode("\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
        }
        return seRemoteSynonymRspBo;
    }

    public RspUccBo rewriteFile(SeRemoteSynonymReqBo seRemoteSynonymReqBo) {
        RspUccBo rspBO = new RspUccBo();
        try {
            int pageNo;
            if (rewriteFile) {
                rspBO.setRespDesc("\u5df2\u7ecf\u5728\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            rewriteFile = true;
            SeInitDicReqBO seInitDicReqBO = new SeInitDicReqBO();
            seInitDicReqBO.setPageNo(pageNo);
            seInitDicReqBO.setPageSize(1000);
            RspUccPageBo seInitDicBOList = this.seInitDicService.querySeInitDicListPage(seInitDicReqBO);
            log.info("\u5206\u8bcd\u9759\u6001\u6587\u4ef6\u751f\u6210\u4e2d\uff0cfilePath=" + this.filePath + "\uff0cpageNo=" + pageNo + "\uff0cpageSize=" + seInitDicReqBO.getPageSize() + "\uff0ctotal=" + seInitDicBOList.getTotal());
            String context = this.convertToString((RspUccPageBo<SeInitDicBO>)seInitDicBOList);
            SeFileUtil.rewriteFile((String)this.filePath, (String)context);
            for (pageNo = 1; pageNo < seInitDicBOList.getTotal(); ++pageNo) {
                seInitDicReqBO.setPageNo(pageNo);
                RspUccPageBo seInitDicBONextList = this.seInitDicService.querySeInitDicListPage(seInitDicReqBO);
                log.info("\u5206\u8bcd\u9759\u6001\u6587\u4ef6\u751f\u6210\u4e2d\uff0cfilePath=" + this.filePath + "\uff0cpageNo=" + pageNo + "\uff0cpageSize=" + seInitDicReqBO.getPageSize() + "\uff0ctotal=" + seInitDicBOList.getTotal());
                String nextContext = this.convertToString((RspUccPageBo<SeInitDicBO>)seInitDicBONextList);
                SeFileUtil.appendFile((String)this.filePath, (String)nextContext);
            }
            log.info("\u5206\u8bcd\u9759\u6001\u6587\u4ef6\u5b8c\u6210\uff0crecordsTotal=" + seInitDicBOList.getRecordsTotal());
            rewriteFile = false;
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        }
        catch (IOException e) {
            rewriteFile = false;
            e.printStackTrace();
            rspBO.setRespDesc("\u5931\u8d25 " + e.getMessage());
            rspBO.setRespCode("8888");
        }
        return rspBO;
    }

    @Bean
    private void init() {
    }

    private String convertToString(RspUccPageBo<SeInitDicBO> seWordListRspBO) {
        List data = seWordListRspBO.getRows();
        StringBuilder stringBuilder = new StringBuilder();
        for (SeInitDicBO seInitDicBO : data) {
            if (!ObjectUtils.isEmpty((Object)seInitDicBO.getStatus()) && "\u505c\u7528".equals(seInitDicBO.getStatus())) continue;
            stringBuilder.append(seInitDicBO.getDic());
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }
}

