/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.behavior.thesaurus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.RspUccBo;
import com.tydic.se.base.ability.bo.RspUccPageBo;
import com.tydic.se.base.util.ExecutorProcessPool;
import com.tydic.se.base.util.SeFileUtil;
import com.tydic.se.behavior.ability.SeInitDicService;
import com.tydic.se.behavior.ability.bo.SeInitDicBO;
import com.tydic.se.behavior.ability.bo.SeInitDicReqBO;
import com.tydic.se.behavior.dao.SeInitDicMapper;
import com.tydic.se.behavior.dao.SeWordMapper;
import com.tydic.se.behavior.po.SeInitDicPO;
import com.tydic.se.behavior.po.SeWordPO;
import com.tydic.se.behavior.thesaurus.CountSqlEnum;
import com.tydic.se.behavior.thesaurus.QuerySqlEnum;
import com.tydic.se.behavior.thesaurus.SeAliWordBO;
import com.tydic.se.behavior.thesaurus.SeAliWordDataBO;
import com.tydic.se.behavior.thesaurus.SeAliWordResultItemBO;
import com.tydic.se.behavior.thesaurus.SeChatResBO;
import com.tydic.se.behavior.thesaurus.SeWordService;
import com.tydic.se.behavior.thesaurus.bo.SeChatGptWordReqBO;
import com.tydic.se.behavior.thesaurus.bo.SeRemoteSynonymReqBo;
import com.tydic.se.behavior.thesaurus.bo.SeRemoteSynonymRspBo;
import com.tydic.se.behavior.thesaurus.bo.SeWordBO;
import com.tydic.se.behavior.thesaurus.bo.SeWordListRspBO;
import com.tydic.se.behavior.thesaurus.bo.SeWordReqBO;
import com.tydic.se.behavior.thesaurus.bo.SeWordRspBO;
import com.tydic.se.behavior.utils.OsworkflowHttpsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class SeWordServiceImpl
implements SeWordService {
    private static final Logger log = LoggerFactory.getLogger(SeWordServiceImpl.class);
    @Autowired
    SeWordMapper seWordMapper;
    @Autowired
    SeInitDicService seInitDicService;
    @Autowired
    SeInitDicMapper seInitDicMapper;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${se.chatUrl:http://39.105.66.173:1818/openai/single/chat}")
    private String chatUrl;
    @Value(value="${sys.nlp.region}")
    private String regionId;
    @Value(value="${sys.nlp.accessKey}")
    private String accessKeyId;
    @Value(value="${sys.nlp.secret}")
    private String secret;
    private static final int PAGE_SIZE = 10;
    private static boolean rewriteFile = false;
    private String filePath = System.getProperty("user.dir") + "/config/word.txt";

    public SeWordRspBO querySeParticipleSingle(SeWordReqBO seWordReqBO) {
        SeWordRspBO rspBO = new SeWordRspBO();
        SeWordPO selectSeWordPO = new SeWordPO();
        BeanUtils.copyProperties((Object)seWordReqBO, (Object)selectSeWordPO);
        List<SeWordPO> seParticipleList = this.seWordMapper.selectByCondition(selectSeWordPO);
        if (seParticipleList.size() != 1) {
            if (seParticipleList.size() > 1) {
                throw new SeBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        SeWordBO seWordBO = new SeWordBO();
        BeanUtils.copyProperties((Object)seParticipleList.get(0), (Object)seWordBO);
        rspBO.setData(seWordBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public SeWordListRspBO querySeParticipleList(SeWordReqBO seWordReqBO) {
        SeWordListRspBO rspBO = new SeWordListRspBO();
        SeWordPO selectSeWordPO = new SeWordPO();
        BeanUtils.copyProperties((Object)seWordReqBO, (Object)selectSeWordPO);
        List<SeWordPO> seWordPOList = this.seWordMapper.selectByCondition(selectSeWordPO);
        ArrayList<SeWordBO> seWordBOList = new ArrayList<SeWordBO>();
        for (SeWordPO seWordPO : seWordPOList) {
            SeWordBO seWordBO = new SeWordBO();
            BeanUtils.copyProperties((Object)seWordPO, (Object)seWordBO);
            seWordBOList.add(seWordBO);
        }
        rspBO.setData(seWordBOList);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public RspPage<SeWordBO> querySeParticipleListPage(SeWordReqBO seWordReqBO) {
        if (seWordReqBO.getPageNo() < 1) {
            seWordReqBO.setPageNo(1);
        }
        if (seWordReqBO.getPageSize() < 1) {
            seWordReqBO.setPageSize(10);
        }
        SeWordPO selectSeWordPO = new SeWordPO();
        BeanUtils.copyProperties((Object)seWordReqBO, (Object)selectSeWordPO);
        Page page = PageHelper.startPage((int)seWordReqBO.getPageNo(), (int)seWordReqBO.getPageSize()).doSelectPage(() -> this.seWordMapper.selectByCondition(selectSeWordPO));
        ArrayList<SeWordBO> seWordBOList = new ArrayList<SeWordBO>();
        for (SeWordPO seWordPO : page.getResult()) {
            SeWordBO seWordBO = new SeWordBO();
            BeanUtils.copyProperties((Object)seWordPO, (Object)seWordBO);
            seWordBOList.add(seWordBO);
        }
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(seWordBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    @Transactional
    public SeWordRspBO addSeParticiple(SeWordReqBO seWordReqBO) {
        SeWordRspBO rspBO = new SeWordRspBO();
        SeWordPO insertSeWordPO = new SeWordPO();
        BeanUtils.copyProperties((Object)seWordReqBO, (Object)insertSeWordPO);
        int num = this.seWordMapper.insert(insertSeWordPO);
        if (num != 1) {
            throw new SeBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        SeWordBO SeWordBO2 = new SeWordBO();
        BeanUtils.copyProperties((Object)insertSeWordPO, (Object)SeWordBO2);
        rspBO.setData(SeWordBO2);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @Transactional
    public SeWordRspBO updateSeParticiple(SeWordReqBO seWordReqBO) {
        SeWordPO updateSeWordPO;
        SeWordRspBO rspBO = new SeWordRspBO();
        SeWordPO selectSeWordPO = new SeWordPO();
        selectSeWordPO.setId(seWordReqBO.getId());
        List<SeWordPO> seParticipleList = this.seWordMapper.selectByCondition(selectSeWordPO);
        if (seParticipleList.size() == 1) {
            updateSeWordPO = new SeWordPO();
            BeanUtils.copyProperties((Object)seWordReqBO, (Object)updateSeWordPO);
            int num = this.seWordMapper.update(updateSeWordPO);
            if (num != 1) {
                throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (seParticipleList.size() > 1) {
                throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        SeWordBO seWordBO = new SeWordBO();
        BeanUtils.copyProperties((Object)updateSeWordPO, (Object)seWordBO);
        rspBO.setData(seWordBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @Transactional
    public SeWordRspBO saveSeParticiple(SeWordReqBO seWordReqBO) {
        if (seWordReqBO.getId() == null) {
            return this.addSeParticiple(seWordReqBO);
        }
        return this.updateSeParticiple(seWordReqBO);
    }

    @Transactional
    public SeWordRspBO deleteSeParticiple(SeWordReqBO seWordReqBO) {
        SeWordRspBO rspBO = new SeWordRspBO();
        SeWordPO selectSeWordPO = new SeWordPO();
        selectSeWordPO.setId(seWordReqBO.getId());
        List<SeWordPO> seParticipleList = this.seWordMapper.selectByCondition(selectSeWordPO);
        if (seParticipleList.size() == 1) {
            SeWordPO deleteSeWordPO = new SeWordPO();
            BeanUtils.copyProperties((Object)seWordReqBO, (Object)deleteSeWordPO);
            int num = this.seWordMapper.delete(deleteSeWordPO);
            if (num != 1) {
                throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5220\u9664\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (seParticipleList.size() > 1) {
                throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new SeBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public SeRemoteSynonymRspBo synonymFile() {
        SeRemoteSynonymRspBo seRemoteSynonymRspBo = new SeRemoteSynonymRspBo();
        try {
            byte[] bytes = SeFileUtil.downloadResourceFile((String)this.filePath);
            seRemoteSynonymRspBo.setData(bytes);
            seRemoteSynonymRspBo.setFilename(FilenameUtils.getName((String)this.filePath));
            seRemoteSynonymRspBo.setRespCode("0000");
            seRemoteSynonymRspBo.setRespDesc("\u6210\u529f");
        }
        catch (IOException e) {
            seRemoteSynonymRspBo.setRespCode("8888");
            seRemoteSynonymRspBo.setRespCode("\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
        }
        return seRemoteSynonymRspBo;
    }

    public RspUccBo rewriteFile(SeRemoteSynonymReqBo seRemoteSynonymReqBo) {
        RspUccBo rspBO = new RspUccBo();
        try {
            int pageNo;
            if (rewriteFile) {
                rspBO.setRespDesc("\u5df2\u7ecf\u5728\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                rspBO.setRespCode("8888");
                return rspBO;
            }
            rewriteFile = true;
            SeInitDicReqBO seInitDicReqBO = new SeInitDicReqBO();
            seInitDicReqBO.setPageNo(pageNo);
            seInitDicReqBO.setPageSize(1000);
            RspUccPageBo seInitDicBOList = this.seInitDicService.querySeInitDicListPage(seInitDicReqBO);
            log.info("\u5206\u8bcd\u9759\u6001\u6587\u4ef6\u751f\u6210\u4e2d\uff0cfilePath=" + this.filePath + "\uff0cpageNo=" + pageNo + "\uff0cpageSize=" + seInitDicReqBO.getPageSize() + "\uff0ctotal=" + seInitDicBOList.getTotal());
            String context = this.convertToString((RspUccPageBo<SeInitDicBO>)seInitDicBOList);
            SeFileUtil.rewriteFile((String)this.filePath, (String)context);
            for (pageNo = 1; pageNo < seInitDicBOList.getTotal(); ++pageNo) {
                seInitDicReqBO.setPageNo(pageNo);
                RspUccPageBo seInitDicBONextList = this.seInitDicService.querySeInitDicListPage(seInitDicReqBO);
                log.info("\u5206\u8bcd\u9759\u6001\u6587\u4ef6\u751f\u6210\u4e2d\uff0cfilePath=" + this.filePath + "\uff0cpageNo=" + pageNo + "\uff0cpageSize=" + seInitDicReqBO.getPageSize() + "\uff0ctotal=" + seInitDicBOList.getTotal());
                String nextContext = this.convertToString((RspUccPageBo<SeInitDicBO>)seInitDicBONextList);
                SeFileUtil.appendFile((String)this.filePath, (String)nextContext);
            }
            log.info("\u5206\u8bcd\u9759\u6001\u6587\u4ef6\u5b8c\u6210\uff0crecordsTotal=" + seInitDicBOList.getRecordsTotal());
            rewriteFile = false;
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        }
        catch (IOException e) {
            rewriteFile = false;
            e.printStackTrace();
            rspBO.setRespDesc("\u5931\u8d25 " + e.getMessage());
            rspBO.setRespCode("8888");
        }
        return rspBO;
    }

    public RspUccBo aliWord(SeChatGptWordReqBO seChatGptWordReqBO) {
        RspUccBo rspBO = new RspUccBo();
        int counter = (Integer)this.jdbcTemplate.queryForObject(CountSqlEnum.COMMODITY.getSql(), Integer.class);
        int totalPage = counter % 10 == 0 ? counter / 10 : counter / 10 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        Integer startPage = seChatGptWordReqBO.getStartPage();
        while (startPage < totalPage) {
            StringBuilder sb = new StringBuilder();
            String querySql = QuerySqlEnum.COMMODITY.getSql() + startPage * 10 + "," + 10;
            log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",,\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
            try {
                SqlRowSet rs = this.jdbcTemplate.queryForRowSet(querySql);
                while (rs.next()) {
                    String name = rs.getString(1);
                    if (StringUtils.isEmpty((CharSequence)name)) continue;
                    sb.append(name);
                    sb.append("\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String content = "";
            DefaultProfile defaultProfile = DefaultProfile.getProfile((String)this.regionId, (String)this.accessKeyId, (String)this.secret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)defaultProfile);
            CommonRequest request = new CommonRequest();
            request.setDomain("alinlp.cn-hangzhou.aliyuncs.com");
            request.setVersion("2020-06-29");
            request.setSysAction("GetWsCustomizedChEcomTitle");
            request.putQueryParameter("ServiceCode", "alinlp");
            request.putQueryParameter("Text", sb.toString());
            request.putQueryParameter("TokenizerId", "MAINSE");
            try {
                CommonResponse response = client.getCommonResponse(request);
                String data = response.getData();
                log.info("content:" + data);
                SeAliWordBO seAliWordBO = (SeAliWordBO)JSON.parseObject((String)data, SeAliWordBO.class);
                SeAliWordDataBO seAliWordDataBO = (SeAliWordDataBO)JSON.parseObject((String)seAliWordBO.getData(), SeAliWordDataBO.class);
                ArrayList<String> selectList = new ArrayList<String>();
                for (SeAliWordResultItemBO seAliWordResultItemBO : seAliWordDataBO.getResult()) {
                    if (seAliWordResultItemBO.getWord().length() <= 1 || selectList.contains(seAliWordResultItemBO.getWord())) continue;
                    selectList.add(seAliWordResultItemBO.getWord());
                }
                List<SeInitDicPO> seInitDicBOList = this.seInitDicMapper.selectSeInitDicListByDic(selectList);
                ArrayList<SeInitDicReqBO> insertList = new ArrayList<SeInitDicReqBO>();
                for (String word : selectList) {
                    Boolean wordExist = false;
                    if (seInitDicBOList != null && seInitDicBOList.size() > 0) {
                        for (SeInitDicPO seInitDicPO : seInitDicBOList) {
                            if (!word.equals(seInitDicPO.getDic())) continue;
                            log.info("\u5df2\u5b58\u5728[" + seInitDicPO.getDic() + "]\u5206\u8bcd\uff0c\u4e0d\u5165\u5e93");
                            wordExist = true;
                            break;
                        }
                    }
                    if (wordExist.booleanValue()) continue;
                    SeInitDicReqBO insertSeInitDicReqBO = new SeInitDicReqBO();
                    insertSeInitDicReqBO.setDic(word);
                    insertSeInitDicReqBO.setCreateTime(new Date());
                    insertSeInitDicReqBO.setType("ncl");
                    insertSeInitDicReqBO.setSource("alinlp");
                    insertSeInitDicReqBO.setRemark("alinlp\u5206\u6790\u5206\u8bcd");
                    insertList.add(insertSeInitDicReqBO);
                }
                if (insertList != null && insertList.size() > 0) {
                    this.seInitDicMapper.addAll(insertList);
                }
                Integer n = startPage;
                Integer n2 = startPage = Integer.valueOf(startPage + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RspUccBo chatGptWord(Integer startPage) {
        RspUccBo rspBO = new RspUccBo();
        int counter = (Integer)this.jdbcTemplate.queryForObject(CountSqlEnum.COMMODITY.getSql(), Integer.class);
        int totalPage = counter % 10 == 0 ? counter / 10 : counter / 10 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        while (startPage < totalPage) {
            StringBuilder sb = new StringBuilder();
            sb.append("\u8981\u6c42\uff1a\u628a\u4ee5\u4e0b\u3010\u5185\u5bb9\u3011\u91cc\u9762\u7684\u5546\u54c1\u540d\u79f0\uff0c\u7528\u4e2d\u6587\u8bed\u4e49\u505a\u4e00\u4e0b\u5206\u8bcd\uff0c\u5e76\u4e14\u53bb\u9664\u91cd\u590d\u7684\u5206\u8bcd\u5185\u5bb9\u3002\n");
            sb.append("\u5185\u5bb9\uff1a\n");
            String querySql = QuerySqlEnum.COMMODITY.getSql() + startPage * 10 + "," + 10;
            log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",,\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
            try {
                SqlRowSet rs = this.jdbcTemplate.queryForRowSet(querySql);
                while (rs.next()) {
                    String name = rs.getString(1);
                    if (StringUtils.isEmpty((CharSequence)name)) continue;
                    sb.append(name);
                    sb.append("\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sb.append("\n\u8f93\u51fa\u683c\u5f0f\uff1a\n\u5206\u8bcd1\n\u5206\u8bcd2\n\u5206\u8bcd3");
            String content = "";
            try {
                JSONObject reqJson = new JSONObject();
                reqJson.put("req", (Object)sb.toString());
                content = OsworkflowHttpsUtil.sendPost((String)this.chatUrl, (String)reqJson.toJSONString());
                log.info("content:" + content);
                SeChatResBO seChatResBO = (SeChatResBO)JSON.parseObject((String)content, SeChatResBO.class);
                String answerJson = seChatResBO.getAnswer();
                String[] nameList = answerJson.split("\\n");
                System.out.println("\u5206\u8bcd\u5982\u4e0b\uff1a");
                for (String name : nameList) {
                    SeInitDicReqBO insertSeInitDicReqBO = new SeInitDicReqBO();
                    insertSeInitDicReqBO.setCreateTime(new Date());
                    insertSeInitDicReqBO.setDic(name);
                    insertSeInitDicReqBO.setType("ncl");
                    insertSeInitDicReqBO.setSource("chatGPT");
                    insertSeInitDicReqBO.setRemark("chatGPT\u5206\u6790\u5206\u8bcd");
                    this.seInitDicService.addSeInitDic(insertSeInitDicReqBO);
                }
                Integer object = startPage;
                Integer n = startPage = Integer.valueOf(startPage + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Bean
    private void init() {
        Runnable run = () -> {
            log.info("\u521d\u59cb\u5316\u5206\u8bcd\u9759\u6001\u6587\u4ef6\u4e2d...");
            this.rewriteFile(new SeRemoteSynonymReqBo());
            log.info("\u521d\u59cb\u5316\u5206\u8bcd\u9759\u6001\u6587\u4ef6\u5b8c\u6210\u3002");
        };
        ExecutorProcessPool.getInstance().executeByCustomThread(run);
    }

    private String convertToString(RspUccPageBo<SeInitDicBO> seWordListRspBO) {
        List data = seWordListRspBO.getRows();
        StringBuilder stringBuilder = new StringBuilder();
        for (SeInitDicBO seInitDicBO : data) {
            if (!ObjectUtils.isEmpty((Object)seInitDicBO.getStatus()) && "\u505c\u7528".equals(seInitDicBO.getStatus())) continue;
            stringBuilder.append(seInitDicBO.getDic());
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }
}

