/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.behavior.impl;

import com.alibaba.fastjson.JSON;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.se.behavior.api.SeBehaviorLogAbilityService;
import com.tydic.se.behavior.api.bo.SeAddPurchaseInLogBO;
import com.tydic.se.behavior.api.bo.SeAddPurchaseInLogRspBO;
import com.tydic.se.behavior.api.bo.SeAddPurchaseOutLogBO;
import com.tydic.se.behavior.api.bo.SeCollectionInLogBO;
import com.tydic.se.behavior.api.bo.SeCollectionInLogRspBO;
import com.tydic.se.behavior.api.bo.SeCommDetailInLogBO;
import com.tydic.se.behavior.api.bo.SeCommDetailInLogRspBO;
import com.tydic.se.behavior.api.bo.SeCommDetailOutLogBO;
import com.tydic.se.behavior.api.bo.SeSearchInLogBO;
import com.tydic.se.behavior.api.bo.SeSearchInLogRspBO;
import com.tydic.se.behavior.api.bo.SeSearchOutLogBO;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"search-engine-group/3.0.0/com.tydic.se.behavior.api.SeBehaviorLogAbilityService"})
public class SeBehaviorLogAbilityServiceImpl
implements SeBehaviorLogAbilityService {
    @Value(value="${aop.maxParamOutSize:500}")
    private Integer MAX_PARAM_OUT_SIZE;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverName;
    private static final Logger logger = LoggerFactory.getLogger(SeBehaviorLogAbilityServiceImpl.class);

    @PostMapping(value={"putSearchInLog"})
    public SeSearchInLogRspBO putSearchInLog(@RequestBody SeSearchInLogBO reqBO) {
        String jsonStr = JSON.toJSONString((Object)reqBO);
        if (jsonStr.length() > this.MAX_PARAM_OUT_SIZE) {
            jsonStr = jsonStr.substring(0, this.MAX_PARAM_OUT_SIZE) + "......";
        }
        logger.info("\u641c\u7d22\u7528\u6237\u884c\u4e3a\u8bb0\u5f55\uff0c\u5165\u53c2:{}", (Object)jsonStr);
        SeSearchInLogRspBO rspBO = new SeSearchInLogRspBO();
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String yearMonth = now.format(formatter);
        Long searchId = reqBO.getSearchId();
        if (reqBO.getSearchId() == null) {
            searchId = Sequence.getInstance().nextId();
        }
        Long traceId = Sequence.getInstance().nextId();
        Record record = new Record();
        record.set("TRACE_ID", (Object)traceId);
        record.set("SEARCH_ID", (Object)searchId);
        record.set("CREATE_TIME", (Object)new Date());
        record.set("PAGE_NO", (Object)reqBO.getPageNo());
        record.set("PAGE_SIZE", (Object)reqBO.getPageSize());
        record.set("QUERY_STR", (Object)reqBO.getQueryStr());
        record.set("QUERY_CHANNEL_ID", (Object)reqBO.getQueryChannelId());
        record.set("LEVEL", (Object)reqBO.getLevel());
        record.set("BRAND_ID", (Object)reqBO.getBrandId());
        record.set("SUPPLIER_SHOP_ID", (Object)reqBO.getSupplierShopId());
        record.set("ORDER_BY_COLUMN", (Object)reqBO.getOrderByColumn());
        record.set("ORDER_TYPE", (Object)reqBO.getOrderType());
        record.set("QUERY_FILTER_LIST", (Object)reqBO.getQueryFilterList());
        record.set("QUERY_PROPERTY_LIST", (Object)reqBO.getQueryPropertyList());
        record.set("MIN_SALE_PRICE", (Object)reqBO.getMinSalePrice());
        record.set("MAX_SALE_PRICE", (Object)reqBO.getMaxSalePrice());
        record.set("MUST_TERMS_LIST", (Object)reqBO.getMustTermsList());
        record.set("MUST_NOT_TERMS_LIST", (Object)reqBO.getMustNotTermsList());
        record.set("SHOULD_LIST", (Object)reqBO.getShouldList());
        record.set("SHOULD_NOT_LIST", (Object)reqBO.getShouldNotList());
        record.set("AGREEMENT_ID", (Object)reqBO.getAgreementId());
        record.set("ORG_PATH", (Object)reqBO.getOrgPath());
        record.set("ORG_ID_IN", (Object)reqBO.getOrgIdIn());
        record.set("USER_ID", (Object)(reqBO.getUserId() + ""));
        record.set("USER_PERMISSION", (Object)reqBO.getUserPermission());
        record.set("ACTIVITY_ID", (Object)reqBO.getActivityId());
        record.set("COMPANY_ID", (Object)reqBO.getCompanyId());
        record.set("COMMODITY_TYPE_IDS", (Object)reqBO.getCommodityTypeIds());
        record.set("ACCURACY_FLAG", (Object)reqBO.getAccuracyFlag());
        if (this.driverName.contains("dm")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sdf.format(record.getDate("CREATE_TIME"));
            Long traceIdVal = traceId;
            Long searchIdVal = searchId;
            String createTimeVal = "TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS')";
            String pageNoVal = this.processStringField(reqBO.getPageNo());
            String pageSizeVal = this.processStringField(reqBO.getPageSize());
            String queryStrVal = this.processStringField(reqBO.getQueryStr());
            String queryChannelIdVal = this.processStringField(reqBO.getQueryChannelId());
            String levelVal = this.processStringField(reqBO.getLevel());
            String brandIdVal = this.processStringField(reqBO.getBrandId());
            String supplierShopIdVal = this.processStringField(reqBO.getSupplierShopId());
            String orderByColumnVal = this.processStringField(reqBO.getOrderByColumn());
            String orderTypeVal = this.processStringField(reqBO.getOrderType());
            String queryFilterListVal = this.processStringField(reqBO.getQueryFilterList());
            String queryPropertyListVal = this.processStringField(reqBO.getQueryPropertyList());
            String minSalePriceVal = this.processStringField(reqBO.getMinSalePrice());
            String maxSalePriceVal = this.processStringField(reqBO.getMaxSalePrice());
            String mustTermsListVal = this.processStringField(reqBO.getMustTermsList());
            String mustNotTermsListVal = this.processStringField(reqBO.getMustNotTermsList());
            String shouldListVal = this.processStringField(reqBO.getShouldList());
            String shouldNotListVal = this.processStringField(reqBO.getShouldNotList());
            String agreementIdVal = this.processStringField(reqBO.getAgreementId());
            String orgPathVal = this.processStringField(reqBO.getOrgPath());
            String orgIdInVal = this.processStringField(reqBO.getOrgIdIn());
            String userIdVal = this.processStringField(reqBO.getUserId() + "");
            String userPermissionVal = this.processStringField(reqBO.getUserPermission());
            String activityIdVal = this.processStringField(reqBO.getActivityId());
            String companyIdVal = this.processStringField(reqBO.getCompanyId());
            String commodityTypeIdsVal = this.processStringField(reqBO.getCommodityTypeIds());
            String accuracyFlagVal = this.processStringField(reqBO.getAccuracyFlag());
            String insertSql = "INSERT INTO STAND_SE_IN_LOG (TRACE_ID, SEARCH_ID, CREATE_TIME, PAGE_NO, PAGE_SIZE, QUERY_STR, QUERY_CHANNEL_ID, LEVEL, BRAND_ID, SUPPLIER_SHOP_ID, ORDER_BY_COLUMN, ORDER_TYPE, QUERY_FILTER_LIST, QUERY_PROPERTY_LIST, MIN_SALE_PRICE, MAX_SALE_PRICE, MUST_TERMS_LIST, MUST_NOT_TERMS_LIST, SHOULD_LIST, SHOULD_NOT_LIST, AGREEMENT_ID, ORG_PATH, ORG_ID_IN, USER_ID, USER_PERMISSION, ACTIVITY_ID, COMPANY_ID, COMMODITY_TYPE_IDS, ACCURACY_FLAG) VALUES (" + traceIdVal + ", " + searchIdVal + ", " + createTimeVal + ", " + pageNoVal + ", " + pageSizeVal + ", " + queryStrVal + ", " + queryChannelIdVal + ", " + levelVal + ", " + brandIdVal + ", " + supplierShopIdVal + ", " + orderByColumnVal + ", " + orderTypeVal + ", " + queryFilterListVal + ", " + queryPropertyListVal + ", " + minSalePriceVal + ", " + maxSalePriceVal + ", " + mustTermsListVal + ", " + mustNotTermsListVal + ", " + shouldListVal + ", " + shouldNotListVal + ", " + agreementIdVal + ", " + orgPathVal + ", " + orgIdInVal + ", " + userIdVal + ", " + userPermissionVal + ", " + activityIdVal + ", " + companyIdVal + ", " + commodityTypeIdsVal + ", " + accuracyFlagVal + ")";
            Db.use((String)"DATAPLAT").update(insertSql);
        } else {
            Db.use((String)"DATAPLAT").save("stand_se_in_log", record);
        }
        rspBO.setSearchId(searchId);
        rspBO.setTraceId(traceId);
        return rspBO;
    }

    @PostMapping(value={"putSearchOutLog"})
    public void putSearchOutLog(@RequestBody SeSearchOutLogBO reqBO) {
        String jsonStr = JSON.toJSONString((Object)reqBO);
        if (jsonStr.length() > this.MAX_PARAM_OUT_SIZE) {
            jsonStr = jsonStr.substring(0, this.MAX_PARAM_OUT_SIZE) + "......";
        }
        logger.info("\u641c\u7d22\u7528\u6237\u884c\u4e3a\u8bb0\u5f55\uff0c\u51fa\u53c2:{}", (Object)jsonStr);
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String yearMonth = now.format(formatter);
        Record record1 = new Record();
        record1.set("TRACE_ID", (Object)reqBO.getTraceId());
        record1.set("SEARCH_ID", (Object)reqBO.getSearchId());
        record1.set("CREATE_TIME", (Object)new Date());
        record1.set("PAGE_NO", (Object)reqBO.getPageNo());
        record1.set("PAGE_SIZE", (Object)reqBO.getPageSize());
        record1.set("RECORDS_TOTAL", (Object)reqBO.getRecordsTotal());
        record1.set("TOTAL", (Object)reqBO.getTotal());
        record1.set("RESULT", (Object)reqBO.getResult());
        if (this.driverName.contains("dm")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sdf.format(record1.getDate("CREATE_TIME"));
            Long traceIdVal = reqBO.getTraceId();
            Long searchIdVal = reqBO.getSearchId();
            String createTimeVal = "TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS')";
            String pageNoVal = this.processStringField(reqBO.getPageNo());
            String pageSizeVal = this.processStringField(reqBO.getPageSize());
            String recordsTotalVal = this.processStringField(reqBO.getRecordsTotal());
            String totalVal = this.processStringField(reqBO.getTotal());
            String resultVal = this.processStringField(reqBO.getResult());
            String insertSql = "INSERT INTO STAND_SE_OUT_LOG (TRACE_ID, SEARCH_ID, CREATE_TIME, PAGE_NO, PAGE_SIZE, RECORDS_TOTAL, TOTAL, RESULT) VALUES (" + traceIdVal + ", " + searchIdVal + ", " + createTimeVal + ", " + pageNoVal + ", " + pageSizeVal + ", " + recordsTotalVal + ", " + totalVal + ", " + resultVal + ")";
            Db.use((String)"DATAPLAT").update(insertSql);
        } else {
            Db.use((String)"DATAPLAT").save("stand_se_out_log", record1);
        }
    }

    @PostMapping(value={"putAddPurchaseInLog"})
    public SeAddPurchaseInLogRspBO putAddPurchaseInLog(@RequestBody SeAddPurchaseInLogBO reqBO) {
        String jsonStr = JSON.toJSONString((Object)reqBO);
        if (jsonStr.length() > this.MAX_PARAM_OUT_SIZE) {
            jsonStr = jsonStr.substring(0, this.MAX_PARAM_OUT_SIZE) + "......";
        }
        logger.info("\u52a0\u8d2d\u65e5\u5fd7\u5165\u53c2:{}", (Object)jsonStr);
        SeAddPurchaseInLogRspBO rspBO = new SeAddPurchaseInLogRspBO();
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String yearMonth = now.format(formatter);
        Long addId = Sequence.getInstance().nextId();
        Record record1 = new Record();
        record1.set("ADD_ID", (Object)addId);
        record1.set("TRACE_ID", (Object)reqBO.getTraceId());
        record1.set("SEARCH_ID", (Object)reqBO.getSearchId());
        record1.set("CREATE_TIME", (Object)new Date());
        record1.set("SKU_ID", (Object)reqBO.getSkuId());
        record1.set("USER_ID", (Object)(reqBO.getUserId() + ""));
        record1.set("USER_PERMISSION", (Object)reqBO.getUserPermission());
        record1.set("ORG_PATH", (Object)reqBO.getOrgPath());
        record1.set("ORG_ID_IN", (Object)reqBO.getOrgIdIn());
        record1.set("USER_ID_IN", (Object)reqBO.getUserIdIn());
        record1.set("ADD_GOODS", (Object)reqBO.getAddGoods());
        record1.set("PROVINCE", (Object)reqBO.getProvince());
        record1.set("CITY", (Object)reqBO.getCity());
        record1.set("COUNTY", (Object)reqBO.getCounty());
        record1.set("TOWN", (Object)reqBO.getTown());
        if (this.driverName.contains("dm")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sdf.format(record1.getDate("CREATE_TIME"));
            Long addIdVal = addId;
            Long traceIdVal = reqBO.getTraceId();
            Long searchIdVal = reqBO.getSearchId();
            String createTimeVal = "TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS')";
            String skuIdVal = this.processStringField(reqBO.getSkuId());
            String userIdVal = this.processStringField(reqBO.getUserId() + "");
            String userPermissionVal = this.processStringField(reqBO.getUserPermission());
            String orgPathVal = this.processStringField(reqBO.getOrgPath());
            String orgIdInVal = this.processStringField(reqBO.getOrgIdIn());
            String userIdInVal = this.processStringField(reqBO.getUserIdIn());
            String addGoodsVal = this.processStringField(reqBO.getAddGoods());
            String provinceVal = this.processStringField(reqBO.getProvince());
            String cityVal = this.processStringField(reqBO.getCity());
            String countyVal = this.processStringField(reqBO.getCounty());
            String townVal = this.processStringField(reqBO.getTown());
            String insertSql = "INSERT INTO STAND_SE_ADD_PURCHASE_IN_LOG (ADD_ID, TRACE_ID, SEARCH_ID, CREATE_TIME, SKU_ID, USER_ID, USER_PERMISSION, ORG_PATH, ORG_ID_IN, USER_ID_IN, ADD_GOODS, PROVINCE, CITY, COUNTY, TOWN) VALUES (" + addIdVal + ", " + traceIdVal + ", " + searchIdVal + ", " + createTimeVal + ", " + skuIdVal + ", " + userIdVal + ", " + userPermissionVal + ", " + orgPathVal + ", " + orgIdInVal + ", " + userIdInVal + ", " + addGoodsVal + ", " + provinceVal + ", " + cityVal + ", " + countyVal + ", " + townVal + ")";
            Db.use((String)"DATAPLAT").update(insertSql);
        } else {
            Db.use((String)"DATAPLAT").save("stand_se_add_purchase_in_log", record1);
        }
        rspBO.setAddId(addId);
        rspBO.setSearchId(reqBO.getSearchId());
        rspBO.setTraceId(reqBO.getTraceId());
        return rspBO;
    }

    @PostMapping(value={"putAddPurchaseOutLog"})
    public void putAddPurchaseOutLog(@RequestBody SeAddPurchaseOutLogBO reqBO) {
        String jsonStr = JSON.toJSONString((Object)reqBO);
        if (jsonStr.length() > this.MAX_PARAM_OUT_SIZE) {
            jsonStr = jsonStr.substring(0, this.MAX_PARAM_OUT_SIZE) + "......";
        }
        logger.info("\u52a0\u8d2d\u65e5\u5fd7\u51fa\u53c2:{}", (Object)jsonStr);
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String yearMonth = now.format(formatter);
        Record record1 = new Record();
        record1.set("ADD_ID", (Object)reqBO.getAddId());
        record1.set("TRACE_ID", (Object)reqBO.getTraceId());
        record1.set("SEARCH_ID", (Object)reqBO.getSearchId());
        record1.set("CREATE_TIME", (Object)new Date());
        record1.set("TIP_SUCCES_FLAG", (Object)reqBO.getTipSuccesFlag());
        record1.set("SKU_ID_MAP", (Object)reqBO.getSkuIdMap());
        if (this.driverName.contains("dm")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sdf.format(record1.getDate("CREATE_TIME"));
            Long addIdVal = reqBO.getAddId();
            String traceIdVal = this.processStringField(reqBO.getTraceId());
            String searchIdVal = this.processStringField(reqBO.getSearchId());
            String createTimeVal = "TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS')";
            String tipSuccessFlagVal = this.processStringField(reqBO.getTipSuccesFlag());
            String skuIdMapVal = reqBO.getSkuIdMap();
            if (StringUtils.isBlank((CharSequence)skuIdMapVal)) {
                skuIdMapVal = "''";
            }
            String insertSql = "INSERT INTO STAND_SE_ADD_PURCHASE_OUT_LOG (ADD_ID, TRACE_ID, SEARCH_ID, CREATE_TIME, TIP_SUCCES_FLAG, SKU_ID_MAP) VALUES (" + addIdVal + ", " + traceIdVal + ", " + searchIdVal + ", " + createTimeVal + ", " + tipSuccessFlagVal + ", " + skuIdMapVal + ")";
            Db.use((String)"DATAPLAT").update(insertSql);
        } else {
            Db.use((String)"DATAPLAT").save("stand_se_add_purchase_out_log", record1);
        }
    }

    @PostMapping(value={"putCommDetailInLog"})
    public SeCommDetailInLogRspBO putCommDetailInLog(@RequestBody SeCommDetailInLogBO reqBO) {
        String jsonStr = JSON.toJSONString((Object)reqBO);
        if (jsonStr.length() > this.MAX_PARAM_OUT_SIZE) {
            jsonStr = jsonStr.substring(0, this.MAX_PARAM_OUT_SIZE) + "......";
        }
        logger.info("\u8be6\u60c5\u65e5\u5fd7\u5165\u53c2:{}", (Object)jsonStr);
        SeCommDetailInLogRspBO rspBO = new SeCommDetailInLogRspBO();
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String yearMonth = now.format(formatter);
        Long detailId = Sequence.getInstance().nextId();
        Record record = new Record();
        record.set("DETAIL_ID", (Object)detailId);
        record.set("TRACE_ID", (Object)reqBO.getTraceId());
        record.set("SEARCH_ID", (Object)reqBO.getSearchId());
        record.set("CREATE_TIME", (Object)new Date());
        record.set("USER_ID", (Object)(reqBO.getUserId() + ""));
        record.set("USER_PERMISSION", (Object)reqBO.getUserPermission());
        record.set("PROVINCE", (Object)reqBO.getProvince());
        record.set("CITY", (Object)reqBO.getCity());
        record.set("COUNTY", (Object)reqBO.getCounty());
        record.set("TOWN", (Object)reqBO.getTown());
        record.set("RECORDS_TOTAL", (Object)reqBO.getRecordsTotal());
        record.set("TOTAL", (Object)reqBO.getTotal());
        record.set("SUPPLIER_SHOP_ID", (Object)reqBO.getSupplierShopId());
        record.set("SKU_ID", (Object)reqBO.getSkuId());
        record.set("NUM", (Object)reqBO.getNum());
        record.set("COMPANY_ID", (Object)reqBO.getCompanyId());
        if (this.driverName.contains("dm")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sdf.format(record.getDate("CREATE_TIME"));
            Long detailIdVal = detailId;
            Long traceIdVal = reqBO.getTraceId();
            Long searchIdVal = reqBO.getSearchId();
            String createTimeVal = "TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS')";
            String userIdVal = this.processStringField(reqBO.getUserId() + "");
            String userPermissionVal = this.processStringField(reqBO.getUserPermission());
            String provinceVal = this.processStringField(reqBO.getProvince());
            String cityVal = this.processStringField(reqBO.getCity());
            String countyVal = this.processStringField(reqBO.getCounty());
            String townVal = this.processStringField(reqBO.getTown());
            String recordsTotalVal = this.processStringField(reqBO.getRecordsTotal());
            String totalVal = this.processStringField(reqBO.getTotal());
            String supplierShopIdVal = this.processStringField(reqBO.getSupplierShopId());
            String skuIdVal = this.processStringField(reqBO.getSkuId());
            String numVal = this.processStringField(reqBO.getNum());
            String companyIdVal = this.processStringField(reqBO.getCompanyId());
            String insertSql = "INSERT INTO STAND_SE_COMM_DETAIL_IN_LOG (DETAIL_ID, TRACE_ID, SEARCH_ID, CREATE_TIME, USER_ID, USER_PERMISSION, PROVINCE, CITY, COUNTY, TOWN, RECORDS_TOTAL, TOTAL, SUPPLIER_SHOP_ID, SKU_ID, NUM, COMPANY_ID) VALUES (" + detailIdVal + ", " + traceIdVal + ", " + searchIdVal + ", " + createTimeVal + ", " + userIdVal + ", " + userPermissionVal + ", " + provinceVal + ", " + cityVal + ", " + countyVal + ", " + townVal + ", " + recordsTotalVal + ", " + totalVal + ", " + supplierShopIdVal + ", " + skuIdVal + ", " + numVal + ", " + companyIdVal + ")";
            Db.use((String)"DATAPLAT").update(insertSql);
        } else {
            Db.use((String)"DATAPLAT").save("stand_se_comm_detail_in_log", record);
        }
        rspBO.setDetailId(detailId);
        rspBO.setSearchId(reqBO.getSearchId());
        rspBO.setTraceId(reqBO.getTraceId());
        return rspBO;
    }

    @PostMapping(value={"putCommDetailOutLog"})
    public void putCommDetailOutLog(@RequestBody SeCommDetailOutLogBO reqBO) {
        String jsonStr = JSON.toJSONString((Object)reqBO);
        if (jsonStr.length() > this.MAX_PARAM_OUT_SIZE) {
            jsonStr = jsonStr.substring(0, this.MAX_PARAM_OUT_SIZE) + "......";
        }
        logger.info("\u8be6\u60c5\u65e5\u5fd7\u51fa\u53c2:{}", (Object)jsonStr);
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String yearMonth = now.format(formatter);
        Record record1 = new Record();
        record1.set("DETAIL_ID", (Object)reqBO.getDetailId());
        record1.set("TRACE_ID", (Object)reqBO.getTraceId());
        record1.set("SEARCH_ID", (Object)reqBO.getSearchId());
        record1.set("CREATE_TIME", (Object)new Date());
        record1.set("COMMD_DETAILS_INFO", (Object)reqBO.getCommdDetailsInfo());
        record1.set("SKU_INFO_SALE_NUM", (Object)reqBO.getSkuInfoSaleNum());
        record1.set("ENT_AGREEMENT_CODE", (Object)reqBO.getEntAgreementCode());
        if (this.driverName.contains("dm")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sdf.format(record1.getDate("CREATE_TIME"));
            Long detailIdVal = reqBO.getDetailId();
            Long traceIdVal = reqBO.getTraceId();
            Long searchIdVal = reqBO.getSearchId();
            String createTimeVal = "TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS')";
            String commdDetailsInfoVal = this.processStringField(reqBO.getCommdDetailsInfo());
            String skuInfoSaleNumVal = this.processStringField(reqBO.getSkuInfoSaleNum());
            String entAgreementCodeVal = this.processStringField(reqBO.getEntAgreementCode());
            String insertSql = "INSERT INTO STAND_SE_COMM_DETAIL_OUT_LOG (DETAIL_ID, TRACE_ID, SEARCH_ID, CREATE_TIME, COMMD_DETAILS_INFO, SKU_INFO_SALE_NUM, ENT_AGREEMENT_CODE) VALUES (" + detailIdVal + ", " + traceIdVal + ", " + searchIdVal + ", " + createTimeVal + ", " + commdDetailsInfoVal + ", " + skuInfoSaleNumVal + ", " + entAgreementCodeVal + ")";
            Db.use((String)"DATAPLAT").update(insertSql);
        } else {
            Db.use((String)"DATAPLAT").save("stand_se_comm_detail_out_log", record1);
        }
    }

    @PostMapping(value={"putCollectionInLog"})
    public SeCollectionInLogRspBO putCollectionInLog(@RequestBody SeCollectionInLogBO reqBO) {
        String jsonStr = JSON.toJSONString((Object)reqBO);
        if (jsonStr.length() > this.MAX_PARAM_OUT_SIZE) {
            jsonStr = jsonStr.substring(0, this.MAX_PARAM_OUT_SIZE) + "......";
        }
        logger.info("\u6536\u85cf\u65e5\u5fd7\u5165\u53c2:{}", (Object)jsonStr);
        SeCollectionInLogRspBO rspBO = new SeCollectionInLogRspBO();
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String yearMonth = now.format(formatter);
        Long collId = Sequence.getInstance().nextId();
        Record record = new Record();
        record.set("COLLECTION_ID", (Object)collId);
        record.set("TRACE_ID", (Object)reqBO.getTraceId());
        record.set("SEARCH_ID", (Object)reqBO.getSearchId());
        record.set("CREATE_TIME", (Object)new Date());
        record.set("SKU_ID", (Object)reqBO.getSkuId());
        record.set("SKU_NAME", (Object)reqBO.getSkuName());
        record.set("SHOP_CODE", (Object)reqBO.getShopCode());
        record.set("USER_ID", (Object)(reqBO.getUserId() + ""));
        record.set("USER_PERMISSION", (Object)reqBO.getUserPermission());
        record.set("MEM_ID_IN", (Object)reqBO.getMemIdIn());
        record.set("SKU_IMG_URL", (Object)reqBO.getSkuImgUrl());
        record.set("SKU_SOURCE", (Object)reqBO.getSkuSource());
        record.set("SUPPLIER_NAME", (Object)reqBO.getSupplierName());
        record.set("SUPPLIER_SHOP_ID", (Object)reqBO.getSupplierShopId());
        record.set("SUPPLIER_SHOP_NAME", (Object)reqBO.getSupplierShopName());
        if (this.driverName.contains("dm")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sdf.format(record.getDate("CREATE_TIME"));
            Long collectionIdVal = collId;
            Long traceIdVal = reqBO.getTraceId();
            Long searchIdVal = reqBO.getSearchId();
            String createTimeVal = "TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS')";
            String skuIdVal = this.processStringField(reqBO.getSkuId());
            String skuNameVal = this.processStringField(reqBO.getSkuName());
            String shopCodeVal = this.processStringField(reqBO.getShopCode());
            String userIdVal = this.processStringField(reqBO.getUserId() + "");
            String userPermissionVal = this.processStringField(reqBO.getUserPermission());
            String memIdInVal = this.processStringField(reqBO.getMemIdIn());
            String skuImgUrlVal = this.processStringField(reqBO.getSkuImgUrl());
            String skuSourceVal = this.processStringField(reqBO.getSkuSource());
            String supplierNameVal = this.processStringField(reqBO.getSupplierName());
            String supplierShopIdVal = this.processStringField(reqBO.getSupplierShopId());
            String supplierShopNameVal = this.processStringField(reqBO.getSupplierShopName());
            String insertSql = "INSERT INTO STAND_SE_COLLECTION_IN_LOG (COLLECTION_ID, TRACE_ID, SEARCH_ID, CREATE_TIME, SKU_ID, SKU_NAME, SHOP_CODE, USER_ID, USER_PERMISSION, MEM_ID_IN, SKU_IMG_URL, SKU_SOURCE, SUPPLIER_NAME, SUPPLIER_SHOP_ID, SUPPLIER_SHOP_NAME) VALUES (" + collectionIdVal + ", " + traceIdVal + ", " + searchIdVal + ", " + createTimeVal + ", " + skuIdVal + ", " + skuNameVal + ", " + shopCodeVal + ", " + userIdVal + ", " + userPermissionVal + ", " + memIdInVal + ", " + skuImgUrlVal + ", " + skuSourceVal + ", " + supplierNameVal + ", " + supplierShopIdVal + ", " + supplierShopNameVal + ")";
            Db.use((String)"DATAPLAT").update(insertSql);
        } else {
            Db.use((String)"DATAPLAT").save("stand_se_collection_in_log", record);
        }
        rspBO.setCollectionId(collId);
        rspBO.setSearchId(reqBO.getSearchId());
        rspBO.setTraceId(reqBO.getTraceId());
        return rspBO;
    }

    private String processStringField(String value) {
        return value != null ? "'" + value.replace("'", "''") + "'" : "NULL";
    }
}

