/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.ability.impl;

import com.tydic.se.es.ability.SeIndexAddAbilityService;
import com.tydic.se.es.ability.bo.SeIndexAddServiceReqBo;
import com.tydic.se.es.ability.bo.SeIndexServiceRspBo;
import com.tydic.se.es.util.ElasticsearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="seIndexAddAbilityService")
public class SeIndexAddAbilityServiceImpl
implements SeIndexAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SeIndexAddAbilityServiceImpl.class);
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public SeIndexServiceRspBo addIndex(SeIndexAddServiceReqBo reqBo) {
        SeIndexServiceRspBo rspBo = new SeIndexServiceRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setCode("1");
            rspBo.setMessage("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        if (this.elasticsearchUtil.isExistIndex(reqBo.getIndexName()).booleanValue()) {
            rspBo.setCode("1");
            rspBo.setMessage("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5df2\u5b58\u5728\u7684\u7d22\u5f15");
            return rspBo;
        }
        Boolean index = this.elasticsearchUtil.createIndex(reqBo.getIndexName(), reqBo.getIndexJsonStr());
        this.LOGGER.info("\u8c03\u7528\u5de5\u5177\u7c7b\u521b\u5efaES\u7d22\u5f15");
        if (index.booleanValue()) {
            rspBo.setCode("0");
            rspBo.setMessage("\u6210\u529f");
        }
        return rspBo;
    }

    private String validateArg(SeIndexAddServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getIndexName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027indexName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getIndexJsonStr())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027indexJsonStr\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

