/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.async;

import com.alibaba.fastjson.JSON;
import com.tydic.se.base.dao.UccCommodityMapper;
import com.tydic.se.es.beanpost.SyncAbleManager;
import com.tydic.se.es.comb.SeDataSyncCombService;
import com.tydic.se.es.comb.bo.SeDataSyncCombServiceReqBo;
import com.tydic.se.es.comb.bo.SeDataSyncCombServiceRspBo;
import com.tydic.se.es.data.SeAsyncIndexDataBo;
import com.tydic.se.es.syncable.SyncAble;
import com.tydic.se.es.syncable.bo.SyncAbleReqBo;
import com.tydic.se.es.syncable.bo.SyncAbleRspBo;
import com.tydic.se.es.util.ElasticsearchUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SeAsyncIndexResetService {
    private static final Logger log = LoggerFactory.getLogger(SeAsyncIndexResetService.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private SeDataSyncCombService seDataSyncBusiService;
    @Autowired
    private SyncAbleManager syncAbleManager;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    @Async(value="EsToolAsyncExecutor")
    public void reSyncData(SeAsyncIndexDataBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u7d22\u5f15\u91cd\u7f6e-\u5f02\u6b65\u6570\u636e\u540c\u6b65\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        if (!this.dealSyncData(reqBo).booleanValue()) {
            log.error("==========\u7d22\u5f15\u91cd\u7f6e-\u5f02\u6b65\u6570\u636e\u540c\u6b65\uff1a\u540c\u6b65\u6570\u636e\u5931\u8d25");
            return;
        }
        if (!this.elasticsearchUtil.moveAliasIndex(reqBo.getAlias(), reqBo.getOriIndexName(), reqBo.getIndexName()).booleanValue()) {
            log.error("==========\u7d22\u5f15\u91cd\u7f6e-\u5f02\u6b65\u6570\u636e\u540c\u6b65\uff1a\u522b\u540d\u6307\u5b9a\u7684\u7d22\u5f15\u8fc1\u79fb\u5931\u8d25");
        }
    }

    @Async(value="EsToolAsyncExecutor")
    public void syncData(SeAsyncIndexDataBo reqBo) {
        this.dealSyncData(reqBo);
    }

    @Async(value="EsToolAsyncExecutor")
    public void syncDataScene(SeAsyncIndexDataBo reqBo) {
        SyncAble syncAble = this.syncAbleManager.getSyncAbleByMethod(reqBo.getOperateType());
        SyncAbleReqBo ableReqBo = new SyncAbleReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)ableReqBo);
        SyncAbleRspBo ableRspBo = syncAble.dealSync(ableReqBo);
        if (!"0".equals(ableRspBo.getCode())) {
            log.error("\u8c03\u7528\u540c\u6b65\u80fd\u529b\u7c7b\u540c\u6b65\u6570\u636e\u5931\u8d25\uff1a" + ableRspBo.getMessage());
        }
    }

    public Boolean dealSyncData(SeAsyncIndexDataBo reqBo) {
        List supplierIds;
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupplierId())) {
            log.info("\u5165\u53c2\u4f20\u5165\u4f9b\u5e94\u5546ID\u5217\u8868\uff1a[{}]\uff0c\u5373\u5c06\u5f00\u59cb\u540c\u6b65\u8be5\u4f9b\u5e94\u5546\u4e0b\u7684\u5546\u54c1\u4fe1\u606f", (Object)JSON.toJSONString((Object)reqBo.getSupplierId()));
            try {
                supplierIds = reqBo.getSupplierId().stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.error("==========\u8f6c\u6362\u4f20\u5165\u7684\u4f9b\u5e94\u5546ID\u5217\u8868\u5f02\u5e38\uff1a" + e.getMessage());
                return false;
            }
        } else {
            supplierIds = this.uccCommodityMapper.countShopIds();
            if (CollectionUtils.isEmpty((Collection)supplierIds)) {
                log.info("==========\u83b7\u53d6\u4f9b\u5e94\u5546\u5217\u8868\u4e3a\u7a7a\uff0c\u540c\u6b65\u7a0b\u5e8f\u7ed3\u675f");
                return false;
            }
        }
        SeDataSyncCombServiceReqBo combReqBo = new SeDataSyncCombServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combReqBo);
        combReqBo.setSupplierIds(supplierIds);
        SeDataSyncCombServiceRspBo combRetBo = this.seDataSyncBusiService.syncData(combReqBo);
        log.info("==========\u6570\u636e\u540c\u6b65\u7ed3\u675f\uff0c\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)combRetBo.getMessage());
        if ("0".equals(combRetBo.getCode())) {
            return true;
        }
        return false;
    }
}

